// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
define("esri/renderers/smartMapping","require module dojo/_base/array dojo/_base/lang dojo/has dojo/Deferred dojo/DeferredList dojo/promise/all dojo/when dojo/on ../kernel ../Color ../numberUtils ../promiseList ../lang ../styles/type ../styles/size ../styles/choropleth ../styles/heatmap ../styles/predominance ../symbols/SimpleMarkerSymbol ../symbols/SimpleLineSymbol ../symbols/SimpleFillSymbol ./UniqueValueRenderer ./ClassBreaksRenderer ./HeatmapRenderer ./BlendRenderer ./utils dojo/i18n!../nls/jsapi".split(" "),
function(aa,ua,t,B,va,l,I,wa,T,xa,ya,w,J,za,Aa,ba,L,M,ca,U,Ba,V,Ca,Da,N,Ea,Fa,z,Ga){function k(a,c){a.reject(Error(c))}function da(a,c){if(a.loaded)c.call();else xa.once(a,"load",c)}function y(a,c,b,d,e){var f,g=a.outline&&a.outline.color;c=c?new w(c):null;g=g?new w(g):null;switch(b){case "point":f=new Ba;f.setColor(c);f.setSize(null!=d?d:a.size);c=new V;c.setColor(g);c.setWidth(a.outline.width);f.setOutline(c);break;case "line":f=new V;f.setColor(c);f.setWidth(null!=d?d:a.width);break;case "polygon":f=
new Ca,f.setColor(c),c=new V,c.setColor(g),c.setWidth(a.outline.width),null!=e&&c.color&&(c.color.a=e),f.setOutline(c)}return f}function E(a){var c=a.geometryType;if("esriGeometryPoint"===c||"esriGeometryMultipoint"===c)c="point";else if("esriGeometryPolyline"===c)c="line";else if("esriGeometryPolygon"===c||a.hasXYFootprint())c="polygon";return c}function W(a,c){var b=a.scheme;b=b?ba.cloneScheme(b):(b=ba.getSchemes({theme:a.theme||"default",basemap:a.basemap,geometryType:c}))&&b.primaryScheme;return b}
function ea(a,c){return a.label<c.label?-1:a.label>c.label?1:0}function fa(a,c){return a.value<c.value?-1:a.value>c.value?1:0}function Ha(a,c){var b=c.count-a.count;0===b&&(b=ea(a,c));return b}function Ia(a,c){var b=c.count-a.count;0===b&&(b=fa(a,c));return b}function Ja(a,c,b){var d;B.isFunction(c)?d=c:"count"===c?(d=Ia,b&&b.codedValues&&(d=Ha)):"value"===c&&(d=fa,b&&b.codedValues&&(d=ea));d&&a.sort(d)}function ga(a,c,b){var d=b.layer,e=b.field,f=B.isFunction(e),g=e&&!f?d.getField(e):null,h=g?d.getDomain(g.name):
null,p,m=-1,u,k=null==b.numTypes?10:-1===b.numTypes?a.length:b.numTypes,f=null==b.showOthers?!0:b.showOthers,q=null==b.sortBy?"count":b.sortBy,n=b&&b.labelCallback,r=E(d),v=W(b,r),F=c&&c.opacity,d=new Da(null,e),e=b.predominanceScheme,l=b.useSizeInfo,w,x;if(e){var D=(w="polygon"===r)&&l,H=e.sizeInfo,l=l?w?H.marker:H:null;if(H=D&&H?H.background:null)d.backgroundFillSymbol=y(H,H.color,"polygon",null,F);w=x=w?D?l.size:null:"line"===r?e.width:e.size;v=e;r=D?"point":r}var K={domain:h,fieldInfo:g};t.forEach(a,
function(a,c){K.value=a.value;a.label=z.createUniqueValueLabel(K);n&&(a.label=n(a));null===a.value&&(m=c)});-1<m&&(u=a.splice(m,1)[0]);Ja(a,q,h);g&&"esriFieldTypeDate"===g.type&&(K.dateFormatInterval=z.calculateDateFormatInterval(t.map(t.filter(a,function(a,c){return c<k}),function(a){return a.value})));p=A.createColors(v.colors,a.length);t.forEach(a,function(a,c){K.value=a.value;a.label=z.createUniqueValueLabel(K);n&&(a.label=n(a));a.symbol=y(v,p[c],r,x,F)});b.valueExpression&&(d.setValueExpression(b.valueExpression),
d.valueExpressionTitle=b.valueExpressionTitle);d.legendOptions=b.legendOptions;p=A.createColors(v.colors,k);for(g=0;g<k;g++)(h=a[g])&&d.addValue({value:h.value,label:h.label,symbol:y(v,p[g],r,x,F)});f&&(d.defaultSymbol=y(v,v.noDataColor,r,w,F),d.defaultLabel=G.other);u&&(u.symbol=y(v,v.noDataColor,r,w,F),a.push(u));c&&c.widthInfo&&d.setVisualVariables([c.widthInfo]);return{renderer:d,uniqueValueInfos:a,othersStartIndex:d.infos.length===a.length?-1:d.infos.length,scheme:e?U.cloneScheme(e):W(b,r)}}
function O(a,c,b){var d=a.scheme;d=d?M.cloneScheme(d):(d=M.getSchemes({theme:b||a.theme||"high-to-low",basemap:a.basemap,geometryType:c}))&&d.primaryScheme;return d}function X(a,c){var b=a.avg,d=b-a.stddev,e=b+a.stddev;d<a.min&&(d=a.min);e>a.max&&(e=a.max);c&&(b=d+(e-d)/2);e=J.round([d,e],{strictBounds:!0});d=e[0];e=e[1];e=[d,d+(b-d)/2,b,b+(e-b)/2,e];return J.round(e,{strictBounds:!0})}function Ka(a,c,b){var d=(c-a)/(b-1),e,f=[a];for(e=1;e<=b-2;e++)f.push(a+e*d);f.push(c);return J.round(f,{strictBounds:!0})}
function P(a,c,b,d){var e,f;a=a.statisticsPlugin.getSuggestedDataRange({statistics:c,isDate:b});a.defaultStatistics?(e=a.min,f=a.max):!d||null!=c.avg&&c.stddev||(e=c.min,f=c.max);return null!=e?[e,f]:null}function ha(a,c,b,d,e){var f=null==d.useDefaultStatistics?!0:d.useDefaultStatistics;if(!a||a.count||f){var g=d.layer,h=d.field,p=B.isFunction(h),m=(p=h&&!p?g.getField(h):null)&&"esriFieldTypeDate"===p.type,p=E(g),u=O(d,p),C=d.semiContinuous,q,n,r,v=c&&c.classBreakInfos,F=v&&v.length,l=c?F:5;if(u){var y=
-1<u.id.indexOf("seq-"),x=c&&y?ia(u,{length:l}):A.createColors(u.colors,l);if(x.length<l)k(e,"smartMapping.createColorInfo: not enough colors in the scheme.");else{if(c){q=[];var D;1===F?(n=[v[0].minValue,v[0].maxValue],q=[0,1],D=A.createColors(x,l)[0],r=[D,new w(D)]):C?(n=[],r=[],t.forEach(v,function(a,c){var d=.1*(a.maxValue-a.minValue);0===c?n.push(a.minValue):n.push(a.minValue+d);c===F-1?n.push(a.maxValue):n.push(a.maxValue-d);D=new w(x[c]);r.push(D);r.push(new w(D));q.push(2*c);q.push(2*c+1)})):
(n=t.map(v,function(a,c){q.push(c);return(a.minValue+a.maxValue)/2}),r=A.createColors(x,l));n=J.round(n,{strictBounds:!0})}else n=(f=f?P(g,a,m,!0):null)?Ka(f[0],f[1],5):X(a,y),q=[0,2,4],r=A.createColors(x,l);b={type:"colorInfo",field:h,valueExpression:d.valueExpression,valueExpressionTitle:d.valueExpressionTitle,normalizationField:b,stops:z.createColorStops({values:n,isDate:m,dateFormatOptions:m?z.timelineDateFormatOptions:null,colors:r,labelIndexes:q}),legendOptions:d.legendOptions};e.resolve({colorInfo:b,
statistics:a,classBreaks:c,scheme:O(d,p)})}}else k(e,"smartMapping.createColorInfo: unable to find the specified scheme.")}else k(e,"smartMapping.createColorInfo: cannot create renderer when statistics.count is 0.")}function ja(a,c,b,d){var e=null==b.useDefaultStatistics?!0:b.useDefaultStatistics;if(!a||a.count||e){var f=b.layer,g=b.field,h=g&&!B.isFunction(g)?f.getField(g):null,p=h&&"esriFieldTypeDate"===h.type,m=(h=b.useStdDev)?X(a):null,f=(e=e?P(f,a,p,h):null)||(h?[m[0],m[4]]:[a.min,a.max]);d.resolve({opacityInfo:{type:"opacityInfo",
field:g,valueExpression:b.valueExpression,valueExpressionTitle:b.valueExpressionTitle,normalizationField:c,stops:[{value:f[0],opacity:.3},{value:f[1],opacity:.7}],legendOptions:b.legendOptions},statistics:a,defaultStatistics:!!e})}else k(d,"smartMapping.createOpacityInfo: cannot create opacityInfo when statistics.count is 0.")}function Q(a,c){var b=a.scheme;b=b?L.cloneScheme(b):(b=L.getSchemes({theme:a.theme||"default",basemap:a.basemap,geometryType:c}))&&b.primaryScheme;return b}function ka(a,c){var b;
switch(c){case "point":b=[a.minSize,a.maxSize];break;case "line":b=[a.minWidth,a.maxWidth];break;case "polygon":b=[a.marker.minSize,a.marker.maxSize]}return b}function la(a,c,b,d,e){var f=null==d.useDefaultStatistics?!0:d.useDefaultStatistics,g=c&&[c.minSize,c.maxSize];if(!a||a.count||f){var h=d.layer,p=d.field,m=p&&!B.isFunction(p)?h.getField(p):null,u=m&&"esriFieldTypeDate"===m.type,m=E(h),C=Q(d,m),g=g||ka(C,m),q=(C=d.useStdDev)?X(a):null,h=(f=f?P(h,a,u,C):null)||(C?[q[0],q[4]]:[a.min,a.max]);e.resolve({sizeInfo:{type:"sizeInfo",
field:p,valueExpression:d.valueExpression,valueExpressionTitle:d.valueExpressionTitle,valueUnit:"unknown",normalizationField:b,legendOptions:d.legendOptions,minSize:g[0],maxSize:g[1],minDataValue:h[0],maxDataValue:h[1]},statistics:a,defaultStatistics:!!f,suggestedSizeRange:c,scheme:Q(d,m)})}else k(e,"smartMapping.createSizeInfo: cannot create renderer when statistics.count is 0.")}function R(a,c,b){var d,e=[],f=1/(b+1);for(d=1;d<=b;d++)e.push(w.blendColors(a,c,f*d));return e}function ma(a,c){var b=
[];if(1===c)b=[a[0]];else if(2===c)b=[a[0],a[2]];else if(3===c)b=a;else{var d=c-a.length,b=d/2;0===d%2?(d=R(a[0],a[1],b),b=R(a[1],a[2],b)):(d=R(a[0],a[1],Math.floor(b)),b=R(a[1],a[2],Math.ceil(b)));b=[a[0]].concat(d).concat([a[1]]).concat(b).concat([a[2]])}return b}function ia(a,c,b){var d,e=c.length,f=-1;b&&t.some(c,function(a,c){a.hasAvg&&(f=c);return-1<f});if(-1<f){var g=a.colors;a=f+1;c=e-f;b=g.slice(0,3);g=g.slice(2);b.reverse();b=ma(b,a);g=ma(g,c);b.reverse();d=[].concat(b).concat(g.slice(1))}else if((a=
a.colorsForClassBreaks)&&0<a.length&&(t.some(a,function(a){a.numClasses===e&&(d=a.colors);return!!d}),!d&&(b=a[a.length-1],a=e-b.numClasses,0<a)))for(c=b.colors[b.numClasses-1],d=b.colors.splice(0),b=1;b<=a;b++)d.push(c);d&&(d=A.createColors(d,d.length));return d}function La(a,c,b,d){var e=b.field,f=E(b.layer),g=null==b.showOthers?!0:b.showOthers,h=c&&c.opacity,p=b.classificationMethod||"equal-interval",m="standard-deviation"===p,u=b.normalizationType,C,q,n,r=a.classBreakInfos;(C=O(b,f,"high-to-low"))?
(q=ia(C,r))&&q.length==r.length?(n=new N(null,e),b.valueExpression&&(n.setValueExpression(b.valueExpression),n.valueExpressionTitle=b.valueExpressionTitle),n.legendOptions=b.legendOptions,n.classificationMethod=p,n.normalizationType=u,n.normalizationField="field"===u?b.normalizationField:void 0,n.normalizationTotal="percent-of-total"===u?a.normalizationTotal:void 0,g&&(n.defaultSymbol=y(C,C.noDataColor,f,null,h),n.defaultLabel=G.other),t.forEach(r,function(a,c){n.addBreak({minValue:a.minValue,maxValue:a.maxValue,
symbol:y(C,q[c],f,null,h),label:a.label})}),m||z.setLabelsForClassBreaks({classBreaks:n.infos,classificationMethod:p,normalizationType:u,round:!0}),c&&c.widthInfo&&n.setVisualVariables([c.widthInfo]),a.renderer=n,a.scheme=O(b,f,"high-to-low"),d.resolve(a)):k(d,"smartMapping.createClassedColorRenderer: unable to find suitable colors for number of classes."):k(d,"smartMapping.createClassedColorRenderer: unable to find suitable style scheme.")}function na(a){var c=new l,b=a.layer,d=null==a.useDefaultBreaks?
!0:a.useDefaultBreaks,e=a.optimizeOutline,f=[b.statisticsPlugin.getClassBreaks(a)];e&&f.push(b.statisticsPlugin.getSuggestedOutline("object"===typeof e?e:null));(new I(f)).then(function(f){var h=f[0];f=f[1];var g=e&&f[0]?f[1]:null;if(h[0]||d&&!b.graphics.length){var h=h[1],m=d?P(b,h?{min:h.minValue,max:h.maxValue}:{}):null;m&&(h=a.layer.statisticsPlugin.getClassBreaks(B.mixin(a,{classificationMethod:"equal-interval",numClasses:1,analyzeData:!1,minValue:m[0],maxValue:m[1],normalizationTotal:m[0]+m[1]})));
T(h).then(function(a){a.defaultStatistics=!!m;c.resolve({cbResponse:a,suggestedOutline:g})}).otherwise(function(){k(c,"smartMapping: error when calculating default class breaks.")})}else k(c,"smartMapping: error when calculating class breaks.")});return c.promise}function Ma(a,c,b,d){c=d||ka(a,c);a=c[0];c=(c[1]-a)/(4<=b?b-1:b);var e=[];for(d=0;d<b;d++)e.push(a+c*d);return e}function Y(a,c,b,d,e){var f=d.field,g=E(d.layer),h=null==d.showOthers?!0:d.showOthers,p=b&&b.opacity,m=d.classificationMethod||
"equal-interval",u=d.normalizationType,k=a.classBreakInfos,q=Q(d,g),n=Ma(q,g,k.length,c),r="polygon"===g,v=r?q.marker:q;c=r?q.background:null;var l;l=new N(null,f);d.valueExpression&&(l.setValueExpression(d.valueExpression),l.valueExpressionTitle=d.valueExpressionTitle);l.legendOptions=d.legendOptions;l.classificationMethod=m;l.normalizationType=u;l.normalizationField="field"===u?d.normalizationField:void 0;l.normalizationTotal="percent-of-total"===u?a.normalizationTotal:void 0;h&&(l.defaultSymbol=
y(v,v.noDataColor,r?"point":g),l.defaultLabel=G.other);c&&(l.backgroundFillSymbol=y(c,c.color,g,null,p));t.forEach(k,function(a,c){l.addBreak({minValue:a.minValue,maxValue:a.maxValue,symbol:y(v,v.color,r?"point":g,n[c]),label:a.label})});"standard-deviation"!==m&&z.setLabelsForClassBreaks({classBreaks:l.infos,classificationMethod:m,normalizationType:u,round:!0});b&&b.widthInfo&&l.setVisualVariables([b.widthInfo]);a.renderer=l;a.scheme=Q(d,g);e.resolve(a)}function Z(a){var c=a.scheme;c=c?ca.cloneScheme(c):
(c=ca.getSchemes({theme:a.theme||"default",basemap:a.basemap}))&&c.primaryScheme;return c}function oa(a,c,b){var d=null==c.useDefaultStatistics?!0:c.useDefaultStatistics;if(a.count||d){var e=a.fieldOffset,f=null==c.blurRadius?10:c.blurRadius,g=null==c.minRatio?.01:c.minRatio,h=null==c.maxRatio?1:c.maxRatio,p=null==c.fadeToTransparent?!0:c.fadeToTransparent,m=Z(c).colors,u=m.length,l=(d=!a.count&&d)?[0,100]:[a.min,a.max],q=new Ea;q.setBlurRadius(f);q.setField(c.field);null!=e&&q.setFieldOffset(e);
q.setMinPixelIntensity(l[0]);q.setMaxPixelIntensity(l[1]);var e=m[0],n=[{ratio:0,color:new w([e.r,e.g,e.b,0])},{ratio:.01,color:new w([e.r,e.g,e.b,0])},{ratio:p?g:.01,color:e}],r=(h-g)/(u-1),m=A.createColors(m,u);t.forEach(m,function(a,c){n.push({ratio:g+r*c,color:a})});q.setColorStops(n);b.resolve({renderer:q,statistics:a,defaultStatistics:d,scheme:Z(c)})}else k(b,"smartMapping.createHeatmapRenderer: cannot create renderer when statistics.count is 0.")}function Na(a,c){var b=a.scheme;b=b?U.cloneScheme(b):
(b=U.getSchemes({theme:a.theme||"default",basemap:a.basemap,geometryType:c}))&&b.primaryScheme;return b}function Oa(a,c){var b={};t.forEach(a,function(a){var d=c.getField(a.name);b[a.name]=a.label||d&&d.alias||a.name});return function(a){return b[a.value]}}function Pa(a){return function(c,b){var d=t.indexOf(a,c.value),e=t.indexOf(a,b.value);return d-e}}function Qa(a,c,b,d,e){var f=new l,g=a.layer;g.statisticsPlugin.getPredominantCategories({fields:c}).always(function(h){h&&h.predominantCategoryInfos||
(h={predominantCategoryInfos:t.map(c,function(a){return{value:a,count:0}})});var p=ga(h.predominantCategoryInfos,e,{layer:g,valueExpression:d.valueExpression,valueExpressionTitle:G.predominantCategory,labelCallback:Oa(a.fields,g),numTypes:-1,showOthers:a.showOthers,sortBy:Pa(c),predominanceScheme:b,useSizeInfo:a.includeSizeInfo});p.predominantCategoryInfos=p.uniqueValueInfos;delete p.uniqueValueInfos;p.source=h.source;f.resolve(p)});return f.promise}function Ra(a,c,b,d){var e=new l;A.createSizeInfo({layer:a.layer,
valueExpression:d.valueExpression,sqlExpression:d.statisticsQuery.sqlExpression,sqlWhere:d.statisticsQuery.sqlWhere,scheme:b,optimizeForScale:a.optimizeForScale}).then(function(a){a.sizeInfo.legendOptions={title:G.sumOfCategories};e.resolve(a)}).otherwise(function(a){k(e,"smartMapping.createPredominanceRenderer: error when calculating statistics for visual variable(size).")});return e.promise}function Sa(a,c,b){var d=new l;a.layer.statisticsPlugin.getFieldStatistics({valueExpression:b.valueExpression,
sqlExpression:b.statisticsQuery.sqlExpression,sqlWhere:b.statisticsQuery.sqlWhere}).then(function(a){var e=null==a.avg||null==a.stddev,g=1/c.length*100,h=e?100:a.avg+1.285*a.stddev;100<h&&(h=100);g=J.round([g,h],{strictBounds:!0});d.resolve({opacityInfo:{type:"opacityInfo",valueExpression:b.valueExpression,stops:[{value:g[0],opacity:.15},{value:g[1],opacity:1}],legendOptions:{title:G.strengthOfPredominance}},statistics:a,defaultStatistics:e})}).otherwise(function(a){k(d,"smartMapping.createPredominanceRenderer: error when calculating statistics for visual variable(opacity).")});
return d.promise}function Ta(a,c,b,d){var e=E(a.layer),f=Na(a,e);a.layer.statisticsPlugin.getPredominanceExpressions({fields:c}).then(function(e){var h=Qa(a,c,f,e.predominantCategory,b),g,m;a.includeSizeInfo&&(g=Ra(a,c,f.sizeInfo,e.size));a.includeOpacityInfo&&(m=Sa(a,c,e.opacity));za([h,g,m]).then(function(a){var c=a[0],b=a[1],e=a[2];a=[];if(c instanceof Error)k(d,"smartMapping.createPredominanceRenderer: unable to create unique-value renderer.");else{if(g){if(b instanceof Error){k(d,"smartMapping.createPredominanceRenderer: unable to create visual variable for symbol size.");
return}a.push(z.cloneSizeInfo(b.sizeInfo));delete b.scheme;c.size=b}if(m){if(e instanceof Error){k(d,"smartMapping.createPredominanceRenderer: unable to create visual variable for symbol opacity.");return}a.push(z.cloneOpacityInfo(e.opacityInfo));c.opacity=e}if(a.length){if(b=c.renderer.visualVariables)Array.prototype.push.apply(b,a),a=b;c.renderer.setVisualVariables(a)}d.resolve(c)}})}).otherwise(function(a){k(d,"smartMapping.createPredominanceRenderer: unable to generate expressions.")})}function pa(a,
c,b){var d=a;if("string"===typeof a)(a=b.getField(a))&&"esriFieldTypeDate"===a.type&&(d=b.getFieldLabel(a.name));else if("number"===typeof a||a instanceof Date)b=-1<t.indexOf(Ua,c)?null:"date",d=z.formatDate(a,{selector:b});return d}function Va(a,c,b){var d=c.startTime,e=c.endTime,f=c.layer;f.statisticsPlugin.getAgeExpressions({startTime:d,endTime:e,units:a.units}).then(function(c){var h=a.units,g="ageInfo_"+h;a.legendOptions={title:Aa.substitute({units:h,startTime:pa(d,h,f),endTime:pa(e,h,f)},G[g])};
B.mixin(a,c);b.resolve(a)}).otherwise(function(a){k(b,"smartMapping.createAgeInfo: unable to generate expressions to calculate age.")})}function qa(a,c){var b,d,e,f,g,h,p,m,k={};b=t.filter(a,function(a){d=a.name;e=d.toLowerCase();if(h=d!==c&&-1===t.indexOf(ra,e))p=p||(-1<t.indexOf(sa,a.type)?d:null),m=m||("esriFieldTypeString"===a.type?d:null);return h});t.forEach(b,function(a){d=a.name;e=d.toLowerCase();(f=-1<t.indexOf(sa,a.type))&&(k=ta(d,e,Wa,k,"number"));k.rank&&"string"!==k.fieldType||(g="esriFieldTypeString"===
a.type)&&(k=ta(d,e,Xa,k,"string"))});return k.fieldName||p||m}function ta(a,c,b,d,e){var f,g=-1;f=-1;var h,g=t.indexOf(b,c);for(h=0;h<b.length;h++)if(-1<c.indexOf(b[h])){f=h;break}c=g;-1<c&&(!d.rank||d.fieldType!==e||"exact"===d.matchType&&d.fieldType===e&&d.rank>c)?d={rank:c,matchType:"exact",fieldType:e,fieldName:a}:-1<f&&(!d.rank||d.fieldType===e&&"contains"===d.matchType&&d.rank>f)&&(d={rank:f,matchType:"contains",fieldType:e,fieldName:a});return d}var A={},S=Math.pow(2,53)-1,G=Ga.smartMapping,
Ya=/(https?:)?\/\/services.*\.arcgis\.com/i,ra="id fips fid objectid _objectid __objectid x y lat long latitude longitude shape shape_length shape_leng shape_area perimeter stretched_value fnode_ tnode_ lpoly_ rpoly_ poly_ subclass rings_ok rings_nok st_length(shape) st_area(shape)".split(" "),Wa="count percent sum elevation value valore valoare total gesamt score income age expected average median size cost expenditure revenue profit growth sale quantity population price unit length width difference distance".split(" "),
Xa="type name status class category code value label zone symbol color owner district group species rating score party".split(" "),sa=["esriFieldTypeInteger","esriFieldTypeDouble","esriFieldTypeSingle","esriFieldTypeSmallInteger"],Ua=["hours","minutes","seconds"],x=function(a){return aa.toAbsMid?aa.toAbsMid(a):ua.id.replace(/\/[^\/]*$/ig,"/")+a}("../plugins/FeatureLayerStatistics");B.mixin(A,{createColors:function(a,c){var b=[],d=a.length,e;for(e=0;e<c;e++)b.push(new w(a[e%d]));return b},createTypeRenderer:function(a){var c=
new l;if(!a||!a.layer||!a.field&&!a.valueExpression||!a.scheme&&!a.basemap)return k(c,"smartMapping.createTypeRenderer: missing parameters."),c.promise;var b=a.layer,d=a.optimizeOutline;b.addPlugin(x).then(function(){var e=[b.statisticsPlugin.getUniqueValues({field:a.field,valueExpression:a.valueExpression,includeAllCodedValues:a.includeAllCodedValues})];d&&e.push(b.statisticsPlugin.getSuggestedOutline("object"===typeof d?d:null));(new I(e)).then(function(b){var e=b[0];b=b[1];b=d&&b[0]?b[1]:null;
e[0]?(e=e[1],b=ga(e.uniqueValueInfos,b,a),b.source=e.source,b.partialData=e.partialData,c.resolve(b)):k(c,"smartMapping.createTypeRenderer: error when calculating unique values.")})}).otherwise(function(a){k(c,"smartMapping.createTypeRenderer: error when adding feature layer statistics plugin.")});return c.promise},createColorInfo:function(a){var c=new l;if(!(a&&a.layer&&(a.field||a.valueExpression||a.sqlExpression)))return k(c,"smartMapping.createColorInfo: missing parameters."),c.promise;var b=
a.layer,d=a.normalizationField,e=d?"field":void 0;a.statistics?ha(a.statistics,null,d,a,c):b.addPlugin(x).then(function(){var f="group-similar"===a.theme||a.scheme&&0===a.scheme.id.indexOf("group-similar/");(f?b.statisticsPlugin.getClassBreaks({field:a.field,valueExpression:a.valueExpression,classificationMethod:"natural-breaks",numClasses:a.numGroups||5,normalizationType:e,normalizationField:d,minValue:a.minValue,maxValue:a.maxValue}):b.statisticsPlugin.getFieldStatistics({field:a.field,valueExpression:a.valueExpression,
sqlExpression:a.sqlExpression,sqlWhere:a.sqlWhere,normalizationType:e,normalizationField:d,minValue:a.minValue,maxValue:a.maxValue})).then(function(b){var e,g;f?e=b:g=b;ha(g,e,d,a,c)}).otherwise(function(a){k(c,f?"smartMapping.createColorInfo: error when calculating class breaks.":"smartMapping.createColorInfo: error when calculating field statistics.")})}).otherwise(function(a){k(c,"smartMapping.createColorInfo: error when adding feature layer statistics plugin.")});return c.promise},createColorRenderer:function(a){var c=
new l;if(!(a&&a.layer&&(a.field||a.valueExpression||a.sqlExpression)))return k(c,"smartMapping.createColorRenderer: missing parameters."),c.promise;var b=a.layer,d=a.normalizationField,e=d?"field":void 0,f=a.optimizeOutline;b.addPlugin(x).then(function(){var g=[A.createColorInfo(a)];f&&g.push(b.statisticsPlugin.getSuggestedOutline("object"===typeof f?f:null));(new I(g)).then(function(b){var h=b[0];b=b[1];b=f&&b[0]?b[1]:null;if(h[0]){var h=h[1],g=a.field,u=E(a.layer),l=null==a.showOthers?!0:a.showOthers,
q=b&&b.opacity,n=M.cloneScheme(h.scheme),g=new N(null,g);a.valueExpression&&g.setValueExpression(a.valueExpression);l&&(g.defaultSymbol=y(n,n.noDataColor,u,null,q),g.defaultLabel=G.other);g.addBreak({minValue:-S,maxValue:S,symbol:y(n,n.noDataColor,u,null,q)});g.normalizationType=e;g.normalizationField=d;u=[z.cloneColorInfo(h.colorInfo)];b&&b.widthInfo&&u.push(b.widthInfo);g.setVisualVariables(u);c.resolve({renderer:g,colorInfo:z.cloneColorInfo(h.colorInfo),statistics:h.statistics,classBreaks:h.classBreaks,
scheme:M.cloneScheme(h.scheme)})}else k(c,"smartMapping.createColorRenderer: error when calculating colorInfo.")})}).otherwise(function(a){k(c,"smartMapping.createColorRenderer: error when adding feature layer statistics plugin.")});return c.promise},createOpacityInfo:function(a){var c=new l;if(!(a&&a.layer&&(a.field||a.valueExpression||a.sqlExpression)))return k(c,"smartMapping.createOpacityInfo: missing parameters."),c.promise;var b=a.layer,d=a.normalizationField,e=d?"field":void 0;a.statistics?
ja(a.statistics,d,a,c):b.addPlugin(x).then(function(){b.statisticsPlugin.getFieldStatistics({field:a.field,valueExpression:a.valueExpression,sqlExpression:a.sqlExpression,sqlWhere:a.sqlWhere,normalizationType:e,normalizationField:d,minValue:a.minValue,maxValue:a.maxValue,features:a.features}).then(function(b){ja(b,d,a,c)}).otherwise(function(a){k(c,"smartMapping.createOpacityInfo: error when calculating field statistics.")})}).otherwise(function(a){k(c,"smartMapping.createOpacityInfo: error when adding feature layer statistics plugin.")});
return c.promise},createBlendRenderer:function(a){var c=new l,b=this,d,e=[],f={},g=[],h=[],p=a.opacityValueCombinationMethod||"avg",m={};if(!(a&&a.layer&&a.blendedFields))return k(c,"smartMapping.createBlendRenderer: missing parameters."),c.promise;a.basemap=a.basemap||"topo";e=E(a.layer);d=W({basemap:a.basemap},e);d.colors=[new w("#e60000"),new w("#0000e6"),new w("#00e600"),new w("#e67300"),new w("#a900e6")];m.fields=[];m.normalizationField=a.normalizationField;m.blendMode=a.blendMode||"source-over";
m.symbol=y(d,d.noDataColor,a.markers?"point":e);f.layer=a.layer;f.normalizationField=a.normalizationField;f.useStdDev=a.useStdDev||!1;e=t.map(a.blendedFields,function(a,c){m.fields.push({field:a,color:d.colors[c]});f.field=a;return b.createOpacityInfo(f)});wa(e).then(function(b){h[0]=b[0].opacityInfo.stops[0].value;h[1]=b[1].opacityInfo.stops[1].value;t.forEach(b.slice(0,1),function(a){var c=a.opacityInfo.stops[0].value,b=a.opacityInfo.stops[1].value;"union"===p?(h[0]=c<h[0]?c:h[0],h[1]=b>h[1]?b:
h[1]):"avg"===p&&(h[0]+=a.opacityInfo.stops[0].value,h[1]+=a.opacityInfo.stops[1].value)});g[0]={value:"avg"===p?h[0]/b.length:h[0],opacity:a.minOpacity?a.minOpacity:b[0].opacityInfo.stops[0].opacity};g[1]={value:"avg"===p?h[1]/b.length:h[1],opacity:a.maxOpacity?a.maxOpacity:b[0].opacityInfo.stops[1].opacity};m.opacityStops=g;c.resolve({renderer:new Fa(m),scheme:d,opacityInfos:b})});return c.promise},createSizeInfo:function(a){var c=new l;if(!(a&&a.layer&&(a.field||a.valueExpression||a.sqlExpression)))return k(c,
"smartMapping.createSizeInfo: missing parameters."),c.promise;var b=a.layer,d=a.normalizationField,e=d?"field":void 0,f=a.optimizeForScale;a.statistics?la(a.statistics,null,d,a,c):b.addPlugin(x).then(function(){var g=[b.statisticsPlugin.getFieldStatistics({field:a.field,valueExpression:a.valueExpression,sqlExpression:a.sqlExpression,sqlWhere:a.sqlWhere,normalizationType:e,normalizationField:d,minValue:a.minValue,maxValue:a.maxValue})];f&&g.push(b.statisticsPlugin.getSuggestedSizeRange({optimizeForScale:!0===
f?"map-scale":f}));(new I(g)).then(function(b){var e=b[0];b=f&&b[1];b=f&&b[0]?b[1]:null;e[0]?la(e[1],b,d,a,c):k(c,"smartMapping.createSizeInfo: error when calculating field statistics.")})}).otherwise(function(a){k(c,"smartMapping.createSizeInfo: error when adding feature layer statistics plugin.")});return c.promise},createSizeRenderer:function(a){var c=new l;if(!(a&&a.layer&&(a.field||a.valueExpression||a.sqlExpression)))return k(c,"smartMapping.createSizeRenderer: missing parameters."),c.promise;
var b=a.layer,d=a.normalizationField,e=d?"field":void 0,f=a.optimizeOutline;b.addPlugin(x).then(function(){var g=[A.createSizeInfo(a)];f&&g.push(b.statisticsPlugin.getSuggestedOutline("object"===typeof f?f:null));(new I(g)).then(function(b){var g=b[0];b=b[1];b=f&&b[0]?b[1]:null;if(g[0]){var g=g[1],h=a.field,l=E(a.layer),t=null==a.showOthers?!0:a.showOthers,q=b&&b.opacity,n=L.cloneScheme(g.scheme),r="polygon"===l,v=r?n.marker:n,n=r?n.background:null,w="line"===l?v.noDataWidth:v.noDataSize,h=new N(null,
h);a.valueExpression&&h.setValueExpression(a.valueExpression);t&&(h.defaultSymbol=y(v,v.noDataColor,r?"point":l,w),h.defaultLabel=G.other);h.addBreak({minValue:-S,maxValue:S,symbol:y(v,v.color,r?"point":l)});n&&(h.backgroundFillSymbol=y(n,n.color,l,null,q));h.normalizationType=e;h.normalizationField=d;l=[z.cloneSizeInfo(g.sizeInfo)];b&&b.widthInfo&&l.push(b.widthInfo);h.setVisualVariables(l);c.resolve({renderer:h,sizeInfo:z.cloneSizeInfo(g.sizeInfo),statistics:g.statistics,defaultStatistics:g.defaultStatistics,
suggestedSizeRange:g.suggestedSizeRange,scheme:L.cloneScheme(g.scheme)})}else k(c,"smartMapping.createSizeRenderer: error when calculating sizeInfo.")})}).otherwise(function(a){k(c,"smartMapping.createSizeRenderer: error when adding feature layer statistics plugin.")});return c.promise},createClassedColorRenderer:function(a){var c=new l,b=a.minValue,d=a.maxValue,e;if(!a||!a.layer||!a.field&&!a.valueExpression)return k(c,"smartMapping.createClassedColorRenderer: missing parameters."),c.promise;e=null!=
b&&null!=d;if(!e&&(null!=b||null!=d))return k(c,"smartMapping.createClassedColorRenderer: both minValue and maxValue are required when specifying custom data range."),c.promise;a=B.mixin({analyzeData:!e},a);a.layer.addPlugin(x).then(function(){na(a).then(function(b){La(b.cbResponse,b.suggestedOutline,a,c)}).otherwise(function(a){k(c,"smartMapping.createClassedColorRenderer: error when calculating class breaks.")})}).otherwise(function(a){k(c,"smartMapping.createClassedColorRenderer: error when adding feature layer statistics plugin.")});
return c.promise},createClassedSizeRenderer:function(a){var c=new l,b=a.minValue,d=a.maxValue,e;if(!a||!a.layer||!a.field&&!a.valueExpression)return k(c,"smartMapping.createClassedSizeRenderer: missing parameters."),c.promise;e=null!=b&&null!=d;if(!e&&(null!=b||null!=d))return k(c,"smartMapping.createClassedColorRenderer: both minValue and maxValue are required when specifying custom data range."),c.promise;a=B.mixin({analyzeData:!e},a);var f=a.layer;f.addPlugin(x).then(function(){na(a).then(function(b){a.optimizeForScale?
f.statisticsPlugin.getSuggestedSizeRange().then(function(d){Y(b.cbResponse,[d.minSize,d.maxSize],b.suggestedOutline,a,c)}).otherwise(function(d){Y(b.cbResponse,null,b.suggestedOutline,a,c)}):Y(b.cbResponse,null,b.suggestedOutline,a,c)}).otherwise(function(a){k(c,"smartMapping.createClassedSizeRenderer: error when calculating class breaks.")})}).otherwise(function(a){k(c,"smartMapping.createClassedSizeRenderer: error when adding feature layer statistics plugin.")});return c.promise},createHeatmapRenderer:function(a){var c=
new l;if(!a||!a.layer)return k(c,"smartMapping.createHeatmapRenderer: missing parameters."),c.promise;var b=a.layer;a.statistics?oa(a.statistics,a,c):b.addPlugin(x).then(function(){b.statisticsPlugin.getHeatmapStatistics(a).then(function(b){oa(b,a,c)}).otherwise(function(a){k(c,"smartMapping.createHeatmapRenderer: error when calculating heatmap statistics.")})}).otherwise(function(a){k(c,"smartMapping.createHeatmapRenderer: error when adding feature layer statistics plugin.")});return c.promise},
applyHeatmapScheme:function(a){if(a&&a.renderer&&a.scheme){var c=Z({scheme:a.scheme});a=a.renderer;var b=a.colorStops,c=c.colors;if(b.length!==c.length+3)console.log("smartMapping.applyHeatmapScheme: incompatible number of colors in 'colors' and 'renderer.colorStops'.");else{var d;d=new w(c[0]);b=t.map(b,function(a){return B.mixin({},a)});b[0].color=new w([d.r,d.g,d.b,0]);b[1].color=new w([d.r,d.g,d.b,0]);b[2].color=d;for(d=3;d<b.length;d++)b[d].color=c[d-3];a.setColorStops(b)}}else console.log("smartMapping.applyHeatmapScheme: missing parameters.")},
sampleSize:500,createPredominanceRenderer:function(a){var c=new l;if(!(a&&a.layer&&a.fields&&1<a.fields.length))return k(c,"smartMapping.createPredominanceRenderer: missing parameters."),c.promise;if(5<a.fields.length)return k(c,"smartMapping.createPredominanceRenderer: too many fields. Maximum supported is 5."),c.promise;var b=a.layer;b.addPlugin(x).then(function(){var d=t.map(a.fields,function(a){return a.name});da(b,function(){var e=b.getOutFields()||[],f=-1!==t.indexOf(e,"*"),g=a.optimizeOutline,
f=f?null:t.filter(d,function(a){return-1===t.indexOf(e,a)});!b.url||b._collection||Ya.test(b.url)?f&&f.length?k(c,"smartMapping.createPredominanceRenderer: make sure the layer is configured to fetch all fields specified in parameters."):(g=g?b.statisticsPlugin.getSuggestedOutline("object"===typeof g?g:null):null,T(g).always(function(b){b&&!b.widthInfo&&(b=null);Ta(a,d,b,c)})):k(c,"smartMapping.createPredominanceRenderer: predominance renderer is not supported for this layer. Make sure the layer supports advanced SQL expressions and standardized queries.")})}).otherwise(function(a){k(c,
"smartMapping.createPredominanceRenderer: error when adding feature layer statistics plugin.")});return c.promise},createAgeInfo:function(a){var c=new l;if(!(a&&a.layer&&a.startTime&&a.endTime))return k(c,"smartMapping.createAgeInfo: missing parameters."),c.promise;var b=a.layer;b.addPlugin(x).then(function(){var d=a.units?{units:a.units}:b.statisticsPlugin.getSuggestedAgeUnits({startTime:a.startTime,endTime:a.endTime});T(d).then(function(b){Va(b,a,c)}).otherwise(function(a){k(c,"smartMapping.createAgeInfo: unable to calculate age units.")})}).otherwise(function(a){k(c,
"smartMapping.createAgeInfo: error when adding feature layer statistics plugin.")});return c.promise},excludedFields:ra,getSuggestedField:function(a){var c=new l;if(!a||!(a.layer||a.fields&&a.objectIdField))return k(c,"smartMapping.getSuggestedField: missing parameters."),c.promise;a.layer?da(a.layer,function(){c.resolve(qa(a.layer.fields,a.layer.objectIdField))}):c.resolve(qa(a.fields,a.objectIdField));return c.promise}});va("extend-esri")&&B.setObject("renderer.smartMapping",A,ya);return A});