// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
define("esri/_coremap","require module dojo/_base/kernel dojo/_base/declare dojo/_base/connect dojo/_base/Deferred dojo/_base/lang dojo/_base/array dojo/_base/event dojo/_base/unload dojo/dom dojo/dom-attr dojo/dom-class dojo/dom-construct dojo/dom-geometry dojo/dom-style dojo/sniff dijit/registry dojox/gfx/matrix ./kernel ./config ./basemaps ./lang ./Evented ./fx ./deferredUtils ./tileUtils ./urlUtils ./PluginTarget ./Color ./arcade/Dictionary ./geometry/Point ./geometry/ScreenPoint ./geometry/Extent ./geometry/Rect ./geometry/mathUtils ./geometry/scaleUtils ./geometry/screenUtils ./geometry/webMercatorUtils ./layers/GraphicsLayer ./layers/TileInfo ./layers/LOD ./layers/ArcGISTiledMapServiceLayer ./layers/MapImageLayer ./layers/OpenStreetMapLayer ./layers/VectorTileLayer ./dijit/Popup ./plugins/popupManager dojo/uacss".split(" "),
function(S,oa,pa,V,A,da,K,l,Ma,qa,ra,sa,Z,C,W,N,E,ta,ua,va,wa,G,w,xa,ea,ya,fa,ga,za,Aa,Ba,O,F,B,P,Ca,I,ha,aa,z,Da,Ea,Fa,Ga,ia,Ha,Ia){function ja(a,b){var c=a.lods;c.sort(function(a,b){return a.scale>b.scale?-1:a.scale<b.scale?1:0});var d=[],c=l.filter(c,function(a){if(-1===Q(d,a.scale))return d.push(a.scale),!0}),e=b.lods=[],f;l.forEach(c,function(a,b){f=e[b]=new Ea(a);f.level=b});b.tileInfo=new Da(T(a,{lods:e}))}var ba,U=ha.toMapPoint,ca=ha.toScreenPoint,X=A.connect,R=A.disconnect,t=K.hitch,L=N.set,
Q=l.indexOf,T=K.mixin,Y=0,J=wa.defaults.map,ka=J.layerNamePrefix,la=J.graphicsLayerNamePrefix,Ja=new RegExp("^"+ka+"(\\d+)$"),Ka=new RegExp("^"+la+"(\\d+)$"),La=function(){},ma=0;V=V([xa,za],{declaredClass:"esri._CoreMap",resizeDelay:300,invalidExtent:"Map does not have a valid extent.",invalidGeometry:"Geometry (wkid: ${geometry}) cannot be converted to spatial reference of the map (wkid: ${map})",unknownBasemap:'Unable to find basemap definition for: "${basemapName}". Try one of these: ${list}',
invalidBasemap:'Unable to add basemap: "${basemapName}".',unknownLayerType:'Unknown basemap layer type: "${type}" found in basemap definition for: "${basemapName}".',visible:!0,_eventMap:{"basemap-change":!0,"extent-change":["extent","delta","levelChange","lod"],"layer-add":["layer"],"layer-add-result":["layer","error"],"layer-remove":["layer"],"layer-reorder":["layer","index"],"layer-resume":["layer"],"layer-suspend":["layer"],"layers-add-result":["layers"],"layers-removed":!0,"layers-reordered":["layerIds"],
load:["map"],pan:["extent","delta"],"pan-end":["extent","delta"],"pan-start":["extent","screenPoint"],reposition:["x","y"],resize:["extent","width","height"],scale:["matrix","immediate"],"time-extent-change":["timeExtent"],"before-unload":["map"],unload:["map"],"update-end":["error"],"update-start":!0,zoom:["extent","zoomFactor","anchor"],"zoom-end":["extent","zoomFactor","anchor","level"],"zoom-start":["extent","zoomFactor","anchor","level"],click:!0,"dbl-click":!0,"key-down":!0,"key-up":!0,"mouse-down":!0,
"mouse-drag":!0,"mouse-drag-end":!0,"mouse-drag-start":!0,"mouse-move":!0,"mouse-out":!0,"mouse-over":!0,"mouse-up":!0,"mouse-wheel":!0,"basic-tap":!0,"double-tap":!0,"pinch-end":!0,"pinch-move":!0,"pinch-start":!0,"processed-double-tap":!0,"processed-tap":!0,"swipe-end":!0,"swipe-move":!0,"swipe-start":!0,tap:!0,"two-finger-tap":!0},constructor:function(a,b){b=b||{};this.registerConnectEvents();T(this,{_internalLayerIds:[],_layers:[],_layerDivs:[],_layerSize:0,_connects:[],_zoomAnimDiv:null,_zoomAnim:null,
_layersDiv:null,_firstLayerId:null,_delta:null,_cursor:null,_ratioW:1,_ratioH:1,_params:null,_minResolution:0,_maxResolution:0,cursor:null,layerIds:[],graphicsLayerIds:[],graphics:null,_labels:null,loaded:!1,__panning:!1,__zooming:!1,__container:null,root:null,__LOD:null,__tileInfo:null,__visibleRect:null,__visibleDelta:null,_rids:[]});var c=this.container=ra.byId(a),d=this.id=sa.get(c,"id")||ta.getUniqueId(this.declaredClass);Z.add(c,"map");var e=W.getContentBox(c),f=Z.add,g=C.create;this.position=
new F(0,0);this._reposition();var k=this.width=0<e.w?e.w:J.width,h=this.height=0<e.h?e.h:J.height,m=this.root=g("div",{id:d+"_root",style:{width:k+"px",height:h+"px",direction:"ltr"}});f(m,"esriMapContainer");e=this.__container=g("div",{id:d+"_container"},m);L(e,"position","absolute");f(e,"esriMapContainer");c.appendChild(m);c=this._params=T({slider:!0,nav:!1,zoom:-1,minZoom:-1,maxZoom:-1,scale:-1,minScale:0,maxScale:0,showInfoWindowOnClick:!0,displayGraphicsOnPan:!0,wrapAround180:!0,fitExtent:!1,
optimizePanAnimation:!0},b);this.wrapAround180=c.wrapAround180;this.optimizePanAnimation=c.optimizePanAnimation;this.setBackgroundColor(c.backgroundColor);w.isDefined(c.resizeDelay)&&(this.resizeDelay=c.resizeDelay);c.lods&&(ja({rows:512,cols:512,dpi:96,format:"JPEG",compressionQuality:75,origin:{x:-180,y:90},spatialReference:{wkid:4326},lods:c.lods},c),this.__tileInfo=c.tileInfo);this.extent=c.extent;this._extentUtil({mapCenter:c.center,targetLevel:c.zoom,targetScale:c.scale});this.__visibleRect=
new P(0,0,k,h);this.__visibleDelta=new P(0,0,k,h);d=this._layersDiv=g("div",{id:d+"_layers"});f(d,"esriMapLayers");e.appendChild(d);this._zoomAnimDiv=g("div",{style:{position:"absolute"}});c.infoWindow?this.infoWindow=c.infoWindow:(f=this.infoWindow=new Ia(c.popupOptions,g("div")),f.startup(),f._ootb=!0,L(f.domNode,"zIndex",40));if(c.showLabels){var x=this;S(["./layers/LabelLayer"],function(a){ba=a;x._createLabelLayer()});this.on("load",function(){x._createLabelLayer()})}this.addPlugin(this._getAbsMid("./plugins/popupManager"),
{enabled:c.showInfoWindowOnClick});this._zoomStartHandler=t(this,this._zoomStartHandler);this._zoomingHandler=t(this,this._zoomingHandler);this._zoomEndHandler=t(this,this._zoomEndHandler);this._panningHandler=t(this,this._panningHandler);this._panEndHandler=t(this,this._panEndHandler);this._endTranslate=t(this,this._endTranslate);this._timedResize=t(this,this._timedResize);this._execResize=t(this,this._execResize);this._processLabelLayers=t(this,this._processLabelLayers);this._updateLabelLayers=
t(this,this._updateLabelLayers);this.resize=t(this,this.resize);qa.addOnWindowUnload(this,this.destroy)},_getAbsMid:function(a){return S.toAbsMid?S.toAbsMid(a):oa.id.replace(/\/[^\/]*$/ig,"/")+a},_cleanUp:function(){var a=this.infoWindow;a&&(a._ootb&&a.destroy?a.destroy():a.unsetMap(this),delete this.infoWindow);R(this._tsTimeExtentChange_connect);this.removePlugin("./plugins/popupManager");C.destroy(this.root);this.root=null},_addLayer:function(a,b,c){if(a.id){var d=a.id.match(a instanceof z?Ka:
Ja);d&&d[1]&&(d=Number(d[1]),Y<=d&&(Y=d+1))}var e=a.id||(a instanceof z?la:ka)+Y++;a.id=e;this._layers[e]=a;var f,g;if(b===this.layerIds||b===this.graphicsLayerIds)f=this._layerSize,this._layerSize++;a._isRefLayer="top"===c;c=!w.isDefined(c)||0>c||c>b.length||"top"===c?b.length:c;0===f&&(this._firstLayerId=e);if(!a._isRefLayer)for(;(g=this.getLayer(b[c-1]))&&g._isRefLayer;)c--;b.splice(c,0,e);var k=t(this,this._addLayerHandler),h=this;c=this._connects;d=function(){a.loaded?h._onLoadFix?(h._onLoadFix=
!1,setTimeout(function(){k(a)},0)):k(a):(h["_"+e+"_addtoken_load"]=X(a,"onLoad",h,"_addLayerHandler"),h["_"+e+"_addtoken_err"]=X(a,"onError",h,function(c){k(a,c,b)}))};this.loaded||0===f||a.loaded&&-1===Q(this.graphicsLayerIds,e)?d():c.push(X(this,"onLoad",d));return a},_addLayerHandler:function(a,b,c){var d=this.id,e=a.id,f=Q(a instanceof z?this.graphicsLayerIds:this.layerIds,e),g=f,k=!1,h=this._params;R(this["_"+e+"_addtoken_load"]);R(this["_"+e+"_addtoken_err"]);if(b)delete this._layers[e],-1!==
f&&(c.splice(f,1),this.onLayerAddResult(a,b));else{-1===f&&(f=Q(this._internalLayerIds,e),g=20+f,k=!0);if(e===this._firstLayerId){b=a.spatialReference;c=this.extent&&this.extent.spatialReference;!c||c.equals(b)||!a.tileInfo&&a.url||(c=null);c=this.spatialReference=c||b;this.wrapAround180=this.wrapAround180&&c&&c._isWrappable()?!0:!1;a.tileInfo&&(this.__tileInfo?(b=this.__tileInfo.lods,this.__tileInfo=T({},a.tileInfo),this.__tileInfo.lods=b):(ja(T({},a.tileInfo),h),this.__tileInfo=h.tileInfo));if(this.wrapAround180){b=
this.__tileInfo;c=c._getInfo();if(!b||Math.abs(c.origin[0]-b.origin.x)>c.dx)this.wrapAround180=!1;this.wrapAround180&&b&&fa._addFrameInfo(b,c)}h.units=a.units;if((b=this.__tileInfo&&this.__tileInfo.lods)&&b.length){c=h.minScale;var f=h.maxScale,m=-1,x=-1,n=!1,M=!1,r;for(r=0;r<b.length;r++)0<c&&!n&&c>=b[r].scale&&(m=b[r].level,n=!0),0<f&&!M&&f>=b[r].scale&&(x=0<r?b[r-1].level:-1,M=!0);-1===h.minZoom&&(h.minZoom=0===c?b[0].level:m);-1===h.maxZoom&&(h.maxZoom=0===f?b[b.length-1].level:x);for(r=0;r<b.length;r++)h.minZoom===
b[r].level&&(h.minScale=b[r].scale,this._minResolution=b[r].resolution),h.maxZoom===b[r].level&&(h.maxScale=b[r].scale,this._maxResolution=b[r].resolution)}else h.minZoom=h.maxZoom=h.zoom=-1}a instanceof z?(this._gc||(this._gc=new z._GraphicsContainer,this._gc._setMap(this,this._layersDiv).id=d+"_gc"),g=a._setMap(this,this._gc._surface),g.id=d+"_"+e,this._layerDivs[e]=g,this._reorderLayers(this.graphicsLayerIds)):(g=a._setMap(this,this._layersDiv,g,this.__LOD),g.id=d+"_"+e,this._layerDivs[e]=g,this._reorderLayers(this.layerIds),
k||-1===a.declaredClass.indexOf("VETiledLayer")||this._onBingLayerAdd(a));e===this._firstLayerId&&(this.graphics=new z({id:d+"_graphics",displayOnPan:h.displayGraphicsOnPan}),this._addLayer(this.graphics,this._internalLayerIds,20));if(a===this.graphics){c=this._layers[this._firstLayerId];d=h.zoom;g=h.scale;b=h.center;c=c.initialExtent||c.fullExtent;this._firstLayerId=null;this.extent&&(this.extent=this._convertGeometry(this,this.extent));!this.extent&&c&&(b&&(b=this._convertGeometry(c,b)),b&&(c=c.centerAt(b),
b=null));if(b=this.extent||c&&new B(c.toJson()))-1<d?b=this.__getExtentForLevel(d,null,b).extent:0<g&&(b=I.getExtentForScale(this,g,b));if(!b){console.log("Map: "+this.invalidExtent);return}h=this._fixExtent(b,h.fitExtent);this.extent=h.extent;this.__LOD=h.lod;this.__setExtent(this.extent);this.loaded=!0;this.attr("data-loaded","");this.infoWindow.setMap(this);this.onLoad(this)}k||(this.onLayerAdd(a),this.onLayerAddResult(a));R(this[e+"_addLayerHandler_connect"])}},_convertGeometry:function(a,b){var c=
a&&a.spatialReference,d=b&&b.spatialReference;c&&d&&!c.equals(d)&&(c._canProject(d)?c.isWebMercator()?b=aa.geographicToWebMercator(b):4326===c.wkid&&(b=aa.webMercatorToGeographic(b,!0)):(console.log("Map: "+w.substitute({geometry:d.wkid||d.wkt,map:c.wkid||c.wkt},this.invalidGeometry)),b=null));return b},_reorderLayers:function(a){var b=this.onLayerReorder,c=C.place,d=this._layerDivs,e=this._layers,f=this._gc?this._gc._surface.getEventSource():null;if(a===this.graphicsLayerIds)l.forEach(a,function(a,
g){var h=d[a];h&&(c(h.getEventSource(),f,g),b(e[a],g))});else{var g=this.graphics,k=g?g.id:null,h=this._layersDiv,m;l.forEach(a,function(a,f){m=d[a];a!==k&&m&&(c(m,h,f),b(e[a],f))});this._mapImageLyr&&this._placeMapImageLyr();f&&(f=9>E("ie")?f.parentNode:f,c(f,f.parentNode,a.length))}this.onLayersReordered([].concat(a))},_zoomStartHandler:function(){this.__zoomStart(this._zoomAnimDiv.startingExtent,this._zoomAnimDiv.anchor)},_zoomingHandler:function(a){var b=parseFloat(a.left),c=parseFloat(a.top);
a=new B(b,c-parseFloat(a.height),b+parseFloat(a.width),c,this.spatialReference);b=this.extent.getWidth()/a.getWidth();this.__zoom(a,b,this._zoomAnimDiv.anchor)},_zoomEndHandler:function(){var a=this._zoomAnimDiv,b=a.extent,c=this.extent.getWidth()/b.getWidth(),d=a.anchor,e=a.newLod,f=a.levelChange;a.extent=a.anchor=a.levelChange=a.startingExtent=a.newLod=this._delta=this._zoomAnim=null;this.__zoomEnd(b,c,d,e,f)},_panningHandler:function(a){if(isNaN(parseFloat(a.left))||isNaN(parseFloat(a.top))){var b=
Math.round,c=this._panAnim.node;a.left=-1*(this._delta.x-b(this.width/2))+"px";a.top=-1*(this._delta.y-b(this.height/2))+"px";N.set(c,"left",a.left);N.set(c,"top",a.top)}a=new F(parseFloat(a.left),parseFloat(a.top));b=this.toMap(a);this.onPan(this.extent.offset(this.extent.xmin-b.x,this.extent.ymax-b.y),a)},_panEndHandler:function(a){this.__panning=!1;var b=Math.round;a=new F(-b(parseFloat(a.style.left)),-b(parseFloat(a.style.top)));var b=a.x,c=a.y,d=this.__visibleRect,e=this.__visibleDelta;d.x+=
-b;d.y+=-c;e.x+=-b;e.y+=-c;L(this._zoomAnimDiv,{left:"0px",top:"0px"});var d=this.extent,e=this._ratioW,f=this._ratioH,d=new B(d.xmin+b/e,d.ymin-c/f,d.xmax+b/e,d.ymax-c/f,this.spatialReference);a.setX(-a.x);a.setY(-a.y);this._delta=this._panAnim=null;this._updateExtent(d);this.onPanEnd(d,a);this._fireExtChg([d,a,!1,this.__LOD])},_fixExtent:function(a,b){for(var c=this._reshapeExtent(a),d=1.25;!0===b&&(c.extent.getWidth()<a.getWidth()||c.extent.getHeight()<a.getHeight())&&0<c.lod.level&&3>=d;)c=this._reshapeExtent(a.expand(d)),
d+=.25;return c},_getFrameWidth:function(){var a=-1,b=this.spatialReference._getInfo();this.__LOD?(b=this.__LOD._frameInfo)&&(a=b[3]):b&&(a=Math.round(2*b.valid[1]/(this.extent.getWidth()/this.width)));return a},_fixAspectRatio:function(a){var b=a.getWidth(),c=a.getHeight(),d=b/c,e=this.width/this.height,f=0,g=0;this.width>this.height?b>c?e>d?f=c*e-b:g=b/e-c:f=c*e-b:this.width<this.height?b<c?e>d?f=c*e-b:g=b/e-c:g=b/e-c:b<c?f=c-b:b>c&&(g=b/e-c);f&&(a.xmin-=f/2,a.xmax+=f/2);g&&(a.ymin-=g/2,a.ymax+=
g/2);return a},_reshapeExtent:function(a){a=this._fixAspectRatio(a);return this._getAdjustedExtent(a)},_getAdjustedExtent:function(a){if(this.__tileInfo)return fa.getCandidateTileInfo(this,this.__tileInfo,a);var b=I.getScale(this,a),c=this.getMinScale(),d=this.getMaxScale();!c||b<=c?!d||b>=d||(a=I.getExtentForScale(this,d,a)):a=I.getExtentForScale(this,c,a);return{extent:a}},_onBingLayerAdd:function(a){this["__"+a.id+"_vis_connect"]=A.connect(a,"onVisibilityChange",this,"_toggleBingLogo");this._toggleBingLogo(a.visible)},
_onBingLayerRemove:function(a){A.disconnect(this["__"+a.id+"_vis_connect"]);delete this["__"+a.id+"_vis_connect"];var b=l.some(this.layerIds,function(b){return(a=this._layers[b])&&a.visible&&-1!==a.declaredClass.indexOf("VETiledLayer")},this);this._toggleBingLogo(b)},_toggleBingLogo:function(a){a&&!this._bingLogo?(a={left:this._mapParams&&this._mapParams.nav?"25px":""},6===E("ie")&&(a.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled\x3d'true', sizingMethod\x3d'crop', src\x3d'"+S.toUrl("./images/map/bing-logo-lg.png")+
"')"),a=this._bingLogo=C.create("div",{style:a},this.root),Z.add(a,"bingLogo-lg")):!a&&this._bingLogo&&(C.destroy(this._bingLogo),delete this._bingLogo)},__panStart:function(a,b){var c=this._zoomAnim,d=this._panAnim;if(c&&c._active)c.stop(),c._fire("onEnd",[c.node]);else if(d&&d._active){d.stop();this._panAnim=null;var d=d.curve.getValue(d._getStep()),c=Math.round(parseFloat(d.left)),d=Math.round(parseFloat(d.top)),e=this.navigationManager._dragOrigin;this.__pan(c,d);e&&(e.x-=c,e.y-=d);return}this.__panning=
!0;this.onPanStart(this.extent,new F(a,b))},__pan:function(a,b){var c=this.extent,d=this._ratioW,e=this._ratioH;this.onPan(new B(c.xmin-a/d,c.ymin+b/e,c.xmax-a/d,c.ymax+b/e,this.spatialReference),new F(a,b))},__panEnd:function(a,b){var c=this.__visibleRect,d=this.__visibleDelta;c.x+=a;c.y+=b;d.x+=a;d.y+=b;var c=new F(a,b),d=this.extent,e=this._ratioW,f=this._ratioH,d=new B(d.xmin-a/e,d.ymin+b/f,d.xmax-a/e,d.ymax+b/f,this.spatialReference);this.__panning=!1;this._updateExtent(d);this.onPanEnd(d,c);
this._fireExtChg([d,c,!1,this.__LOD])},__zoomStart:function(a,b){this.__zooming=!0;this.onZoomStart(a,1,b,this.__LOD?this.__LOD.level:null)},__zoom:function(a,b,c){this.onZoom(a,b,c)},__zoomEnd:function(a,b,c,d,e){L(this._layersDiv,{left:"0px",top:"0px"});this._delta=new F(0,0);this.__visibleRect.x=this.__visibleRect.y=0;a=new B(a);this.__LOD=d;this._ratioW=this.width/a.getWidth();this._ratioH=this.height/a.getHeight();var f=this._delta;this._delta=null;this.__zooming=!1;this._updateExtent(a,e);this.onZoomEnd(a,
b,c,d?d.level:null);this._fireExtChg([a,f,e,d])},_extentUtil:function(a,b,c,d,e){var f=new da,g,k,h,m,x,n,M,r,p,l,q=this.width,u=this.height,t,y,v;a&&(g=a.numLevels,k=a.targetLevel,t=w.isDefined(k),h=a.factor,m=a.mapAnchor,x=a.screenAnchor,n=a.mapCenter,y=a.levelOrFactor,M=a.targetScale,r=w.isDefined(M)&&0<M);b&&(p=b.dx,l=b.dy,n=b.mapCenter);K.isArray(n)&&(n=new O(n));var A=this._panAnim;b=(a=this._stopAnim())?a.divExtent:this.extent;var z=this.__tileInfo,H=this._params;if(!this.loaded){if(c)b&&(c=
this._convertGeometry(b,c)),c&&(this.extent=c,H.zoom=H.scale=-1,H.center=null);else if(n||t||r){if(n)if(b){if(n=this._convertGeometry(b,n))this.extent=b.centerAt(n),H.center=null}else H.center=n;t&&-1<k?(H.zoom=k,H.scale=-1):r&&(H.scale=M,H.zoom=-1)}f.resolve();return f}if(n&&(n=this._convertGeometry(this,n),!n)||m&&(m=this._convertGeometry(this,m),!m)||c&&(c=this._convertGeometry(this,c),!c))return f.reject(),f;A&&m&&x&&(m=U(this.extent,q,u,x));a&&m&&x&&(m=U(a.divExtent,q,u,x));t&&(z?(g=this.getMinZoom(),
t=this.getMaxZoom(),k<g?k=g:k>t&&(k=t),g=k-(a?a.level:this.getLevel())):(g=0<k?-1:1,v=y?k:null));if(!c)if(w.isDefined(g))z?(q=a?a.level:this.getLevel(),q=this.__getExtentForLevel(q+g,n,b).extent):(q=(a?a.end:this.extent).expand(v||(0<g?.5*g:2*-g)),v&&n&&(q=q.centerAt(n))),q&&(n?c=q:(p=m||b.getCenter(),u=q.getWidth(),l=q.getHeight(),q=p.x>=b.xmin&&p.x<=b.xmax?(p.x-b.xmin)/b.getWidth():.5,c=p.y>=b.ymin&&p.y<=b.ymax?(p.y-b.ymin)/b.getHeight():.5,q=p.x-q*u,p=p.y-c*l,c=new B(q,p,q+u,p+l,this.spatialReference)));
else if(r)c=I.getExtentForScale(this,M,b);else if(w.isDefined(h))c=b.expand(h);else if(p||l)a?(c=a.end,m=c.getCenter(),v=ca(c,q,u,m),v.x+=p,v.y+=l,v=U(c,q,u,v),c=c.offset(v.x-m.x,v.y-m.y)):(p=new F(q/2+p,u/2+l),p=U(b,q,u,p),u=b.getWidth(),l=b.getHeight(),q=p.x-u/2,p=p.y-l/2,c=new B(q,p,q+u,p+l,this.spatialReference));c||(n?(b=a?a.end:b,u=b.getWidth(),l=b.getHeight(),q=n.x-u/2,p=n.y-l/2,c=new B(q,p,q+u,p+l,this.spatialReference)):a&&(c=a.end));c?(this._extentDfd&&-1===this._extentDfd.fired&&(this._extentDfd.then(null,
La),this._extentDfd.reject()),this._extentDfd=f,this.__setExtent(c,null,x,d,a,e)):f.reject();return f},__setExtent:function(a,b,c,d,e,f){try{if(this._firstLayerId)this.extent=a;else{var g=!0,k=this.spatialReference,h=e?e.divExtent:this.extent,m=this._fixExtent(a,d||!1);a=m.extent;var x=a.getWidth(),n=a.getHeight(),l=Math.round;if(h)var r=l(1E6*h.getWidth()),p=l(1E6*x),t=l(1E6*h.getHeight()),q=l(1E6*n),g=r!==p||t!==q;var u,w,y=e&&e.rect,v=e&&e.divExtent;if(J.zoomDuration&&g&&h){v=v||new B(h);y=y||
{left:h.xmin,top:h.ymax,width:h.getWidth(),height:h.getHeight()};w={left:a.xmin,top:a.ymax,width:x,height:n};var z=new O(a.xmin,a.ymax,k),A=new O(a.xmin,a.ymin,k),H=new O(this.extent.xmin,this.extent.ymax,k),G=new O(this.extent.xmin,this.extent.ymin,k);(u=Ca.getLineIntersection(H,z,G,A,k))||e||(g=!1)}this._ratioW=this.width/x;this._ratioH=this.height/n;var D=this._zoomAnimDiv;if(g)if(L(this._layersDiv,{left:"0px",top:"0px"}),b=new F(0,0),this.__visibleRect.x=this.__visibleRect.y=0,y&&w){this._delta=
b;D.id="_zAD";D.startingExtent=v;D.extent=a;D.levelChange=g;D.newLod=m.lod;D.anchor=c?c:!u&&e?e.anchor:ca(this.extent,this.width,this.height,u);var C=this.extent.getWidth()/a.getWidth();1024<(1>C?1/C:C)?(this.__zoomStart(v,D.anchor),this.__zoom(v,1,D.anchor),this._fireOnScale(1,D.anchor,!0),this.__zoomEnd(a,C,D.anchor,m.lod,g)):(this._zoomAnim=ea.resize({node:D,start:y,end:w,duration:J.zoomDuration,rate:J.zoomRate,beforeBegin:e?null:this._zoomStartHandler,onAnimate:this._zoomingHandler,onEnd:this._zoomEndHandler}).play(),
this._fireOnScale(C,D.anchor,f))}else this._updateExtent(a,g,f),this._fireExtChg([this.extent,b,g,this.__LOD=m.lod]);else if(!this.__panning)if(!1===this.loaded||f)this._updateExtent(a,g,f),this._fireExtChg([this.extent,b,g,this.__LOD=m.lod]);else{this.__panning=!0;y=(new P(0,0,this.width,this.height,this.spatialReference)).getCenter();y.x=l(y.x);y.y=l(y.y);var E=this._delta=this.toScreen(a.getCenter()),I=Math.abs(y.x-E.x),K=Math.abs(y.y-E.y);this.optimizePanAnimation&&(I>2*this.width||K>2*this.height)?
(this.__panStart(0,0),this.__pan(0,0),this.__visibleRect.x=this.__visibleRect.y=this.__visibleDelta.x=this.__visibleDelta.y=0,this.__panning=!1,this._delta=null,this._updateExtent(a,!1,f),this.onPanEnd(this.extent,new F(0,0)),this._fireExtChg([this.extent,new F(0,0),!0,this.__LOD])):(this.onPanStart(this.extent,new F(0,0)),this._panAnim=ea.slideTo({node:D,left:y.x-E.x,top:y.y-E.y,duration:J.panDuration,rate:J.panRate,onAnimate:this._panningHandler,onEnd:this._panEndHandler}),this._panAnim.play())}}}catch(na){console.log(na.stack),
console.error(na)}},_fireOnScale:function(a,b,c){if("css-transforms"===this.navigationMode){var d=this.__visibleDelta;this.onScale(ua.scaleAt(a,{x:-1*(this.width/2-(b.x-d.x)),y:-1*(this.height/2-(b.y-d.y))}),c)}},_stopAnim:function(){var a=this._zoomAnim,b=this._panAnim;if(a&&a._active){a.stop();var b=a.curve.getValue(a._getStep()),c=parseFloat(b.left),d=parseFloat(b.top),a=a.node;return{anchor:a.anchor,start:a.startingExtent,end:a.extent,level:a.newLod&&a.newLod.level,rect:b,divExtent:new B(c,d-
parseFloat(b.height),c+parseFloat(b.width),d,this.spatialReference)}}b&&b._active&&(b.stop(),b._fire("onEnd",[b.node]))},__getExtentForLevel:function(a,b,c){var d=this.__tileInfo,d=d&&d.lods;a=w.isDefined(a)?a:0;c=c||this.extent;b=b||c&&c.getCenter();if(d){if(b){c=this.getMinZoom();var e=this.getMaxZoom();a>e&&(a=e);a<c&&(a=c);a=d[a];d=this.width*a.resolution/2;c=this.height*a.resolution/2;return{extent:new B(b.x-d,b.y-c,b.x+d,b.y+c,b.spatialReference),lod:a}}}else if(c)return{extent:c.expand(!a||
1>a?1:a).centerAt(b)};console.log("Map: "+this.invalidExtent)},_jobs:0,_incr:function(){1===++this._jobs&&(this.updating=!0,this.attr("data-updating",""),this.onUpdateStart())},_decr:function(){var a=--this._jobs;a?0>a&&(this._jobs=0):(this.updating=!1,this.attr("data-updating"),this.onUpdateEnd())},_fireEvent:function(a,b){this[a]&&this[a].apply(this,b)},_updateExtent:function(a,b,c){this.extent=a;a=this.spatialReference;this._viewInfo={view:new Ba({viewingMode:"map",scale:this.getScale()}),sr:a,
_version:b?++ma:ma};(b||c)&&this._setClipRect();this._calcGeographicExtent()},_calcGeographicExtent:function(){var a=this.spatialReference;a&&(a.isWebMercator()?this.geographicExtent=aa.webMercatorToGeographic(this._getAvailExtent(),!0):4326===a.wkid&&(this.geographicExtent=new B(this._getAvailExtent().toJson())))},_fireExtChg:function(a){this.attr("data-zoom",this.getZoom());this.attr("data-scale",this.getScale());this._fireEvent("onExtentChange",a);if(a=this._extentDfd)delete this._extentDfd,a.resolve()},
attr:function(a,b){var c=this.container;c&&(null==b?c.removeAttribute(a):c.setAttribute(a,b));return this},onUpdateStart:function(){},onUpdateEnd:function(){},onLoad:function(){this._setClipRect();this._calcGeographicExtent()},onBeforeUnload:function(){},onUnload:function(){},onExtentChange:function(a,b,c){},onTimeExtentChange:function(){},onLayerAdd:function(){},onLayerAddResult:function(){},onLayersAddResult:function(){},onLayerRemove:function(){},onLayersRemoved:function(){},onLayerReorder:function(){},
onLayersReordered:function(){},onLayerSuspend:function(){},onLayerResume:function(){},onPanStart:function(){},onPan:function(){},onPanEnd:function(){},onScale:function(){},onZoomStart:function(){},onZoom:function(){},onZoomEnd:function(){},onResize:function(){this._setClipRect()},onReposition:function(){},destroy:function(){this._destroyed||(this.onBeforeUnload(this),this.removeAllLayers(),this._cleanUp(),clearTimeout(this._resizeTimerHandle),this._gc&&this._gc._cleanUp(),this._destroyed=!0,this.onUnload(this))},
setCursor:function(a){L(this.__container,"cursor",this.cursor=a)},setMapCursor:function(a){this.setCursor(this._cursor=a)},resetMapCursor:function(){this.setCursor(this._cursor)},setBackgroundColor:function(a){a&&!a.declaredClass&&(a=new Aa(a));this.backgroundColor=a||null;var b="";a&&(b=9>E("ie")?a.toHex():"rgba("+a.toRgba().join(",")+")");N.set(this.root,{backgroundColor:b})},setInfoWindow:function(a){var b=this.infoWindow;b&&b.unsetMap(this);this.infoWindow=a;this.loaded&&a&&a.setMap(this)},setInfoWindowOnClick:function(a){this._params.showInfoWindowOnClick=
a;this.popupManager&&this.popupManager.set("enabled",a)},getInfoWindowAnchor:function(a){return this.infoWindow&&this.infoWindow._getAnchor&&this.infoWindow._getAnchor(a)||"upperright"},toScreen:function(a,b){return ca(this.extent,this.width,this.height,a,b)},toMap:function(a){return U(this.extent,this.width,this.height,a)},addLayer:function(a,b){a&&!this.getLayer(a.id)&&this._addLayer(a,a instanceof z?this.graphicsLayerIds:this.layerIds,b);return a},addLayers:function(a){var b=[],c=a.length,d,e,
f=a.length;d=A.connect(this,"onLayerAddResult",function(e,f){-1!==l.indexOf(a,e)&&(c--,b.push({layer:e,success:!f,error:f}),c||(A.disconnect(d),this.onLayersAddResult(b)))});for(e=0;e<f;e++)this.addLayer(a[e]);return this},removeLayer:function(a,b){var c=a.id,d=a instanceof z?this.graphicsLayerIds:this.layerIds,e=Q(d,c);0<=e&&(d.splice(e,1),a instanceof z?(R(this["_gl_"+a.id+"_click_connect"]),a.loaded&&a._unsetMap(this,this._gc._surface)):a.loaded&&(a._unsetMap(this,this._layersDiv),-1!==a.declaredClass.indexOf("VETiledLayer")&&
this._onBingLayerRemove(a)),delete this._layers[c],delete this._layerDivs[c],b||this._reorderLayers(d),this.onLayerRemove(a))},removeAllLayers:function(){var a=this.layerIds,b;for(b=a.length-1;0<=b;b--)this.removeLayer(this._layers[a[b]],1);a=this.graphicsLayerIds;for(b=a.length-1;0<=b;b--)this.removeLayer(this._layers[a[b]],1);this.onLayersRemoved()},reorderLayer:function(a,b){K.isString(a)&&(pa.deprecated(this.declaredClass+": Map.reorderLayer(/*String*/ id, /*Number*/ index) deprecated. Use Map.reorderLayer(/*Layer*/ layer, /*Number*/ index).",
null,"v2.0"),a=this.getLayer(a));var c=a.id,d,e=a instanceof z?this.graphicsLayerIds:this.layerIds;0>b?b=0:b>=e.length&&(b=e.length-1);d=Q(e,c);-1!==d&&d!==b&&(e.splice(d,1),e.splice(b,0,c),this._reorderLayers(e))},getLayer:function(a){return this._layers[a]},setExtent:function(a,b){a=new B(a.toJson());var c=a.getWidth(),d=a.getHeight();return 0===c&&0===d?this.centerAt(new O({x:a.xmin,y:a.ymin,spatialReference:a.spatialReference&&a.spatialReference.toJson()})):this._extentUtil(null,null,a,b)},centerAt:function(a){return this._extentUtil(null,
{mapCenter:a})},centerAndZoom:function(a,b){return this._extentUtil({targetLevel:b,mapCenter:a,levelOrFactor:!0})},getScale:function(){return this.__LOD?this.__LOD.scale:I.getScale(this)},getResolution:function(){return this.__LOD?this.__LOD.resolution:this.extent?this.extent.getWidth()/this.width:0},getResolutionInMeters:function(){return this.getResolution()*I.getUnitValueForSR(this.spatialReference)},getMinResolution:function(){return this._minResolution},getMaxResolution:function(){return this._maxResolution},
getMinScale:function(){return this._params.minScale},getMaxScale:function(){return this._params.maxScale},_getViewInfo:function(){return this._viewInfo},setScale:function(a){return this._extentUtil({targetScale:a})},getLayersVisibleAtScale:function(a){var b=[];(a=a||this.getScale())&&l.forEach(this.layerIds.concat(this.graphicsLayerIds),function(c){c=this.getLayer(c);c.isVisibleAtScale(a)&&b.push(c)},this);return b},getNumLevels:function(){var a=this.getMinZoom(),b=this.getMaxZoom();return a===b&&
0>a?0:b-a+1},getLevel:function(){return this.__LOD?this.__LOD.level:-1},setLevel:function(a){if(-1<a)return this._extentUtil({targetLevel:a})},getZoom:function(){return this.getLevel()},setZoom:function(a){return this.setLevel(a)},getMinZoom:function(){return this._params.minZoom},getMaxZoom:function(){return this._params.maxZoom},setBasemap:function(a){var b;K.isObject(a)?(b=a,a=b.title):b=G&&G[a];if(b){this._basemapDfd&&-1===this._basemapDfd.fired&&this._basemapDfd.cancel();var c=[],d=[],e=0;l.forEach(b.baseMapLayers||
b.layers,function(b){var f,g={id:b.id,displayLevels:b.displayLevels,opacity:w.isDefined(b.opacity)?b.opacity:null,visible:w.isDefined(b.visibility)?b.visibility:null};if(b.type)switch(b.type){case "OpenStreetMap":f=new ia(g);break;case "VectorTile":f=ga.normalize(b.url);f=new Ha(f,g);break;default:console.log("Map.setBasemap: "+w.substitute({basemapName:a,type:b.type},this.unknownLayerType))}else f=ga.normalize(b.url),f=new Fa(f,g);f&&(c.push(f),d.push(b),b.isReference||e++)},this);if(c.length&&e){var f=
{basemapName:a,infos:d,layers:c};if(this.loaded){var g=this,k=new da(ya._dfdCanceller),h=function(a){k._pendingLayers--;a=l.indexOf(f.layers,this);-1<a&&(a=k._layerEvents[a])&&(A.disconnect(a[0]),A.disconnect(a[1]));0>=k._pendingLayers&&(delete k._layerEvents,delete g._basemapDfd,0>k.fired&&k.callback(f))};this._basemapDfd=k;k._pendingLayers=0;k._layerEvents={};l.forEach(c,function(a,b){a&&(k._pendingLayers++,a.loaded?h(a):k._layerEvents[b]=[A.connect(a,"onLoad",a,h),A.connect(a,"onError",a,h)])});
k.addCallback(t(this,this._basemapLoaded))}else this._basemapLoaded(f)}else console.log("Map.setBasemap: "+w.substitute({basemapName:a},this.invalidBasemap))}else{b=[];for(var m in G)b.push(m);console.log("Map.setBasemap: "+w.substitute({basemapName:a,list:b.join(",")},this.unknownBasemap))}},_basemapLoaded:function(a){var b=a.layers,c=a.infos,d=0,e=!0,f;this.loaded&&(l.forEach(b,function(a,b){a.loaded&&(c[b].isReference||d++)}),e=d);e&&(this.basemapLayerIds&&(f={basemapName:this._basemap,infos:G&&
G[this._basemap]&&G[this._basemap].baseMapLayers},f.basemapName||(l.forEach(this.basemapLayerIds,function(a){if(this.getLayer(a)instanceof ia)return f.basemapName="osm",f.infos=G&&G.osm&&G.osm.baseMapLayers,!1},this),f.basemapName||(f=null))),this._removeBasemap(),this._basemap=a.basemapName,this.basemapLayerIds=this._addBasemap(b,c),this.attr("data-basemap",this.getBasemap()),this.emit("basemap-change",{current:a,previous:f}))},_addBasemap:function(a,b){var c=[],d=[],e=0;l.forEach(a,function(a,g){b[g].isReference?
c.push(a):(this.addLayer(a,e++),d.push(a.id))},this);c.length&&l.forEach(c,function(a){a.attr("data-reference",!0);this.addLayer(a,"top");d.push(a.id)},this);return d},_removeBasemap:function(){var a=this.basemapLayerIds,b;a&&a.length&&l.forEach(a,function(a){(b=this.getLayer(a))&&this.removeLayer(b)},this)},getBasemap:function(){return this._basemap||""},translate:function(a,b){a=a||0;b=b||0;if(!this._txTimer){this._tx=this._ty=0;var c=this.toScreen(this.extent.getCenter());this.__panStart(c.x,c.y)}this._tx+=
a;this._ty+=b;this.__pan(this._tx,this._ty);clearTimeout(this._txTimer);this._txTimer=setTimeout(this._endTranslate,150)},_endTranslate:function(){clearTimeout(this._txTimer);this._txTimer=null;var a=this._tx,b=this._ty;this._tx=this._ty=0;this.__panEnd(a,b)},setTimeExtent:function(a){a=(this.timeExtent=a)?new a.constructor(a.toJson()):null;this.onTimeExtentChange(a)},setTimeSlider:function(a){this.timeSlider&&(R(this._tsTimeExtentChange_connect),this.timeSlider=this._tsTimeExtentChange_connect=null);
a&&(this.timeSlider=a,this.setTimeExtent(a.getCurrentTimeExtent()),this._tsTimeExtentChange_connect=X(a,"onTimeExtentChange",this,"setTimeExtent"))},setVisibility:function(a){if(this.visible!==a){this.visible=a;a||(this._display=this.container.style.display);this.container.style.display=a?this._display:"none";if(this.autoResize){var b=a?"resume":"pause";this._rszSignal[b]();this._oriSignal[b]()}a&&this.resize()}return this},resize:function(a){clearTimeout(this._resizeTimerHandle);this._destroyed||
(!0===a?this._execResize():this._resizeTimerHandle=setTimeout(this._execResize,this.resizeDelay))},_timedResize:function(){this._resizeTimerHandle||this._execResize()},_execResize:function(){clearTimeout(this._resizeTimerHandle);this._resizeTimerHandle=null;this.reposition();this._resize();this.autoResize&&this._startResizeTimer()},_resize:function(){var a=this.width,b=this.height,c=N.get(this.container,"display"),d=W.getContentBox(this.container);if(!("none"===c||0>=d.w||0>=d.h||a===d.w&&b===d.h)){if(c=
this._zoomAnim||this._panAnim)c.stop(),c._fire("onEnd",[c.node]);L(this.root,{width:(this.width=d.w)+"px",height:(this.height=d.h)+"px"});d=this.width;c=this.height;this.attribution&&this.attribution.domNode&&N.set(this.attribution.domNode,"maxWidth",Math.floor(d*this._mapParams.attributionWidth)+"px");this.__visibleRect.update(this.__visibleRect.x,this.__visibleRect.y,d,c);this.__visibleDelta.update(this.__visibleDelta.x,this.__visibleDelta.y,d,c);var e=new P(this.extent),a=(new P(e.x,e.y,d/a*e.width,
c/b*e.height,this.spatialReference)).getExtent();this.onResize(a,d,c);this._extentUtil(null,null,a,null,!0)}},reposition:function(){var a=this.position,b=a.x,c=a.y;this._reposition();a=this.position;if(b!==a.x||c!==a.y)this.onReposition(a.x,a.y)},_reposition:function(){var a=W.position(this.container,!0),b=W.getPadBorderExtents(this.container);this.position.update(a.x+b.l,a.y+b.t)},_setClipRect:function(){delete this._clip;var a=7>=E("ie")||void 0===E("ie")&&7<=E("trident")?"rect(auto,auto,auto,auto)":
"auto";if(this.wrapAround180){var b=this.width,c=this.height,d=this._getFrameWidth(),e=b-d;0<e&&(a=e/2,a="rect(0px,"+(a+d)+"px,"+c+"px,"+a+"px)",c=this.extent.getWidth(),b=d/b*c,this._clip=[(c-b)/2,b])}L(this.__container,"clip",a)},_getAvailExtent:function(){var a=this.extent,b=this._clip;if(b){if(!a._clip){var c=new P(a);c.width=b[1];c.x+=b[0];a._clip=c.getExtent()}return a._clip}return a},_fixedPan:function(a,b){return this._extentUtil(null,{dx:a,dy:b})},panUp:function(){return this._fixedPan(0,
-.75*this.height)},panUpperRight:function(){return this._fixedPan(.75*this.width,-.75*this.height)},panRight:function(){return this._fixedPan(.75*this.width,0)},panLowerRight:function(){return this._fixedPan(.75*this.width,.75*this.height)},panDown:function(){return this._fixedPan(0,.75*this.height)},panLowerLeft:function(){return this._fixedPan(-.75*this.width,.75*this.height)},panLeft:function(){return this._fixedPan(-.75*this.width,0)},panUpperLeft:function(){return this._fixedPan(-.75*this.width,
-.75*this.height)},enableSnapping:function(a){a=a||{};if("esri.SnappingManager"===a.declaredClass)this.snappingManager=a;else{var b=Y++,c=this;this._rids&&this._rids.push(b);S(["./SnappingManager"],function(d){var e=c._rids?l.indexOf(c._rids,b):-1;-1!==e&&(c._rids.splice(e,1),c.snappingManager=new d(K.mixin({map:c},a)))})}return this.snappingManager},disableSnapping:function(){this.snappingManager&&this.snappingManager.destroy();this.snappingManager=null},_createLabelLayer:function(){!this._labels&&
ba&&this.loaded&&(this._labels=new ba({id:"_internal_LabelLayer"}),this._labels._setMap(this,this._gc._surface),this._processLabelLayers(),this.on("layers-reordered",this._processLabelLayers))},_processLabelLayers:function(){null==this._labelProcessor&&(this._labelProcessor=setTimeout(this._updateLabelLayers,0))},_updateLabelLayers:function(){this._labelProcessor=null;this._labels&&(this._labels.removeAllFeatureLayers(),l.forEach(this.graphicsLayerIds,function(a){a=this.getLayer(a);"function"===typeof a.applyEdits?
this._labels.addFeatureLayer(a):"esri.layers.WFSLayer"===a.declaredClass&&this._labels.addFeatureLayer(a)},this))},_getMapImageLyr:function(){this.loaded&&!this._mapImageLyr&&(this._mapImageLyr=new Ga,this._mapImageLyr._setMap(this,this._layersDiv),this._placeMapImageLyr());return this._mapImageLyr},_placeMapImageLyr:function(){for(var a=this.layerIds,b=this._layerDivs,c=!1,d,e,f=a.length-1;0<=f;f--)if(d=a[f],e=this.getLayer(d),d=b[d],e&&d&&!e._isReference){C.place(this._mapImageLyr._div,d,"after");
c=!0;break}c||C.place(this._mapImageLyr._div,this._layersDiv,"first")}});E("extend-esri")&&(va._CoreMap=V);return V});