// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
require({cache:{"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/backgroundShaders.xml":'\x3c?xml version\x3d"1.0" encoding\x3d"UTF-8"?\x3e\r\n\x3c!--\r\n  // YF TODO: (doc)\r\n--\x3e\r\n\x3csnippets\x3e\r\n  \x3csnippet name\x3d"backgroundVS"\x3e\r\n    \x3c![CDATA[\r\n    precision mediump float;\r\n\r\n    attribute vec2 a_pos;\r\n\r\n  #ifdef ID\r\n    uniform mediump vec4 u_id;\r\n    varying mediump vec4 v_id;\r\n  #endif // ID\r\n\r\n    uniform highp mat4 u_transformMatrix;\r\n    uniform mediump vec2 u_normalized_origin;\r\n    uniform mediump float u_coord_range;\r\n    uniform mediump float u_depth;\r\n\r\n  #ifdef PATTERN\r\n    uniform mediump mat3 u_pattern_matrix; // can we use medium precision?\r\n    varying mediump vec2 v_tileTextureCoord;\r\n  #endif // PATTERN\r\n\r\n    void main() {\r\n      gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(u_coord_range * a_pos, 0.0, 1.0);\r\n\r\n  #ifdef PATTERN\r\n      // calculate the texture coordinates of the current vertex. It will of course get interpolated.\r\n      // The pattern matrix is a 3x3 scale matrix which \'tiles\' the texture inside the tile, translating from tile coordinates\r\n      v_tileTextureCoord \x3d (u_pattern_matrix * vec3(a_pos, 1.0)).xy;\r\n  #endif // PATTERN\r\n\r\n  #ifdef ID\r\n      v_id \x3d u_id / 255.0;\r\n  #endif // ID\r\n    }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d"backgroundFS"\x3e\r\n    \x3c![CDATA[\r\n  #ifdef PATTERN\r\n    uniform lowp float u_opacity;\r\n    uniform mediump vec2 u_pattern_tl;\r\n    uniform mediump vec2 u_pattern_br;\r\n    uniform sampler2D u_texture;\r\n\r\n    varying mediump vec2 v_tileTextureCoord;\r\n  #else\r\n    uniform lowp vec4 u_color;\r\n  #endif // PATTERN\r\n\r\n  #ifdef ID\r\n    varying mediump vec4 v_id;\r\n  #endif // ID\r\n\r\n    void main() {\r\n  #ifdef PATTERN\r\n      // normalize the calculated texture coordinate such that it fits in the range of 0 to 1.\r\n      mediump vec2 normalizedTextureCoord \x3d mod(v_tileTextureCoord, 1.0);\r\n\r\n      // interpolate the image coordinate between the top-left and the bottom right to get the actual position to sample.\r\n      // after normalizing the position, we get a value ranging between 0 and 1 which refers to the entire texture, however\r\n      // we need to only sample from area that has our sprite in the mosaic.\r\n      mediump vec2 samplePos \x3d mix(u_pattern_tl, u_pattern_br, normalizedTextureCoord);\r\n\r\n      // sample the sprite mosaic\r\n      lowp vec4 color \x3d texture2D(u_texture, samplePos);\r\n      gl_FragColor \x3d u_opacity * color;\r\n  #else\r\n      gl_FragColor \x3d u_color;\r\n  #endif // PATTERN\r\n\r\n  #ifdef ID\r\n      if (gl_FragColor.a \x3c 1.0 / 255.0) {\r\n        discard;\r\n      }\r\n      gl_FragColor \x3d v_id;\r\n  #endif // ID\r\n    }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\x3c/snippets\x3e\r\n',
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/fillShaders.xml":'\x3c?xml version\x3d"1.0" encoding\x3d"UTF-8"?\x3e\r\n\x3c!--\r\n  // YF TODO: (doc)\r\n--\x3e\r\n\x3csnippets\x3e\r\n  \x3csnippet name\x3d"fillVS"\x3e\r\n    \x3c![CDATA[\r\n      precision mediump float;\r\n\r\n      attribute vec2 a_pos;\r\n\r\n      uniform highp mat4 u_transformMatrix;\r\n      uniform highp vec2 u_normalized_origin;\r\n      uniform mediump float u_depth;\r\n\r\n    #ifdef PATTERN\r\n      uniform mediump mat3 u_pattern_matrix;\r\n      varying mediump vec2 v_tileTextureCoord;\r\n    #endif // PATTERN\r\n\r\n    #ifdef ID\r\n      uniform mediump vec4 u_id;\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n    #ifdef DD\r\n      attribute vec4 a_color;\r\n    #else\r\n      uniform lowp vec4 u_color;\r\n    #endif // DD\r\n      varying lowp vec4 v_color;\r\n\r\n      void main()\r\n      {\r\n      #ifdef DD\r\n        v_color \x3d a_color;\r\n      #else\r\n        v_color \x3d u_color;\r\n      #endif // DD\r\n\r\n      #ifdef ID\r\n        v_id \x3d u_id / 255.0;\r\n      #endif // ID\r\n\r\n      #ifdef PATTERN\r\n        // calculate the texture coordinates of the current vertex. It will of course get interpolated.\r\n        // The pattern matrix is a 3x3 scale matrix which \'tiles\' the texture inside the tile, translating from tile coordinates\r\n        // (-4k to 8k -1) to texture coordinates.\r\n        v_tileTextureCoord \x3d (u_pattern_matrix * vec3(a_pos, 1.0)).xy;\r\n      #endif // PATTERN\r\n\r\n        gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(a_pos, 0, 1.0);\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d"fillFS"\x3e\r\n    \x3c![CDATA[\r\n      precision lowp float;\r\n\r\n    #ifdef PATTERN\r\n      uniform mediump vec2 u_pattern_tl;\r\n      uniform mediump vec2 u_pattern_br;\r\n      uniform lowp sampler2D u_texture;\r\n      varying mediump vec2 v_tileTextureCoord;\r\n    #endif // PATTERN\r\n\r\n    #ifdef ID\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      varying lowp vec4 v_color;\r\n\r\n      vec4 mixColors(vec4 color1, vec4 color2) {\r\n        // perform un-premultiplied over operator (see https://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending)\r\n        // we use pre-multiplied colors hence the need for this kind of mixing. At lease we save ourselves an extra division...\r\n        float compositeAlpha \x3d color2.a + color1.a * (1.0 - color2.a);\r\n        vec3 compositeColor \x3d color2.rgb + color1.rgb * (1.0 - color2.a);\r\n\r\n        return vec4(compositeColor, compositeAlpha);\r\n      }\r\n      void main()\r\n      {\r\n      #ifdef PATTERN\r\n        // normalize the calculated texture coordinate such that it fits in the range of 0 to 1.\r\n        mediump vec2 normalizedTextureCoord \x3d mod(v_tileTextureCoord, 1.0);\r\n\r\n        // interpolate the image coordinate between the top-left and the bottom right to get the actual position to sample.\r\n        // after normalizing the position, we get a value ranging between 0 and 1 which refers to the entire texture, however\r\n        // we need to only sample from area that has our sprite in the mosaic.\r\n        mediump vec2 samplePos \x3d mix(u_pattern_tl, u_pattern_br, normalizedTextureCoord);\r\n\r\n        // sample the sprite mosaic\r\n        lowp vec4 color \x3d texture2D(u_texture, samplePos);\r\n        gl_FragColor \x3d v_color[3] * color;\r\n      #else\r\n        gl_FragColor \x3d v_color;\r\n      #endif // PATTERN\r\n\r\n      #ifdef ID\r\n        if (gl_FragColor.a \x3c 1.0 / 255.0) {\r\n          discard;\r\n        }\r\n        gl_FragColor \x3d v_id;\r\n      #endif // ID\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\x3c/snippets\x3e\r\n',
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/outlineShaders.xml":'\x3c?xml version\x3d"1.0" encoding\x3d"UTF-8"?\x3e\r\n\x3c!--\r\n  // YF TODO: (doc)\r\n--\x3e\r\n\x3csnippets\x3e\r\n  \x3csnippet name\x3d"outlineVS"\x3e\r\n    \x3c![CDATA[\r\n      attribute vec2 a_pos;\r\n      attribute vec2 a_offset;\r\n      attribute vec2 a_xnormal;\r\n\r\n    #ifdef DD\r\n      attribute vec4 a_color;\r\n    #else\r\n      uniform lowp vec4 u_color;\r\n    #endif // DD\r\n      varying lowp vec4 v_color;\r\n\r\n    #ifdef ID\r\n      uniform mediump vec4 u_id;\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      uniform highp mat4 u_transformMatrix;\r\n      uniform highp mat4 u_extrudeMatrix;\r\n      uniform highp vec2 u_normalized_origin;\r\n      uniform mediump float u_depth;\r\n      uniform mediump float u_outline_width;\r\n\r\n      varying lowp vec2 v_normal;\r\n\r\n      const float scale \x3d 1.0 / 15.0;\r\n\r\n      void main()\r\n      {\r\n      #ifdef DD\r\n        v_color \x3d a_color;\r\n      #else\r\n        v_color \x3d u_color;\r\n      #endif // DD\r\n\r\n      #ifdef ID\r\n        v_id \x3d u_id / 255.0;\r\n      #endif // ID\r\n\r\n        v_normal \x3d a_xnormal;\r\n\r\n        // calculate the relative distance from the centerline to the edge of the line. Since offset is given in integers (for the\r\n        // sake of using less attribute memory, we need to scale it back to the original range of ~ 0: 1)\r\n        mediump vec4 dist \x3d vec4(u_outline_width * a_offset * scale, 0.0, 0.0);\r\n\r\n        // Remove the texture normal bit of the position before scaling it with the\r\n        // model/view matrix. Add the extrusion vector *after* the model/view matrix\r\n        // because we\'re extruding the line in pixel space, regardless of the current\r\n        // tile\'s zoom level.\r\n        gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(a_pos, 0.0, 1.0) + u_extrudeMatrix * dist;\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d"outlineFS"\x3e\r\n    \x3c![CDATA[\r\n      varying lowp vec4 v_color;\r\n      varying mediump vec2 v_normal;\r\n\r\n    #ifdef ID\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      void main()\r\n      {\r\n        // Calculate the distance of the pixel from the line in pixels.\r\n        lowp float dist \x3d abs(v_normal.y);\r\n\r\n        lowp float alpha \x3d smoothstep(1.0, 0.0, dist);\r\n        gl_FragColor \x3d alpha * v_color;\r\n\r\n      #ifdef ID\r\n        if (gl_FragColor.a \x3c 1.0 / 255.0) {\r\n          discard;\r\n        }\r\n        gl_FragColor \x3d v_id;\r\n      #endif // ID\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\x3c/snippets\x3e\r\n',
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/lineShaders.xml":'\x3c?xml version\x3d"1.0" encoding\x3d"UTF-8"?\x3e\r\n\x3c!--\r\n  // YF TODO: (doc)\r\n--\x3e\r\n\x3csnippets\x3e\r\n  \x3csnippet name\x3d"lineVS"\x3e\r\n    \x3c![CDATA[\r\n      /* The implementation of the renderer is based on the article and implementation of MB described here:\r\n      * https://www.mapbox.com/blog/drawing-antialiased-lines/\r\n      */\r\n\r\n      attribute vec2 a_pos;\r\n      attribute vec4 a_offsetAndNormal;\r\n      attribute vec2 a_accumulatedDistance;\r\n\r\n      // the relative transformation of a vertex given in tile coordinates to a relative normalized coordinate\r\n      // relative to the tile\'s upper left corner\r\n      // the extrusion vector.\r\n      uniform highp mat4 u_transformMatrix;\r\n\r\n      // the extrude matrix which is responsible for the \'anti-zoom\' as well as the rotation\r\n      uniform highp mat4 u_extrudeMatrix;\r\n\r\n      // u_normalized_origin is the tile\'s upper left corner given in normalized coordinates\r\n      uniform highp vec2 u_normalized_origin;\r\n\r\n      uniform mediump float u_blur; // the feather distance at which the line edge fades out\r\n\r\n      // the z of the layer. Given by the order of the layers in the style\r\n      uniform mediump float u_depth;\r\n\r\n      // the interpolated normal to the line. the information is packed into the two LSBs of the vertex coordinate\r\n      varying mediump vec2 v_normal;\r\n\r\n      // the accumulated distance along the line. We need this information in order to render the dashes.\r\n      varying highp float v_accumulatedDistance;\r\n\r\n      const float scale \x3d 1.0 / 31.0;\r\n\r\n    #ifdef DD\r\n      attribute vec4 a_color;\r\n      attribute mediump float a_width;\r\n    #else\r\n      uniform lowp vec4 u_color;\r\n      uniform mediump float u_width;\r\n    #endif // DD\r\n\r\n    #ifdef ID\r\n      uniform mediump vec4 u_id;\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      varying lowp vec4 v_color;\r\n      varying mediump float v_lineHalfWidth; // the inset and outset of the line\r\n\r\n    #ifndef PATTERN\r\n      uniform mediump vec2 u_dasharray;\r\n      varying mediump vec2 v_dasharray;\r\n    #endif\r\n\r\n      void main()\r\n      {\r\n        v_normal \x3d a_offsetAndNormal.zw * scale;\r\n\r\n      #ifdef DD\r\n        v_lineHalfWidth \x3d a_width + u_blur;\r\n      #else\r\n        v_lineHalfWidth \x3d u_width + u_blur;\r\n      #endif // DD\r\n\r\n        v_lineHalfWidth *\x3d 0.5;\r\n\r\n      #ifndef PATTERN\r\n      #ifdef DD\r\n        v_dasharray \x3d u_dasharray * a_width;\r\n      #else\r\n        v_dasharray \x3d u_dasharray * u_width;\r\n      #endif // DD\r\n      #endif\r\n\r\n        // calculate the relative distance from the centerline to the edge of the line. Since offset is given in integers (for the\r\n        // sake of using less attribute memory, we need to scale it back to the original range of ~ 0: 1)\r\n        mediump vec2 dist \x3d v_lineHalfWidth * a_offsetAndNormal.xy * scale;\r\n\r\n        // transform the vertex\r\n        gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(a_pos, 0.0, 1.0) + u_extrudeMatrix * vec4(dist, 0.0, 0.0);\r\n\r\n        // the accumulated distance will be used to calculate the dashes (or the no-data...)\r\n        v_accumulatedDistance \x3d a_accumulatedDistance.x;\r\n\r\n        #ifdef DD\r\n          v_color \x3d a_color;\r\n        #else\r\n          v_color \x3d u_color;\r\n        #endif // DD\r\n\r\n        #ifdef ID\r\n          v_id \x3d u_id / 255.0;\r\n        #endif // ID\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d"lineFS"\x3e\r\n    \x3c![CDATA[\r\n      uniform mediump float u_blur;\r\n\r\n      varying mediump vec2 v_normal;\r\n      varying highp float v_accumulatedDistance;\r\n\r\n      varying mediump float v_lineHalfWidth;\r\n      varying lowp vec4 v_color;\r\n\r\n    #ifdef PATTERN\r\n      uniform mediump vec2 u_pattern_tl;\r\n      uniform mediump vec2 u_pattern_br;\r\n      uniform mediump vec2 u_spriteSize;\r\n      uniform sampler2D u_texture;\r\n\r\n      // Horizontal scale is used to scale the horizontal texture coordinate v_normal.x before adding it as an offset to the\r\n      // accumulated distance. Most vertices will have v_normal.x \x3d\x3d 0, because the pattern must be sampled only depending on\r\n      // the v_accumulatedDistance value. But tessellation at caps can have vertices with v_normal.x !\x3d 0, thus allowing to\r\n      // "keep moving" for a few more pixel even when the line has ended or has not started yet.\r\n      const mediump float tileCoordRatio \x3d 8.0;\r\n    #else\r\n      varying mediump vec2 v_dasharray;\r\n    #endif\r\n\r\n    #ifdef ID\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      void main()\r\n      {\r\n        // dist represent the distance of the fragment from the line. 1.0 or -1.0 will be the values on the edge of the line,\r\n        // and any value in between will be inside the line (the sign represent the direction - right or left).\r\n        // since u_linewidth.s (half line width) is represented in pixels, dist is also given in pixels\r\n        mediump float fragDist \x3d length(v_normal) * v_lineHalfWidth;\r\n\r\n        // calculate the alpha given the difference between the line-width and the distance of the fragment from the center-line.\r\n        // We need to count for both sides of the line.\r\n        lowp float alpha \x3d clamp(min(fragDist + u_blur + 1.0, v_lineHalfWidth - fragDist) / u_blur, 0.0, 1.0);\r\n\r\n      #ifdef PATTERN\r\n        // we need to calculate the relative portion of the line texture along the line given the accumulated distance aliong the line\r\n        // The computed value should is anumber btween 0 and 1 which will later be used to interpolate btween the BR and TL values\r\n        mediump float relativeTexX \x3d mod((v_accumulatedDistance + v_normal.x * v_lineHalfWidth * tileCoordRatio) / u_spriteSize.x, 1.0);\r\n\r\n        // in order to calculate the texture coordinates perpendicular to the line (Y axis), we use the interpolated normal values\r\n        // which range from -1.0 to 1.0. On the line\'s centerline, the value of the interpolated normal is 0.0, however the relative\r\n        // texture value should be 0.5 (given that at the bottom of the line, the texture coordinate must be equal to 0.0)\r\n        // (TL) ---------------------------      --\x3e left edge of line. Interpolated normal is 1.0\r\n        //              | -\x3e line-width / 2\r\n        //      - - - - - - - - - - - - - -\r\n        //              | -\x3e line-width / 2\r\n        //      ---------------------------- (BR)--\x3e right edge of line. Interpolated normal is -1.0\r\n\r\n        mediump float relativeTexY \x3d 0.5 + (v_normal.y * v_lineHalfWidth / u_spriteSize.y);\r\n\r\n        // claculate the actual texture coordinates by interpolating between the TL/BR pattern coordinates\r\n        mediump vec2 texCoord \x3d mix(u_pattern_tl, u_pattern_br, vec2(relativeTexX, relativeTexY));\r\n\r\n        // get the color from the texture\r\n        lowp vec4 color \x3d texture2D(u_texture, texCoord);\r\n\r\n        // finally write the fragment value\r\n        gl_FragColor \x3d alpha * v_color[3] * color;\r\n      #else\r\n        // now calculate the dashes given the accumulated distance of the line:\r\n        // start with calculating a normalized position along the line\r\n        lowp float dashPos \x3d  mod(v_accumulatedDistance, v_dasharray.x + v_dasharray.y);\r\n\r\n        // calculate the contribution to the alpha of the dash part. It is provided by the shortest portion of the position along the dash.\r\n        // we must clamp since the value might be bigger than 1 or smaller than zero (when over a dash).\r\n        //   | \x3c--- pos along the dash part\r\n        // -------_______-------_______\r\n        // when the dashPos is over the \'gap\' part of the dash dasharray.x - dashPos is negative and therefore the alpha will\r\n        // get clamped to zero.\r\n        // when dasharray.x - dashPos is positive, or when dashPos is smaller than 1.0, it gives us a soft edge to each dash part.\r\n        // along the direction of the line.\r\n        lowp float dashAlpha \x3d clamp(min(dashPos, v_dasharray.x - dashPos) + 0.5, 0.0, 1.0);\r\n\r\n        // if we don\'t have a no-data part to the dash then it is a solid line\r\n        dashAlpha \x3d max(sign(-v_dasharray.y), dashAlpha);\r\n        // finally multiply the fragment\'s alpha by the calculated dash-alpha\r\n        alpha *\x3d dashAlpha;\r\n\r\n        // output the fragment color\r\n        gl_FragColor \x3d alpha * v_color;\r\n      #endif // PATTERN\r\n\r\n      #ifdef ID\r\n        if (gl_FragColor.a \x3c 1.0 / 255.0) {\r\n          discard;\r\n        }\r\n        gl_FragColor \x3d v_id;\r\n      #endif // ID\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\x3c/snippets\x3e\r\n',
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/iconShaders.xml":"\x3c?xml version\x3d\"1.0\" encoding\x3d\"UTF-8\"?\x3e\r\n\x3c!--\r\n  Add your GLSL snippets to this file. You should start from\r\n  importing your old GLSL files. For instance, if you have a\r\n  file such as myShader.vs.glsl you should create a new \x3csnippet name\x3d\"myShaderVS\"\x3e\r\n  and then copy and paste the GLSL source as the content. You will then convert your\r\n  code to use the {@link module:esri/views/vectorTiles/renderers/vtShaderSnippets vtShaderSnippets}\r\n  instance to access the GLSL code, instead of importing it directly with require(\"dojo/text!...\").\r\n--\x3e\r\n\x3csnippets\x3e\r\n  \x3csnippet name\x3d\"rgba2floatFunc\"\x3e\r\n    \x3c![CDATA[\r\n    float rgba2float(vec4 rgba) {\r\n      return dot(rgba,  vec4(1.0/16777216.0, 1.0/65535.0, 1.0/256.0, 1.0));\r\n    }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d\"iconVS\"\x3e\r\n    \x3c![CDATA[\r\n      attribute vec2 a_pos;\r\n      attribute vec2 a_vertexOffset;\r\n      attribute vec4 a_tex;\r\n      attribute vec4 a_levelInfo;\r\n\r\n    #ifdef DD\r\n      attribute vec4 a_color;\r\n      attribute mediump float a_size;\r\n    #else\r\n      uniform lowp vec4 u_color;\r\n      uniform mediump float u_size;\r\n    #endif // DD\r\n\r\n    #ifdef ID\r\n      uniform mediump vec4 u_id;\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      varying lowp vec4 v_color;\r\n\r\n      // the relative transformation of a vertex given in tile coordinates to a relative normalized coordinate\r\n      // relative to the tile's upper left corner\r\n      // the extrusion vector.\r\n      uniform highp mat4 u_transformMatrix;\r\n\r\n      // the extrude matrix which is responsible for the 'anti-zoom' as well as the rotation\r\n      uniform highp mat4 u_extrudeMatrix;\r\n\r\n      // u_normalized_origin is the tile's upper left corner given in normalized coordinates\r\n      uniform highp vec2 u_normalized_origin;\r\n\r\n      // the size of the mosaic given in pixels\r\n      uniform vec2 u_mosaicSize;\r\n\r\n      // the z of the layer. Given by the order of the layers in the style\r\n      uniform mediump float u_depth;\r\n\r\n      // the map's rotation from the north\r\n      uniform mediump float u_mapRotation;\r\n      uniform mediump float u_level;\r\n\r\n      // indicate whether the current set of iconst should be kept upright when the map is rotated\r\n      uniform lowp float u_keepUpright;\r\n\r\n      // the rate of the change in the opacity (fade) of the icons\r\n      uniform mediump float u_fadeSpeed;\r\n\r\n      // the low level we transition (to/from)\r\n      uniform mediump float u_minfadeLevel;\r\n\r\n      // the high level we transition (to/from)\r\n      uniform mediump float u_maxfadeLevel;\r\n\r\n      // the amount of fade given teh current time past the last recorded level\r\n      uniform mediump float u_fadeChange;\r\n\r\n      // the opacity of the layer given by the painter\r\n      uniform mediump float u_opacity;\r\n\r\n      // the interpolated texture coordinate value to be used by the fragment shader in order to sample the sprite texture\r\n      varying mediump vec2 v_tex;\r\n\r\n      // the calculated transparency to be applied by the fragment shader. It is incorporating both the fade as well as the\r\n      // opacity of the layer given by the painter\r\n      varying lowp float v_transparency;\r\n\r\n      varying mediump vec2 v_size;\r\n\r\n      // the vertex offsets are given in integers, therefore in order to maintain a reasonable precision we multiply the values\r\n      // by 16 and then at the shader devide by the same number\r\n      const float C_OFFSET_PRECISION \x3d 1.0 / 32.0;\r\n\r\n      const float C_256_TO_RAD \x3d 3.14159265359 / 128.0;\r\n      const float C_DEG_TO_RAD \x3d 3.14159265359 / 180.0;\r\n      const float tileCoordRatio \x3d 1.0 / 8.0;\r\n\r\n      void main()\r\n      {\r\n        mediump float a_labelMinLevel \x3d a_levelInfo[0];\r\n        mediump float a_angle         \x3d a_levelInfo[1];\r\n        mediump float a_minLevel      \x3d a_levelInfo[2];\r\n        mediump float a_maxLevel      \x3d a_levelInfo[3];\r\n\r\n        // if the given vertex should not be visible simply clip it by adding it a value that will push it outside the clipping plane\r\n        mediump float delta_z \x3d 0.0;\r\n\r\n        // If the label rotates with the map, and if the rotated label is upside down, hide it\r\n        mediump float rotated \x3d mod(a_angle + u_mapRotation, 256.0);\r\n        delta_z +\x3d (1.0 - step(u_keepUpright, 0.0)) * step(64.0, rotated) * (1.0 - step(192.0, rotated)); //ie. z +\x3d (flip \x3e 0) \x26\x26 (64 \x3c\x3d rotated) \x26\x26 (rotated \x3c 192)\r\n\r\n        // u_level is the current service level adjusted for the change in font size\r\n        delta_z +\x3d 1.0 - step(a_minLevel, u_level); // Test if (level \x3c minLevel)\r\n        delta_z +\x3d step(a_maxLevel, u_level); // Test if (maxLevel \x3c\x3d level)\r\n\r\n        // calculate the alpha given the change in the fade and the fade-speed\r\n        lowp float alpha \x3d clamp((u_fadeChange - a_labelMinLevel) / u_fadeSpeed, 0.0, 1.0);\r\n\r\n        // if the speed is positive we are zooming in and therefore we need to 'fade-in'. Else we need to 'fade-out'\r\n        v_transparency \x3d (u_fadeSpeed \x3e\x3d 0.0 ? alpha : 1.0 - alpha);\r\n\r\n        // now deal with the min/max fade-levels. If we exceeded the level we simply snap to 0 or 1\r\n        if (u_maxfadeLevel \x3c a_labelMinLevel)\r\n        {\r\n          v_transparency \x3d 0.0;\r\n        }\r\n        if (u_minfadeLevel \x3e\x3d a_labelMinLevel)\r\n        {\r\n          v_transparency \x3d 1.0;\r\n        }\r\n\r\n        // if label had been faded out, clip it\r\n        delta_z +\x3d step(v_transparency, 0.0);\r\n\r\n        vec2 offset \x3d C_OFFSET_PRECISION * a_vertexOffset;\r\n\r\n        v_size \x3d abs(offset);\r\n\r\n      #ifdef SDF\r\n        offset \x3d (120.0 / 86.0) * offset;\r\n      #endif // SDF\r\n\r\n      #ifdef DD\r\n        mediump float icon_size \x3d a_size;\r\n      #else\r\n        mediump float icon_size \x3d u_size;\r\n      #endif // DD\r\n        gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(a_pos, 0.0, 1.0) + u_extrudeMatrix * icon_size * vec4(offset, delta_z, 0.0);\r\n\r\n        float opacity;\r\n\r\n      #ifdef SDF\r\n      #ifdef DD\r\n        v_color \x3d a_color;\r\n      #else\r\n        v_color \x3d u_color;\r\n      #endif // DD\r\n        opacity \x3d u_opacity;\r\n      #else // SDF\r\n      #ifdef DD\r\n        opacity \x3d a_color.w;\r\n      #else\r\n        opacity \x3d u_opacity;\r\n      #endif // DD\r\n      #endif // SDF\r\n\r\n      #ifdef ID\r\n        v_id \x3d u_id / 255.0;\r\n      #endif // ID\r\n\r\n        v_tex \x3d a_tex.xy / u_mosaicSize;\r\n        v_transparency *\x3d opacity;\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d\"iconFS\"\x3e\r\n    \x3c![CDATA[\r\n      precision mediump float;\r\n\r\n      uniform lowp sampler2D u_texture; // SDF texture\r\n    #ifdef SDF\r\n      uniform lowp vec4 u_color; // a color to override the one of the vertex\r\n      uniform lowp vec4 u_outlineColor;\r\n      uniform mediump float u_outlineSize;\r\n    #endif // SDF\r\n\r\n      varying mediump vec2 v_tex;\r\n      // the calculated transparency to be applied by the fragment shader. It is incorporating both the fade as well as the\r\n      // opacity of the layer given by the painter\r\n      varying lowp float v_transparency;\r\n\r\n      varying mediump vec2 v_size;\r\n\r\n    #ifdef SDF\r\n      varying lowp vec4 v_color;\r\n    #endif // SDF\r\n\r\n    #ifdef ID\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      // we need the conversion function from RGBA to float\r\n      $rgba2floatFunc\r\n\r\n      vec4 mixColors(vec4 color1, vec4 color2) {\r\n        // perform un-premultiplied over operator (see https://en.wikipedia.org/wiki/Alpha_compositing#Alpha_blending)\r\n        // we use pre-multiplied colors hence the need for this kind of mixing. At lease we save ourselves an extra division...\r\n        float compositeAlpha \x3d color2.a + color1.a * (1.0 - color2.a);\r\n        vec3 compositeColor \x3d color2.rgb + color1.rgb * (1.0 - color2.a);\r\n\r\n        return vec4(compositeColor, compositeAlpha);\r\n      }\r\n\r\n      void main()\r\n      {\r\n      #ifdef SDF\r\n        lowp vec4 fillPixelColor \x3d v_color;\r\n\r\n        // calculate the distance from the edge [-0.5, 0.5]\r\n        float d \x3d rgba2float(texture2D(u_texture, v_tex)) - 0.5;\r\n\r\n        // Work around loss of precision for 'd \x3d 0.0'.\r\n        // '0' gets normalised to 0.5 * 256 \x3d 128 before float packing, but can only\r\n        // be stored in the texture as 128 / 255 \x3d 0.502.\r\n        // see: https://devtopia.esri.com/WebGIS/arcgis-js-api/issues/7058#issuecomment-603110\r\n        const float diff \x3d (128.0 / 255.0 - 0.5);\r\n\r\n        // adjust all values, not just those close to 0, to avoid discontinuities in\r\n        // the outlines of other shapes e.g. circles\r\n        d \x3d d - diff;\r\n\r\n        // the soft edge ratio is about 1.5 pixels allocated for the soft edge.\r\n        // 1 / 86 represents a single pixel given the the size of the SDF is 128 and we add 4 pixels margins to deal with\r\n        // other non SDF types.\r\n        // The rasterized geometry takes only 86 pixels because of the extra 16 pixels margin for the outline.\r\n        const float sofetEdgeRatio \x3d 0.248062016; // \x3d\x3d\x3e (32.0 / 86.0) / 1.5;\r\n        float size \x3d max(v_size.x, v_size.y);\r\n        float dist \x3d d * sofetEdgeRatio * size;\r\n\r\n        // set the fragment's transparency according to the distance from the edge\r\n        fillPixelColor *\x3d clamp(0.5 - dist, 0.0, 1.0);\r\n\r\n        // count for the outline\r\n        // therefore tint the entire icon area.\r\n        if (u_outlineSize \x3e 0.25) {\r\n          lowp vec4 outlinePixelColor \x3d u_outlineColor;\r\n          // the outline limit ratio is derived from the 16 pixels allocated for the outline and the fact that 1/86 represents\r\n          // a single pixel.\r\n          const float outlineLimitRatio \x3d (16.0 / 86.0);\r\n          float clampedOutlineSize \x3d sofetEdgeRatio * min(u_outlineSize, outlineLimitRatio * max(v_size.x, v_size.y));\r\n\r\n          outlinePixelColor *\x3d clamp(0.5 - (abs(dist) - clampedOutlineSize), 0.0, 1.0);\r\n\r\n          // finally combine the outline and the fill colors\r\n          gl_FragColor \x3d v_transparency * mixColors(fillPixelColor, outlinePixelColor);\r\n        }\r\n        else {\r\n          gl_FragColor \x3d v_transparency * fillPixelColor;\r\n        }\r\n      #else // not an SDF\r\n        lowp vec4 texColor \x3d texture2D(u_texture, v_tex);\r\n        gl_FragColor \x3d v_transparency * texColor;\r\n      #endif // SDF\r\n\r\n      #ifdef ID\r\n        if (gl_FragColor.a \x3c 1.0 / 255.0) {\r\n          discard;\r\n        }\r\n        gl_FragColor \x3d v_id;\r\n      #endif // ID\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n\x3c/snippets\x3e\r\n\r\n",
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/textShaders.xml":'\x3c?xml version\x3d"1.0" encoding\x3d"UTF-8"?\x3e\r\n\x3c!--\r\n  Add your GLSL snippets to this file. You should start from\r\n  importing your old GLSL files. For instance, if you have a\r\n  file such as myShader.vs.glsl you should create a new \x3csnippet name\x3d"myShaderVS"\x3e\r\n  and then copy and paste the GLSL source as the content. You will then convert your\r\n  code to use the {@link module:esri/views/vectorTiles/renderers/vtShaderSnippets vtShaderSnippets}\r\n  instance to access the GLSL code, instead of importing it directly with require("dojo/text!...").\r\n--\x3e\r\n\x3csnippets\x3e\r\n  \x3csnippet name\x3d"rgba2floatFunc"\x3e\r\n    \x3c![CDATA[\r\n    float rgba2float(vec4 rgba) {\r\n      return dot(rgba, vec4(1.0/16777216.0, 1.0/65535.0, 1.0/256.0, 1.0));\r\n    }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d"textVS"\x3e\r\n    \x3c![CDATA[\r\n      attribute vec2 a_pos;\r\n      attribute vec2 a_vertexOffset;\r\n      attribute vec4 a_tex;\r\n      attribute vec4 a_levelInfo;\r\n\r\n      uniform lowp vec4 u_color; // always defined as halo does not support data driven but text does\r\n    #ifdef DD\r\n      attribute vec4 a_color;\r\n    #endif // DD\r\n      varying lowp vec4 v_color;\r\n\r\n    #ifdef DD\r\n      attribute mediump float a_size;\r\n    #else\r\n      uniform mediump float u_size;\r\n    #endif // DD\r\n      varying mediump float v_size;\r\n\r\n    #ifdef ID\r\n      uniform mediump vec4 u_id;\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n\r\n      // attribute bool a_visible; // --\x3e a one bit controlling the visibility of the vertex\r\n\r\n      // the relative transformation of a vertex given in tile coordinates to a relative normalized coordinate\r\n      // relative to the tile\'s upper left corner\r\n      // the extrusion vector.\r\n      uniform highp mat4 u_transformMatrix;\r\n\r\n      // the extrude matrix which is responsible for the \'anti-zoom\' as well as the rotation\r\n      uniform highp mat4 u_extrudeMatrix;\r\n\r\n      // u_normalized_origin is the tile\'s upper left corner given in normalized coordinates\r\n      uniform highp vec2 u_normalized_origin;\r\n\r\n      // the size of the mosaic given in pixels\r\n      uniform vec2 u_mosaicSize;\r\n\r\n      // the z of the layer. Given by the order of the layers in the style\r\n      uniform mediump float u_depth;\r\n\r\n      // the map\'s rotation from the north\r\n      uniform mediump float u_mapRotation;\r\n      uniform mediump float u_level;\r\n\r\n      // indicate whether the current set of iconst should be kept upright when the map is rotated\r\n      uniform lowp float u_keepUpright;\r\n\r\n      // the rate of the change in the opacity (fade) of the icons\r\n      uniform mediump float u_fadeSpeed;\r\n\r\n      // the low level we transition (to/from)\r\n      uniform mediump float u_minfadeLevel;\r\n\r\n      // the high level we transition (to/from)\r\n      uniform mediump float u_maxfadeLevel;\r\n\r\n      // the amount of fade given teh current time past the last recorded level\r\n      uniform mediump float u_fadeChange;\r\n\r\n      // the opacity of the layer given by the painter\r\n      uniform mediump float u_opacity;\r\n\r\n      // the interpolated texture coordinate value to be used by the fragment shader in order to sample the sprite texture\r\n      varying lowp vec2 v_tex;\r\n\r\n      // the calculated transparency to be applied by the fragment shader. It is incorporating both the fade as well as the\r\n      // opacity of the layer given by the painter\r\n      varying lowp float v_transparency;\r\n\r\n      // the vertex offsets are given in integers, therefore in order to maintain a reasonable precission we multiply the values\r\n      // by 16 and then at the shader devide by the same number\r\n      const float offsetPrecision \x3d 1.0 / 32.0;\r\n\r\n      // outline position and appearance\r\n      const mediump float edgePos \x3d 0.75; // defined by the SDF encoding\r\n      uniform mediump float u_edgeDistance;\r\n      uniform mediump float u_edgeBlur;\r\n      uniform mediump float u_antialiasingWidth; // antialiasing (factors in the pixel_ratio for high res devices)\r\n\r\n      varying mediump float v_edgeDistance; // will factor in the size\r\n      varying mediump float v_edgeWidth; // will factor in the size\r\n\r\n      uniform lowp float u_halo; // needed to avoid using the color attribute for halo\r\n\r\n      void main()\r\n      {\r\n        mediump float a_labelMinLevel \x3d a_levelInfo[0];\r\n        mediump float a_angle        \x3d a_levelInfo[1];\r\n        mediump float a_minLevel    \x3d a_levelInfo[2];\r\n        mediump float a_maxLevel    \x3d a_levelInfo[3];\r\n\r\n        // if the given vertex should not be visible simply clip it by adding it a value that will push it outside the clipping plane\r\n        mediump float delta_z \x3d 0.0;\r\n\r\n        // TODO: force clipping the vertex in case that the vertex isn\'t visible\r\n        //delta_z +\x3d a_visible ? 0.0 : 1.0;\r\n\r\n        // If the label rotates with the map, and if the rotated label is upside down, hide it\r\n        mediump float rotated \x3d mod(a_angle + u_mapRotation, 256.0);\r\n        delta_z +\x3d (1.0 - step(u_keepUpright, 0.0)) * step(64.0, rotated) * (1.0 - step(192.0, rotated)); //ie. z +\x3d (flip \x3e 0) \x26\x26 (64 \x3c\x3d rotated) \x26\x26 (rotated \x3c 192)\r\n\r\n        // u_level is the current service level adjusted for the change in font size\r\n        delta_z +\x3d 1.0 - step(a_minLevel, u_level); // Test if (level \x3c minLevel)\r\n        delta_z +\x3d step(a_maxLevel, u_level); // Test if (maxLevel \x3c\x3d level)\r\n\r\n        // calculate the alpha given the change in the fade and the fade-speed\r\n        lowp float alpha \x3d clamp((u_fadeChange - a_labelMinLevel) / u_fadeSpeed, 0.0, 1.0);\r\n\r\n        // if the speed is positive we are zooming in and therefore we need to \'fade-in\'. Else we need to \'fade-out\'\r\n        v_transparency \x3d (u_fadeSpeed \x3e\x3d 0.0 ? alpha : 1.0 - alpha);\r\n\r\n        // now deal with the min/max fade-levels. If we exceeded the level we simply snap to 0 or 1\r\n        if (u_maxfadeLevel \x3c a_labelMinLevel)\r\n        {\r\n          v_transparency \x3d 0.0;\r\n        }\r\n        if (u_minfadeLevel \x3e\x3d a_labelMinLevel)\r\n        {\r\n          v_transparency \x3d 1.0;\r\n        }\r\n\r\n        // if label has been faded out, clip it\r\n        delta_z +\x3d step(v_transparency, 0.0);\r\n\r\n        v_tex \x3d a_tex.xy / u_mosaicSize;\r\n\r\n      #ifdef DD\r\n        if (u_halo \x3e 0.5)\r\n        {\r\n          v_color \x3d u_color;\r\n          v_transparency *\x3d u_opacity;\r\n        }\r\n        else\r\n        {\r\n          v_color \x3d a_color;\r\n          // opacity already factored in a_color\r\n        }\r\n      #else\r\n        v_color \x3d u_color;\r\n        v_transparency *\x3d u_opacity;\r\n      #endif // DD\r\n\r\n      #ifdef DD\r\n        v_size \x3d a_size;\r\n      #else\r\n        v_size \x3d u_size;\r\n      #endif // DD\r\n\r\n      #ifdef ID\r\n        v_id \x3d u_id / 255.0;\r\n      #endif // ID\r\n\r\n        v_edgeDistance \x3d edgePos - u_edgeDistance / v_size;\r\n        v_edgeWidth \x3d (u_antialiasingWidth + u_edgeBlur) / v_size;\r\n\r\n        gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(a_pos, 0.0, 1.0) + u_extrudeMatrix * v_size * vec4(offsetPrecision * a_vertexOffset, delta_z, 0.0);\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n  \x3csnippet name\x3d"textFS"\x3e\r\n    \x3c![CDATA[\r\n      uniform lowp sampler2D u_texture;\r\n      uniform mediump float u_edgeDistance;\r\n\r\n      varying lowp vec2 v_tex;\r\n      varying lowp float v_transparency;\r\n      varying lowp vec4 v_color;\r\n      varying mediump float v_edgeWidth;\r\n      varying mediump float v_edgeDistance;\r\n\r\n    #ifdef ID\r\n      varying mediump vec4 v_id;\r\n    #endif // ID\r\n\r\n      // this is taken from http://www.valvesoftware.com/publications/2007/SIGGRAPH2007_AlphaTestedMagnification.pdf\r\n      // and https://www.mapbox.com/blog/text-signed-distance-fields/\r\n      // http://metalbyexample.com/rendering-text-in-metal-with-signed-distance-fields/\r\n\r\n      void main()\r\n      {\r\n        // read the distance from the SDF texture\r\n        lowp float dist \x3d texture2D(u_texture, v_tex).a;\r\n\r\n        // use a smooth-step in order to calculate the geometry of the shape given by the distance field\r\n        mediump float alpha \x3d smoothstep(v_edgeDistance - v_edgeWidth, v_edgeDistance + v_edgeWidth, dist) * v_transparency;\r\n\r\n        gl_FragColor \x3d alpha * v_color;\r\n\r\n      #ifdef ID\r\n        if (gl_FragColor.a \x3c 1.0 / 255.0) {\r\n          discard;\r\n        }\r\n        gl_FragColor \x3d v_id;\r\n      #endif // ID\r\n      }\r\n    ]]\x3e\r\n  \x3c/snippet\x3e\r\n\r\n\x3c/snippets\x3e\r\n\r\n',
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/tileInfo.vs.glsl":"attribute vec2 a_pos;\r\n\r\nuniform highp mat4 u_transformMatrix;\r\nuniform mediump vec2 u_normalized_origin;\r\nuniform mediump float u_depth;\r\nuniform mediump float u_coord_ratio;\r\nuniform mediump vec2 u_delta; // in tile coordinates\r\nuniform mediump vec2 u_dimensions; // in tile coordinates\r\n\r\nvarying mediump vec2 v_tex;\r\n\r\nvoid main() {\r\n  mediump vec2 offests \x3d u_coord_ratio * vec2(u_delta + a_pos * u_dimensions);\r\n  gl_Position \x3d vec4(u_normalized_origin, u_depth, 0.0) + u_transformMatrix * vec4(offests, 0.0, 1.0);\r\n\r\n  v_tex \x3d a_pos;\r\n}\r\n",
"url:esri/layers/vectorTiles/views/vectorTiles/renderers/shaders/tileInfo.fs.glsl":"uniform mediump sampler2D u_texture;\r\nvarying mediump vec2 v_tex;\r\n\r\nvoid main(void) {\r\n  lowp vec4 color \x3d texture2D(u_texture, v_tex);\r\n  gl_FragColor \x3d 0.75 * color;\r\n}\r\n"}});
define("esri/layers/vectorTiles/views/vectorTiles/renderers/vtShaderSnippets","require exports ../../webgl/ShaderSnippets dojo/text!./shaders/backgroundShaders.xml dojo/text!./shaders/fillShaders.xml dojo/text!./shaders/outlineShaders.xml dojo/text!./shaders/lineShaders.xml dojo/text!./shaders/iconShaders.xml dojo/text!./shaders/textShaders.xml dojo/text!./shaders/tileInfo.vs.glsl dojo/text!./shaders/tileInfo.fs.glsl".split(" "),function(a,p,b,e,f,g,h,k,l,m,n){function d(a,b){c+='\x3csnippet name\x3d"'+
a+'"\x3e\x3c![CDATA[';c+=b;c+="]]\x3e\x3c/snippet\x3e"}var c="",c=c+'\x3c?xml version\x3d"1.0" encoding\x3d"UTF-8"?\x3e',c=c+"\x3csnippets\x3e";d("tileInfoVS",m);d("tileInfoFS",n);c+="\x3c/snippets\x3e";a=new b;b.parse(e,a);b.parse(c,a);b.parse(f,a);b.parse(g,a);b.parse(h,a);b.parse(k,a);b.parse(l,a);return a});