# dgrid Documentation

This folder contains the official dgrid documentation. It includes
information on dgrid's core components, as well as information on various
mixins, plugins, and extensions that are available to further expand dgrid's
default functionality. 

## Components

* Core Components
    * [List](components/core-components/List.md)
    * [Grid](components/core-components/Grid.md)
    * [GridFromHtml](components/core-components/GridFromHtml.md)
    * [OnDemandList and OnDemandGrid](components/core-components/OnDemandList-and-OnDemandGrid.md)
* Mixins
    * [Keyboard](components/mixins/Keyboard.md)
    * [ColumnSet](components/mixins/ColumnSet.md)
    * [Selection](components/mixins/Selection.md)
    * [CellSelection](components/mixins/CellSelection.md)
* Column Plugins
    * [editor](components/column-plugins/editor.md)
    * [tree](components/column-plugins/tree.md)
    * [selector](components/column-plugins/selector.md)
* Extensions
    * [ColumnReorder](components/extensions/ColumnReorder.md)
    * [ColumnResizer](components/extensions/ColumnResizer.md)
    * [ColumnHider](components/extensions/ColumnHider.md)
    * [CompoundColumns](components/extensions/CompoundColumns.md)
    * [Pagination](components/extensions/Pagination.md)
    * [DijitRegistry](components/extensions/DijitRegistry.md)
    * [DnD](components/extensions/DnD.md)
* Utilities
    * [mouse](components/utilities/mouse.md)
    * [touch](components/utilities/touch.md)
    * [misc](components/utilities/misc.md)

## Usage

* [Working with Events](usage/Working-with-Events.md)
* [Working with Widgets](usage/Working-with-Widgets.md)
* [Styling dgrid](usage/Styling-dgrid.md)
* [Limitations](usage/Limitations.md)

## Migrating from dojox/grid

* [API Comparison](migrating/API-Comparison.md)
* [Usage Comparison](migrating/Usage-Comparison.md)

## Tutorials

Various tutorials are available on [dgrid.io](http://dojofoundation.org/packages/dgrid/#tutorials).