// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
define("esri/plugins/FeatureLayerStatistics","dojo/_base/lang dojo/_base/array dojo/_base/declare dojo/has dojo/Deferred dojo/on dojo/promise/all dojo/when dojo/string ../kernel ../config ../urlUtils ../Evented ../SpatialReference ../support/expressionUtils ../tasks/query ../tasks/StatisticDefinition ../tasks/GenerateRendererTask ../tasks/UniqueValueDefinition ../tasks/ClassBreaksDefinition ../tasks/GenerateRendererParameters ../tasks/generateRenderer ../tasks/GeometryService ../tasks/ProjectParameters ../layers/TileInfo ../layers/support/attributeUtils ../layers/HeatmapManager ../workers/heatmapCalculator ../geometry/mathUtils ../geometry/webMercatorUtils ../geometry/scaleUtils ../geometry/Point ../geometry/Extent".split(" "),
function(p,l,L,M,n,H,N,w,O,P,B,Q,R,C,x,r,D,S,T,U,E,V,W,X,Y,F,Z,I,G,J,aa,ba,ca){B=B.defaults;var da=I.prototype._calculateIntensityMatrix,ea=I.calculateStats,fa=Z.prototype._getScreenPoints,ga=/_value$/i,K="min max avg stddev count sum variance".split(" "),A=L([R],{declaredClass:"esri.plugins.FeatureLayerStatistics",sampleSize:500,worldScale:1E8,generalizeForScale:4E5,generalizeForResolution:105,mapWidth:1280,mapHeight:800,mapPaddingRatioForFE:.25,minDistance:12,minLength:30,minSize:15,minScaleRelaxationRatio:.25,
samplingThreshold:2E4,numBins:10,numClasses:5,classificationMethod:"equal-interval",standardDeviationInterval:1,geometryServiceUrl:Q.getProtocolForWebResource()+"//utility.arcgisonline.com/arcgis/rest/services/Geometry/GeometryServer",tileInfo:new Y({rows:256,cols:256,dpi:96,format:"JPEG",compressionQuality:90,origin:{x:-2.0037508342787E7,y:2.0037508342787E7},spatialReference:{wkid:102100,latestWkid:3857},lods:[{level:0,resolution:156543.03392800014,scale:5.91657527591555E8},{level:1,resolution:78271.51696399994,
scale:2.95828763795777E8},{level:2,resolution:39135.75848200009,scale:1.47914381897889E8},{level:3,resolution:19567.87924099992,scale:7.3957190948944E7},{level:4,resolution:9783.93962049996,scale:3.6978595474472E7},{level:5,resolution:4891.96981024998,scale:1.8489297737236E7},{level:6,resolution:2445.98490512499,scale:9244648.868618},{level:7,resolution:1222.992452562495,scale:4622324.434309},{level:8,resolution:611.4962262813797,scale:2311162.217155},{level:9,resolution:305.74811314055756,scale:1155581.108577},
{level:10,resolution:152.87405657041106,scale:577790.554289},{level:11,resolution:76.43702828507324,scale:288895.277144},{level:12,resolution:38.21851414253662,scale:144447.638572},{level:13,resolution:19.10925707126831,scale:72223.819286},{level:14,resolution:9.554628535634155,scale:36111.909643},{level:15,resolution:4.77731426794937,scale:18055.954822},{level:16,resolution:2.388657133974685,scale:9027.977411},{level:17,resolution:1.1943285668550503,scale:4513.988705},{level:18,resolution:.5971642835598172,
scale:2256.994353},{level:19,resolution:.29858214164761665,scale:1128.497176}]}),_outlineInfo:[{size:10,width:0},{size:20,width:.5},{size:80,width:1},{size:250,width:2}],_srcQuery:"service-query",_srcGenRend:"service-generate-renderer",_srcMemory:"features-in-memory",_srcFeatures:"features",_log10e:Math.LOG10E,_reNumber:/\s*(\+|-)?((\d+(\.\d+)?)|(\.\d+))\s*/gi,constructor:function(a){p.mixin(this,a);this._sampleCache=this._maxFeaturesForStats=null;this._gsTask=B.geometryService||new W(this.geometryServiceUrl);
if(this.layer.loaded)this._createGRTask();else H.once(this.layer,"load",p.hitch(this,this._createGRTask))},destroy:function(){this.clearFeaturesCache();this.layer=this._grTask=null},clearFeaturesCache:function(){this._sampleCache=this._maxFeaturesForStats=null},getUniqueValues:function(a){var b=new n;a&&(a.field||a.valueExpression)?this._callAfterLoad(this._fetchFeatures,{dfd:b,params:a},this._findUniqueValues):this._rejectDfd(b,"FeatureLayerStatistics.getUniqueValues: 'field' or 'valueExpression' parameter is required.");
return b.promise},getPredominantCategories:function(a){var b=new n;a&&a.fields?2>a.fields.length?this._rejectDfd(b,"FeatureLayerStatistics.getPredominantCategories: invalid fields. Minimum required is 2."):this._callAfterLoad(this._predominantCategories,{dfd:b,params:a}):this._rejectDfd(b,"FeatureLayerStatistics.getPredominantCategories: 'fields' parameter is missing.");return b.promise},getPredominanceExpressions:function(a){var b=new n;a&&a.fields?2>a.fields.length?this._rejectDfd(b,"FeatureLayerStatistics.getPredominanceExpressions: invalid fields. Minimum required is 2."):
this._callAfterLoad(this._predominanceExpressions,{dfd:b,params:a}):this._rejectDfd(b,"FeatureLayerStatistics.getPredominanceExpressions: 'fields' parameter is missing.");return b.promise},getAgeStatistics:function(a){var b=new n;null==a.startTime||null==a.endTime||null==a.units?this._rejectDfd(b,"FeatureLayerStatistics.getAgeStatistics: 'startTime', 'endTime' or 'units' parameter is missing."):this._callAfterLoad(this._ageStatistics,{dfd:b,params:a});return b.promise},getSuggestedAgeUnits:function(a){var b=
new n;null==a.startTime||null==a.endTime?this._rejectDfd(b,"FeatureLayerStatistics.getSuggestedAgeUnits: 'startTime' or 'endTime' parameter is missing."):this._callAfterLoad(this._suggestedAgeUnits,{dfd:b,params:a});return b.promise},getAgeExpressions:function(a){var b=new n;null==a.startTime||null==a.endTime?this._rejectDfd(b,"FeatureLayerStatistics.getAgeExpressions: 'startTime' or 'endTime' parameter is missing."):this._callAfterLoad(this._ageExpressions,{dfd:b,params:a});return b.promise},getFieldStatistics:function(a){var b=
new n;a&&(a.field||a.valueExpression||a.sqlExpression)?this._callAfterLoad(this._getFieldStats,{dfd:b,params:a}):this._rejectDfd(b,"FeatureLayerStatistics.getFieldStatistics: 'field', 'valueExpression' or 'sqlExpression' parameter is required.");return b.promise},getSuggestedDataRange:function(a){var b=a&&a.statistics;if(b){var c,d;null==b.min?a.isDate?(a=this._getYearOfDate(),c=a[0],d=a[1]):(c=0,d=100):b.min===b.max&&(a.isDate?(a=this._getYearOfDate(b.min),c=a[0],d=a[1]):0>b.min?(c=2*b.min,d=0):
0<b.min?(c=0,d=2*b.min):(c=0,d=100));return{min:null!=c?c:b.min,max:null!=d?d:b.max,defaultStatistics:null!=c||null!=d}}console.log("FeatureLayerStatistics.getSuggestedDataRange: 'statistics' parameter is required.")},getSpatialStatistics:function(a){var b=new n;a&&a.features&&a.features.length?this._callAfterLoad(this._spatialStats,{dfd:b,params:a}):this._rejectDfd(b,"FeatureLayerStatistics.getSpatialStatistics: 'features' parameter is missing or it has no features.");return b.promise},getSuggestedSizeRange:function(a){var b=
new n;this._callAfterLoad(this._getSizeRange,{dfd:b,params:a});return b.promise},getSuggestedOutline:function(a){var b=new n;this._callAfterLoad(this._getOutline,{dfd:b,params:a});return b.promise},getHeatmapStatistics:function(a){var b=new n;this._callAfterLoad(this._getHeatmapStats,{dfd:b,params:a});return b.promise},getHistogram:function(a){var b=new n;a&&(a.field||a.valueExpression||a.sqlExpression)?this._callAfterLoad(this._fetchFeatures,{dfd:b,params:a},this._getHistogram):this._rejectDfd(b,
"FeatureLayerStatistics.getHistogram: 'field', 'valueExpression' or 'sqlExpression' parameter is required.");return b.promise},getSampleFeatures:function(a){var b=new n;a=p.mixin({},a);a.caching=null!=a.caching?a.caching:!0;a.sampleSize=a.sampleSize||this.sampleSize;this._callAfterLoad(this._sampleFeatures,{dfd:b,params:a});return b.promise},getSuggestedScaleRange:function(a){var b=new n;this._callAfterLoad(this._scaleRange,{dfd:b,params:a});return b.promise},getClassBreaks:function(a){var b=new n;
a&&(a.field||a.valueExpression)?this._callAfterLoad(this._fetchFeatures,{dfd:b,params:a},this._findClassBreaks):this._rejectDfd(b,"FeatureLayerStatistics.getClassBreaks: 'field' or 'valueExpression' parameter is required.");return b.promise},_isCollection:function(){return!this.layer.url||-1<this.layer.declaredClass.indexOf("CSVLayer")},_getFieldStats:function(a){var b=this,c=a.params,d=p.isFunction(c.field),e=c.valueExpression||c.sqlExpression,f=e&&!c.sqlExpression,g=this._isCollection()||c.features,
h=d||f,k=(d=c.field&&!d?this.layer.getField(c.field):null)?d.type===this._dateType:!1;if(d){if(this._rejectIfInvalidType(a.dfd,d,"getFieldStatistics",[].concat(this._numericTypes).concat(this._dateType)))return;if(k&&c.normalizationType){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getFieldStatistics: normalization is not supported when calculating statistics for date field.");return}}else if(e){if(c.normalizationType){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getFieldStatistics: normalization is not supported when valueExpression or sqlExpression is specified.");
return}if(f&&(f=this._getExpressionInfo(c.valueExpression),this._rejectIfInvalidExpression(a.dfd,f,"getFieldStatistics")))return}g||h?(e=!g&&h?this._fetchMaxFeaturesForStats():null,w(e).always(function(d){var e=d&&d.features;e&&(c=p.mixin({},c),c.features=e);b._statsFromMemory(c,k).then(function(c){b._resolveStats(a.dfd,c,d&&d.hasAllFeatures)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getFieldStatistics: unable to calculate field statistics.")})})):this._canUseSQL92Expression()||
!k&&!e?(c.normalizationType?this._statsFromGenRend(c):this._statsFromQuery(c,k)).then(function(c){b._resolveStats(a.dfd,c)}).otherwise(function(d){w(b._fetchMaxFeaturesForStats()).always(function(d){var e=d&&d.features;e&&(c=p.mixin({},c),c.features=e);b._statsFromMemory(c,k).then(function(c){b._resolveStats(a.dfd,c,d&&d.hasAllFeatures)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getFieldStatistics: unable to calculate field statistics.")})})}):this._rejectDfd(a.dfd,"FeatureLayerStatistics.getFieldStatistics: unable to calculate statistics. Make sure the layer supports SQL expressions and standardized queries.")},
_resolveStats:function(a,b,c){for(var d in b)-1<l.indexOf(K,d)&&(this._isValidNumber(b[d])||(b[d]=null));b.partialData=null!=c?!c:!this._isCollection()&&b.source===this._srcMemory;a.resolve(b)},_statsFromQuery:function(a,b){var c;this._canUseSQL92Expression()&&b&&(c=p.mixin({},a),delete c.field,c.sqlExpression=this._msSinceUnixEpochSQL(a.field));return this._executeStatsQuery(c||a).then(function(a){b&&(l.forEach("min max avg stddev sum variance".split(" "),function(b){null!=a[b]&&(a[b]=Math.ceil(a[b]))}),
a.min===a.max&&null!=a.min&&(a.avg=a.min,a.stddev=a.variance=0));return a})},_msSinceUnixEpochSQL:function(a){return this._getDateDiffSQL(new Date(0),a,"milliseconds").sqlExpression},_executeStatsQuery:function(a){var b=this.layer,c=new n;if(b.url&&b.supportsStatistics){var d=new r,e=this,f=a.sqlExpression||a.field,g=f?this._getRangeExpr(f,a.minValue,a.maxValue):null;d.sqlFormat=a.sqlExpression?"standard":null;d.where=this._mergeWhereClauses(a.sqlWhere,g);d.outStatistics=l.map(K,function(a){var b=
new D;b.statisticType="variance"===a?"var":a;b.onStatisticField=f;b.outStatisticFieldName=a+"_value";return b});b.queryFeatures(d).then(function(a){a=(a=a&&a.features)&&a[0]&&a[0].attributes;var b,d={source:e._srcQuery};for(b in a)d[b.replace(ga,"").toLowerCase()]=a[b];d.min===d.max&&null!=d.min&&null==d.stddev&&(d.stddev=d.variance=0);c.resolve(d)}).otherwise(function(a){e._rejectDfd(c,"FeatureLayerStatistics: Statistics query operation failed.")})}else this._rejectDfd(c,"FeatureLayerStatistics: Statistics query requires a layer that supports statistics.");
return c.promise},_mergeWhereClauses:function(a,b){var c=a;b&&(c=c?"("+c+") AND ("+b+")":b);return c},_statsFromMemory:function(a,b){var c=new n,d;if("percent-of-total"===a.normalizationType){d=this._calcStatsFromMemory({field:a.field}).sum;if(null==d){this._rejectDfd(c,"getFieldStatistics: invalid normalizationTotal.");return}a=p.mixin({normalizationTotal:d},a)}c.resolve(this._calcStatsFromMemory(a,b));return c.promise},_calcStatsFromMemory:function(a,b){var c=!(!a.features||!a.features.length),
d=this._getDataValues(c?a.features:this.layer.graphics,a),e=this._calcStatistics(d,!a.normalizationType);e.source=c?this._srcFeatures:this._srcMemory;b&&l.forEach(["avg","stddev","variance"],function(a){null!=e[a]&&(e[a]=Math.ceil(e[a]))});return e},_isValidNumber:function(a){return"number"===typeof a&&!isNaN(a)&&Infinity!==a&&-Infinity!==a},_getDataValues:function(a,b){var c=F.createAttributeCache({field:b.field,valueExpression:b.valueExpression,normalizationType:b.normalizationType,normalizationField:b.normalizationField,
normalizationTotal:b.normalizationTotal}),d=null==b.minValue?-Infinity:b.minValue,e=null==b.maxValue?Infinity:b.maxValue,f=[];l.forEach(a,function(a){a=a._getDataValue(c.attributeInfo,c,x,this.layer);null!=a&&a>=d&&a<=e&&f.push(a)},this);return f},_calcStatistics:function(a,b){var c=Infinity,d=-Infinity,e=0,f=null,g=null,h=null,k=null;l.forEach(a,function(a){e++;f+=a;a<c&&(c=a);a>d&&(d=a)});if(e){var g=f/e,m=0;l.forEach(a,function(a){m+=Math.pow(a-g,2)});k=b?1<e?m/(e-1):0:0<e?m/e:0;h=Math.sqrt(k)}return{min:e?
c:null,max:e?d:null,count:e,sum:f,avg:g,stddev:h,variance:k}},_statsFromGenRend:function(a){var b=new n,c=this,d=a.normalizationType,e=a.normalizationField;this.getClassBreaks({field:a.field,classificationMethod:"standard-deviation",standardDeviationInterval:.25,normalizationType:d,normalizationField:"field"===d?e:void 0,minValue:a.minValue,maxValue:a.maxValue}).then(function(a){var d,e,f;l.some(a.classBreakInfos,function(a,b){a.hasAvg&&(d=a);return!!d});d&&(f=d.maxValue-d.minValue,e=d.minValue+f/
2,f*=4);b.resolve({min:a.minValue,max:a.maxValue,avg:e,stddev:f,source:c._srcGenRend})}).otherwise(function(a){c._rejectDfd(b,"FeatureLayerStatistics.getFieldStatistics: unable to calculate class breaks.")});return b.promise},_getYearOfDate:function(a){var b=("number"===typeof a?new Date(a):new Date).getUTCFullYear(),c=Date.UTC(b,0,1,12,0,0,0),b=Date.UTC(b,11,31,12,0,0,0);"number"===typeof a&&(a<c&&(c=a),a>b&&(b=a));return[c,b]},_spatialStats:function(a){var b=a.params.features,c=this.layer.geometryType,
d={},c={point:"esriGeometryPoint"===c,mPoint:"esriGeometryMultipoint"===c,line:"esriGeometryPolyline"===c,polygon:"esriGeometryPolygon"===c||this.layer.hasXYFootprint()};c.point?d=this._getPointStats(b):c.mPoint?d=this._getPointStats(b,!0):c.line?d=this._getLineStats(b):c.polygon&&(d=this._getPolygonStats(b));d.avgXY=this._getAvgXY(b,c);a.dfd.resolve(d)},_getPointStats:function(a,b){var c,d,e=a.length,f,g,h={},k={},m=0,q=0,y=Infinity,l=-Infinity,z=0,u=0,v,n,p=[];if(b)for(c=0;c<e;c++)a[c].geometry&&
p.push.apply(p,a[c].geometry.points);else p=a;e=p.length;for(c=0;c<e;c++)if(b?(h.x=p[c][0],h.y=p[c][1],f=h):f=p[c].geometry,f){v=Infinity;n=-Infinity;for(d=0;d<e;d++)d!==c&&(b?(k.x=p[d][0],k.y=p[d][1],g=k):g=p[d].geometry,g&&(g=G.getLength(f,g),0<g&&(g<v&&(v=g),g<y&&(y=g),g>n&&(n=g),g>l&&(l=g))));Infinity!==v&&(++z,m+=v);-Infinity!==n&&(++u,q+=n)}return{minDistance:Infinity!==y?y:null,maxDistance:-Infinity!==l?l:null,avgMinDistance:z?m/z:null,avgMaxDistance:u?q/u:null}},_getLineStats:function(a){var b,
c=a.length,d,e={},f={},g=Infinity,h=-Infinity,k=0,m=0;for(b=0;b<c;b++)if(d=a[b].geometry)d=this._getLineLength(d,e,f),0<d&&(++m,k+=d,d<g&&(g=d),d>h&&(h=d));return{minLength:Infinity!==g?g:null,maxLength:-Infinity!==h?h:null,avgLength:m?k/m:null}},_getLineLength:function(a,b,c){a=a.paths;var d,e=a.length,f,g=0;for(d=0;d<e;d++)f=a[d],f=this._getActualLineLength(f,b,c),0<f&&(g+=f);return g},_getApproxLineLength:function(a,b,c){var d=a[0],e=a[a.length-1],f=0;d&&e&&d[0]===e[0]&&d[1]===e[1]&&(e=a[a.length-
2]);d&&e&&d!==e&&(b.x=d[0],b.y=d[1],c.x=e[0],c.y=e[1],f=G.getLength(b,c));return f},_getActualLineLength:function(a,b,c){var d,e=a.length,f,g,h=0;for(d=0;d<e-1;d++)f=a[d],g=a[d+1],f&&g&&(b.x=f[0],b.y=f[1],c.x=g[0],c.y=g[1],h+=G.getLength(b,c));return h},_getPolygonStats:function(a){var b,c=a.length,d,e=Infinity,f=-Infinity,g=0,h=0;for(b=0;b<c;b++)a[b].geometry&&(d=a[b].geometry.getExtent())&&(d=(d.getWidth()+d.getHeight())/2,0<d&&(++h,g+=d,d<e&&(e=d),d>f&&(f=d)));return{minSize:Infinity!==e?e:null,
maxSize:-Infinity!==f?f:null,avgSize:h?g/h:null}},_getAvgXY:function(a,b){var c,d,e,f=a.length,g,h,k,m,q=null,l=null,t=0,z;for(c=0;c<f;c++)if(d=a[c].geometry)if(b.point)++t,q+=d.x,l+=d.y;else if(b.mPoint)for(k=d.points,h=k.length,d=0;d<h;d++)++t,q+=k[d][0],l+=k[d][1];else if(b.line)for(m=d.paths,g=m.length,d=0;d<g;d++)for(k=m[d],h=k.length,e=0;e<h;e++)++t,q+=k[e][0],l+=k[e][1];else if(b.polygon)for(m=d.rings,g=m.length,d=0;d<g;d++)for(k=m[d],h=k.length,e=0;e<h;e++)++t,q+=k[e][0],l+=k[e][1];null!=
q&&null!=l&&(z={x:q/t,y:l/t});return z},_getSizeRange:function(a){var b=this,c=a.params,d=this.layer,e=d.getMap();if("esriGeometryPolygon"===d.geometryType||d.hasXYFootprint())if(e)if(c&&"visible-scale-range"===c.optimizeForScale){var f=this._projectExtent(d.fullExtent,this.tileInfo.spatialReference);this.getSuggestedScaleRange({map:!1}).then(function(c){b._processSizeRange(c.spatialStatistics,e,a.dfd,f,c)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedSizeRange: unable to calculate suggested scale range.")})}else this._getFeatures(e,
c).then(function(c){b.getSpatialStatistics({features:c}).then(function(c){b._processSizeRange(c,e,a.dfd)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedSizeRange: unable to calculate spatial statistics.")})}).otherwise(function(c){b._rejectDfd(a.dfd,c.message)});else this._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedSizeRange: layer has to be added to the map.");else this._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedSizeRange: not supported for points and lines.")},
_processSizeRange:function(a,b,c,d,e){var f=this;w(d).always(function(d){d=d&&d.hasOwnProperty("xmin")?d:null;f._calcSizeRange(a,b,c,d,e)})},_getFeatures:function(a,b){var c=new n,d=this,e;b&&b.useMapExtent?(e=new r,e.geometry=a.extent,e=this.layer.queryFeatures(e)):e={features:this.layer.graphics.slice(0)};w(e).then(function(a){(a=a&&a.features)&&a.length?c.resolve(a):d._rejectDfd(c,"FeatureLayerStatistics: layer has 0 features.")}).otherwise(function(a){d._rejectDfd(c,"FeatureLayerStatistics: unable to query features.")});
return c.promise},_calcSizeRange:function(a,b,c,d,e){var f=a&&a.avgSize,g=b.getResolution();b=b.getScale();if(null==f||isNaN(f))this._rejectDfd(c,"FeatureLayerStatistics.getSuggestedSizeRange: invalid average feature size.");else if(g&&b){var h;if(e){var k=g/b;d=this._getScaleValues(d,e);var m=d.feScaleIndex,q=[],y=[];h=d.scales[m];l.forEach(d.scales,function(a,b){var c=this._calcSizeValues(f,k*a),d=-1<m&&b>m?2:1;q.push({value:a,size:c.min/d});y.push({value:a,size:c.max/d})},this);d={type:"sizeInfo",
expression:"view.scale",valueExpression:"$view.scale",stops:q};g={type:"sizeInfo",expression:"view.scale",valueExpression:"$view.scale",stops:y}}else g=this._calcSizeValues(f,g),d=g.min,g=g.max;c.resolve({minSize:d,maxSize:g,spatialStatistics:a,avgFeatureSize:f,scaleAtFullExtent:h,suggestedScaleRange:e})}else this._rejectDfd(c,"FeatureLayerStatistics.getSuggestedSizeRange: invalid map scale/resolution.")},_getScaleValues:function(a,b){var c=this.tileInfo.lods,d=this.layer.minScale||c[0].scale,c=this.layer.maxScale||
c[c.length-1].scale,e=b&&b.minScale||0,f=b&&b.maxScale||0,g=a&&this._findLODForFE(this.tileInfo.lods,a,this.mapWidth,this.mapHeight),g=g&&g.scale<d&&g.scale>c?Math.round(g.scale):0,h=l.map([d,c,e,f,g],Math.round);h.sort(this._numberSorter);h=l.filter(h,function(a,b){return!!a&&l.indexOf(h,a)===b});h=l.filter(h,function(a,b,c){return b?5<Math.abs(a-c[b-1]):!0});return{scales:h,feScaleIndex:l.indexOf(h,g)}},_numberSorter:function(a,b){return a-b},_findLODForFE:function(a,b,c,d){var e=a.length,f=b.getWidth(),
g=b.getHeight(),h,k;for(b=0;b<e;b++)if(h=a[b],c*h.resolution<f||d*h.resolution<g){k=0===b?a[b]:a[b-1];break}else if(b===e-1){k=a[b];break}return k},_calcSizeValues:function(a,b){a=Math.ceil(a/b);var c=Math.ceil(a/4);4>c?c=4:16<c&&(c=16);var d=5*c;return{min:c,max:50>d?50:d}},_getOutline:function(a){var b=this;"esriGeometryPolygon"===this.layer.geometryType||this.layer.hasXYFootprint()?this._getFeatures().then(function(c){b.getSpatialStatistics({features:c}).then(function(d){if(d.avgSize){var e;l.some(c,
function(a){a.geometry&&(e=a.geometry.spatialReference);return!!e});b._calcOutline(d,e,a.params,a.dfd)}else b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedOutline: average feature size is 0 or null.")}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedOutline: unable to calculate spatial statistics.")})}).otherwise(function(c){b._rejectDfd(a.dfd,c.message)}):this._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedOutline: not supported for points and lines.")},
_calcOutline:function(a,b,c,d){var e=a.avgSize,f=c&&null!=c.allowZeroWidth?c.allowZeroWidth:!0,g=39.37*96*aa.getUnitValueForSR(b);b=l.map(l.filter(this._outlineInfo,function(a,b){return f||0<b}),function(a){return{size:a.width,value:Math.round(e/a.size*g)}});b.sort(function(a,b){return a.value-b.value});d.resolve({widthInfo:{type:"sizeInfo",target:"outline",expression:"view.scale",valueExpression:"$view.scale",stops:b},opacity:.5,spatialStatistics:a})},_getHeatmapStats:function(a){var b=this,c=this.layer,
d=a.params,e=a.dfd,f=d.fieldOffset;a=d.field&&this.layer.getField(d.field);d.field&&this._rejectNonNumeric(e,a,"getHeatmapStatistics")||(d.field&&null==f?c.statisticsPlugin.getFieldStatistics({field:d.field}).then(function(a){b._calcHeatmapStats(a,f,d,e)}).otherwise(function(a){b._rejectDfd(e,"FeatureLayerStatistics.getHeatmapStatistics: unable to calculate field statistics.")}):this._calcHeatmapStats(null,f,d,e))},_calcHeatmapStats:function(a,b,c,d){var e=this;if(a){var f=a.min,g=a.max;a.count?f===
g&&0===f?b=1:0>=g?b="abs":0>f&&(b=-1.01*f):b=1}this._heatStatsFromMemory(c,b).then(function(c){c.fieldStatistics=a;c.fieldOffset=b;d.resolve(c)}).otherwise(function(a){e._rejectDfd(d,"FeatureLayerStatistics.getHeatmapStatistics: unable to calculate heatmap statistics.")})},_heatStatsFromMemory:function(a,b){var c=new n,d=this.layer,e=d.graphics,f=e.length,g=d.getMap();if(!f)return c.resolve({count:0,min:null,max:null,avg:null,stddev:null,source:this._srcMemory}),c.promise;(d=(d=g&&da(fa(e,g,d),g.width,
g.height,a.blurRadius||10,a.field,b))&&d.matrix&&ea(d.matrix))?c.resolve({count:f,min:d.min,max:d.max,avg:d.mean,stddev:d.stdDev,source:this._srcMemory}):this._rejectDfd(c,"FeatureLayerStatistics.getHeatmapStatistics: unable to calculate heatmap statistics.");return c.promise},_getHistogram:function(a){var b=this,c=a.params,d=c.minValue,e=c.maxValue,f=c.valueExpression||c.sqlExpression,g=f&&!c.sqlExpression,h=this._isCollection()||g,k=this._canUseSQL92Expression(),m=null!=d&&null!=e,q=c.field?this.layer.getField(c.field):
null,l=q?q.type===this._dateType:!1,t=!c.classificationMethod||"equal-interval"===c.classificationMethod;if(q){if(this._rejectIfInvalidType(a.dfd,q,"getHistogram",[].concat(this._numericTypes).concat(this._dateType)))return;if(l){if(c.normalizationType){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: normalization is not supported when calculating histogram for date field.");return}if(!t){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram:  classification methods other than 'equal-interval' are not supported when calculating histogram for date field.");
return}}}else if(f){if(c.normalizationType){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: normalization is not supported when valueExpression or sqlExpression is specified.");return}if(!t){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: classification methods other than 'equal-interval' are not supported when valueExpression or sqlExpression is specified.");return}if(g){if(g=this._getExpressionInfo(c.valueExpression),this._rejectIfInvalidExpression(a.dfd,g,"getHistogram"))return}else if(!c.valueExpression){this._rejectDfd(a.dfd,
"FeatureLayerStatistics.getHistogram: valueExpression parameter is missing.");return}}f&&!h?this._getBinsFromStatsQueryForExpr(a.dfd,c,d,e):k&&t&&!h?this._getBinsFromStatsQueryForField(a,l):c.normalizationType||!t?this._binParamsFromGenRend(c).then(function(f){if(m)if(d>f.max||e<f.min)b._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: custom value range is beyond field value range.");else{var g=b._getFieldExpr(c,f.normTotal),g=b._getRangeExpr(g,d,e);t?b._getBins(a,f.sqlExpr,d,e,null,"parameters",
null,f.excludeZerosExpr):b._binParamsFromGenRend(c,g).then(function(c){b._getBins(a,c.sqlExpr,c.min,c.max,c.intervals,c.source,c.normTotal,c.excludeZerosExpr)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: unable to calculate histogram parameters using custom min/max values.")})}else b._getBins(a,f.sqlExpr,f.min,f.max,f.intervals,f.source,f.normTotal,f.excludeZerosExpr)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: unable to calculate min/max from generate renderer operation.")}):
m?this._getBins(a,null,d,e,null,"parameters"):this.getFieldStatistics(c).then(function(c){c.count?b._getBins(a,null,c.min,c.max,null,c.source):b._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: cannot calculate histogram for 0 features (statistics.count \x3d 0).")}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getHistogram: unable to calculate min/max.")})},_getBins:function(a,b,c,d,e,f,g,h){var k=this,m=a.params.field,q=m?this.layer.getField(m):null,q=q?q.type===this._dateType:
!1,y=a.params.numBins||this.numBins;e=e||this._getEqualIntervalBins(c,d,y);b=b||m;this._isCollection()||q||a.params.features?this._countBinsInMemory(a,c,d,e,g,f):this._queryBins(b,e,h).then(function(b){b=l.map(b,function(a,b){return{minValue:e[b][0],maxValue:e[b][1],count:a}});a.dfd.resolve({bins:b,minValue:c,maxValue:d,normalizationTotal:g,source:k._srcQuery,statisticsSource:f,partialData:!1})}).otherwise(function(b){k._countBinsInMemory(a,c,d,e,g,f)})},_getEqualIntervalBins:function(a,b,c){b=(b-
a)/c;var d=a,e,f=[];for(a=1;a<=c;a++)e=d+b,e=Number(e.toFixed(16)),f.push([d,e]),d=e;return f},_countBinsInMemory:function(a,b,c,d,e,f){var g=this;this._binsFromMemory(a.params,b,c,d,e).then(function(d){var k=a.params.hasAllFeatures;a.dfd.resolve({bins:d,minValue:b,maxValue:c,normalizationTotal:e,source:a.params.features?g._srcFeatures:g._srcMemory,statisticsSource:f,partialData:null!=k?!k:!g._isCollection()})}).otherwise(function(b){g._rejectDfd(a.dfd,"FeatureLayerStatistics: unable to calculate histogram.")})},
_queryBins:function(a,b,c){var d=this.layer,e,f,g=[],h=b.length;for(e=0;e<h;e++)f=new r,f.where=(c?c+" AND ":"")+a+" \x3e\x3d "+b[e][0]+(null!==b[e][1]?" AND "+a+(e===h-1?" \x3c\x3d ":" \x3c ")+b[e][1]:""),g.push(f);return N(l.map(g,function(a){return d.queryCount(a)}))},_binsFromMemory:function(a,b,c,d,e){var f=new n;e=F.createAttributeCache({field:a.field,valueExpression:a.valueExpression,normalizationType:a.normalizationType,normalizationField:a.normalizationField,normalizationTotal:e});a=a.features||
this.layer.graphics;var g,h,k,m=[];if(!a.length)return this._rejectDfd(f,"Layer has 0 features in memory."),f.promise;k=d.length;for(h=0;h<k;h++)m.push({minValue:d[h][0],maxValue:d[h][1],count:0});k=a.length;for(h=0;h<k;h++)g=a[h],g=g._getDataValue(e.attributeInfo,e,x,this.layer),null!=g&&g>=b&&g<=c&&(g=this._binIndex(d,g),-1<g&&m[g].count++);f.resolve(m);return f.promise},_binIndex:function(a,b){var c,d,e=-1;for(c=a.length-1;0<=c;c--)if(d=a[c][0],b>=d){e=c;break}return e},_binParamsFromGenRend:function(a,
b){var c=this.layer,d=new n,e=this,f=this._getGRWhereInfo(c,a),g=f.where,h=a.numBins||this.numBins,k=this._createCBDefn(a,h),m=new E;m.classificationDefinition=k;m.where=g?g+(b?" AND "+b:""):b;!this._isCollection()&&10.1<=c.version&&!a.features?this._grTask.execute(m).then(function(b){e._resolveBinParams(b,f,e._srcGenRend,a,d)}).otherwise(function(b){e._binParamsFromMemory(h,f,a,d)}):e._binParamsFromMemory(h,f,a,d);return d.promise},_binParamsFromMemory:function(a,b,c,d){var e=this;this._cbFromMemory(c,
a).then(function(a){e._resolveBinParams(a,b,c.features?e._srcFeatures:e._srcMemory,c,d)}).otherwise(function(a){e._rejectDfd(d,"FeatureLayerStatistics.getHistogram: unable to calculate class breaks.")})},_resolveBinParams:function(a,b,c,d,e){var f,g,h=[],k=a.infos;g=k.length;f=k[0].minValue;g=k[g-1].maxValue;l.forEach(k,function(a,b){h.push([a.minValue,a.maxValue])});e.resolve({min:f,max:g,intervals:h,sqlExpr:this._getFieldExpr(d,a.normalizationTotal),excludeZerosExpr:b.excludeZerosExpr,normTotal:a.normalizationTotal,
source:c})},_getGRWhereInfo:function(a,b){var c=b.field,d=b.normalizationType,e=b.normalizationField,f=a.getDefinitionExpression(),g;"log"===d?g="(NOT "+c+" \x3d 0)":"field"===d&&(g="(NOT "+e+" \x3d 0)");return{where:g?g+(f?" AND "+f:""):f,excludeZerosExpr:g}},_getFieldExpr:function(a,b){var c=a.field,d=a.normalizationType,e=a.normalizationField,f=c;"percent-of-total"===d?f="(("+c+" / "+b+") * 100)":"log"===d?f="(log("+c+") * "+this._log10e+")":"field"===d&&(f="("+c+" / "+e+")");return f},_getRangeExpr:function(a,
b,c){b=null!=b?a+" \x3e\x3d "+b:"";a=null!=c?a+" \x3c\x3d "+c:"";c="";return(c=b&&a?b+" AND "+a:b||a)?"("+c+")":""},_getBinsFromStatsQueryForExpr:function(a,b,c,d){var e=this,f=null!=c&&null!=d;c=f?{min:c,max:d}:this.getFieldStatistics(b);w(c).then(function(c){e._getBinsFromStatsQuery(b,c.min,c.max,f?"parameters":c.source).then(function(b){a.resolve(b)}).otherwise(function(b){e._rejectDfd(a,"FeatureLayerStatistics.getHistogram: query to calculate count failed.")})}).otherwise(function(b){e._rejectDfd(a,
"FeatureLayerStatistics.getHistogram: unable to calculate min/max.")})},_getBinsFromStatsQueryForField:function(a,b){var c=this,d=a.params,e=this.layer,f;"percent-of-total"===d.normalizationType&&(f=this.getFieldStatistics({field:d.field}).then(function(a){return a.sum}));w(f).then(function(f){f={numBins:d.numBins,sqlExpression:b?c._msSinceUnixEpochSQL(d.field):c._getFieldExpr(d,f),sqlWhere:b?null:c._getGRWhereInfo(e,d).excludeZerosExpr};c._getBinsFromStatsQueryForExpr(a.dfd,f,d.minValue,d.maxValue)}).otherwise(function(b){c._rejectDfd(a.dfd,
"FeatureLayerStatistics.getHistogram: unable to calculate normalizationTotal.")})},_getBinsFromStatsQuery:function(a,b,c,d){var e=this.layer,f=new n;if(this._canUseSQL92Expression()){var g=this._getEqualIntervalBins(b,c,a.numBins||this.numBins),h=this._calcBinsSQL(a.sqlExpression,g),k=this,m=new D;m.statisticType="count";m.outStatisticFieldName="countOFExpr";m.onStatisticField="*";var q=new r;q.outStatistics=[m];q.groupByFieldsForStatistics=[h];q.orderByFields=[h];q.where=a.sqlWhere;q.sqlFormat="standard";
e.queryFeatures(q).then(function(a){var e={};l.forEach(a.features,function(a){var b=a.attributes;a=this._getCustomExprVal(b,"countOFExpr");b=this._getAttributeVal(b,"countOFExpr");0!==a&&(e[a]=b)},k);var h=[];l.forEach(g,function(a,b){var c=b+1;h.push({minValue:a[0],maxValue:a[1],count:e.hasOwnProperty(c)?e[c]:0})});f.resolve({bins:h,minValue:b,maxValue:c,source:k._srcQuery,statisticsSource:d,partialData:!1})}).otherwise(function(a){k._rejectDfd(f,"FeatureLayerStatistics.getHistogram: Statistics query operation failed.")})}else this._rejectDfd(f,
"FeatureLayerStatistics.getHistogram: make sure the layer supports advanced SQL expressions and standardized queries.");return f.promise},_fetchMaxFeaturesForStats:function(){var a=this;if(this._maxFeaturesForStats){var b=new n;b.resolve(this._maxFeaturesForStats);return b.promise}return this.getSampleFeatures({sampleSize:-1,caching:!1,returnGeometry:!1}).then(function(b){a._maxFeaturesForStats={features:b.features,hasAllFeatures:b.features.length===b.totalFeatures};return a._maxFeaturesForStats})},
_sampleFeatures:function(a){var b=this,c=a.params,d=a.dfd,e=this.layer,f=e.graphics,g=c.caching;a=this._sampleCache;var h=c.resample,k=c.sampleSize;g&&a&&!h?d.resolve(this._cloneSample(a)):(d._time={start:this._getTime()},f.length&&0<k&&k<=f.length?this._resolveSample(d,this._pickItems(f,k),g,this._srcMemory):(a=new r,a.where="1\x3d1",d._time.countStart=this._getTime(),e.queryCount(a).then(function(a){d._time.countEnd=b._getTime();d._totalFeatures=a;-1===k&&(k=a);k>e.maxRecordCount&&(k=e.maxRecordCount);
var h;a?a<=f.length||f.length>=e.maxRecordCount?b._resolveSample(d,b._pickItems(f,f.length),g,b._srcMemory):a<=k?(h=new r,h.where="1\x3d1",b._queryFeatures(h,c,e,f,d)):a<=b.samplingThreshold?(a=new r,a.where="1\x3d1",d._time.idStart=b._getTime(),e.queryIds(a).then(function(a){d._time.idEnd=b._getTime();var g=new r;g.objectIds=b._pickItems(a,k);b._queryFeatures(g,c,e,f,d)}).otherwise(function(a){h=new r;h.where="1\x3d1";b._queryFeatures(h,c,e,f,d)})):(h=new r,h.where="1\x3d1",(a=e.advancedQueryCapabilities)&&
a.supportsPagination&&(h.num=k),b._queryFeatures(h,c,e,f,d)):b._resolveSample(d,[],g,b._srcQuery)}).otherwise(function(a){b._resolveSample(d,b._pickItems(f,f.length),g,b._srcMemory)})))},_queryFeatures:function(a,b,c,d,e){var f=this;a.outSpatialReference=b.spatialReference;a.maxAllowableOffset=b.maxAllowableOffset;a.outFields=b.outFields;null!=b.returnGeometry&&(a.returnGeometry=b.returnGeometry);e._time.featStart=this._getTime();c.queryFeatures(a).then(function(a){e._time.featEnd=f._getTime();f._resolveSample(e,
a&&a.features||[],b.caching,f._srcQuery)}).otherwise(function(a){f._resolveSample(e,f._pickItems(d,d.length),b.caching,f._srcMemory)})},_pickItems:function(a,b){var c=a.length,d=[],e,f=[];if(b>=c)f=a.slice(0);else for(;f.length<b;)e=this._getRandomInt(0,c),-1===l.indexOf(d,e)&&(d.push(e),f.push(a[e]));return f},_getRandomInt:function(a,b){return Math.floor(Math.random()*(b-a))+a},_resolveSample:function(a,b,c,d){b=b||[];var e,f=b.length,g;for(e=0;e<f&&!(g=(g=b[e].geometry)&&g.spatialReference);e++);
a._time.end=(new Date).getTime();e=a._time;a._time=null;b={features:b,spatialReference:g&&new C(g.toJson()),source:d,time:this._getTimeStats(e),totalFeatures:a._totalFeatures};c&&(this._sampleCache=this._cloneSample(b));a.resolve(b)},_cloneSample:function(a){return{features:l.map(a.features,function(a){return new a.constructor(a.toJson())}),spatialReference:a.spatialReference&&new C(a.spatialReference.toJson()),source:a.source,time:p.clone(a.time),totalFeatures:a.totalFeatures}},_getTimeStats:function(a){var b=
this._getTimeDiff;return{total:b(a.start,a.end),features:b(a.featStart,a.featEnd),featureIds:b(a.idStart,a.idEnd),featureCount:b(a.countStart,a.countEnd)}},_getTimeDiff:function(a,b){var c,d;null!=a&&null!=b&&(c=b-a,d="millisecond",1E3<=c&&(c/=1E3,d="second",60<=c&&(c/=60,d="minute")),c={value:Number(c.toFixed(2)),unit:d});return c},_getTime:function(){return(new Date).getTime()},_scaleRange:function(a){var b=this,c=a.params,d=this.layer,e=c&&c.sampleSize||this.sampleSize,f=c&&c.map||d.getMap(),g=
c&&c.mapWidth||this.mapWidth,h=c&&c.mapHeight||this.mapHeight,k=c&&c.generalizeForScale||this.generalizeForScale,m,q;c&&!1===c.map&&(f=null);f&&f.__tileInfo?(m=f.__tileInfo,q=f.spatialReference,f=f.extent.getWidth()/f.width/f.getScale()*k):(m=this.tileInfo,q=m.spatialReference,f=this.generalizeForResolution/this.generalizeForScale*k);this.getSampleFeatures({sampleSize:e,spatialReference:q,maxAllowableOffset:f,outFields:[]}).then(function(e){var f=b._projectExtent(d.fullExtent,q),k=e.features;k&&k.length?
b.getSpatialStatistics({features:k}).then(function(d){w(f).always(function(f){f=f&&f.hasOwnProperty("xmin")?f:null;b._processScaleRange(a.dfd,c,m,g,h,f,e,d)})}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedScaleRange: unable to calculate spatial statistics.")}):b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedScaleRange: sampling returned 0 features.")}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedScaleRange: unable to sample features.")})},
_processScaleRange:function(a,b,c,d,e,f,g,h){var k=this.layer.geometryType,m={point:"esriGeometryPoint"===k,mPoint:"esriGeometryMultipoint"===k,line:"esriGeometryPolyline"===k,polygon:"esriGeometryPolygon"===k||this.layer.hasXYFootprint()},k=b&&b.forPublishingTiles,q=c.lods,l=this._getLODForMinScale(b,h,m,c),n=k||m.polygon?this._getLODForMaxScale(b,h,m,c):null,p=1-this.mapPaddingRatioForFE,u=(p=f&&this._findLODForFE(q,f,d*p,e*p))?p.scale:null,v=(b=this._getLODForMinScale(b,h,m,c,this.minScaleRelaxationRatio))?
b.scale:null,r=(b=h.avgXY)&&new ba(b.x,b.y,g.spatialReference&&new C(g.spatialReference.toJson())),w=this,x,A=k||m.polygon?n?Math.floor(n.scale):null:0,B;l&&f&&r&&(B=this._findClosestLOD(q,l,f,r,d,e));x=(l=B||l)?Math.ceil(l.scale):null;v=v&&u?Math.max(v,2*u):v||2*u;u=u&&Math.ceil(u);v=v&&Math.ceil(v);l||n?l&&r?this._countAtView(r,l,d,e).then(function(b){var c;b||(b=g.features[0],c=m.point?b.geometry:(b=b.geometry&&b.geometry.getExtent())&&b.getCenter());w._resolveScaleRange(a,x,A,u,v,c||r,g,h)}).otherwise(function(b){w._resolveScaleRange(a,
x,A,u,v,r,g,h)}):this._resolveScaleRange(a,x,A,u,v,r,g,h):this._rejectDfd(a,"FeatureLayerStatistics.getSuggestedScaleRange: unable to find optimal scale range.")},_resolveScaleRange:function(a,b,c,d,e,f,g,h){b<c?this._rejectDfd(a,"FeatureLayerStatistics.getSuggestedScaleRange: invalid scale range - calculated minScale is less than maxScale."):(c>b/2&&(c=Math.floor(c/2)),a.resolve({minScale:b&&(b>this.worldScale?0:b),maxScale:c,scaleAtFullExtent:d,relaxedMinScale:e&&(e>this.worldScale?0:e),center:f,
sampleInfo:g,spatialStatistics:h}))},_countAtView:function(a,b,c,d){a=this._getExtentFromCenter(a,b,c,d);b=new r;b.geometry=a;return this.layer.queryCount(b).promise},_projectExtent:function(a,b){if(a.spatialReference.equals(b))return new a.constructor(a.toJson());if(J.canProject(a.spatialReference,b))return J.project(a,b);var c=new X;c.geometries=[a];c.outSR=b;return this._gsTask.project(c).then(function(a){return a&&a[0]})},_getLODForMinScale:function(a,b,c,d,e){var f=a&&a.minDistance||this.minDistance,
g=a&&a.minLength||this.minLength;a=a&&a.minSize||this.minSize;var h,k,m;c.point?(h=b.avgMinDistance,m=f):c.mPoint?(h=b.avgMinDistance,m=f):c.line?(h=b.avgLength,m=g):c.polygon&&(h=b.avgSize,m=a);0<h&&(k=this._findLOD(d,h,m*(e||1)));return k},_getLODForMaxScale:function(a,b,c,d){var e=this.mapWidth,f=a&&a.forPublishingTiles,g=a&&a.maxDistance||e/4,h=a&&a.maxLength||e/4;a=a&&a.maxSize||e/2;var k,m,l;c.point?(k=f?b.avgMinDistance:b.minDistance,l=g):c.mPoint?(k=f?b.avgMinDistance:b.minDistance,l=g):c.line?
(k=f?b.avgLength:b.minLength,l=h):c.polygon&&(k=f?b.avgSize:b.minSize,l=a);0<k&&(m=this._findLOD(d,k,null,l));return m},_findLOD:function(a,b,c,d){a=a&&a.lods;var e,f,g,h;if(a&&a.length){var k=null!=d,m=k?0:a.length-1,l=k?-1:1;for(g=k?a.length-1:0;k?g>=m:g<=m;g+=l)if(f=a[g],h=Math.round(b/f.resolution),k){if(h<=d){e=f;break}}else if(h>=c){e=f;break}}return e},_getExtentFromCenter:function(a,b,c,d){c=c/2*b.resolution;b=d/2*b.resolution;return new ca(a.x-c,a.y-b,a.x+c,a.y+b,new C(a.spatialReference.toJson()))},
_findClosestLOD:function(a,b,c,d,e,f){var g,h=a.length,k,m;for(g=0;g<h;g++)if(!(a[g].level<b.level))if(k=this._getExtentFromCenter(d,a[g],e,f),!k.contains(c)){m=a[g-1];break}else if(g===h-1){m=a[g];break}return m=m&&m.level>b.level?m:null},_findUniqueValues:function(a){var b=this,c=a.params,d=c.field,e=d?this.layer.getField(d):null,f=c.valueExpression||c.sqlExpression,g=c.valueExpression&&(!c.sqlExpression||!this._canUseSQL92Expression()),h=this._isCollection()||c.features||g;if(d&&!e)this._rejectDfd(a.dfd,
"FeatureLayerStatistics.getUniqueValues: unknown 'field'.");else{if(f)if(g){if(d=this._getExpressionInfo(c.valueExpression),this._rejectIfInvalidExpression(a.dfd,d,"getUniqueValues"))return}else if(!c.valueExpression){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getUniqueValues: valueExpression parameter is missing.");return}h?this._uvFromMemory(c).then(function(d){b._resolveUVDfd(d,a,e,c.features?b._srcFeatures:b._srcMemory)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics: unable to calculate unique values.")}):
this._uvFromStatisticsQuery(c).then(function(c){b._resolveUVDfd(c,a,e,b._srcQuery)}).otherwise(function(d){b._uvFromGenRenderer(c,e).then(function(c){b._resolveUVDfd(c,a,e,b._srcGenRend)}).otherwise(function(d){b._uvFromMemory(c).then(function(c){b._resolveUVDfd(c,a,e,b._srcMemory)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics: unable to calculate unique values.")})})})}},_uvFromStatisticsQuery:function(a){var b=this.layer,c=new n;if(b.supportsStatistics){var d=a.field;a=a.sqlExpression;
var e="countOF"+(d||"Expr"),f=this,g=new D;g.statisticType="count";g.onStatisticField=a?"*":d;g.outStatisticFieldName=e;var h=new r;h.outStatistics=[g];h.groupByFieldsForStatistics=[d||a];h.sqlFormat=a?"standard":null;b.queryFeatures(h).then(function(a){var g,k,n={},t,z,u=!!a.exceededTransferLimit;l.forEach(a.features,function(a){g=a.attributes;k=d?this._getAttributeVal(g,d):this._getCustomExprVal(g,e);t=this._getAttributeVal(g,e);null===k&&0===t&&(z=!0);if(null==k||""===k||"string"===typeof k&&""===
p.trim(k))k=null;null==n[k]?n[k]={count:t,data:k}:n[k].count+=t},f);d&&z?(h=new r,h.where=d+" is NULL",b.queryCount(h).then(function(a){n["null"].count+=a||0;c.resolve({count:n,partialData:u})}).otherwise(function(a){c.resolve({count:n,partialData:u})})):c.resolve({count:n,partialData:u})}).otherwise(function(a){f._rejectDfd(c,"FeatureLayerStatistics: Statistics query operation failed.")})}else this._rejectDfd(c,"FeatureLayerStatistics: Statistics query requires a layer that supports statistics.");
return c.promise},_uvFromGenRenderer:function(a,b){var c=this.layer,d=new n,e=this;if(10.1<=c.version){var f=new T;f.attributeField=a.field;var g=new E;g.classificationDefinition=f;g.where=c.getDefinitionExpression();this._grTask.execute(g).then(function(a){var c={},f,g=-1<l.indexOf(e._numericTypes,b.type);l.forEach(a.infos,function(a){f=a.value;if(null==f||""===f||"string"===typeof f&&(""===p.trim(f)||"\x3cnull\x3e"===f.toLowerCase()))f=null;null==c[f]?c[f]={count:a.count,data:g&&f?Number(f):f}:
c[f].count+=a.count});d.resolve({count:c})}).otherwise(function(a){e._rejectDfd(d,"FeatureLayerStatistics: Generate renderer operation failed.")})}else this._rejectDfd(d,"FeatureLayerStatistics: Generate renderer operation requires server version 10.1 or later.");return d.promise},_uvFromMemory:function(a){var b=this.layer,c=new n,d=F.createAttributeCache({field:a.field,valueExpression:a.valueExpression},!0),e={};l.forEach(a.features||b.graphics,function(a){a=a._getDataValue(d.attributeInfo,d,x,b);
if(null==a||""===a||"string"===typeof a&&""===p.trim(a))a=null;null==e[a]?e[a]={count:1,data:a}:e[a].count++},this);c.resolve({count:e});return c.promise},_resolveUVDfd:function(a,b,c,d){var e=a.count,f=c&&this.layer.getDomain(c.name),g;c=[];b.params.includeAllCodedValues&&f&&"codedValue"===f.type&&l.forEach(f.codedValues,function(a){a=a.code;e.hasOwnProperty(a)||(e[a]={data:a,count:0})});for(g in e)f=e[g],c.push({value:f.data,count:f.count});b.dfd.resolve({source:d,partialData:null!=b.params.hasAllFeatures?
!b.params.hasAllFeatures:!this._isCollection()&&(d===this._srcMemory||a.partialData),uniqueValueInfos:c})},_findClassBreaks:function(a){var b=this,c=a.params,d=c.minValue,e=c.maxValue,f=null!=d||null!=e,g=c.classificationMethod,h="percent-of-total"===c.normalizationType,k=c.numClasses||this.numClasses,m=!1!==c.analyzeData,l=c.field,n=l?this.layer.getField(l):null,p=c.valueExpression,l=this._isCollection()||c.features||p;if(!n||!this._rejectNonNumeric(a.dfd,n,"getClassBreaks")){if(p){if(c.normalizationType){this._rejectDfd(a.dfd,
"FeatureLayerStatistics.getClassBreaks: normalization is not supported when valueExpression is specified.");return}d=this._getExpressionInfo(p);if(this._rejectIfInvalidExpression(a.dfd,d,"getClassBreaks"))return}else if(f)if(m){if(h&&null==c.normalizationTotal){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getClassBreaks: normalizationTotal is required when minValue/maxValue are specified.");return}}else{if(null==d||null==e){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getClassBreaks: both minValue AND maxValue are required when data analysis is disabled.");
return}if(g&&"equal-interval"!==g){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getClassBreaks: data analysis can be disabled only for equal-interval classification.");return}if(h&&null==c.normalizationTotal){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getClassBreaks: normalizationTotal is required when data analysis is disabled.");return}}else if(!m){this._rejectDfd(a.dfd,"FeatureLayerStatistics.getClassBreaks: both minValue AND maxValue are required when data analysis is disabled.");return}m?
l?this._cbFromMemory(c,k).then(function(d){b._resolveCBDfd(a.dfd,c,d,c.features?b._srcFeatures:b._srcMemory)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics: unable to calculate class breaks.")}):this._cbFromGenRend(c,k).then(function(d){b._resolveCBDfd(a.dfd,c,d,b._srcGenRend)}).otherwise(function(d){f?b._rejectDfd(a.dfd,"FeatureLayerStatistics.getClassBreaks: cannot calculate class breaks in-memory when minValue/maxValue are specified."):b._cbFromMemory(c,k).then(function(d){b._resolveCBDfd(a.dfd,
c,d,b._srcMemory)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics: unable to calculate class breaks.")})}):this._cbFromInterpolation(c,k).then(function(d){b._resolveCBDfd(a.dfd,c,d,b._srcMemory)}).otherwise(function(c){b._rejectDfd(a.dfd,"FeatureLayerStatistics: unable to calculate class breaks.")})}},_cbFromGenRend:function(a,b){var c=this.layer,d=new n,e=this;if(c.url&&10.1<=c.version){var f=this._createCBDefn(a,b),c=this._getGRWhereInfo(c,a).where,g=this._getFieldExpr(a,a.normalizationTotal),
g=this._getRangeExpr(g,a.minValue,a.maxValue),h=new E;h.classificationDefinition=f;h.where=c?c+(g?" AND "+g:""):g;this._grTask.execute(h).then(function(a){d.resolve(a)}).otherwise(function(a){e._rejectDfd(d,"FeatureLayerStatistics: Generate renderer operation failed.")})}else this._rejectDfd(d,"FeatureLayerStatistics: Generate renderer operation requires server version 10.1 or later.");return d.promise},_cbFromMemory:function(a,b){var c=new n,d=a.features||this.layer.graphics;if(d.length){var e=this._createCBDefn(a,
b),f;if("percent-of-total"===a.normalizationType){f=this._calcStatsFromMemory({field:a.field}).sum;if(null==f)return this._rejectDfd(c,"FeatureLayerStatistics: Invalid normalizationTotal."),c.promise;a=p.mixin({normalizationTotal:f},a)}c.resolve(V.createClassBreaksRenderer({features:d,definition:e,values:this._getDataValues(d,a)}))}else this._rejectDfd(c,"Layer has 0 features in memory.");return c.promise},_cbFromInterpolation:function(a,b){var c=new n,d=a.minValue,e=a.maxValue;if(d>=e||!b||1>b)this._rejectDfd(c,
"FeatureLayerStatistics.getClassBreaks: invalid input parameters: minValue, maxValue or numClasses.");else{var f=[],g,h,k=(e-d)/b;for(g=0;g<b;g++)h=d+g*k,f.push({minValue:h,maxValue:h+k});f[b-1].maxValue=e;c.resolve({infos:f,normalizationTotal:a.normalizationTotal})}return c.promise},_createCBDefn:function(a,b){var c=a.field,d=a.classificationMethod||this.classificationMethod,e=a.normalizationType,f=a.normalizationField,g=new U;g.classificationField=c;g.breakCount=b;g.classificationMethod=d;g.standardDeviationInterval=
"standard-deviation"===d?a.standardDeviationInterval||this.standardDeviationInterval:void 0;g.normalizationType=e;g.normalizationField="field"===e?f:void 0;return g},_resolveCBDfd:function(a,b,c,d){var e=c.infos,f=e[0].minValue,g=e[e.length-1].maxValue,h="standard-deviation"===b.classificationMethod,k=this._reNumber,m,n,r,e=l.map(e,function(a){r=a.label;n={minValue:a.minValue,maxValue:a.maxValue,label:r};h&&r&&(m=r.match(k),m=l.map(m,function(a){return+p.trim(a)}),2===m.length?(n.minStdDev=m[0],n.maxStdDev=
m[1],0>m[0]&&0<m[1]&&(n.hasAvg=!0)):1===m.length&&(-1<r.indexOf("\x3c")?(n.minStdDev=null,n.maxStdDev=m[0]):-1<r.indexOf("\x3e")&&(n.minStdDev=m[0],n.maxStdDev=null)));return n});b=!1!==b.analyzeData?null!=b.hasAllFeatures?!b.hasAllFeatures:!this._isCollection()&&d===this._srcMemory:!1;a.resolve({minValue:f,maxValue:g,classBreakInfos:e,normalizationTotal:c.normalizationTotal,source:d,partialData:b})},_reHostedFS:/(https?:)?\/\/services.*\.arcgis\.com/i,_noDominantCategoryField:"no_dominant_category",
_predominantCategories:function(a){var b=a.dfd,c=a.params.fields,d=this;if(this._canUseExpression()){a=this._predominantCategoryArcade(c);var e=this._predominantCategoryNameSQL(c);(this._isCollection()?this._uvFromMemory({valueExpression:a}):this._uvFromStatisticsQuery({sqlExpression:e.expression,valueExpression:a})).then(function(a){var e=d._isCollection()?d._srcMemory:d._srcQuery;d._resolvePredominantCategories(b,c,a,e)}).otherwise(function(a){d._rejectDfd(b,"FeatureLayerStatistics.getPredominantCategories: error when counting features in each predominant category.")})}else this._rejectDfd(b,
"FeatureLayerStatistics.getPredominantCategories: make sure the layer supports advanced SQL expressions and standardized queries.")},_resolvePredominantCategories:function(a,b,c,d){var e,f=[],g=c.count;for(e in g)c=g[e],f.push({value:c.data,count:c.count});var h=l.map(f,function(a){return a.value});e=l.filter(b,function(a){return-1===l.indexOf(h,a)});l.forEach(e,function(a){f.push({value:a,count:0})});f.sort(this._predominantFieldSorter(b));l.forEach(f,function(a){a.value===this._noDominantCategoryField&&
(a.value=null)},this);a.resolve({predominantCategoryInfos:f,source:d})},_predominantCategoryNameSQL:function(a){return{expression:this._calcMaxFieldSQL(a,{returnFieldName:!0,defaultValue:"'"+this._noDominantCategoryField+"'"})}},_calcMaxFieldSQL:function(a,b){var c=[],d,e,f,g;b&&(d=b.resultValue,e=b.returnFieldName,f=b.defaultValue,g=b.integerFields);if(e&&f){var h=l.map(a,function(a){return a+" \x3c\x3d 0"});c.push("WHEN "+h.join(" AND ")+" THEN "+f)}l.forEach(a,function(b){var f=[];l.forEach(a,
function(a){b!==a&&f.push(b+" \x3e "+a)});c.push("WHEN "+f.join(" AND ")+" THEN "+(d||e&&"'"+b+"'"||(-1<l.indexOf(g,b)?"cast("+b+" as float)":b)))});return["CASE",c.join(" "),"ELSE "+(f||"0"),"END"].join(" ")},_predominantFieldSorter:function(a){return function(b,c){var d=l.indexOf(a,b.value),e=l.indexOf(a,c.value);return d-e}},_predominanceExpressions:function(a){var b=a.params.fields,c=l.map(l.filter(this.layer.fields,function(a){return-1<l.indexOf(this._integerTypes,a.type)},this),function(a){return a.name}),
d=this._sumOfFieldsSQL(b),c=this._strengthOfPredominanceSQL(b,c);a.dfd.resolve({predominantCategory:{valueExpression:this._predominantCategoryArcade(b)},size:{valueExpression:this._sumOfFieldsArcade(b),statisticsQuery:d,histogramQuery:d},opacity:{valueExpression:this._strengthOfPredominanceArcade(b),statisticsQuery:c,histogramQuery:c}})},_calcMaxFieldInfo:function(a,b){a=l.map(a,function(a){return'"'+a+'"'});var c=["var fieldNames \x3d [ "+a.join(", ")+" ];","var numFields \x3d "+a.length+";","var maxValueField \x3d null;",
"var maxValue \x3d -Infinity;","var value, i, totalValue \x3d null;","for(i \x3d 0; i \x3c numFields; i++) {","value \x3d $feature[fieldNames[i]];","if(value \x3e 0) {","if(value \x3e maxValue) {","maxValue \x3d value;","maxValueField \x3d fieldNames[i];","}","else if (value \x3d\x3d maxValue) {","maxValueField \x3d null;","}","}"];b&&c.push("if(value !\x3d null \x26\x26 value \x3e\x3d 0) {","if (totalValue \x3d\x3d null) { totalValue \x3d 0; }","totalValue \x3d totalValue + value;","}");c.push("}");
return c},_declareFieldNames:function(a){var b=[],b=l.map(a,function(a){return'$feature["'+a+'"];'});return b.length?b.join("\n")+"\n":""},_predominantCategoryArcade:function(a){var b=this._calcMaxFieldInfo(a);b.push("return maxValueField;");return this._declareFieldNames(a)+b.join("\n")},_sumOfFieldsArcade:function(a){var b=this._declareFieldNames(a);a=l.map(a,function(a){return'"'+a+'"'});a=["var fieldNames \x3d [ "+a.join(", ")+" ];","var numFields \x3d "+a.length+";","var value, i, totalValue \x3d null;",
"for(i \x3d 0; i \x3c numFields; i++) {","value \x3d $feature[fieldNames[i]];","if(value !\x3d null \x26\x26 value \x3e\x3d 0) {","if (totalValue \x3d\x3d null) { totalValue \x3d 0; }","totalValue \x3d totalValue + value;","}","}","return totalValue;"];return b+a.join("\n")},_strengthOfPredominanceArcade:function(a){var b=this._calcMaxFieldInfo(a,!0);b.push("var strength \x3d null;","if (maxValueField !\x3d null \x26\x26 totalValue \x3e 0) {","strength \x3d (maxValue / totalValue) * 100;","}","return strength;");
return this._declareFieldNames(a)+b.join("\n")},_calcSumOfFieldsSQL:function(a){return a.join(" + ")},_ensurePositiveFields:function(a){return"("+l.map(a,function(a){return a+" \x3e\x3d 0"}).join(" OR ")+")"},_sumOfFieldsSQL:function(a){return{sqlExpression:"("+this._calcSumOfFieldsSQL(a)+")",sqlWhere:this._ensurePositiveFields(a)}},_strengthOfPredominanceSQL:function(a,b){return{sqlExpression:"((("+this._calcMaxFieldSQL(a,{integerFields:b})+") / ("+this._calcSumOfFieldsSQL(a)+")) * 100)",sqlWhere:this._ensurePositiveFields(a)+
" AND (("+this._calcSumOfFieldsSQL(a)+") \x3e 0)"}},_calcBinsSQL:function(a,b){var c=[],d=b.length;l.forEach(b,function(b,f){c.push("WHEN ("+[a+" \x3e\x3d "+b[0],a+(f===d-1?" \x3c\x3d ":" \x3c ")+b[1]].join(" AND ")+") THEN "+(f+1))});return["CASE",c.join(" "),"ELSE 0 END"].join(" ")},_ageStatistics:function(a){var b=a.params.units,c=this;this.getAgeExpressions({startTime:a.params.startTime,endTime:a.params.endTime,units:b}).then(function(d){var e={valueExpression:d.valueExpression};p.mixin(e,d.statisticsQuery);
c.getFieldStatistics(e).then(function(c){a.dfd.resolve({units:b,statistics:c})}).otherwise(function(b){c._rejectDfd(a.dfd,"FeatureLayerStatistics.getAgeStatistics: unable to calculate statistics.")})}).otherwise(function(b){c._rejectDfd(a.dfd,"FeatureLayerStatistics.getAgeStatistics: unable to generate expressions to calculate age.")})},_supportedAgeUnits:"years months days hours minutes seconds".split(" "),_unitValueInDays:{years:365,months:30,days:1,hours:1/24,minutes:1/1440,seconds:1/86400,milliseconds:1/
864E5},_suggestedAgeUnits:function(a){var b=a.params.startTime,c=a.params.endTime,d=this;this._rejectIfInvalidDates(a.dfd,b,c,"getSuggestedAgeUnits")||this.getAgeStatistics({startTime:b,endTime:c,units:"days"}).then(function(b){b=b.statistics;null!=b.avg?a.dfd.resolve({units:d._calcSuggestedAgeUnits(b),statistics:b}):d._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedAgeUnits: 'avg' statistic is not available.")}).otherwise(function(b){d._rejectDfd(a.dfd,"FeatureLayerStatistics.getSuggestedAgeUnits: unable to calculate statistics.")})},
_calcSuggestedAgeUnits:function(a){var b,c=this._unitValueInDays,d=Math.abs(a.avg);l.some(this._supportedAgeUnits,function(a){d>2*c[a]&&(b=a);return!!b});return b},_ageExpressions:function(a){var b=a.params.startTime,c=a.params.endTime,d=a.params.units||"days";if(!this._rejectIfInvalidDates(a.dfd,b,c,"getAgeExpressions"))if(-1===l.indexOf(this._supportedAgeUnits,d))this._rejectDfd(a.dfd,"FeatureLayerStatistics.getAgeExpressions: invalid 'units'. Supported units are: years, months, days, hours, minutes, seconds.");
else{var e=this._getDateDiffSQL(b,c,d);a.dfd.resolve({valueExpression:this._getDateDiffArcade(b,c,d),statisticsQuery:e,histogramQuery:e})}},_getDateDiffArcade:function(a,b,c){var d=this._getDateType(a),e=this._getDateType(b);c=[this._readDateValueArcade(a,d,"startTime"),this._readDateValueArcade(b,e,"endTime"),"var retVal \x3d null;","if (startTime !\x3d null \x26\x26 endTime !\x3d null) {","startTime \x3d Date(startTime);","endTime \x3d Date(endTime);","retVal \x3d DateDiff(endTime, startTime, '"+
c+"');","}","return retVal;"];var f=[];"field"===d&&f.push(a);"field"===e&&f.push(b);return this._declareFieldNames(f)+c.join("\n")},_readDateValueArcade:function(a,b,c){a="number"===b?a:"date"===b?a.getTime():'$feature["'+a+'"]';return"var "+c+" \x3d "+a+";"},_getDateDiffSQL:function(a,b,c){a="("+this._getDateValueSQL(b,this._getDateType(b))+" - "+this._getDateValueSQL(a,this._getDateType(a))+")";c=this._unitValueInDays[c];b="/";1>c&&(c=1/c,b="*");return{sqlExpression:1===c?a:"("+a+" "+b+" "+c+")",
sqlWhere:null}},_getDateValueSQL:function(a,b){var c;"date"===b||"number"===b?("number"===b&&(a=new Date(a)),c="TIMESTAMP'"+a.getUTCFullYear()+"-"+this._padZeros(a.getUTCMonth()+1)+"-"+this._padZeros(a.getUTCDate())+" "+this._padZeros(a.getUTCHours())+":"+this._padZeros(a.getUTCMinutes())+":"+this._padZeros(a.getUTCSeconds())+"'"):c=a;return c},_padZeros:function(a){return O.pad(a,2,"0")},_getDateType:function(a){var b;if(a instanceof Date)b="date";else if("number"===typeof a)b="number";else if("string"===
typeof a){var c=this.layer.getField(a);"\x3cnow\x3e"===a.toLowerCase()?b="":c&&c.type===this._dateType&&(b="field")}return b},_rejectIfInvalidDates:function(a,b,c,d){var e=[],f=!1,g=l.every([b,c],function(a){(a=this._getDateType(a))&&e.push(a);return!!a},this),h="FeatureLayerStatistics."+d+": invalid combination of 'startTime' and 'endTime' parameters.",k=["date","number"];g?e[0]===e[1]?"field"===e[0]?b===c&&(this._rejectDfd(a,"FeatureLayerStatistics."+d+": 'startTime' and 'endTime' parameters cannot be identical."),
f=!0):(this._rejectDfd(a,h),f=!0):-1<l.indexOf(k,e[0])&&-1<l.indexOf(k,e[1])&&(this._rejectDfd(a,h),f=!0):(this._rejectDfd(a,"FeatureLayerStatistics."+d+": 'startTime' and 'endTime' parameters must be one of these values: a date object, unix epoch time, name of a valid date field or \x26lt;now\x26gt;."),f=!0);return f},_fetchFeatures:function(a,b){var c=a.params,d=c.valueExpression&&(!c.sqlExpression||!this._canUseSQL92Expression()),e=this,d=c.features||this._isCollection()||!d?null:this._fetchMaxFeaturesForStats();
w(d).always(function(d){var f,h;d&&(f=d.features,h=d.hasAllFeatures);f&&(a.params=p.mixin({},c),a.params.features=f,a.params.hasAllFeatures=h);b.call(e,a)})},_rejectDfd:function(a,b){a.reject(Error(b))},_rejectNonNumeric:function(a,b,c){var d;if(!b)this._rejectDfd(a,"FeatureLayerStatistics."+c+": unknown 'field'."),d=!0;else if(b.name===this.layer.objectIdField||-1===l.indexOf(this._numericTypes,b.type))this._rejectDfd(a,"FeatureLayerStatistics."+c+": 'field' should be numeric."),d=!0;return d},_rejectIfInvalidType:function(a,
b,c,d){var e;if(!b)this._rejectDfd(a,"FeatureLayerStatistics."+c+": unknown 'field'."),e=!0;else if(b.name===this.layer.objectIdField||-1===l.indexOf(d,b.type))this._rejectDfd(a,"FeatureLayerStatistics."+c+": 'field' should be one of these types: "+d.join(",")),e=!0;return e},_canUseExpression:function(){return this._isCollection()||this._canUseSQL92Expression()},_canUseSQL92Expression:function(){return this._reHostedFS.test(this.layer.url)},_getExpressionInfo:function(a){var b=x.extractFieldNames(a),
c=this.layer,d=[];l.forEach(b,function(a,f){var e=c.getField(a);e?b[f]=e.name:d.push(a)});return{fields:b,unknownFields:d}},_rejectIfInvalidExpression:function(a,b,c){b=b.unknownFields;var d;b&&b.length&&(this._rejectDfd(a,"FeatureLayerStatistics."+c+": valueExpression has unknown field names: "+b.join(", ")),d=!0);return d},_getAttributeVal:function(a,b){var c,d;b=b.toLowerCase();if(a)for(d in a)if(d.toLowerCase()===b){c=a[d];break}return c},_getCustomExprVal:function(a,b){var c,d;b=b.toLowerCase();
if(a)for(d in a)if(d.toLowerCase()!==b){c=a[d];break}return c},_callAfterLoad:function(a,b,c){if(this._loaded)a.call(this,b,c);else H.once(this,"_load",p.hitch(this,a,b,c))},_numericTypes:["esriFieldTypeInteger","esriFieldTypeSmallInteger","esriFieldTypeSingle","esriFieldTypeDouble"],_integerTypes:["esriFieldTypeInteger","esriFieldTypeSmallInteger"],_dateType:"esriFieldTypeDate",_createGRTask:function(){this._grTask=new S(this.layer,{source:this.layer.source,gdbVersion:this.layer.gdbVersion});this._loaded=
!0;this.emit("_load")}});p.mixin(A,{add:function(a,b){if(!a.statisticsPlugin){var c=b||{};c.layer=a;a.statisticsPlugin=new A(c)}},remove:function(a){a.statisticsPlugin&&(a.statisticsPlugin.destroy(),delete a.statisticsPlugin)}});M("extend-esri")&&p.setObject("plugins.FeatureLayerStatistics",A,P);return A});