package com.cx.cn.cxquartz.util;

import com.cx.cn.cxquartz.controller.IndexController;
import com.cx.cn.cxquartz.vo.Location;
import com.cx.cn.cxquartz.vo.Point;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.*;
import java.util.List;

public  class PointUtil {
    private static final Logger logger = LoggerFactory.getLogger(IndexController.class);

public static void getXYWH(List<Point> points, Long[] roiarray){
    Map<Integer, Integer> map=new HashMap();
    Map<Integer, Integer> mapy=new HashMap();
    for(Point point :points){
    map.put(point.getX(),point.getX());
    mapy.put(point.getY(),point.getY());
    }
    //map有两个，mapy有两个值
    List<Integer> numx = new ArrayList<Integer>();
    for (Map.Entry<Integer, Integer> mx:map.entrySet()) {
        numx.add(mx.getValue());
        }
    List<Integer> numy = new ArrayList<Integer>();
    for (Map.Entry<Integer, Integer> my:mapy.entrySet()) {
        numy.add(my.getValue());
    }
    Collections.sort(numx);
    Collections.sort(numy);
    if(numx.size()==2 && numy.size()==2) {
        roiarray[0]=Long.parseLong(String.valueOf(numx.get(0)));
        roiarray[1]=Long.parseLong(String.valueOf(numy.get(0)));
        roiarray[2]=Long.parseLong(String.valueOf(numx.get(1) - numx.get(0)));
        roiarray[3]=Long.parseLong(String.valueOf(numy.get(1) - numy.get(0)));
    }}
public static  ByteArrayOutputStream drawByPoints(InputStream bais,List<Map> detectObjects) {
    ByteArrayOutputStream stream = new ByteArrayOutputStream();
    try {

        BufferedImage image = ImageIO.read(bais);
        Graphics g = image.getGraphics();
        g.setColor(Color.RED);
        //遍历所有特征值，画到图片上
        int x,y,w,h;
        for (Map box : detectObjects) {
            if (null != box) {
                try {
                    if (null != box.get("location")) {
                        x=0;y=0;w=0;h=0;
                        try {
                            Location lo =(Location) box.get("location");
                            logger.info("detectObjects x1,x2,y1,y2==="+lo.toString());
                            g.drawRect(lo.getX1(),lo.getY1(),lo.getX2()-lo.getX1(),lo.getY2()-lo.getY1());
                        }catch (Exception ex){
                            logger.error("Location Map error:{}", ex.toString());
                        }
                    }
                } catch (Exception ex) {
                    logger.error("Location readValue error:{}", ex.toString());
                }
            }
        }

        ImageIO.write(image, "JPEG", stream);
        return  stream;
    }catch (Exception ex){
        logger.error("Location readValue error:{}", ex.toString());

    }
    return stream;
}
}
