package com.cx.cn.cxquartz.service.quartz.impl;

import com.cx.cn.cxquartz.dao.TraffPictureMapper;
import com.cx.cn.cxquartz.service.quartz.FtpService;
import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author wjj
 * @since 2021-04-29
 */
@Service
public class EventWriteService {
    private static final Logger log = LoggerFactory.getLogger(EventWriteService.class);

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TraffPictureMapper traffPictureMapper;

    @Value("${countryside.eventwrite.url}")
    private String url;

    @Value("${voice.url}")
    private String voiceurl;


    @Value("${countryside.eventwrite.timeout}")
    private Integer timeout;


    @Value("${countryside.eventwrite.token}")
    private String qztoken;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    TraffPictureService traffPictureService;

    @Autowired
    TokenCacheService tokensertvice;

    @Autowired
    FtpService ftpService;
    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;
    @Value("${file.rootpath}")
    private String filerootpath;
    @Value("${file.outpath}")
    private String outpath;



    @Value("${file.uploadurl}")
    private String uploadurl;


    private static CompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(ThreadPoolUtil.getPool());

    public void sendEvent(TraffpictureParam traffpictureParamresult, TraffrecordData sendtozhiui) {
        sendtozhiui.setAlarmnum(traffpictureParamresult.getTargetnum());
        sendtozhiui.setFdid(traffpictureParamresult.getFdid());
        sendtozhiui.setRecordtype(traffpictureParamresult.getRecordtype());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sendtozhiui.setRecordtime(traffpictureParamresult.getCreatetime() == null ? "" : format.format(traffpictureParamresult.getCreatetime()));
        ResultObj resultObj;
        try {
            resultObj = sendMessage(sendtozhiui);
            traffpictureParamresult.setPushdesc(resultObj.getMsg());
            /* 成功 */
            if ("0".equals(resultObj.getCode())) {
                traffpictureParamresult.setPushstatus(0);
                traffpictureParamresult.setPushdesc("推送成功");
                traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
                return;
            }
            /* 其他失败 */

        } catch (TimeoutException e) {
            traffpictureParamresult.setPushdesc("请求超时");
            log.error("eventwrite - sendEvent 请求超时:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_1008.getCode(), ResponseEnum.E_1008.getMsg());
        } catch (Exception e) {
            traffpictureParamresult.setPushdesc("请求失败");
            log.error("eventwrite - sendEvent 异常:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString());
        }
        traffpictureParamresult.setPushstatus(-1);
        traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
    }

    public void sendVoice(VoiceData voice) {
        VoiceResultObj result;
        try {
            result = sendVoioceMessage(voice);
            /* 成功 */
            if (result.getCode() == 1) {
                log.info(" push to  voice success");
            } else {
                log.info(" push to  voice result", new ObjectMapper().writeValueAsString(result));
            }
        } catch (TimeoutException e) {
            log.error("push to  voice  请求超时:" + e.toString());
        } catch (Exception e) {
            log.error("push to  voice  异常:" + e.toString());
        }
    }

    private ResultObj sendMessage(TraffrecordData traffalarmrecord) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String token = stringRedisTemplate.opsForValue().get(qztoken);
        if (null == token) {
            token = tokensertvice.keepAlive();
        }
        headers.add("accessToken", token);
        HttpEntity<TraffrecordData> requestEntity = new HttpEntity<>(traffalarmrecord, headers);
        return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(url, requestEntity, ResultObj.class)).get(timeout, TimeUnit.SECONDS);
    }
    private ResultObj sendToCalluri(JobTjParam jobTjParam,String callbackurl) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<JobTjParam> requestEntity = new HttpEntity<>(jobTjParam, headers);
        return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(callbackurl, requestEntity, ResultObj.class)).get(timeout, TimeUnit.SECONDS);
    }



    public void sendEventByCallUrl(TraffpictureParam traffpictureParamresult, JobTjParam jobTjParam, String callbackurl) {
        ResultObj resultObj;
        try {
            resultObj= sendToCalluri(jobTjParam,callbackurl);
//            boolean successFlag = resultObj.getCode() == ResponseEnum.SUCCESS.getCode();
            traffpictureParamresult.setPushdesc(resultObj.getMsg());
            /* 成功 */
            if ("0".equals(resultObj.getCode())) {
                traffpictureParamresult.setPushstatus(0);
                traffpictureParamresult.setPushdesc("推送第三方成功");
                traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
                return;
            }
            /* 其他失败 */

        } catch (Exception e) {
            traffpictureParamresult.setPushdesc("推送第三方成功失败");
            log.error("eventwrite - sendEventByCallUrl 异常:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString());
        }
        traffpictureParamresult.setPushstatus(-1);
        traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
    }


    private VoiceResultObj sendVoioceMessage(VoiceData voiceData) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<VoiceData> requestEntity = new HttpEntity<>(voiceData, headers);
        return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(voiceurl, requestEntity, VoiceResultObj.class)).get(timeout, TimeUnit.SECONDS);
    }

    public String sendToService(JobKey jobKey, String jsondata) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity<String> requestEntity = new HttpEntity<>(jsondata, headers);
            return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(jobKey.getName().contains("cz_") ? czurl : fxurl, requestEntity, String.class)).get(timeout, TimeUnit.SECONDS);
        } catch (Exception ex) {
            log.info("getRtspJob->executeInternal  error:{}", ex.toString());
            return null;
        }

    }

    public TraffpictureParam getResult(int tarnum, Long[] roiarray, String imgurl,
                                       List<Map> objectList,
                                       JobTjParam jobTjParam, List<Map> detectObjects) {
        Map obj = new HashMap();
        String recordtype = jobTjParam.getDetectType();
        //判断是否统计结构化数据
        TraffpictureParam traffpictureParamresult = new TraffpictureParam();
        traffpictureParamresult.setImagedata(imgurl);
        //人群统计
        if ("10".equals(recordtype)) {
            int larmnum = getManNumber(objectList);
            //获得所有对象的坐标
            if (tarnum < larmnum) {
                traffpictureParamresult.setTargetnum(larmnum);
                obj.put("objectCount", larmnum);
            } else {
                return null;
            }
        }
        //获得所有对象的坐标
        for (Map traffpictureParam : objectList) {
            //根据imageid  获得  base64图片
            Map metadata = (Map) traffpictureParam.get("Metadata");
            String metatype = String.valueOf(metadata.get("Type"));
            //获得点位坐标
            Map objlocation = new HashMap();
            getObjectPoint(objlocation, metadata, roiarray,traffpictureParamresult);
            //获得特征属性
            getDetectInfo(recordtype, metadata, objlocation);
            //根据对应的解析结果获得相应的数据，存放到对应的表中
            List<Location> list = new ArrayList<>();
            //getMetaData( roiarray, traffpictureParamresult,list,traffpictureParam,metadata);
            detectObjects.add(objlocation);
        }
        //获得其他告警事件的返回结果
        //超过则预警
        obj.put("detectObjects", detectObjects);
        jobTjParam.setDetectInfo(obj);
        jobTjParam.setTimestamp(new Date().getTime());
        return traffpictureParamresult;
    }

    public void setTraffpictureParam(String recordtype, String sbbh, String createtime,
                                     TraffpictureParam traffpictureParam) {
        traffpictureParam.setAreaid(Long.parseLong("-1"));
        traffpictureParam.setFdid(sbbh);
        //traffpictureParam.setRecordid(transferRecord.getRecordid());
        traffpictureParam.setChannelid(0);
        if (createtime.contains(".")) {
            traffpictureParam.setCreatetime(createtime.split("\\.")[0]);
        } else {
            traffpictureParam.setCreatetime(createtime);
        }

        traffpictureParam.setRecordtype(recordtype);
        //新增到picture
        traffPictureService.inserTraffpicture(traffpictureParam);
    }

    public List<Map> getLocation(List<Map> objectList, String recordtype, Long[] roiarray) {
        for (Map traffpictureParam : objectList) {
            //根据imageid  获得  base64图片
            Map metadata = (Map) traffpictureParam.get("Metadata");
            Map objectBoundingBox = (Map) metadata.get("ObjectBoundingBox");
            String metatype = String.valueOf(metadata.get("Type"));
            Map objlocation = new HashMap();
            //获得物体特征值,只能有一个框框

        }
        return null;
    }

    public int getManNumber(List<Map> objectList) {
        int objsize = 0;
        for (Map traffpictureParam : objectList) {
            //根据imageid  获得  base64图片
            Map metadata = (Map) traffpictureParam.get("Metadata");
            String metadatatyp = metadata.get("Type").toString();
            if ("1".equals(metadatatyp) || "4".equals(metadatatyp)
                    || "3".equals(metadatatyp)) {
                //返回结果是人相关的
                objsize++;
            }
        }
        return objsize;
    }

    public void getObjectPoint(Map objlocation, Map metadata, Long[] roiarray,TraffpictureParam traff) {
        Map objectBoundingBox = (Map) metadata.get("ObjectBoundingBox");
        Location lo=new Location();
        if (null != metadata.get("LeftTopX") &&
                !"".equals(metadata.get("LeftTopX").toString())
                && null != metadata.get("LeftTopY")
                && !"".equals(metadata.get("LeftTopY").toString())
                && null != metadata.get("RightBtmX")
                && !"".equals(metadata.get("RightBtmX").toString())
                && null != metadata.get("RightBtmY")
                && !"".equals(metadata.get("RightBtmY").toString())
        ) {
            try {
                lo = new Location(Integer.parseInt(metadata.get("LeftTopX").toString()) + roiarray[0].intValue(), Integer.parseInt(metadata.get("LeftTopY").toString()) + roiarray[1].intValue(),
                        Integer.parseInt(metadata.get("RightBtmX").toString()), Integer.parseInt(metadata.get("RightBtmY").toString()) + roiarray[1].intValue()
                );
            } catch (Exception ex) {

            }
        } else if (null != objectBoundingBox) {
            try {
                lo=new Location(Integer.parseInt(objectBoundingBox.get("x").toString()) + roiarray[0].intValue(),
                        Integer.parseInt(objectBoundingBox.get("y").toString()) + roiarray[1].intValue(),
                        Integer.parseInt(objectBoundingBox.get("x").toString()) + Integer.parseInt(objectBoundingBox.get("w").toString()) + roiarray[0].intValue(),
                        Integer.parseInt(objectBoundingBox.get("y").toString()) + Integer.parseInt(objectBoundingBox.get("h").toString()) + roiarray[1].intValue()
                );
            } catch (Exception ex) {

            }
        } else {
            if (null != metadata.get("FaceBoundingBox")) {
                try {
                    Map faceBoundingBox = (Map) metadata.get("FaceBoundingBox");
                    lo=new Location(
                            Integer.parseInt(faceBoundingBox.get("x").toString()) + roiarray[0].intValue(),
                            Integer.parseInt(faceBoundingBox.get("y").toString()) + roiarray[1].intValue(),
                            Integer.parseInt(faceBoundingBox.get("x").toString()) +
                                    Integer.parseInt(faceBoundingBox.get("w").toString()) + roiarray[0].intValue(),
                            Integer.parseInt(faceBoundingBox.get("y").toString()) +
                                    Integer.parseInt(faceBoundingBox.get("h").toString()) + roiarray[1].intValue()
                    );
                } catch (Exception ex) {

                }
            } else {
                if (null != metadata.get("HeadBoundingBox")) {
                    try {
                        Map headBoundingBox = (Map) metadata.get("HeadBoundingBox");
                        lo=new Location(
                                Integer.parseInt(headBoundingBox.get("x").toString()) + roiarray[0].intValue(),
                                Integer.parseInt(headBoundingBox.get("y").toString()) + roiarray[1].intValue(),
                                Integer.parseInt(headBoundingBox.get("x").toString()) + Integer.parseInt(headBoundingBox.get("w").toString()) + roiarray[0].intValue(),
                                Integer.parseInt(headBoundingBox.get("y").toString()) + Integer.parseInt(headBoundingBox.get("h").toString()) + roiarray[1].intValue()
                        );
                    } catch (Exception ex) {

                    }


                }
            }
        }

        objlocation.put("location",lo);
        if(null!=lo) {
            traff.setObjx(lo.getX1());
            traff.setObjy(lo.getY1());
            traff.setObjw(lo.getX2() - lo.getX1());
            traff.setObjh(lo.getY2() - lo.getY1());
        }
    }

    public void getDetectInfo(String recordtype, Map metadata, Map objlocation) {
        String metatype = metadata.get("Type").toString();
        if ("20".equals(recordtype)) {//周界入侵，展示objectType
            objlocation.put("objectType", metadata.get("Type").toString());
        } else if ("41".equals(recordtype)) {
            //汽车
            if ("2".equals(metatype)) {
                objlocation.put("carNo", String.valueOf(metadata.get("PlateNo")));
                objlocation.put("carBrand", String.valueOf(metadata.get("carBrand")));
            }
        } else if ("42".equals(recordtype)) {
            //非机动车
            if ("4".equals(metatype)) {
                objlocation.put("bikeClassType", String.valueOf(metadata.get("BikeClass")));
            }
        } else if ("43".equals(recordtype)) {
            if ("4".equals(metatype)) {
                int helmet = Integer.parseInt(metadata.get("Helmet").toString());
                //非机动车未戴头盔
                if (helmet == 0) {
                    objlocation.put("helmet", helmet);
                }
            }
        }
    }

    public void uploadPicture(TraffpictureParam traffpictureParam,String url, List<Map> points, String basepath, String filename) {
        try {
            completionService.submit(() -> {
                        InputStream streanm = RestUtil.ReadFromURL(url);
                        ByteArrayOutputStream bos = PointUtil.drawByPoints(streanm, points);
                        if (null == bos) {
                            log.error("picture is null");
                            return false;
                        }

                File file= FileUtil.uploadToLocal(filerootpath+File.separator+
                        outpath+File.separator+
                        basepath,bos,filename);


//                        HttpHeaders headers = new HttpHeaders();
//                        headers.add("Accept", MediaType.ALL_VALUE);
//                       // headers.setContentType(MediaType.parseMediaType("multipart/form-data"));
//                        MultiValueMap<String, Object> parts = new LinkedMultiValueMap<String, Object>();
//
//                        org.springframework.core.io.Resource resource = new ByteArrayResource(bos.toByteArray()){
//                            @Override
//                            public String getFilename () {
//                                return filename;
//                            }
//                        } ;
//
//                ByteArrayResource arrayResource = new ByteArrayResource(bos.toByteArray()) {
//                    @Override
//                    public String getFilename() throws IllegalStateException {
//                        return filename;
//                    }
//                    @Override
//                    public long contentLength() {
//                        int estimate = bos.size();
//                        return estimate == 0 ? 1 : estimate;
//                    }
//
//                };
               // parts.add(basepath+File.separator+filename, resource);
//                parts.add("name", basepath);
//                parts.add("filename", filename);
               // parts.add("folder", "1");

//                headers.setContentType(MediaType.MULTIPART_FORM_DATA);
//                HttpEntity<MultiValueMap<String, Object>> files = new HttpEntity<>(parts, headers);

//               if(null!=file){
//                   parts.add("file", new FileSystemResource(file));
//               }
                //traffpictureParam.setImagedata(basepath+File.separator+filename);
              //  traffPictureService.updateTraffpicture(traffpictureParam);
//                FileUploadResultVo resultVo=new FileUploadResultVo();
                 //resultVo = restTemplate.postForObject(uploadurl, files, FileUploadResultVo.class);
                //restTemplate.put(uploadurl, files);
             //删除
//                if (file.delete()) {
//                    log.info("delete file success");
//                }

//                if(resultVo.getCode()==200){
//                    //更新地址
//                    if(resultVo.getData().size()>0) {
//                        traffpictureParam.setImagedata(resultVo.getData().get(0).getLocaluri());
//                        traffPictureService.updateTraffpicture(traffpictureParam);
//                    }
//                    return  true;
//                }

                return  true;
            }).get(timeout, TimeUnit.SECONDS);
        } catch (Exception ex) {
            log.error(" uplaod file:{}", ex.toString());
        }
    }
}