package com.cx.cn.cxquartz.service.quartz;

import com.cx.cn.cxquartz.dao.StorageServerMapper;
import com.cx.cn.cxquartz.vo.Storageserver;
import com.google.gson.Gson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

@Service
public class CacheLoadService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Value("${redis.cachekey.ftplist}")
    private String ftplistkey;

    @Autowired
    private StorageServerMapper storageServerMapper;

    public boolean loadFtpCache() {
        try {
            Storageserver server = new Storageserver();
            server.setServerstatus(0);//�����õ�
            server.setServertype("ftp");
            List<Storageserver> storageServers = storageServerMapper.queryStorageServerAll(server);
            if (!storageServers.isEmpty() && storageServers.size() > 0) {
                stringRedisTemplate.opsForValue().set(ftplistkey, new Gson().toJson(storageServers),60, TimeUnit.SECONDS);
            } else {
                System.out.println("storageServers.isEmpty");
            }
            return true;
        } catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

}
