package com.cx.cn.cxquartz.controller;


import com.alibaba.fastjson.JSONObject;
import com.cx.cn.cxquartz.bean.QuartzTaskErrors;
import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.service.quartz.FtpService;
import com.cx.cn.cxquartz.service.quartz.QuartzService;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.util.FTPUtil;
import com.cx.cn.cxquartz.util.FileTransferManager;
import com.cx.cn.cxquartz.util.ResultEnum;
import com.cx.cn.cxquartz.util.ResultUtil;
import com.cx.cn.cxquartz.vo.Ftp;
import com.cx.cn.cxquartz.vo.QuartzTaskRecordsVo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/quartz")
public class QuartzController {

    private static final Logger logger = LoggerFactory.getLogger(QuartzController.class);

    @Autowired
    private QuartzService quartzService;

    @Value("${file.getrtspbyurl}")
    private String getrtspbyurl;

    @Value("${file.rtspurl}")
    private String rtspurl;


    @Value("${ftppath}")
    private String ftppath;


    @Autowired
    private SbtdspsrService sbtdspsrService;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    FtpService ftpService;

    @RequestMapping(value = "/add/taskpage", method = RequestMethod.GET)
    public String addTaskpage() {
        return "addtask";
    }

    @ResponseBody
    @RequestMapping(value = "/add/task", method = RequestMethod.POST)
    public String addTask(QuartzTaskInformations taskInformations) {
        try {
            taskInformations.setSchedulerrule("*/" + taskInformations.getSchedulerrule() + " * * * * ?");
            String result = quartzService.addTask(taskInformations);
            return result;
        } catch (Exception e) {
            logger.error("/add/task exception={}", e);
            return ResultUtil.fail();
        }
    }

    @RequestMapping(value = "/edit/taskpage", method = RequestMethod.GET)
    public String editTaskpage(Model model, String id) {
        QuartzTaskInformations taskInformation = quartzService.getTaskById(id);
        taskInformation.setSchedulerrule(taskInformation.getSchedulerrule().replaceAll("\\?", "").replaceAll("\\*", "").replaceAll("\\/", ""));
        model.addAttribute("taskInformation", taskInformation);
        return "updatetask";
    }

    @ResponseBody
    @RequestMapping(value = "/edit/task", method = RequestMethod.POST)
    public String editTask(QuartzTaskInformations taskInformations) {
        try {
            taskInformations.setSchedulerrule("*/" + taskInformations.getSchedulerrule() + " * * * * ?");
            String result = quartzService.updateTask(taskInformations);
            if(null!=taskInformations.getExecuteparamter() && !taskInformations.getExecuteparamter().contains("rtsp:")) {
                int upresult = sbtdspsrService.updateRecogByRtsp(taskInformations.getRtsp(), taskInformations.getVideoid());

            if (upresult > 0) {
                logger.info("更新sbtddspsr  squrllj 的值为：" + taskInformations.getExecuteparamter());
            }
            }
            return result;
        } catch (Exception e) {
            logger.error("/edit/task exception={}", e);
            return ResultUtil.fail();
        }
    }

    /**
     * 启动 或者 暂定定时任务
     *
     * @param taskNo
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/list/optionjob", method = RequestMethod.GET)
    public String optionJob(String taskNo) {
        logger.info("");
        if (StringUtils.isEmpty(taskNo)) {
            return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
        }
        try {
            return quartzService.startJob(taskNo);
        } catch (Exception e) {
            logger.error("/list/optionjob exception={}", e);
            return ResultUtil.fail();
        }
    }

    /**
     * 定时任务执行情况
     *
     * @param taskNo
     * @param model
     * @return
     */
    @RequestMapping(value = "/taskrecords", method = RequestMethod.GET)
    public String taskRecordsPage(@RequestParam(value = "taskno", required = false) String taskNo, Model model) {
        logger.info("");
        try {
            if (StringUtils.isEmpty(taskNo)) {
                return "redirect:/";
            }
            List<QuartzTaskRecordsVo> quartzTaskRecords = quartzService.taskRecords(taskNo);
            model.addAttribute("quartzTaskRecords", quartzTaskRecords);
        } catch (Exception e) {
            logger.error("");
            return "redirect:/";
        }
        return "taskrecords";
    }

    /**
     * 立即运行一次定时任务
     *
     * @param taskNo
     * @param model
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/runtask/rightnow", method = RequestMethod.GET)
    public String runTaskRightNow(@RequestParam(value = "taskno", required = false) String taskNo, Model model) {
        logger.info("");
        try {
            if (StringUtils.isEmpty(taskNo)) {
                return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
            }
            return quartzService.runTaskRightNow(taskNo);
        } catch (Exception e) {
            logger.error("");
            return ResultUtil.success(ResultEnum.FAIL.getCode(), ResultEnum.FAIL.getMessage());
        }
    }

    /**
     * 定时任务失败详情
     *
     * @param recordId
     * @param model
     * @return
     */
    @RequestMapping(value = "/task/errors", method = RequestMethod.GET)
    public String detailTaskErrors(@RequestParam(value = "recordid", required = false) String recordId, Model model) {
        logger.info("");
        try {
            if (StringUtils.isEmpty(recordId)) {
                return ResultUtil.success(ResultEnum.PARAM_EMPTY.getCode(), ResultEnum.PARAM_EMPTY.getMessage());
            }
            QuartzTaskErrors taskErrors = quartzService.detailTaskErrors(recordId);
            model.addAttribute("taskErrors", taskErrors);
            return "taskerrors";
        } catch (Exception e) {
            logger.error("");
            return "redirect:/";
        }
    }

    @RequestMapping(value = "/getRtsp", method = RequestMethod.POST)
    @ResponseBody
    public String getRTSP(@RequestBody JSONObject devicecode) {
        //判断rtsp  是否过期http://212.129.142.17:8281/gh/device/test?deviceCode=3YSCA44445TFCPX
//判断是否是rtsp  地址
        String rtspValue = devicecode.getString("data");
        if (!rtspValue.contains("rtsp://")) {
            Map<String, String> map = new HashMap<>();
            map.put("deviceCode", rtspValue);
            ResponseEntity<String> responseEntity = restTemplate.getForEntity(getrtspbyurl + "?deviceCode={deviceCode}", String.class, map);
            JSONObject json = JSONObject.parseObject(responseEntity.getBody());
            if (null != json.getString("errorCode") && json.getString("errorCode").equals("0")) {
                //返回rtsp  地址，更新 sbtdspsr  地址
                json = JSONObject.parseObject(json.getString("data"));
                rtspValue = String.valueOf(json.get("rtspUri"));
            }
        }

        //获得抽帧图片
        Map maps = new HashMap<>();
        maps.put("rtspvalue", rtspValue);
        maps.put("refresh", 1);
        try {
            ResponseEntity<String> result = restTemplate.exchange(rtspurl + "?url={rtspvalue}&refresh={refresh}",
                    HttpMethod.GET, null, String.class, maps);
            JSONObject jsonresult = JSONObject.parseObject(result.getBody());
            logger.info("getRtsp:{}",jsonresult);
            if (null != jsonresult.getString("ret") && jsonresult.getString("ret").equals("0") && !"".equals(jsonresult.getString("url"))) {
                //获得图片地址,存放到ftp上面
                //将图片存储到ftp 上去，jsonresult.getString("url")
                Ftp ftp = ftpService.reloadFtp();
                String ftpfilepath=FileTransferManager.urlTransToFtp(jsonresult.getString("url"),ftp,"gstraff/picturedemo/");
                logger.info("ftppath"+ftpfilepath);
                ftpfilepath=ftpfilepath.replace("ftp://"+ftppath+"/","");
                //                return ResultUtil.success(ResultEnum.SUCCESS.getCode(), jsonresult.getString("url")+ "," + rtspValue);

                return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ftpfilepath+ "," + rtspValue);
            }
            return ResultUtil.fail();
        } catch (Exception ex) {
            logger.info(ex.toString());
            return ResultUtil.fail();
        }
    }
}
