package com.cx.cn.cxquartz.util;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class RecursiveGetJsonData {

    private static List<Object> list = new ArrayList<Object>(); //公共的的数据池
    private String rootDir;//根目录
    private List<File> jsonFileList = new ArrayList<File>();//公共的数据区域 找到的文件数据

    public List<File> getJsonFileList() {
        return jsonFileList;
    }

    public void setJsonFileList(List<File> jsonFileList) {
        this.jsonFileList = jsonFileList;
    }

    public RecursiveGetJsonData(String rootDir) {
        this.setRootDir(rootDir);
    }

    public RecursiveGetJsonData() { // 空构造方法
    }

    /**
     * rootDir 根目录
     * fileNameEndFlag  问价结尾标识
     *
     * @param rootDir
     */
    public void getDataFromFile(String rootDir, final String fileNameEndFlag) {
        File rootFile = new File(rootDir);
        FileFilter filter = new FileFilter() { //文件后缀过滤
            @Override
            public boolean accept(File file) {
                String fileName = file.getName();
                if (fileName != null && fileName != "" && fileName.endsWith(fileNameEndFlag)) {
                    return true;
                }
                return false;
            }
        };
        if (rootFile.isDirectory()) { //如果是目录
            File[] listFiles = rootFile.listFiles(filter); // 满足条件的文件装入公共数据区
            if (null != listFiles && listFiles.length > 0) {
                jsonFileList.addAll(Arrays.asList(listFiles)); //Arrays 将数组转化为List集合
            }
            File[] list = rootFile.listFiles();
            if (null != list && list.length > 0) {
                for (int i = 0; i < list.length; i++) {
                    if (list[i].isDirectory()) {
                        getDataFromFile(list[i].getAbsolutePath(), fileNameEndFlag); //递归调用方法
                    }
                }
            }
        }
    }

    public String ImageToBase64ByLocal(File file) {
        InputStream in = null;
        byte[] data = null;
        // 读取图片字节数组
        try {
            //获取图片路径
            in = new FileInputStream(file.getPath());
            data = new byte[in.available()];
            in.read(data);
            in.close();
        } catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(data);
    }


    public String getRootDir() {
        return rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public static List<Object> getList() {
        return list;
    }

    public static void setList(List<Object> list) {
        RecursiveGetJsonData.list = list;
    }


}
