package com.cx.cn.cxquartz.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static  File uploadToLocal(String path,ByteArrayOutputStream bout, String fileName) {
        logger.info("file upload :{}",path+fileName);
        DataOutputStream to=null;
        try {

            File tempFile = new File(path);
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            File file= new File(tempFile.getPath() + File.separator + fileName);

            if (!file.exists()) {
                file.createNewFile();
            }
            to=new DataOutputStream(new FileOutputStream(file));
            bout.writeTo(to);
            return file;
        } catch (IOException e) {
            logger.error(e.toString());
            e.printStackTrace();
            return null;
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return null;
        } finally {
            try {
                if(null!=bout)
                    bout.close();
                if(null!=to){
                    to.close();
                }
            } catch (IOException e) {
                logger.error(e.toString());
                e.printStackTrace();
            }
        }
    }


}
