package com.cx.cn.cxquartz.service.quartz.impl;

import com.cx.cn.cxquartz.dao.TraffPictureMapper;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.ThreadPoolUtil;
import com.cx.cn.cxquartz.vo.ResponseEnum;
import com.cx.cn.cxquartz.vo.ResultObj;
import com.cx.cn.cxquartz.vo.TraffpictureParam;
import com.cx.cn.cxquartz.vo.TraffrecordData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.SimpleDateFormat;
import java.util.concurrent.*;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author wjj
 * @since 2021-04-29
 */
@Service
public class EventWriteService {
    private static final Logger log = LoggerFactory.getLogger(EventWriteService.class);

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TraffPictureMapper   traffPictureMapper;

    @Value("${eventwrite.url}")
    private String url;

    @Value("${eventwrite.timeout}")
    private Integer timeout;


    @Value("${eventwrite.token}")
    private String qztoken;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;


    @Autowired
    TokenCacheService tokensertvice;


    private static CompletionService<ResultObj> completionService  = new ExecutorCompletionService<ResultObj>(ThreadPoolUtil.getPool());

    public void sendEvent(TraffpictureParam traffpictureParamresult,TraffrecordData sendtozhiui) {
        sendtozhiui.setAlarmnum(traffpictureParamresult.getTargetnum());
        sendtozhiui.setFdid(traffpictureParamresult.getFdid());
        sendtozhiui.setRecordtype(traffpictureParamresult.getRecordtype());
        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sendtozhiui.setRecordtime(  traffpictureParamresult.getCreatetime()==null?"": format.format(traffpictureParamresult.getCreatetime()));
        ResultObj resultObj;
        try {
            resultObj = sendMessage(sendtozhiui);
//            boolean successFlag = resultObj.getCode() == ResponseEnum.SUCCESS.getCode();
            traffpictureParamresult.setPushdesc(resultObj.getMsg());
            /* 成功 */
            if ("0".equals(resultObj.getCode())) {
                traffpictureParamresult.setPushstatus(0);
                traffpictureParamresult.setPushdesc("推送成功");
                traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
                return ;
            }
            /* 其他失败 */

        } catch (TimeoutException e) {
            traffpictureParamresult.setPushdesc("请求超时");
            log.error("eventwrite - sendEvent 请求超时:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_1008.getCode(), ResponseEnum.E_1008.getMsg());
        } catch (Exception e) {
            traffpictureParamresult.setPushdesc("请求失败");
            log.error("eventwrite - sendEvent 异常:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString());
        }
        traffpictureParamresult.setPushstatus(-1);
        traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
    }


    private ResultObj sendMessage(TraffrecordData traffalarmrecord) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String token = stringRedisTemplate.opsForValue().get(qztoken);
        if(null==token ){
            token=tokensertvice.keepAlive();
        }
        headers.add("accessToken", token);
        HttpEntity<TraffrecordData> requestEntity = new HttpEntity<>(traffalarmrecord, headers);
        return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(url, requestEntity, ResultObj.class)).get(timeout, TimeUnit.SECONDS);
    }


}
