package com.cx.cn.cxquartz.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cx.cn.cxquartz.bean.PatrolCtrlAlarm;
import com.cx.cn.cxquartz.bean.PatrolCtrlRecord;
import com.cx.cn.cxquartz.bean.PictureTime;
import com.cx.cn.cxquartz.job.WebSocket;
import com.cx.cn.cxquartz.service.quartz.*;
import com.cx.cn.cxquartz.service.quartz.impl.EventWriteService;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.concurrent.*;

@RestController
@RequestMapping("/ext")
public class ExtController {
    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);
    @Autowired
    private QuartzService quartzService;
    @Value("${file.uploadpath}")
    private String uploadpath;
    @Value("${file.alarmpath}")
    private String alarmpath;
    @Value("${file.alarmurl}")
    private String alarmurl;
    @Value("${file.recordurl}")
    private String recordurl;
    @Value("${file.rtspurl}")
    private String rtspurl;
    @Value("${file.recogurl}")
    private String recogurl;
    @Value("${file.getrtspbyurl}")
    private String getrtspbyurl;
    @Value("${file.publicpictureurl}")
    private String publicpictureurl;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SbtdspsrService sbtdspsrService;
    @Autowired
    FtpService ftpService;
    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;
    @Autowired
    TraffPictureService traffPictureService;
    @Autowired
    PedestrianService pedestrianService;
    @Autowired
    TrafficService trafficService;
    @Autowired
    FaceService faceService;
    @Value("${file.ftppath}")
    private String ftppath;
    @Autowired
    PeopleridebicycService peopleridebicycService;
    @Autowired
    WebSocket webSocket;
    @Autowired
    CodeService codeservice;
    @Autowired
    EventWriteService eventWriteService;
    RestUtil  restutil=new RestUtil();
    @RequestMapping(value = "/patrolCtrlRecord", method = RequestMethod.POST)
    public String upload(HttpServletRequest request) {
        try {
            //判断表中各监控设备id 的最新记录时间，如果为空则进行监控数据更新，不为空则获得上一次各个设备最新的截图时间
            //遍历list 从  最新的记录时间开始
            HttpSession session = request.getSession();
            int result = 0, resultSuccess = 0, alarmresultSuccess = 0;
            List<String> resultlist = new ArrayList<>();
            String[] fileParam = null;//文件名称数组
            String filename = "", fileatream = "", picturetime;//文件名拼接成的日期,图片生成时间
            SimpleDateFormat simpledate = new SimpleDateFormat("yyyyMMddHHmmss"), newsimpledate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//日期转换成特定格式
            RecursiveGetJsonData fileutil = new RecursiveGetJsonData();
            fileutil.getDataFromFile(uploadpath, "jpeg");
            List<File> jsonFile = fileutil.getJsonFileList();        //获得文件夹下所有文件信息
            List<PictureTime> picturses = quartzService.findLastPicTime();//查询各个设备最新的记录时间
            CommonUtil.removeFinishFiles(jsonFile, picturses);//去除重复文件
            List<String> deviceids = new ArrayList<>();
            for (File file : jsonFile) {
                fileParam = file.getAbsolutePath().split("\\\\");
                deviceids.add(fileParam[fileParam.length - 3]);
            }
            //查询该设备的国标码
            List<PatrolCtrlRecord> recordList = quartzService.queryCameraCode(deviceids);
            if (jsonFile.size() > 0) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add("access-token", session.getAttribute("token").toString());
                ExecutorService fixedThreadPool = Executors.newFixedThreadPool(5);
                for (File file : jsonFile) {
                    fixedThreadPool.execute(() -> {
                        String[] fileParam1 = file.getAbsolutePath().split("\\\\");
                        String filename1 = fileParam1[fileParam1.length - 2] + fileParam1[fileParam1.length - 1].replace(".jpeg", "");
                        if (null != fileParam1 && fileParam1.length > 4) {
                            String fileatream1 = fileutil.ImageToBase64ByLocal(file);
                            for (PatrolCtrlRecord record : recordList) {
                                if (record.getDeviceid().equals(fileParam1[fileParam1.length - 3])) {
                                    try {
                                        String picturetime1 = newsimpledate.format(simpledate.parse(filename1));
                                        record.setPatrolTime(picturetime1);
                                        record.setRecordSrc("2");
                                        record.setFile(fileatream1);
                                        //调用推送接口
                                        HttpEntity<String> requestEntity = new HttpEntity<>(JSONObject.toJSONString(record), headers);
                                        ResponseEntity<String> response = restTemplate.exchange(recordurl, HttpMethod.POST, requestEntity, String.class);
                                        String body = response.getBody();
                                        JSONObject json = JSONObject.parseObject(body);
                                        if (null != json.getString("status") && json.getString("status").equals("0")) {
                                            record.setFile(null);
                                            record.setPatrolTime(filename1);
                                            quartzService.insertRecord(record);
                                            logger.info("ext/patrolCtrlRecord  success-->" + file.getAbsolutePath());
                                        } else {
                                            logger.info("ext/patrolCtrlRecord  fail-->" + fileParam1[fileParam1.length - 1] + body);
                                        }
                                        PatrolCtrlAlarm alarm = new PatrolCtrlAlarm();
                                        alarm.setCameraCode(record.getCameraCode());
                                        alarm.setCameraName(record.getCameraName());
                                        alarm.setFile(fileatream1);
                                        alarm.setTime(picturetime1);
                                        alarm.setType("2");
                                        //调用告警接口
                                        ResponseEntity<String> alarmresponse = restTemplate.exchange(alarmurl, HttpMethod.POST, new HttpEntity<>(JSONObject.toJSONString(alarm), headers), String.class);
                                        JSONObject alarmjson = JSONObject.parseObject(alarmresponse.getBody());
                                        if (null != alarmjson.getString("status") && alarmjson.getString("status").equals("0")) {
                                            alarm.setFile(null);
                                            alarm.setTime(filename1);
                                            quartzService.insertAlarm(alarm);
                                            logger.info("ext/alarm  success-->" + file.getAbsolutePath());
                                        } else {
                                            logger.info("ext/alarm  fail-->" + fileParam1[fileParam1.length - 1] + alarmresponse.getBody());
                                        }
                                    } catch (Exception e) {
                                        logger.error("ext/patrolCtrlRecord-->" + e.toString());
                                    }
                                }
                            }
                        }


                    });
                    logger.info("ext/patrolCtrlRecord  success-->" + "总共" + jsonFile.size() + "张，推送成功" + resultSuccess + "张，告警成功" + alarmresultSuccess + "张");
                }


            }
            return ResultUtil.success();
        } catch (Exception e) {
            logger.error("ext/patrolCtrlRecord-->" + e.toString());
        }
        return ResultUtil.fail();
    }

    @RequestMapping(value = "/getRTSP/{photonum}", method = RequestMethod.POST)
    public String getrtsp(@RequestBody String videoid,
                          @PathVariable("photonum") Integer photonum) {
        //根据videoID查询  rtsp 值
        List<Sbtdspsr> sbtdspsrlist=sbtdspsrService.selectByRtsp(videoid);
        logger.info("sbtdspsrlist:{}",JSONObject.toJSON(sbtdspsrlist));
        if (sbtdspsrlist.size() == 0) {
            logger.info(videoid+"设备不存在");
            return  ResultUtil.success();
        }

        Sbtdspsr sbtdspsr = sbtdspsrlist.get(0);
        logger.info("sbtdspsr:{}",JSONObject.toJSON(sbtdspsr));
        //尝试抽取第一张图片
        List<String> imgUrls = new ArrayList<>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> maps = new HashMap<>();
        if(null==sbtdspsr.getSqurllj() ||"".equals(sbtdspsr.getSqurllj())){
            String rtsp=restutil.getnewRtspVlue(sbtdspsr.getSbbh(),getrtspbyurl);
            sbtdspsr.setSqurllj(rtsp);
        }
        maps.put("rtspvalue", sbtdspsr.getSqurllj());
        maps.put("refresh", 1);
        logger.info("getRTSP/1:{}",videoid);
        logger.info("rtspurl:{}",rtspurl);
        logger.info("maps:{}",JSONObject.toJSON(maps));
        HttpEntity<String> formEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<String> exchange = restTemplate.exchange(rtspurl + "?url={rtspvalue}&refresh={refresh}",
                    HttpMethod.GET, formEntity, String.class, maps);
            String body = exchange.getBody();
            logger.info("getRTSP/1->body:",body);
            if(null==body|| "".equals(body)){
                //rtsp地址可能改变，重新获取
                if(!videoid.contains("rtsp")) {
                    String rtsp =restutil.getnewRtspVlue(sbtdspsr.getSbbh(),getrtspbyurl);
                    maps.put("rtspvalue", rtsp);
                }
            }
            else{
                JSONObject json = JSONObject.parseObject(exchange.getBody());
                if (null != json.getString("ret") && json.getString("ret").equals("0")) {
                    //获得图片地址
                    imgUrls.add(json.getString("url"));
                }
            }
        }catch (Exception ex)
        {
            //rtsp地址可能改变，重新获取
            String rtsp=restutil.getnewRtspVlue(sbtdspsr.getSbbh(),getrtspbyurl);
            maps.put("rtspvalue", rtsp);
        }
        try{
            if(imgUrls.size()==0){
                logger.info("no picture data ");
                return ResultUtil.success();
            }
            //根据rtsp 进行图片获取及存储
            Map<String, Object> transferRecordMap = new HashMap<>();
            TraffAlarmRecord traffAlarmRecord = new TraffAlarmRecord();
            traffAlarmRecord.setFdid(sbtdspsr.getSbbh());
            traffAlarmRecord.setChannelid(Integer.parseInt(String.valueOf(sbtdspsr.getTdbh())));
            traffAlarmRecord.setAreaid(Long.parseLong(sbtdspsr.getXzbh()));
            int i = 0;
            if(imgUrls.size()>0) {
                i = 1;
            }
            //抽取图片
            restutil.getPicture(imgUrls, maps, formEntity,rtspurl);
            traffAlarmRecord.setCreatetime(new Date());
            traffAlarmRecord.setPushstatus(9);
            //免审
            traffAlarmRecord.setCheckstatus(9);
            //未提取特征
            traffAlarmRecord.setProcessstatus("-2");

            //存储到ftp 上去
            for (int k = 0; k < imgUrls.size(); k++) {
                TraffAlarmRecordFromImgEnum.valueOf("IMG" + k).setImg(traffAlarmRecord, imgUrls.get(k));
            }
            String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            Ftp ftp = ftpService.reloadFtp();
            //入表
            traffAlarmRecordService.inserTraffAlarmRecord(traffAlarmRecord);
            FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
            List<TransferResult> results = FileTransferManager.transferFile(transferRecordMap, ftp, basepath);
//                logger.info("缓存数据上传结果：" + results.toString());
            TraffAlarmRecord recordBak = FileTransferManager.traffAlarmRecordUrlUpdate(results);
            traffAlarmRecord.setImg1path(recordBak.getImg1path());
            traffAlarmRecord.setImg2path(recordBak.getImg2path());
            traffAlarmRecord.setImg3path(recordBak.getImg3path());
            traffAlarmRecord.setImg4path(recordBak.getImg4path());
            traffAlarmRecord.setImg5path(recordBak.getImg5path());
            traffAlarmRecord.setVideopath(recordBak.getVideopath());
            //更新图片地址
            traffAlarmRecordService.updateTraffAlarmRecordUrl(traffAlarmRecord);
            return ResultUtil.success();
        } catch(Exception e){
            logger.error("ext/getRTSPr-->error" + e.toString());
        }
        return ResultUtil.success();
    }




    /***
     * 适配算法偏移-30 的情况
     * @param taskno 设备编号
     * @return
     */
    @RequestMapping(value = "/getRecog", method = RequestMethod.POST)
    public String getRecog(@RequestBody String taskno) {
        //根据判断监控是否存在，该监控检测的事件是什么
        List<Map> mapList = sbtdspsrService.selectRecogByRtsp(taskno);
        String model ="1";
        String recordtype ="1";
        //图片框选出来的范围
        Long[] roiarray;
        String  videoid,tdmc;
        HttpHeaders headers = new HttpHeaders();
        BASE64Encoder base64Encoder = new BASE64Encoder();
        if (null != mapList && !mapList.equals("") && mapList.size()>0) {
            //获得该监控的检测业务与检测范围
            for (Map<String, Object> mapobj: mapList) {
                roiarray=new Long[4];
                videoid="";
                tdmc="";
                for (Map.Entry<String, Object> maps:mapobj.entrySet()) {
                    if("videoid".equals(maps.getKey())){
                        videoid = String.valueOf(maps.getValue());
                    }
                   else if("metatype".equals(maps.getKey())){
                        model = String.valueOf(maps.getValue());
                    }
                    else if("recordtype".equals(maps.getKey())){
                        recordtype = String.valueOf(maps.getValue());
                    }
                    else if("objectx".equals(maps.getKey())){
                        roiarray[0]=new  Long(String.valueOf(maps.getValue()));
                    }

                    else if("objecty".equals(maps.getKey())){
                        roiarray[1]=new  Long(String.valueOf(maps.getValue()));
                    }
                    else if("objectw".equals(maps.getKey())){
                        roiarray[2]=new  Long(String.valueOf(maps.getValue()));
                    }
                    else if("objecth".equals(maps.getKey())){
                        roiarray[3]=new  Long(String.valueOf(maps.getValue()));
                    }
                    else if("tdmc".equals(maps.getKey())){
                        tdmc=String.valueOf(maps.getValue());
                    }
                }

            //查询该监控下面还没有经过分析的数据
            String basepath = "gstraff/" + videoid+ "/" + DateUtils.formatCurrDayNoSign();
            Map<String, Object> map = new HashMap<>();
            map.put("sbbh", videoid);
            List<TraffAlarmRecord> traffalarmrecordlist = traffAlarmRecordService.getTraffAlarmRecordByProgress(map);
           if(traffalarmrecordlist.size()<1) {
               return ResultUtil.success();
           }

            //调用结构化服务，获得图片返回结果

            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity<String> requestEntity = null;
                if (getAlarm(model, recordtype, roiarray, tdmc, headers, base64Encoder, basepath, traffalarmrecordlist))
                    return ResultUtil.success();

            }
            return ResultUtil.success();
        }else {
            logger.info("监控不属于该范围");
        }
        //更新record 表Progress 字段，0为 未检测，-2 为检测失败，将检测
        //结果进行额外封装入表
        logger.error("rtsp 不存在-->");
        return ResultUtil.fail();
    }

    public boolean getAlarm(String model, String recordtype, Long[] roiarray, String tdmc, HttpHeaders headers, BASE64Encoder base64Encoder, String basepath, List<TraffAlarmRecord> traffalarmrecordlist) {
        HttpEntity<String> requestEntity;
        for (TraffAlarmRecord transferRecord : traffalarmrecordlist) {
            GoalStructureParam param = FileTransferManager.getGoalStructureParam(roiarray,
                    Integer.parseInt(model == null ? "1" : "".equals(model) ? "1" : model
                    ), base64Encoder, transferRecord);
            if (param.getImageList().size() < 1) {
                logger.info(" no  imagelist ");
                transferRecord.setProcessstatus("-1");
                traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
                continue;
            }
            requestEntity = new HttpEntity<>(JSONObject.toJSONString(param), headers);
            try {
                ResponseEntity<String> response = restTemplate.exchange(recogurl, HttpMethod.POST, requestEntity, String.class);
                String body = response.getBody();
                JSONObject result = JSONObject.parseObject(body);
                if (null != result.get("ret") && result.get("ret").equals("200")) {
                    //获得返回结果,根据 Metadata.type 判断是人，车，人骑车，并将详细信息入对应的表
                    List<TraffpictureParam> objectList =  JSONArray.parseArray(String.valueOf(result.get("ObjectList")), TraffpictureParam.class);
                    //获得 type,更新 recordalarm 为已分析
                    transferRecord.setProcessstatus("-1");
                    traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
                    if (objectList.size() < 1) {
                        logger.info(" no picturedata ");
                        continue;
                    }
                    TraffrecordData traffrecordData=new TraffrecordData();
                    //根据结构化统计查询是否超过密度，超过则预警
                    Code code = codeservice.selectalarmNum(recordtype);
                    roiarray[0] = roiarray[0] - 30;
                    roiarray[1] = roiarray[1] - 30;
                    roiarray[2] = roiarray[2] - 30;
                    roiarray[3] = roiarray[3] - 30;
                    //判断是否统计结构化数据
                    TraffpictureParam traffpictureParamresult = new TraffpictureParam();
                    traffpictureParamresult.setImagedata(transferRecord.getImg1path());
                    if (("6".equals(recordtype) || "2".equals(recordtype))) {
                        if (null != code && null != code.getAlarmnum() && code.getAlarmnum() < objectList.size()) {
                            setTraffpictureParam(recordtype, transferRecord, traffpictureParamresult);
                            traffpictureParamresult.setTargetnum(objectList.size());
                            //超过则预警
                            traffpictureParamresult.setRecordtype(recordtype);
                            traffPictureService.updateTraffpicture(traffpictureParamresult);
                        }
                        else{
                            return true;
                        }
                    }
//                        if ((("6".equals(recordtype) || "2".equals(recordtype))
//                                && (null != code && null != code.getAlarmnum() && code.getAlarmnum() < objectList.size()))
//                                && (!"6".equals(recordtype) && !"2".equals(recordtype))) {
                        List<ObjectBoundingBox> list = new ArrayList<>();
                        for (TraffpictureParam traffpictureParam : objectList) {
                            //根据imageid  获得  base64图片
                            JSONObject metadata = JSONObject.parseObject(String.valueOf(traffpictureParam.getMetadata()));
                            JSONObject ObjectBoundingBox = metadata.getJSONObject("ObjectBoundingBox");

                            //获得物体特征值
                            if (null == ObjectBoundingBox) {
                                list.add(new ObjectBoundingBox(metadata.getIntValue("LeftTopX") + roiarray[0].intValue(),
                                        metadata.getIntValue("LeftTopY") + roiarray[1].intValue(),
                                        metadata.getIntValue("RightBtmX") - metadata.getIntValue("LeftTopX"),
                                        metadata.getIntValue("RightBtmY") - metadata.getIntValue("LeftTopY")
                                ));
                            } else {
                                list.add(new ObjectBoundingBox(ObjectBoundingBox.getIntValue("X") + roiarray[0].intValue(),
                                        ObjectBoundingBox.getIntValue("Y") + roiarray[1].intValue(),
                                        ObjectBoundingBox.getIntValue("W"),
                                        ObjectBoundingBox.getIntValue("H")
                                ));
                            }
                            //根据对应的解析结果获得相应的数据，存放到对应的表中
                            getMetaData(recordtype, roiarray, base64Encoder, transferRecord, traffpictureParamresult, list, traffpictureParam, metadata);
                        }

                        //更新 traffpicture特征值
                        try {
                            byte[] Img = FTPUtil.getFtpPicBytes(traffpictureParamresult.getImagedata());
                            if (null != Img) {
                                ByteArrayInputStream bais = new ByteArrayInputStream(Img);
                                BufferedImage image = ImageIO.read(bais);
                                Graphics g = image.getGraphics();
                                g.setColor(Color.RED);
                                //遍历所有特征值，画到图片上
                                for (ObjectBoundingBox box : list) {
                                    if (null != box) {
                                        g.drawRect(box.getX(), box.getY(), box.getW(), box.getH());
                                    }
                                }

                                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                                ImageIO.write(image, "png", stream);
                                //上传ftp
                                Ftp ftp = ftpService.reloadFtp();
                                String filename = DateUtils.formatCurrDateNoSign() + "imgdata.png";
                                String ftputl = FTPUtil.getFtpUrl(ftp) + basepath + "/" + traffpictureParamresult.getId() + "/" + filename;
                                traffpictureParamresult.setImagedata(ftputl);
                                //base 64 图片
                                String png_base64 = base64Encoder.encode(stream.toByteArray()).trim();
                                FTPUtil.uploadFile(ftp, basepath + "/" + traffpictureParamresult.getId(), filename,png_base64 );

                            }
                        } catch (Exception ex) {
                            logger.info("base64画框异常：" + ex.toString());
                        }
                        traffPictureService.updateTraffpicture(traffpictureParamresult);
                        //推送给第三方的base64
                        traffrecordData.setImagedata(publicpictureurl+"?location="+traffpictureParamresult.getImagedata().replace("ftp://"+ftppath+"/",""));
                        //赋值推送第三方数据
                        traffrecordData.setRecordlevel(code.getAlarmlevel());
                        traffrecordData.setTargetnum(code.getMaxnum());
                        traffrecordData.setRecordname(code.getName());
                        traffrecordData.setTdmc(tdmc);
                        //推送给第三方
                        eventWriteService.sendEvent(traffpictureParamresult,traffrecordData);
                        logger.info(" send to  meili: {}",JSONObject.toJSON(traffrecordData));
                        //推送告警到前端
                        webSocket.GroupSending(JSONObject.toJSONString(traffpictureParamresult));
                    }

            } catch (Exception ex) {
                //推送失败
                transferRecord.setProcessstatus("-3");
                traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
            }
        }
        return false;
    }

    private void getMetaData(String recordtype, Long[] roiarray, BASE64Encoder base64Encoder, TraffAlarmRecord transferRecord, TraffpictureParam traffpictureParamresult, List<ObjectBoundingBox> list, TraffpictureParam traffpictureParam, JSONObject metadata) {
        if (null != metadata) {
            traffpictureParamresult.setMetatype(String.valueOf(metadata.get("Type")));
            //规定区域内出现告警对象
            if(null==traffpictureParamresult.getId()) {
                setTraffpictureParam(recordtype, transferRecord, traffpictureParamresult);
            }
            if ("1".equals(metadata.get("Type"))) {
                //规定范围内检测到人
                Pedestrian meta = JSON.toJavaObject(metadata, Pedestrian.class);
                meta.setId(traffpictureParamresult.getId());
                pedestrianService.insertpedestrian(meta);
                if (null != meta.getFaceBoundingBox()) {
                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getFaceBoundingBox().getW(),
                            meta.getFaceBoundingBox().getH()
                    ));
                }
                if (null != meta.getObjectBoundingBox()) {

                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getObjectBoundingBox().getW(),
                            meta.getObjectBoundingBox().getH()
                    ));
                }

                if (null != meta.getHeadBoundingBox()) {

                    list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getHeadBoundingBox().getW(),
                            meta.getHeadBoundingBox().getH()
                    ));
                }

                if (null != meta.getUpperBoundingBox()) {
                    list.add(new ObjectBoundingBox(meta.getUpperBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getUpperBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getUpperBoundingBox().getW(),
                            meta.getUpperBoundingBox().getH()
                    ));
                }
                if (null != meta.getLowerBoundingBox()) {
                    list.add(new ObjectBoundingBox(meta.getLowerBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getLowerBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getLowerBoundingBox().getW(),
                            meta.getLowerBoundingBox().getH()
                    ));
                }

            } else if (null != metadata && "2".equals(metadata.get("Type"))) {
                //车辆
                Traffic meta = JSON.toJavaObject(metadata, Traffic.class);
                meta.setId(traffpictureParamresult.getId());
                //新增到车辆详情表
                trafficService.insertTraffic(meta);
                if (null != meta.getObjectBoundingBox()) {

                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getObjectBoundingBox().getW(),
                            meta.getObjectBoundingBox().getH()
                    ));
                }

            } else if (null != metadata && "3".equals(metadata.get("Type"))) {
                Face meta = JSON.toJavaObject(metadata, Face.class);
                meta.setId(traffpictureParamresult.getId());
                faceService.insertFace(meta);
                if (null != meta.getFaceBoundingBox()) {
                    traffpictureParam.setObjx(meta.getFaceBoundingBox().getX() + roiarray[0].intValue());
                    traffpictureParam.setObjy(meta.getFaceBoundingBox().getY() + roiarray[1].intValue());
                    traffpictureParam.setObjw(meta.getFaceBoundingBox().getW());
                    traffpictureParam.setObjh(meta.getFaceBoundingBox().getH());
                }

                if (null != meta.getFaceBoundingBox()) {
                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getFaceBoundingBox().getW(),
                            meta.getFaceBoundingBox().getH()
                    ));
                }
                if (null != meta.getHeadBoundingBox()) {

                    list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getHeadBoundingBox().getW(),
                            meta.getHeadBoundingBox().getH()
                    ));
                }
                //人骑车
            } else if (null != metadata && "4".equals(metadata.get("Type"))) {
                PeopleRideBicyc meta = JSON.toJavaObject(metadata, PeopleRideBicyc.class);
                meta.setId(traffpictureParamresult.getId());
                peopleridebicycService.insertPeopleRideBicyc(meta);
                if (null != meta.getFaceBoundingBox()) {
                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getFaceBoundingBox().getW(),
                            meta.getFaceBoundingBox().getH()
                    ));
                }
                if (null != meta.getObjectBoundingBox()) {

                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
                            meta.getObjectBoundingBox().getW(),
                            meta.getObjectBoundingBox().getH()
                    ));
                }
            }

        }
    }

    /***
     * 原来推送
     * @param recordtype
     * @param transferRecord
     * @param traffpictureParam
     */
//    @RequestMapping(value = "/getRecog", method = RequestMethod.POST)
//    public String getRecog(@RequestBody String videoid) {
//        //根据判断监控是否存在，该监控检测的事件是什么
//        List<Map> mapList = sbtdspsrService.selectRecogByRtsp(videoid);
//        String model ="1";
//        String recordtype ="1";
//        //图片框选出来的范围
//        Long[] roiarray=new Long[4];
//
//        if (null != mapList && !mapList.equals("") && mapList.size()>0) {
//
//            //获得该监控的检测业务与检测范围
//            for (Map<String, Object> map: mapList) {
//                for (Map.Entry<String, Object> maps:map.entrySet()) {
//                    if("videoid".equals(maps.getKey())){
//                        videoid = String.valueOf(maps.getValue());
//                    }
//                    else if("metatype".equals(maps.getKey())){
//                        model = String.valueOf(maps.getValue());
//                    }
//                    else if("recordtype".equals(maps.getKey())){
//                        recordtype = String.valueOf(maps.getValue());
//                    }
//                    else if("objectx".equals(maps.getKey())){
//                        roiarray[0]=new  Long(String.valueOf(maps.getValue()));
//                    }
//
//                    else if("objecty".equals(maps.getKey())){
//                        roiarray[1]=new  Long(String.valueOf(maps.getValue()));
//                    }
//                    else if("objectw".equals(maps.getKey())){
//                        roiarray[2]=new  Long(String.valueOf(maps.getValue()));
//                    }
//                    else if("objecth".equals(maps.getKey())){
//                        roiarray[3]=new  Long(String.valueOf(maps.getValue()));
//                    }
//                }
//            }
//            //查询该监控下面还没有经过分析的数据
//            String basepath = "gstraff/" + videoid+ "/" + DateUtils.formatCurrDayNoSign();
//
//            Map<String, Object> map = new HashMap<>();
//
//            if(videoid.split("_").length<2){
//                logger.info("监控不存在");
//                return ResultUtil.success();
//            }
//
//            map.put("sbbh", videoid.split("_")[0]);
//            map.put("tdbh", videoid.split("_")[1]);
//            List<TraffAlarmRecord> traffalarmrecordlist = traffAlarmRecordService.getTraffAlarmRecordByProgress(map);
//            if(traffalarmrecordlist.size()<1) {
//                return ResultUtil.success();
//            }
//            BASE64Decoder base64Decoder = new BASE64Decoder();
//            //开启多线程
//            //调用结构化服务，获得图片返回结果
//            HttpHeaders headers = new HttpHeaders();
//            BASE64Encoder base64Encoder = new BASE64Encoder();
//            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
//            HttpEntity<String> requestEntity = null;
//            for (TraffAlarmRecord transferRecord : traffalarmrecordlist) {
//                GoalStructureParam param = FileTransferManager.getGoalStructureParam(roiarray,
//                        Integer.parseInt(model == null ? "1" : "".equals(model) ? "1" : model
//                        ), base64Encoder, transferRecord);
//                if (param.getImageList().size() < 1) {
//                    logger.info(" no  imagelist ");
//                    continue;
//                }
//                requestEntity = new HttpEntity<>(JSONObject.toJSONString(param), headers);
//                try {
//                    ResponseEntity<String> response = restTemplate.exchange(recogurl, HttpMethod.POST, requestEntity, String.class);
//
//                    String body = response.getBody();
//                    JSONObject result = JSONObject.parseObject(body);
//                    if (null != result.get("ret") && result.get("ret").equals("200")) {
//                        //获得返回结果,根据 Metadata.type 判断是人，车，人骑车，并将详细信息入对应的表
//                        List<TraffpictureParam> objectList = (List<TraffpictureParam>) JSONArray.parseArray(String.valueOf(result.get("ObjectList")), TraffpictureParam.class);
//                        //获得 type
//                        //更新 recordalarm 为一分析
//                        traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
//                        if (objectList.size() < 1) {
//                            logger.info(" no picturedata ");
//                            continue;
//                        }
//                        //根据结构化统计查询是否超过密度，超过则预警
//                        Code code = codeservice.selectalarmNum(recordtype);
//                        //判断是否统计结构化数据
//                        if (("6".equals(recordtype) || "2".equals(recordtype))) {
//                            if (null != code && null != code.getAlarmnum() && code.getAlarmnum() < objectList.size()) {
//                                TraffpictureParam traffpictureParam = new TraffpictureParam();
//                                setTraffpictureParam(recordtype, base64Encoder, transferRecord, traffpictureParam);
//                                traffpictureParam.setTargetnum(objectList.size());
//                                //超过则预警
//                                traffpictureParam.setRecordtype(recordtype);
//                                traffpictureParam.setImagedata(transferRecord.getImg1path());
//                                traffPictureService.updateTraffpicture(traffpictureParam);
//
//                                //WebSocket.GroupSending(JSONObject.toJSONString(traffpictureParam));
//                            }
//                        }
//                        //为了适配算法偏移-30问题
//
//
//                        List<ObjectBoundingBox> list=new ArrayList<>();
//                        for (TraffpictureParam traffpictureParam : objectList) {
//
//                            //根据imageid  获得  base64图片
//                            JSONObject metadata = JSONObject.parseObject(String.valueOf(traffpictureParam.getMetadata()));
//                            JSONObject ObjectBoundingBox = metadata.getJSONObject("ObjectBoundingBox");
//                            if (null == ObjectBoundingBox) {
//                                traffpictureParam.setObjx(metadata.getIntValue("LeftTopX")+ roiarray[0].intValue());
//                                traffpictureParam.setObjy(metadata.getIntValue("LeftTopY")+roiarray[1].intValue());
//                                traffpictureParam.setObjw(metadata.getIntValue("RightBtmX") - metadata.getIntValue("LeftTopX"));
//                                traffpictureParam.setObjh(metadata.getIntValue("RightBtmY") - metadata.getIntValue("LeftTopY"));
//                                list.add(new ObjectBoundingBox(metadata.getIntValue("LeftTopX")+ roiarray[0].intValue(),
//                                        metadata.getIntValue("LeftTopY")+roiarray[1].intValue(),
//                                        metadata.getIntValue("RightBtmX") - metadata.getIntValue("LeftTopX"),
//                                        metadata.getIntValue("RightBtmY") - metadata.getIntValue("LeftTopY")
//                                ));
//                            } else {
//                                traffpictureParam.setObjx(ObjectBoundingBox.getIntValue("X")+ roiarray[0].intValue());
//                                traffpictureParam.setObjy(ObjectBoundingBox.getIntValue("Y")+roiarray[1].intValue());
//                                traffpictureParam.setObjw(ObjectBoundingBox.getIntValue("W"));
//                                traffpictureParam.setObjh(ObjectBoundingBox.getIntValue("H"));
//                                list.add(new ObjectBoundingBox(ObjectBoundingBox.getIntValue("X")+ roiarray[0].intValue(),
//                                        ObjectBoundingBox.getIntValue("Y")+roiarray[1].intValue(),
//                                        ObjectBoundingBox.getIntValue("W"),
//                                        ObjectBoundingBox.getIntValue("H")
//                                ));
//                            }
//                            if (null != metadata ) {
//                                traffpictureParam.setMetatype(String.valueOf(metadata.get("Type")));
//                                //规定区域内出现告警对象
//                                setTraffpictureParam(recordtype, base64Encoder, transferRecord, traffpictureParam);
//                                if ("1".equals(metadata.get("Type"))) {
//                                    //规定范围内检测到人
//                                    Pedestrian meta = JSON.toJavaObject(metadata, Pedestrian.class);
//                                    meta.setId(traffpictureParam.getId());
//                                    pedestrianService.insertpedestrian(meta);
//                                    if(null!=meta.getFaceBoundingBox()) {
//                                        list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX()+roiarray[0].intValue(),
//                                                meta.getFaceBoundingBox().getY()+roiarray[1].intValue(),
//                                                meta.getFaceBoundingBox().getW(),
//                                                meta.getFaceBoundingBox().getH()
//                                        ));
//                                    }
//                                    if(null!=meta.getObjectBoundingBox()){
//
//                                        list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX()+roiarray[0].intValue() ,
//                                                meta.getObjectBoundingBox().getY()+roiarray[1].intValue(),
//                                                meta.getObjectBoundingBox().getW(),
//                                                meta.getObjectBoundingBox().getH()
//                                        ));
//                                    }
//
//                                    if(null!=meta.getHeadBoundingBox()){
//
//                                        list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() +roiarray[0].intValue(),
//                                                meta.getHeadBoundingBox().getY() +roiarray[1].intValue(),
//                                                meta.getHeadBoundingBox().getW(),
//                                                meta.getHeadBoundingBox().getH()
//                                        ));
//                                    }
//
//                                    if(null!=meta.getUpperBoundingBox()) {
//                                        list.add(new ObjectBoundingBox(meta.getUpperBoundingBox().getX()  +roiarray[0].intValue(),
//                                                meta.getUpperBoundingBox().getY()  +roiarray[1].intValue(),
//                                                meta.getUpperBoundingBox().getW(),
//                                                meta.getUpperBoundingBox().getH()
//                                        ));
//                                    }
//                                    if(null!=meta.getLowerBoundingBox()) {
//                                        list.add(new ObjectBoundingBox(meta.getLowerBoundingBox().getX() +roiarray[0].intValue(),
//                                                meta.getLowerBoundingBox().getY() +roiarray[1].intValue(),
//                                                meta.getLowerBoundingBox().getW(),
//                                                meta.getLowerBoundingBox().getH()
//                                        ));
//                                    }
//
//                                } else if (null != metadata && "2".equals(metadata.get("Type"))) {
//                                    //车辆
//                                    Traffic meta = JSON.toJavaObject(metadata, Traffic.class);
//                                    meta.setId(traffpictureParam.getId());
//                                    //新增到车辆详情表
//                                    trafficService.insertTraffic(meta);
//                                    if(null!=meta.getObjectBoundingBox()){
//
//                                        list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                                                meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                                                meta.getObjectBoundingBox().getW(),
//                                                meta.getObjectBoundingBox().getH()
//                                        ));
//                                    }
//
//                                } else if (null != metadata && "3".equals(metadata.get("Type"))) {
//                                    Face meta = JSON.toJavaObject(metadata, Face.class);
//                                    meta.setId(traffpictureParam.getId());
//                                    faceService.insertFace(meta);
//                                    if (null != meta.getFaceBoundingBox()) {
//                                        traffpictureParam.setObjx(meta.getFaceBoundingBox().getX()+roiarray[0].intValue());
//                                        traffpictureParam.setObjy(meta.getFaceBoundingBox().getY()+roiarray[1].intValue());
//                                        traffpictureParam.setObjw(meta.getFaceBoundingBox().getW());
//                                        traffpictureParam.setObjh(meta.getFaceBoundingBox().getH());
//                                    }
//
//                                    if(null!=meta.getFaceBoundingBox()) {
//                                        list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                                                meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                                                meta.getFaceBoundingBox().getW(),
//                                                meta.getFaceBoundingBox().getH()
//                                        ));
//                                    }
//                                    if(null!=meta.getHeadBoundingBox()){
//
//                                        list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
//                                                meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
//                                                meta.getHeadBoundingBox().getW(),
//                                                meta.getHeadBoundingBox().getH()
//                                        ));
//                                    }
//                                    //人骑车
//                                } else if (null != metadata && "4".equals(metadata.get("Type"))) {
//                                    PeopleRideBicyc meta = JSON.toJavaObject(metadata, PeopleRideBicyc.class);
//                                    meta.setId(traffpictureParam.getId());
//                                    peopleridebicycService.insertPeopleRideBicyc(meta);
//                                    if(null!=meta.getFaceBoundingBox()) {
//                                        list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                                                meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                                                meta.getFaceBoundingBox().getW(),
//                                                meta.getFaceBoundingBox().getH()
//                                        ));
//                                    }
//                                    if(null!=meta.getObjectBoundingBox()){
//
//                                        list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                                                meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                                                meta.getObjectBoundingBox().getW(),
//                                                meta.getObjectBoundingBox().getH()
//                                        ));
//                                    }
//                                }
//                                //更新 traffpicture特征值
//                                try {
//                                    ByteArrayInputStream bais = new ByteArrayInputStream(base64Decoder.decodeBuffer(traffpictureParam.getImagedata()));
//                                    BufferedImage image = ImageIO.read(bais);
//                                    Graphics g = image.getGraphics();
//                                    g.setColor(Color.RED);
//                                    for(ObjectBoundingBox box :list) {
//                                        //if (null != box.getX() && null != traffpictureParam.getObjy() && null != traffpictureParam.getObjw() && null != traffpictureParam.getObjh())
//                                        if(null!=box)
//                                            g.drawRect(box.getX(),
//                                                    box.getY(),
//                                                    box.getW(),
//                                                    box.getH());
//                                    }
//
//                                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
//                                    ImageIO.write(image, "png", stream);
//                                    //上传ftp
//                                    Ftp ftp = ftpService.reloadFtp();
//                                    String ftputl = FTPUtil.getFtpUrl(ftp) + basepath + "/" + traffpictureParam.getId() + "/imgdata.png";
//                                    traffpictureParam.setImagedata(ftputl);
//                                    FTPUtil.uploadFile(ftp, basepath + "/" + traffpictureParam.getId(), "imgdata.png", base64Encoder.encode(stream.toByteArray()));
//
//                                } catch (Exception ex) {
//                                    logger.info("base64画框异常：" + ex.toString());
//                                }
//                                traffPictureService.updateTraffpicture(traffpictureParam);
//                            }
//
//                            //推送告警
//                            WebSocket.GroupSending(JSONObject.toJSONString(traffpictureParam));
//                        }
//                    }
//                } catch (Exception ex) {
//                    //推送失败
//                    transferRecord.setProcessstatus("-3");
//                    traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
//                }
//            }
//            return ResultUtil.success();
//        } else {
//            logger.info("监控不属于该范围");
//        }
//        //更新record 表Progress 字段，0为 未检测，-2 为检测失败，将检测
//        //结果进行额外封装入表
//        logger.error("rtsp 不存在-->");
//        return ResultUtil.fail();
//    }
    private void setTraffpictureParam(String recordtype, TraffAlarmRecord transferRecord, TraffpictureParam traffpictureParam) {
        traffpictureParam.setAreaid(transferRecord.getAreaid());
        traffpictureParam.setFdid(transferRecord.getFdid());
        traffpictureParam.setRecordid(transferRecord.getRecordid());
        traffpictureParam.setChannelid(transferRecord.getChannelid());
        traffpictureParam.setCreatetime(transferRecord.getCreatetime());
        //获得imgid  对应的 base64
       // String imgftpurl = traffPictureService.queryimgpath(traffpictureParam);
     //   Ftp ftp = ftpService.reloadFtp();

//        if (null != imgftpurl && !"".equals(imgftpurl)) {
//            byte[] Img = FTPUtil.getFtpPicBytes(imgftpurl);
//            if (null != Img) {
//                traffpictureParam.setImagedata(base64Encoder.encode(Img));
//            }
//        }
        traffpictureParam.setRecordtype(recordtype);
        //新增到picture
        int id = traffPictureService.inserTraffpicture(traffpictureParam);
    }


}
