package cn.yw.nhyw.nhywjthlgl.action;

 import cn.yw.nhyw.nhywjthlgl.service.NhywjthlglService;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.FTPUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("nhywjthlglAction")
public class NhywjthlglAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywjthlglAction.class);
	
	@Autowired
	private NhywjthlglService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywjthlglByPage")
	public void listNhywjthlglByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywjthlglByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-listNhywjthlglByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	/*
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywjthlgl")
	public void count_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywjthlgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-count_Nhywjthlgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ѯ Nhywjthlgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywjthlgl")
	public void query_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_AllNhywjthlgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-query_Nhywjthlgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һNhywjthlgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywjthlgl")
	public void get_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywjthlgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglActionquery_Nhywjthlgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteNhywjthlgl")
	public void delete_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				String zpUrl = (String) map.get("sjzp");
				if(RHUtil.isNotEmpty(zpUrl) && !"null".equals(zpUrl)) {
					FTPUtil.deleteFileFromFtpUrl(zpUrl);
				}
				int result = service.delete_Nhywjthlgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-delete_Nhywjthlgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywjthlgl")
	public void insert_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjthlgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywjthlgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywjthlgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-insert_Nhywjthlgl()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywjthlgl")
	public void update_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjthlgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Nhywjthlgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Nhywjthlgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-update_Nhywjthlgl-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ޸ľγ
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateJthlJdWdByXh")
	public void updateJthlJdWdByXh() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjthlgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.updateJthlJdWdByXh(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.updateJthlJdWdByXh(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-updateJthlJdWdByXh-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywjthlgl")
	public void batch_delete_Nhywjthlgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywjthlgl(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-batch_delete_Nhywjthlgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywjthlgl")
	public void exp_Nhywjthlgl(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywjthlgl(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ͨ-"+dateTime);
			params.put("sheetName", "ͨ");
			params.put("header", "ͨ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjthlglAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywjthlgl")
	public String imp_Nhywjthlgl(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("NhywjthlglAction-imp_Nhywjthlgl-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
