package cn.im.che.service;

 import cn.im.che.dao.CllkxxDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("cllkxxService")
public class CllkxxService extends BaseService {
	
	private static Log log = LogFactory.getLog(CllkxxService.class);
	
	@Autowired
	private CllkxxDao cllkxxDao;
	
	/**
	 * ¼
	 */
	public void insert_Cllkxx(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		cllkxxDao.insert_Cllkxx(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Cllkxx(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return cllkxxDao.update_Cllkxx(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Cllkxx(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return cllkxxDao.delete_Cllkxx(map);
	}

	/**
	 * Cllkxx ҳ
	 */
	public Map listCllkxxByPage(Map map) throws SQLException {
		List<Map> list = cllkxxDao.query_Cllkxx(map);
		Integer totalCount = cllkxxDao.count_Cllkxx(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
