package cn.amq.business;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import cn.amq.basis.AmqConst;
import cn.amq.peas.SafetyHatAlarmHolder;
import cn.amq.peas.VideoTaskAlarmHolder;
import cn.base.conf.Amq;
import cn.base.conf.ModuleConfFactory;

public class AmqMainPoint {
	static Logger logger = Logger.getLogger(AmqMainPoint.class);
	static public AmqPublishJob publishJob=null;
	public static void initAmq(){
		Amq activeMq = ModuleConfFactory.getInstance().getAmq();
    	String amqUrl= activeMq.getType()+"://"+activeMq.getHost()+":"+activeMq.getPort();
        publishJob = new AmqPublishJob();
        publishJob.setAmqServerUrl(amqUrl);
        publishJob.start();
        
        List<String> subscribleSubjectList=new LinkedList<String>();  
        //ȫñ澯
	    subscribleSubjectList.add(AmqConst.AMQ_SUBJECT_safetyHatAlarm);
	    //Ѳ澯
	    subscribleSubjectList.add(AmqConst.AMQ_SUBJECT_videoTaskAlarm);
	    
	    
	    AmqSubscribleJob amqSubscribleDispatchJob=new AmqSubscribleJob(amqUrl,subscribleSubjectList);
	    //հȫñ澯amq
	    amqSubscribleDispatchJob.injectClassTagName(AmqConst.AMQ_MSG_safetyHatAlarm, SafetyHatAlarmHolder.class);
	    //Ѳ澯
	    amqSubscribleDispatchJob.injectClassTagName(AmqConst.AMQ_MSG_videoTaskAlarm, VideoTaskAlarmHolder.class);
	    
	    
	    amqSubscribleDispatchJob.start();
	    
	    logger.info("**************Start amq subscribleSubjectList ... ...[OK]");
	} 
}
