/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    public static Hashtable parseQueryString(String string) {
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string3 = HttpUtils.parseName(string2.substring(0, n), stringBuffer);
            String string4 = HttpUtils.parseName(string2.substring(n + 1, string2.length()), stringBuffer);
            if (hashtable.containsKey(string3)) {
                String[] stringArray2 = (String[])hashtable.get(string3);
                stringArray = new String[stringArray2.length + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[i] = stringArray2[i];
                }
                stringArray[stringArray2.length] = string4;
            } else {
                stringArray = new String[]{string4};
            }
            hashtable.put(string3, stringArray);
        }
        return hashtable;
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream) {
        if (n <= 0) {
            return new Hashtable();
        }
        if (servletInputStream == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n];
        try {
            int n2;
            int n3 = 0;
            do {
                if ((n2 = servletInputStream.read(byArray, n3, n - n3)) > 0) continue;
                String string = lStrings.getString("err.io.short_read");
                throw new IllegalArgumentException(string);
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        try {
            String string = new String(byArray, 0, n, "8859_1");
            return HttpUtils.parseQueryString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(i);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        String string2 = httpServletRequest.getRequestURI();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }
}

