package cn.map.alarmmap.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.util.IOUtils;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("alarmMapAction")
public class AlarmMapAction {
	
	private static Log logger = LogFactory.getLog(AlarmMapAction.class);
	private static final String ENCODING = "gbk";
	
	@OperateType(value=LogConstants.LOG_QUERY ,info ="readAlarmMapConfig")
	public void readAlarmMapConfig(){
		StringBuilder builder = new StringBuilder();
		InputStreamReader read = null;
		BufferedReader bufferedReader = null;
		try{
			File file = new File(AlarmMapAction.class.getResource("/").getFile()+"/alarmMap/mainConfig.json");
			if (file.isFile() && file.exists()) {
				read = new InputStreamReader(new FileInputStream(file), ENCODING);
				bufferedReader = new BufferedReader(read);
				String lineTxt = null;
				while ((lineTxt = bufferedReader.readLine()) != null) {
					builder.append(lineTxt.trim());
				}
			}
			Struts2Utils.renderJson(builder.toString());
		}catch(Exception e){
			e.printStackTrace();
			logger.error("AlarmMapAction - readAlarmMapConfig() : error === " +e);
			Struts2Utils.renderJson(null);
		}finally {
			try {
				IOUtils.close(bufferedReader, read);
			} catch (Exception ex) {
			}
		}
	}
}
