package cn.bsystem.ptuserrole.service;

 import cn.bsystem.ptuserrole.dao.PtyhhmdlDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("ptyhhmdlService")
public class PtyhhmdlService extends BaseService {
	
	private static Log log = LogFactory.getLog(PtyhhmdlService.class);
	
	@Autowired
	private PtyhhmdlDao ptyhhmdlDao;
	
	/**
	 * ¼
	 */
	public void insert_Ptyhhmdl(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhhmdlDao.insert_Ptyhhmdl(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Ptyhhmdl(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptyhhmdlDao.update_Ptyhhmdl(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Ptyhhmdl(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptyhhmdlDao.delete_Ptyhhmdl(map);
	}

	/**
	 * Ptyhhmdl ҳ
	 */
	public Map listPtyhhmdlByPage(Map map) throws SQLException {
		List<Map> list = ptyhhmdlDao.query_Ptyhhmdl(map);
		Integer totalCount = ptyhhmdlDao.count_Ptyhhmdl(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
