package cn.im.trafficplan.action;

 import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.im.trafficplan.service.TrafficplanlinkagedeviceService;

@SuppressWarnings({"all"})
@Component("trafficplanlinkagedeviceAction")
public class TrafficplanlinkagedeviceAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficplanlinkagedeviceAction.class);
	
	@Autowired
	private TrafficplanlinkagedeviceService service;
	
	
	/**
	 * ѯʼ豸
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getlinkageDeviceOrigin")
	public void getlinkageDeviceOrigin(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.getlinkageDeviceOrigin(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanlinkagedeviceAction-getlinkageDeviceOrigin-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficplanlinkagedeviceByPage")
	public void listTrafficplanlinkagedeviceByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficplanlinkagedeviceByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanlinkagedeviceAction-listTrafficplanlinkagedeviceByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_Trafficplanlinkagedevice")
	public void delete_Trafficplanlinkagedevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Trafficplanlinkagedevice(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanlinkagedeviceAction-delete_Trafficplanlinkagedevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficplanlinkagedevice")
	public void insert_Trafficplanlinkagedevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("linkageID"))){
				map.put("linkageID",StringUtil.getUUID());
			}
			service.insert_Trafficplanlinkagedevice(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanlinkagedeviceAction-listTrafficplanlinkagedeviceByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficplanlinkagedevice")
	public void update_Trafficplanlinkagedevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Trafficplanlinkagedevice(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanlinkagedeviceAction-update_Trafficplanlinkagedevice-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Trafficplanlinkagedevice")
	public void query_Trafficplanlinkagedevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.query_Trafficplanlinkagedevice(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanlinkagedeviceAction-query_Trafficplanlinkagedevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}
