package cn.yw.archive.companymanage.service;

 import cn.yw.archive.companymanage.dao.YwarchivecompanyDao;
import cn.yw.archive.companymanage.dao.YwarchivecompanypersonDao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;

@Service("ywarchivecompanyService")
public class YwarchivecompanyService extends BaseService {
	
	private static Log log = LogFactory.getLog(YwarchivecompanyService.class);
	
	@Autowired
	private YwarchivecompanyDao ywarchivecompanyDao;

	@Autowired
	private YwarchivecompanypersonDao ywarchivecompanypersonDao;
	
	/**
	 * ¼
	 */
	public void insert_Ywarchivecompany(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywarchivecompanyDao.insert_Ywarchivecompany(map);
	}

	/**
	 * ޸ļ¼
	 */
	public Integer update_Ywarchivecompany(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		Map stMap = new HashMap();
		stMap.put("companyid", map.get("XGTJcompanyid"));
		List<Map> ls = ywarchivecompanypersonDao.query_Ywarchivecompanyperson(stMap);
		if(!StringUtil.checkEmpty(ls)||ls.size()>0){
			for (Map maps : ls) {
				stMap.put("XGTJpersonid", maps.get("personid"));
				stMap.put("companyname", map.get("companyname"));
				ywarchivecompanypersonDao.update_Ywarchivecompanyperson(stMap);
			}
		}
		return ywarchivecompanyDao.update_Ywarchivecompany(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Ywarchivecompany(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		Map stMap = new HashMap();
		stMap.put("companyid", map.get("companyid"));
		stMap.put("companyname", map.get("companyname"));
		List<Map> ls = ywarchivecompanypersonDao.query_Ywarchivecompanyperson(stMap);
		if(!StringUtil.checkEmpty(ls)||ls.size()>0){
			for (Map maps : ls) {
				ywarchivecompanypersonDao.delete_Ywarchivecompanyperson(stMap);
			}
		}
		return ywarchivecompanyDao.delete_Ywarchivecompany(map);
	}
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer batch_delete_Ywarchivecompany(Map map) throws SQLException{
		return ywarchivecompanyDao.batch_delete_Ywarchivecompany(map);
	}
	*/
	
	/**
	 * ѯ
	 */
	public Integer count_Ywarchivecompany(Map map) throws SQLException{
		return ywarchivecompanyDao.count_Ywarchivecompany(map);
	}
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Ywarchivecompany(Map map) throws SQLException{
		return ywarchivecompanyDao.query_Ywarchivecompany(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	/*
	public Map get_Ywarchivecompany(Map map) throws SQLException{
		return ywarchivecompanyDao.get_Ywarchivecompany(map);
	}
	*/
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwarchivecompany(Map map) throws SQLException{
		return this.listYwarchivecompanyByPage(map);
	}
	*/
	
	/**
	 * Ywarchivecompany ҳ
	 */
	public Map listYwarchivecompanyByPage(Map map) throws SQLException {
		List<Map> list = ywarchivecompanyDao.query_Ywarchivecompany(map);
		Integer totalCount = ywarchivecompanyDao.count_Ywarchivecompany(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
