package cn.bsystem.ptuserrole.action;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptmenu.util.MenuXml;
import cn.bsystem.ptuserrole.service.PtyhcdjsService;

@SuppressWarnings({"all"})
@Component("ptyhcdjsAction")
public class PtyhcdjsAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtyhcdjsAction.class);
	
	@Autowired
	private PtyhcdjsService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyhcdjsByPage")
	public String listPtyhcdjsByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listPtyhcdjsByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - listPtyhcdjsByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
		return null;
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptyhcdjs")
	public void count_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptyhcdjs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - count_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptyhcdjs
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptyhcdjs")
	public void query_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptyhcdjs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - query_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һPtyhcdjs
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptyhcdjs")
	public void get_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptyhcdjs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - query_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtyhcdjs")
	public void delete_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptyhcdjs(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - delete_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptyhcdjs")
	public void insert_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			service.insert_Ptyhcdjs(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - listPtyhcdjsByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyhcdjs")
	public void update_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptyhcdjs(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - update_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptyhcdjs")
	public void batch_delete_Ptyhcdjs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptyhcdjs(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - batch_delete_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ query_ptyh_alreadyIn
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_ptyh_alreadyIn")
	public void query_ptyh_alreadyIn(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			int limit =  start+rows ;
			map.put("start",start );
			map.put("limit",limit );
			Struts2Utils.renderJson(this.service.query_ptyh_alreadyIn(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - query_ptyh_alreadyIn() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ query_ptyh_alreadyOut
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_ptyh_alreadyOut")
	public void query_ptyh_alreadyOut(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			int limit =  start+rows ;
			map.put("start",start );
			map.put("limit",limit );
			Struts2Utils.renderJson(this.service.query_ptyh_alreadyOut(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - query_ptyh_alreadyOut() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insertPtyhcdjsByjsbh")
	public void insertPtyhcdjsByjsbh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("xh", StringUtil.getUUID());
			map.put("ssxm", MenuXml.getInstance().getMenuType());
			service.insertPtyhcdjsByjsbh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - insertPtyhcdjsByjsbh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="deletePtyhcdjsByjsbh")
	public void deletePtyhcdjsByjsbh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			service.deletePtyhcdjsByjsbh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhcdjsAction - deletePtyhcdjsByjsbh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
}
