package cn.map.szmap.schedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;

import cn.base.bean.BeanHelper;
import cn.im.che.dao.CllkxxDao;
import cn.im.che.dao.ClxxgpsDao;
import cn.map.szmap.LayerConstant;
import cn.map.szmap.cache.CacheManager;

import com.google.gxp.com.google.common.collect.Maps;

@SuppressWarnings("all")
class CacheRefreshThread extends Thread {
	static Logger logger = Logger.getLogger(CacheRefreshThread.class);
	static boolean shutdown = false;
	protected int jobInterval = 300 ;
	protected final Long layerSeq;
	protected final String layerName;
	
	public CacheRefreshThread(Long seq,String layerName){
		this.layerSeq = seq ;
		this.layerName = layerName ;
	}
	
	public CacheRefreshThread(Long seq,String layerName,int jobInterval){
			this(seq,layerName);
			this.jobInterval = jobInterval ;
	}
	
	@Override
	public void run(){
		
		while(!shutdown){
			List list = null;
			Map condition = Maps.newHashBiMap();
			System.out.println("this.layerSeq:" +this.layerSeq);
			if(this.layerSeq == LayerConstant.LAYER_TYPE_MONITOR){
				cn.ice.autoDef.SbtdspsrEntityArrayHolder holder = new  cn.ice.autoDef.SbtdspsrEntityArrayHolder();
				int loginret = BeanHelper.getIcxDacClient().getDacServicePrx().queryVideoInChannelArray(condition, holder);
				Date d2  = new Date();
				logger.info("getChannelListFromSystem from dac ice Ret="+loginret+" size="+holder.value.length);
				list = new ArrayList();
				for(int i=0;i<holder.value.length;i++){
		 			/*
		 			if(i == 0){
		 				map.put("total", holder.value[i].kz1); //dacչб
		 			}
		 			*/
		 			Map mm = new HashMap();
		 			mm.put("xh",holder.value[i].xh);
		 			mm.put("id",holder.value[i].xh);
		 			mm.put("name",holder.value[i].tdmc);
		 			mm.put("pid",holder.value[i].xzbh);
		 			mm.put("jdpx",holder.value[i].jdpx);
		 			mm.put("sbbh",holder.value[i].sbbh);	 			
		 			mm.put("tdbh",holder.value[i].tdbh);
		 			mm.put("tdmc",holder.value[i].tdmc);
		 			mm.put("tdmcpy",holder.value[i].tdmcpy);
		 			mm.put("xzbh",holder.value[i].xzbh);
		 			mm.put("ggbh",holder.value[i].ggbh);
		 			mm.put("dqx",holder.value[i].dqx);
		 			mm.put("xqx",holder.value[i].xqx);
		 			mm.put("pqx",holder.value[i].pqx);
		 			mm.put("kqx",holder.value[i].kqx);
		 			mm.put("lxxzqx",holder.value[i].lxxzqx);
		 			mm.put("tdzt",holder.value[i].tdzt);
		 			mm.put("jd",holder.value[i].jd);
		 			mm.put("wd",holder.value[i].wd);
		 			mm.put("sfzx",holder.value[i].sfzx);
		 			mm.put("lxzt",holder.value[i].lxzt);
		 			mm.put("tdlx",holder.value[i].tdlx);
		 			mm.put("nodeOrder",holder.value[i].jdpx);
		 			mm.put("sj",holder.value[i].sj);
		 			list.add(mm);
		 		}
				CacheManager.getIntance().putDataInCache((long)layerSeq ,list);
			}
			else if(this.layerSeq == LayerConstant.LAYER_TYPE_MONITORLOCATION){
				try {
					CllkxxDao cllkxxDao = (CllkxxDao)BeanHelper.getBean("cllkxxDao");
					list = new ArrayList();
					list = cllkxxDao.query_Cllkxx(condition);
					CacheManager.getIntance().putDataInCache((long)layerSeq ,list );
				} catch (Exception e) {
					e.printStackTrace();
					logger.error("CacheRefreshThread cllkxxDao query_Cllkxx error :"+layerSeq, e);
				}
			}
			else if(this.layerSeq == LayerConstant.LAYER_TYPE_CHEGPS){
				try {
					ClxxgpsDao clxxgpsDao = (ClxxgpsDao)BeanHelper.getBean("clxxgpsDao");
					list = new ArrayList();
					list = clxxgpsDao.query_Clxxgps(condition);
					CacheManager.getIntance().putDataInCache((long)layerSeq ,list );
				} catch (Exception e) {
					e.printStackTrace();
					logger.error("CacheRefreshThread clxxgpsDao query_Clxxgps error :"+layerSeq, e);
				}
			}
			else{
				logger.error("CacheRefreshThread refresh unknown layerseq:"+this.layerSeq);
			}			
			try {
				TimeUnit.SECONDS.sleep(jobInterval + new Random().nextInt(jobInterval/2));
			} catch (Exception e) {
				e.printStackTrace();
				logger.error("CacheRefreshThread refresh error :"+layerSeq, e);
			}
			
		}
		
	}
	
}