package cn.base.conf;
import java.io.File;

import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
public class ModuleConfManager {
	
    static private final Logger logger = Logger.getLogger(ModuleConfManager.class);
    private static ModuleConfManager moduleConfManager = new ModuleConfManager();
	public static ModuleConfManager getInstance() {
		return moduleConfManager;
	}
	private void addObjectRule(Digester digester, String nodeName,Class classObject) {
		digester.addObjectCreate("imp/"+nodeName, classObject);
		digester.addSetProperties("imp/"+nodeName);
		//öջ͵ڶջ(parent)֮Ĺϵ
		digester.addSetNext("imp/"+nodeName, "set"+ nodeName.substring(0, 1).toUpperCase()+nodeName.substring(1)); 
		digester.addObjectCreate("imp/"+nodeName+"/node", Node.class);
		digester.addSetProperties("imp/"+nodeName+"/node");
		digester.addSetNext("imp/"+nodeName+"/node", "addNode");
	}
	private void addObjectRule2(Digester digester, String nodeName,Class classObject) {
		digester.addObjectCreate("moduleProps/"+nodeName, classObject);
		digester.addSetProperties("moduleProps/"+nodeName);
		//öջ͵ڶջ(parent)֮Ĺϵ
		digester.addSetNext("moduleProps/"+nodeName, "set"+ nodeName.substring(0, 1).toUpperCase()+nodeName.substring(1)); 
		digester.addObjectCreate("moduleProps/"+nodeName+"/node", Node.class);
		digester.addSetProperties("moduleProps/"+nodeName+"/node");
		digester.addSetNext("moduleProps/"+nodeName+"/node", "addNode");
	}
	
	public ModuleConfFactory parseAppXml(String xmlPath,ModuleConfFactory props) {
		String path = ModuleConfManager.class.getResource("/").getFile()+xmlPath;
		if(xmlPath.contains(":"))path=xmlPath;  //windows ·
		if(xmlPath.charAt(0)=='/')path=xmlPath; //linux ·
		if(xmlPath.startsWith("\\")==true)path=xmlPath; //繲·
		
		logger.debug("parseAppXml:xmlPath="+xmlPath);
		File file = new File(path);
		//
		Digester digester = new Digester();
		digester.push(props);
		// add rules򷽷
		addObjectRule(digester, "scatter", Scatter.class);
		addObjectRule(digester, "ice", Ice.class);	
		addObjectRule(digester, "db", Db.class);
		addObjectRule(digester, "amq", Amq.class);
		addObjectRule(digester, "oracleDB", OracleDB.class);	
		addObjectRule(digester, "es", Es.class);	
		addObjectRule(digester, "email", Email.class);	
		addObjectRule(digester, "dac", Dac.class);	
		addObjectRule(digester, "ditu", Ditu.class);
		addObjectRule(digester, "ftps", Ftps.class);
		addObjectRule(digester, "ftp", Ftp.class);
		addObjectRule(digester, "webrtc", Webrtc.class);	
		addObjectRule(digester, "traffAccident", TraffAccident.class);
		addObjectRule(digester, "impagent", Impagent.class);
		addObjectRule(digester, "roadDirection", RoadDirection.class);
		addObjectRule(digester, "ywsoftware", Ywsoftware.class);
		addObjectRule(digester, "ywDp", YwDp.class);
		addObjectRule(digester, "videoTaskAlarm", VideoTaskAlarm.class);
		addObjectRule(digester, "ywPatrol", YwPatrol.class);
		try {
			props = (ModuleConfFactory) digester.parse(file);
			props.init();
		} catch (Exception e) {
			logger.error("ļ:"+path+":,ļǷȷ!",e);
		}
		return props;
	}
}
