package cn.amq.traffic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.business.AmqMainPoint;
import cn.amq.peas.TrafficEventAlarmHolder;
import cn.amq.peas.TrafficEventAlarmPeas;
import cn.base.bean.BeanHelper;
import cn.base.util.DateUtil;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.im.trafficalarm.model.TrafficaccidentinfoBean;
/**
 * ͽͨ澯¼Ϣamq
 * ڷͽͨ澯¼Ϣamq
 * */
public class AmqTrafficEventAlarmService {

static Logger logger = Logger.getLogger(AmqTrafficEventAlarmService.class);
	
	/**
	 *    ͨ澯¼ Ϣ AMQ
	 *
	 * * return msg 0AMQʧܣ1AMQͳɹ
	 * 
	 * */
	public String publishTrafficEventAlarmAction(String gjxh,String gjsj,String sbbh,String sbmc,String tdbh,String sjlx,String sjdj,String jcfx,String mblx,String ruleNum,String tpurllj,String bz) {
		String msg = "1";
		//step1ͨ澯¼ ϢAMQ
		try {
			TrafficEventAlarmHolder holder = new TrafficEventAlarmHolder();
			List<TrafficEventAlarmPeas> list = new ArrayList<TrafficEventAlarmPeas>();
			TrafficEventAlarmPeas action = new TrafficEventAlarmPeas();
			action.setGjxh(gjxh);
			action.setGjsj(gjsj);
			action.setSbbh(sbbh);
			action.setSbmc(sbmc);
			int i_tdbh = 0;
			try {
				i_tdbh = Integer.parseInt(tdbh);
			}catch(Exception ex) {
				i_tdbh = 0;
			}
			action.setTdbh(i_tdbh);
			action.setSjlx(sjlx);
			action.setSjdj(sjdj);
			action.setJcfx(jcfx);
			action.setMblx(mblx);
			action.setRuleNum(ruleNum);
			action.setTpurllj(tpurllj);
			action.setBz(bz);
			list.add(action);
			holder.setList(list);
			AmqMainPoint.publishJob.publishGeneralEvent(holder, AmqConst.AMQ_SUBJECT_trafficEventAlarm);//ʹǽAMQϢ
			logger.info("******AMQϢ******ͨ澯¼AMQΪ¼ţ"+gjxh+"豸ţ"+sbbh+"ͨţ"+tdbh);
		}catch(Exception e) {
			e.printStackTrace();
			msg = "0";
			logger.error("******AMQϢerror******ͨ澯¼AMQ쳣Ϊ¼ţ"+gjxh+"豸ţ"+sbbh+"ͨţ"+tdbh);
		}
		return msg;
	}
	
	/**
	 * ȡ ͬͨ澯¼AMQϢ<br>
	 * ȡϢ1յд뽻ͨ澯¼ϢУ
	 * 			   2յݼTrafficEventAlarmStateDataServiceС
	 * return msg 0дʧܣ1дɹ
	 * @author 
	 * @since 2018-01-11
	 * 
	 */
	public void doTrafficEventAlarmAction(AmqBasisEvent amqBasisMsg) {
		TrafficEventAlarmHolder entity = (TrafficEventAlarmHolder)amqBasisMsg;
		List<TrafficEventAlarmPeas> list = entity.getList();
		try {
			/**
			 * step1յľд澯¼
			*/
			logger.debug("******ȡAMQϢ******ͨ澯¼ϢAMQո澯¼Ϊ"+list.size());
			List list_alarm = new ArrayList();
			TrafficaccidentinfoBean alarmBean = null;
			for (TrafficEventAlarmPeas trafficPeasBean : list) {
				alarmBean = new TrafficaccidentinfoBean();
				alarmBean.setAccidentId(trafficPeasBean.getGjxh());
				alarmBean.setAccidentState("1");
				alarmBean.setDirection(trafficPeasBean.getJcfx());
				alarmBean.setEventType(trafficPeasBean.getSjlx());
				alarmBean.setOccurTime(trafficPeasBean.getGjsj());
				alarmBean.setAlarmLevel(trafficPeasBean.getSjdj());
				alarmBean.setEventBigUrl(trafficPeasBean.getTpurllj());
				alarmBean.setVdId(trafficPeasBean.getSbbh());
				alarmBean.setChannelId(String.valueOf(trafficPeasBean.getTdbh()));
				alarmBean.setDeviceId(trafficPeasBean.getBz());
				list_alarm.add(alarmBean);
			}
			//amq澯Ϣջ
			BeanHelper.getTrafficEventAlarmStateDataService().setTrafficEventAlarmStateListAdd(list_alarm);
			// Ӧֵ
			BeanHelper.getAlarm2AlarmWorkTableService().setAlarm2AlarmWorkTableDataListListAdd(list_alarm);
			
			//   ҳʹ
			BeanHelper.getTrafficAlarmStateDataService().setTrafficAlarmStateListAdd(list_alarm);
			
			logger.debug("******ȡAMQϢ******ͬԤ֪ͨAMQִɣ");
		}catch(Exception e) {
			e.printStackTrace();
		}
	}
	
}
