package cn.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MD5Util {
	private static Log LOG = LogFactory.getLog(MD5Util.class);
	static MessageDigest md = null;
	static {
		try {
			md = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException ne) {
			LOG.error("NoSuchAlgorithmException: md5", ne);
		}
	}

	/**
	 * һļmd5ֵ
	 * 
	 * @param f
	 *            Ҫmd5ֵļ
	 * @return md5
	 */
	public static String md5(File f) {
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(f);
			byte[] buffer = new byte[8192];
			int length;
			while ((length = fis.read(buffer)) != -1) {
				md.update(buffer, 0, length);
			}
			return new String(Hex.encodeHex(md.digest()));
		} catch (FileNotFoundException e) {
			LOG.error("md5 file " + f.getAbsolutePath() + " failed:"
					+ e.getMessage());
			return null;
		} catch (IOException e) {
			LOG.error("md5 file " + f.getAbsolutePath() + " failed:"
					+ e.getMessage());
			return null;
		} finally {
			try {
				if (fis != null) {
					fis.close();
				}
			} catch (IOException ex) {
				LOG.error("ļʧ", ex);
			}
		}
	}

	/**
	 * һַmd5ֵ
	 * 
	 * @param target
	 *            ַ
	 * @return md5 value
	 */
	public static String md5(String target) {
		return DigestUtils.md5Hex(target);
	}

	private static String digest = "";

	private static String dumpBytes(byte[] bytes) {
		int i;
		StringBuffer sb = new StringBuffer();
		for (i = 0; i < bytes.length; i++) {
			if (i % 32 == 0 && i != 0) {
				sb.append("\n");
			}
			String s = Integer.toHexString(bytes[i]);
			if (s.length() < 2) {
				s = "0" + s;
			}
			if (s.length() > 2) {
				s = s.substring(s.length() - 2);
			}
			sb.append(s);
		}
		return sb.toString();
	}

	public static String MD5Encode(String origin) {
		String digestAndOrigin = origin + digest;
		String resultString = null;
		try {
			resultString = new String(digestAndOrigin);
			MessageDigest md = MessageDigest.getInstance("MD5");
			resultString = dumpBytes(md.digest(resultString.getBytes()));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return resultString;
	}

	/**
	 * ԱȽļǷ
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		System.err.println(MD5Encode("123456"));
		File newFile = new File("D:/files/paoding-analysis.jar.new");
		File oldFile = new File("D:/files/paoding-analysis.jar.old");
		String s1 = md5(newFile);
		String s2 = md5(oldFile);
		System.out.println(s1.equals(s2));
		System.out.println(s1);
		System.out.println(s2);
	}
}