package cn.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Random;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * 
 * 
 * 
 * @version
 */
@SuppressWarnings("all")
public class FileUtils {

	/**
	 * ɾļ
	 * 
	 * @param filePathAndName
	 *            String ļ· c:/fqf.txt
	 * @param fileContent
	 *            String
	 * @return boolean
	 */
	public static boolean delFile(String filePathAndName) {
		File myDelFile = new java.io.File(filePathAndName);
		if (!myDelFile.exists()) {
			return true;
		}
		return myDelFile.delete();
	}

	/**
	 * ɾָļ·ļļ
	 * 
	 * @param file
	 */
	public static boolean delFiles(File file) {
		boolean flag = false;
		try {
			if (file.exists()) {
				if (file.isDirectory()) {
					String[] contents = file.list();
					for (int i = 0; i < contents.length; i++) {
						File file2X = new File(file.getAbsolutePath() + "/" + contents[i]);
						if (file2X.exists()) {
							if (file2X.isFile()) {
								flag = file2X.delete();
							} else if (file2X.isDirectory()) {
								delFiles(file2X);
							}
						} else {
							throw new RuntimeException("File not exist!");
						}
					}
				}
				flag = file.delete();
			} else {
				throw new RuntimeException("File not exist!");
			}
		} catch (Exception e) {
			flag = false;
			e.printStackTrace();
		}
		return flag;
	}

	/**
	 * жļǷѾڣں(n)ʽµļ򷵻ԭʼļ 磺Ѿļ log4j.htm
	 * 򷵻log4j(1).htm
	 * 
	 * @param fileName
	 *            ļ
	 * @param dir
	 *            жϵļ·
	 * @return жϺļ
	 */
	public static String checkFileName(String fileName, String dir) {
		boolean isDirectory = new File(dir + fileName).isDirectory();
		if (FileUtils.isFileExist(fileName, dir)) {
			int index = fileName.lastIndexOf(".");
			StringBuffer newFileName = new StringBuffer();
			String name = isDirectory ? fileName : fileName.substring(0, index);
			String extendName = isDirectory ? "" : fileName.substring(index);
			int nameNum = 1;
			while (true) {
				newFileName.append(name).append("(").append(nameNum).append(")");
				if (!isDirectory) {
					newFileName.append(extendName);
				}
				if (FileUtils.isFileExist(newFileName.toString(), dir)) {
					nameNum++;
					newFileName = new StringBuffer();
					continue;
				}
				return newFileName.toString();
			}
		}
		return fileName;
	}

	/**
	 * ϴĽɹ
	 * 
	 * @param uploadFileName
	 * @param savePath
	 * @param uploadFile
	 * @return
	 */
	public static boolean upload(String uploadFileName, String savePath, File uploadFile) {
		boolean flag = false;
		try {
			uploadForName(uploadFileName, savePath, uploadFile);
			flag = true;
		} catch (IOException e) {
			flag = false;
			e.printStackTrace();
		}
		return flag;
	}

	/**
	 * ϴļϴļ
	 * 
	 * @param uploadFileName
	 *            ϴļ
	 * @param savePath
	 *            ļı·
	 * @param uploadFile
	 *            ϴļ
	 * @return ɹ
	 * @throws IOException
	 */
	public static String uploadForName(String uploadFileName, String savePath, File uploadFile) throws IOException {
		String newFileName = checkFileName(uploadFileName, savePath);
		FileOutputStream fos = null;
		FileInputStream fis = null;
		try {
			fos = new FileOutputStream(savePath + newFileName);
			fis = new FileInputStream(uploadFile);
			byte[] buffer = new byte[1024];
			int len = 0;
			while ((len = fis.read(buffer)) > 0) {
				fos.write(buffer, 0, len);
			}
		} catch (FileNotFoundException e) {
			throw e;
		} catch (IOException e) {
			throw e;
		} finally {
			try {
				if (fos != null) {
					fos.close();
				}
				if (fis != null) {
					fis.close();
				}
			} catch (IOException e) {
				throw e;
			}
		}
		return newFileName;
	}

	/**
	 * ·һϵеĿ¼
	 * 
	 * @param path
	 */
	public static boolean mkDirectory(String path) {
		File file = null;
		try {
			file = new File(path);
			if (!file.exists()) {
				return file.mkdirs();
			}
		} catch (RuntimeException e) {
			e.printStackTrace();
		} finally {
			file = null;
		}
		return false;
	}

	/**
	 * ÿһԪطֱӵָ,Apache commons collections еķ
	 * 
	 * @param collection
	 *            Ŀ꼯϶
	 * @param arr
	 *            
	 */
	public static void addToCollection(Collection collection, Object[] arr) {
		if (null != collection && null != arr) {
			CollectionUtils.addAll(collection, arr);
		}
	}

	/**
	 * ַѶָΪ,Apache commons lang еķ
	 * 
	 * <pre>
	 * Example:
	 *  String[] arr = StringUtils.split(&quot;a b,c d,e-f&quot;, &quot; ,&quot;);
	 *  System.out.println(arr.length);//6
	 * </pre>
	 * 
	 * @param str
	 * Ŀַ
	 * @param separatorChars
	 * ַָ
	 * @return ַ
	 */
	public static String[] split(String str, String separatorChars) {
		return StringUtils.split(str, separatorChars);
	}

	/**
	 * ֶָεsetter
	 * 
	 * <pre>
	 * Example:
	 * User user = new User();
	 *  FileUtils.invokeSetMethod(&quot;userName&quot;, user, new Object[] {&quot;&quot;});
	 * </pre>
	 * 
	 * @param fieldName
	 * ֶ()
	 * @param invokeObj
	 * ÷Ķ
	 * @param args
	 * ÷Ĳ
	 * @return ɹ
	 */
	public static boolean invokeSetMethod(String fieldName, Object invokeObj, Object[] args) {
		boolean flag = false;
		Field[] fields = invokeObj.getClass().getDeclaredFields(); // öʵжֶ
		Method[] methods = invokeObj.getClass().getDeclaredMethods(); // öʵжķ
		for (Field f : fields) {
			String fname = f.getName();
			if (fname.equals(fieldName)) {// ҵҪµֶ
				String mname = "set" + (fname.substring(0, 1).toUpperCase() + fname.substring(1));// 齨setter
				for (Method m : methods) {
					String name = m.getName();
					if (mname.equals(name)) {
						// Integer
						if (f.getType().getSimpleName().equalsIgnoreCase("integer") && args.length > 0) {
							args[0] = Integer.valueOf(args[0].toString());
						}
						// Boolean
						if (f.getType().getSimpleName().equalsIgnoreCase("boolean") && args.length > 0) {
							args[0] = Boolean.valueOf(args[0].toString());
						}
						try {
							m.invoke(invokeObj, args);
							flag = true;
						} catch (IllegalArgumentException e) {
							flag = false;
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							flag = false;
							e.printStackTrace();
						} catch (InvocationTargetException e) {
							flag = false;
							e.printStackTrace();
						}
					}
				}
			}
		}
		return flag;
	}

	/**
	 * жļǷ
	 * 
	 * @param fileName
	 * @param dir
	 * @return
	 */
	public static boolean isFileExist(String fileName, String dir) {
		File files = new File(dir + fileName);
		return (files.exists()) ? true : false;
	}

	/**
	 * ļ,֤ͬһļ²ͬ
	 * 
	 * @param fileName
	 * @param dir
	 * @return
	 */
	public static String getRandomName(String fileName, String dir) {
		String[] split = fileName.split("\\.");// ļ.ʽ
		String extendFile = "." + split[split.length - 1].toLowerCase(); // ļЧ׺

		Random random = new Random();
		int add = random.nextInt(1000000); // 10000
		String ret = add + extendFile;
		while (isFileExist(ret, dir)) {
			add = random.nextInt(1000000);
			ret = fileName + add + extendFile;
		}
		return ret;
	}

	/**
	 * ͼ
	 * 
	 * @param file
	 *            ϴļ
	 * @param height
	 *            Сĳߴ
	 * @throws IOException
	 */
	public static void createMiniPic(File file, float width, float height) throws IOException { }

	/**
	 * жļǷǺϷ,жallowTypesǷcontentType
	 * 
	 * @param contentType
	 *            ļ
	 * @param allowTypes
	 *            ļб
	 * @return ǷϷ
	 */
	public static boolean isValid(String contentType, String[] allowTypes) {
		if (null == contentType || "".equals(contentType)) {
			return false;
		}
		for (String type : allowTypes) {
			if (contentType.equals(type)) {
				return true;
			}
		}
		return false;
	}
}
