package cn.yw.operationcount.videoarchivecount.service;


import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.RHUtil;
import cn.yw.operationcount.videoarchivecount.dao.YwcountvideoarchiveDao;

@Service("ywcountvideoarchiveService")
public class YwcountvideoarchiveService extends BaseService {
	
	private static Log log = LogFactory.getLog(YwcountvideoarchiveService.class);
	
	@Autowired
	private YwcountvideoarchiveDao ywcountvideoarchiveDao;
	
	
	/**
	 * ѯ
	 */
	public Integer count_Ywcountvideoarchive(Map map) throws SQLException{
		return ywcountvideoarchiveDao.count_Ywcountvideoarchive(map);
	}
	
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map<String,String>> query_Ywcountvideoarchive(Map map) throws SQLException{
		List<Map<String,String>> list = ywcountvideoarchiveDao.query_Ywcountvideoarchive(map);
		Integer totalCount = ywcountvideoarchiveDao.count_Ywcountvideoarchive(map);
		
		// ͼ
		if(RHUtil.isNotEmpty(list)) {
			Collections.sort(list, new Comparator<Map<String,String>>(){
				@Override
				public int compare(Map<String, String> o1, Map<String, String> o2) {
					Float t1 = 0f;
					Float t2 = 0f;
					String st1 = o1.get("onmaprate");
					String st2 = o2.get("onmaprate");
					if(RHUtil.isNotEmpty(st1)) {
						st1 = st1.replaceAll("%", "");
						if(RHUtil.isNotEmpty(st1) && !st1.startsWith("00") && !st1.startsWith(".")) {
							t1 = Float.parseFloat(st1);
						}						
					}
					
					if(RHUtil.isNotEmpty(st2)) {
						st2 = st2.replaceAll("%", "");
						if(RHUtil.isNotEmpty(st2) && !st2.startsWith("00") && !st2.startsWith(".")) {
							t2 = Float.parseFloat(st2);
						}						
					}
					
					return t2.compareTo(t1);
				}
				
			});
		}
		
		if(RHUtil.isNotEmpty(list)) {
			int i=0;
			for(Map<String,String> stMap : list) {
				i++;
				stMap.put("stlpm", String.valueOf(i));
			}
			
			// 
			Collections.sort(list, new Comparator<Map<String,String>>(){
				@Override
				public int compare(Map<String, String> o1, Map<String, String> o2) {
					Float w1 = 0f;
					Float w2 = 0f;
					String wz1 = o1.get("completerate");
					String wz2 = o2.get("completerate");
					if(RHUtil.isNotEmpty(wz1)) {
						wz1 = wz1.replaceAll("%", "");
						if(RHUtil.isNotEmpty(wz1) && !wz1.startsWith("00") && !wz1.startsWith(".")) {
							w1 = Float.parseFloat(wz1);
						}						
					}
					
					if(RHUtil.isNotEmpty(wz2)) {
						wz2 = wz2.replaceAll("%", "");
						if(RHUtil.isNotEmpty(wz2) && !wz2.startsWith("00") && !wz2.startsWith(".")) {
							w2 = Float.parseFloat(wz2);
						}						
					}
					
					return w2.compareTo(w1);
				}
				
			});
			
			int j=0;
			for(Map<String,String> stMap : list) {
				j++;
				stMap.put("wzlpm", String.valueOf(j));
			}
		}
		return list;
	}
	
	
	/**
	 * ѯһ
	 */
	public Map get_Ywcountvideoarchive(Map map) throws SQLException{
		return ywcountvideoarchiveDao.get_Ywcountvideoarchive(map);
	}
	
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwcountvideoarchive(Map map) throws SQLException{
		return this.listYwcountvideoarchiveByPage(map);
	}
	*/
	
	/**
	 * Ywcountvideoarchive ҳ
	 */
	
	public Map listYwcountvideoarchiveByPage(Map map) throws SQLException {
		List<Map<String,String>> list = ywcountvideoarchiveDao.query_Ywcountvideoarchive(map);
		Integer totalCount = ywcountvideoarchiveDao.count_Ywcountvideoarchive(map);
		
		// ͼ
		if(RHUtil.isNotEmpty(list)) {
			Collections.sort(list, new Comparator<Map<String,String>>(){
				@Override
				public int compare(Map<String, String> o1, Map<String, String> o2) {
					Float t1 = 0f;
					Float t2 = 0f;
					String st1 = o1.get("onmaprate");
					String st2 = o2.get("onmaprate");
					if(RHUtil.isNotEmpty(st1)) {
						st1 = st1.replaceAll("%", "");
						if(RHUtil.isNotEmpty(st1) && !st1.startsWith("00") && !st1.startsWith(".")) {
							t1 = Float.parseFloat(st1);
						}						
					}
					
					if(RHUtil.isNotEmpty(st2)) {
						st2 = st2.replaceAll("%", "");
						if(RHUtil.isNotEmpty(st2) && !st2.startsWith("00") && !st2.startsWith(".")) {
							t2 = Float.parseFloat(st2);
						}						
					}
					
					return t2.compareTo(t1);
				}
				
			});
		}
		
		if(RHUtil.isNotEmpty(list)) {
			int i=0;
			for(Map<String,String> stMap : list) {
				i++;
				stMap.put("stlpm", String.valueOf(i));
			}
			
			// 
			Collections.sort(list, new Comparator<Map<String,String>>(){
				@Override
				public int compare(Map<String, String> o1, Map<String, String> o2) {
					Float w1 = 0f;
					Float w2 = 0f;
					String wz1 = o1.get("completerate");
					String wz2 = o2.get("completerate");
					if(RHUtil.isNotEmpty(wz1)) {
						wz1 = wz1.replaceAll("%", "");
						if(RHUtil.isNotEmpty(wz1) && !wz1.startsWith("00") && !wz1.startsWith(".")) {
							w1 = Float.parseFloat(wz1);
						}						
					}
					
					if(RHUtil.isNotEmpty(wz2)) {
						wz2 = wz2.replaceAll("%", "");
						if(RHUtil.isNotEmpty(wz2) && !wz2.startsWith("00") && !wz2.startsWith(".")) {
							w2 = Float.parseFloat(wz2);
						}						
					}
					
					return w2.compareTo(w1);
				}
				
			});
			
			int j=0;
			for(Map<String,String> stMap : list) {
				j++;
				stMap.put("wzlpm", String.valueOf(j));
			}
		}

		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	// ͳ  ͼչʾ
	public Map count_showPie(Map map) throws SQLException{
		return ywcountvideoarchiveDao.count_showPie(map);
	}
	// ͳ  ״ͼչʾ
	public List count_showBar(Map map) throws SQLException{
		return ywcountvideoarchiveDao.count_showBar(map);
	}
		
}
