package cn.base.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SuppressWarnings("all")
public class ShowFile extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private static Log iLog = LogFactory.getLog(ShowFile.class);

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.reset();
		response.setHeader("Expires", "Sat, 10 May 2059 12:00:00 GMT");
		response.setHeader("Cache-Control", "max-age=315360000");
		FileInputStream hFile = null;
		OutputStream toClient = null;
		try { } catch (Exception e) {
			if (!(e instanceof java.io.FileNotFoundException)) {
				iLog.error("error", e);
			}
			PrintWriter out = response.getWriter(); 
			response.setContentType("text/html;charset=gb2312");
			out.write("cann't open picture file!  ");
			out.close();
		} finally {
			if (hFile != null) {
				hFile.close();
			}
			if (toClient != null) {
				toClient.close();
			}
		}
	}

	public void shootPhotoCase(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		BufferedInputStream bis = null;
		OutputStream toClient = null;
		FileInputStream hFile = null;
		InputStream inputStream = null;
 		String filePath = null;
		try {
			resetResponse(response);
 			String fileName = request.getParameter("fileName");
			filePath = request.getParameter("filePath");
 
			if (filePath.toUpperCase().indexOf("FTP") != -1) {
				String contentType = request.getParameter("contentType");		 
				response.setContentType(contentType);
				response.setHeader("Content-disposition", "attachment;filename=" + StringUtil.toUtf8(fileName));
				String ip = CommUtils.getIpAddr(Struts2Utils.getRequest());
				String photoRs = CommUtils.getPhotoRsIp(ip, null);
				String rsPath = photoRs+"/showfile?fileType=picUrlProxy&xwPicUrl="+filePath;
				rsPath =StringUtil.getChineseEncoding(rsPath);
				iLog.info("shootPhotoCase-photoRsPath" + rsPath);
				FTPUtil.getInstance().downLoadFile(rsPath, response.getOutputStream());
			} else {
				String contentType = request.getParameter("contentType");
				response.setContentType(contentType);
				iLog.info("shootPhotoCase-fileName" + fileName);
			 
				response.setHeader("Content-disposition", "attachment;filename=" + StringUtil.toUtf8(fileName));
 				File file = new File(filePath);
				long fileLen = file.length();
				response.setContentLength((int) fileLen);
				hFile = new FileInputStream(file);
				toClient = response.getOutputStream();
				org.apache.commons.io.IOUtils.copy(hFile, toClient);
			}
		} catch (Exception e) {
			iLog.error("shootPhotoCase", e);
		} finally {
			closeIO(bis, toClient, hFile, inputStream);
		}

	}
 
	private void resetResponse(HttpServletResponse response) {
		response.reset();
		response.setHeader("Expires", "Sat, 10 May 2059 12:00:00 GMT");
		response.setHeader("Cache-Control", "max-age=315360000");
	}
	private void closeIO(BufferedInputStream bis, OutputStream toClient, FileInputStream hFile, InputStream inputStream) {
		try {
			if (bis != null)
				bis.close();
			if (toClient != null)
				toClient.close();
			if (hFile != null)
				hFile.close();
			if (inputStream != null)
				inputStream.close();
		} catch (IOException e) {
			iLog.error("IOر쳣" + e);
		}
	}
}
