package cn.yw.video.videotask.action;

 import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

 import cn.base.util.*;
 import cn.yw.video.videotask.model.DatetimeParamBean;
 import cn.yw.video.videotask.model.YwvideotaskBean;
 import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
 import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.video.videotask.service.YwvideotaskService;

@SuppressWarnings({"all"})
@Component("ywvideotaskAction")
public class YwvideotaskAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwvideotaskAction.class);
	
	@Autowired
	private YwvideotaskService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwvideotaskByPage")
	public void listYwvideotaskByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwvideotaskByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-listYwvideotaskByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ҵѲƻ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwvideotaskMy")
	public void listYwvideotaskMy(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			PtyhBean ptyh = (PtyhBean)(Struts2Utils.getSession().getAttribute("userInfo"));
			if(ptyh!=null){
				if(ptyh.getSfgly()==0){
					map.put("createaccount",ptyh.getYhzh());
				}
			}
			Struts2Utils.renderJson(this.service.listYwvideotaskByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-listYwvideotaskMy-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ˼ƻ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwvideotaskApproval")
	public void listYwvideotaskApproval(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			PtyhBean ptyh = (PtyhBean)(Struts2Utils.getSession().getAttribute("userInfo"));
			if(ptyh!=null){
				if(ptyh.getSfgly()==0){
					map.put("extend2",ptyh.getYhzh());
				}
			}
			map.put("extend1","0");
			Struts2Utils.renderJson(this.service.listYwvideotaskByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-listYwvideotaskApproval-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ȡ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getApproveUser")
	public void getApproveUser(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List list = service.getApproveUser(map);
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-getReportUser-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywvideotask")
	public void count_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywvideotask(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-count_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywvideotask
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywvideotask")
	public void query_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywvideotask(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-query_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwvideotask
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywvideotask")
	public void get_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywvideotask(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskActionquery_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwvideotask")
	public void delete_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywvideotask(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-delete_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywvideotask")
	public void insert_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("taskid"))){
				map.put("taskid",StringUtil.getUUID());
			}
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			map.put("createaccount", username);
			map.put("createtime", DateUtil.currentDateTime());
			map.put("modifyaccount", username);
			map.put("modifytime", DateUtil.currentDateTime());
			map.put("detectionstarttime", DateUtil.currentDateTime());
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywvideotask(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywvideotask(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywvideotask(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-insert_Ywvideotask()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywvideotask")
	public void update_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			map.put("modifyaccount", username);
			map.put("modifytime", DateUtil.currentDateTime());
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywvideotask(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywvideotask(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywvideotask(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-update_Ywvideotask-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ɾ񼯺
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="delete_channelset_Ywvideotask")
	public void delete_channelset_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.isEmpty((String)map.get("taskid"))){
				Struts2Utils.renderJson(Constants.FAIL);
				return;
			}
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			map.put("modifyaccount", username);
			map.put("modifytime", DateUtil.currentDateTime());
			
			int result = service.delete_channelset_Ywvideotask(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-delete_channelset_Ywvideotask-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywvideotask")
	public void batch_delete_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keyword = map.get("keyword").toString();
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					
					service.batch_delete_Ywvideotask(lists);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-batch_delete_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_update_Ywvideotask")
	public void batch_update_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keyword = map.get("keyword").toString();
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
//				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
//				for(int i=0;i<ids.length;i++){
//					lists.add(ids[i]);
//				}
//				if(lists!=null && lists.size()>0){
				if(ids!=null && ids.length>0){
					map.put("keyword", ids);
					String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
					map.put("modifyaccount", username);
					map.put("modifytime", DateUtil.currentDateTime());
					map.put("detectionstarttime", DateUtil.currentDateTime());
					service.batch_update_Ywvideotask(map);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-batch_delete_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_update_approval_Ywvideotask")
	public void batch_update_approval_Ywvideotask(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keyword = map.get("keyword").toString();
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				String[] ids = keyword.split(",");
				if(ids!=null && ids.length>0){
					map.put("keyword", ids);
					String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
					map.put("modifyaccount", username);
					map.put("modifytime", DateUtil.currentDateTime());
					map.put("extend3", DateUtil.currentDateTime());
					map.put("extend4", map.get("approvalSuggestion"));
					map.put("extend1", map.get("extend1"));
					service.batch_update_Ywvideotask(map);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-batch_update_approval_Ywvideotask-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * źŵƣյشţ΢״Ѳʼʱ䣬һһʼʱһ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwjtqueryTimeParam")
	public void listYwjtqueryTimeParam(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			//жϿʼʱʱ䣬ѯһεѲ豸Ѳ쿪ʼʱ
			List<Map> resultlist=new ArrayList<>();
			if(RHUtil.isNotEmpty(map.get("startdate"))&& RHUtil.isNotEmpty(RHUtil.isNotEmpty(map.get("enddate"))))
			{
				List<Map> tasklist=this.service.listYwjtqueryTimeParam(map);
				//жڼж
				List<String> datelist=DateUtil.getBetweenDate(map.get("startdate").toString(),map.get("enddate").toString());
			for(String date:datelist) {
				for (Map m : tasklist) {
					map.put("startTime", date + " " + m.get("daystarttime"));
					map.put("endTime",date + " " + m.get("nexttime"));
					//ݿʼʱʱѯһΣʱ7죬ÿѲ죬14¼С20Բ÷ҳ
					resultlist.addAll(this.service.listYwjtxjtask(map));
				}
			  }
			}

			Struts2Utils.renderJson(resultlist);
		} catch (Exception e) {
			//e.printStackTrace();
			iLog.error("YwvideotaskAction-listYwjtqueryTimeParam-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * źŵƣյشţ΢״Ѳʼʱ䣬һһʼʱһ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwtaskrunresulthistoryByPage")
	public void listYwtaskrunresulthistoryByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listYwtaskrunresulthistoryByPage(map));
		} catch (Exception e) {
			//e.printStackTrace();
			iLog.error("YwvideotaskAction-listYwjtqueryTimeParam-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ѯͨ豸δμѲ豸嵥
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwDevicetaskNoTaskByPage")
	public void listYwDevicetaskNoTaskByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listYwDevicetaskNoTaskByPage(map));
		} catch (Exception e) {
			//e.printStackTrace();
			iLog.error("YwvideotaskAction-listYwDevicetaskNoTaskByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywvideotask")
	public void exp_Ywvideotask(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywvideotask(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά-"+dateTime);
			params.put("sheetName", "ά");
			params.put("header", "ά");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideotaskAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywvideotask")
	public String imp_Ywvideotask(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwvideotaskAction-imp_Ywvideotask-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
