package cn.yw.operationcount.videoarchivecount.action;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.operationcount.videoarchivecount.service.YwcountvideoarchiveService;

@SuppressWarnings({"all"})
@Component("ywcountvideoarchiveAction")
public class YwcountvideoarchiveAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwcountvideoarchiveAction.class);
	
	@Autowired
	private YwcountvideoarchiveService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwcountvideoarchiveByPage")
	public void listYwcountvideoarchiveByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwcountvideoarchiveByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction-listYwcountvideoarchiveByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywcountvideoarchive")
	public void count_Ywcountvideoarchive(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywcountvideoarchive(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction-count_Ywcountvideoarchive-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywcountvideoarchive
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywcountvideoarchive")
	public void query_Ywcountvideoarchive(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywcountvideoarchive(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction-query_Ywcountvideoarchive-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwcountvideoarchive
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywcountvideoarchive")
	public void get_Ywcountvideoarchive(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywcountvideoarchive(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveActionquery_Ywcountvideoarchive-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ͳ  ͼչʾ
	@OperateType(value = LogConstants.LOG_GET ,info ="count_showPie")
	public void count_showPie(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_showPie(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction--count_showPie-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ͳ  ״ͼչʾ
	@OperateType(value = LogConstants.LOG_GET ,info ="count_showPie")
	public void count_showBar(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_showBar(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction--count_showBar-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountvideoarchive")
	public void exp_Ywcountvideoarchive(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map<String, String>> sList =service.query_Ywcountvideoarchive(map);
			/*List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}*/
			
			String[] zdbm = {"areaname", "monitortotal","networkcount","notnetworkcount","firstmonitorcount","secondmonitorcount","thirdmonitorcount","policemonitorcount"};                          
			String[] zdmc = {"", "λ","","δ","һƵص","Ƶص","Ƶص","ڲص"};
			int excelNum = zdbm.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άͳϢ-"+dateTime);
			params.put("sheetName", "άͳϢ");
			params.put("header", "һһ豸ͳ(Ʊʱ䣺"+dateTime+")");
			//new ExportEngine().exportCommData(params, cells, sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction-exoprtExcel-error:" +e);
			
		}
	}
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountvideoarchive")
	public void excel_Ywcountvideoarchive(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map<String, String>> sList = service.query_Ywcountvideoarchive(map);		
		
			String[] zdbm = {"areaname", "monitortotal","onmaprate","stlpm","completerate","wzlpm","newnetwork","socialmonitorcount"};                          
			String[] zdmc = {"", "λ","ͼ","ͼ","","","",""};
			int excelNum = zdbm.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άͳϢ-"+dateTime);
			params.put("sheetName", "άͳϢ");
			params.put("header", "һһ豸ͳ(Ʊʱ䣺"+dateTime+")");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoarchiveAction-exoprtExcel-error:" +e);
			
		}
	}
	
}
