package cn.base.aspect;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;

import cn.base.bean.BeanHelper;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptlog.dao.PtyhczrzDao;
import cn.bsystem.ptmenu.util.MenuXml;
import cn.bsystem.ptuserrole.model.PtyhBean;

import com.google.gson.Gson;

@Aspect
public class OperateAspect {
	private static Logger iLog = Logger.getLogger(OperateAspect.class);
    private static  Gson gson = new Gson();
	private PtyhczrzDao ptyhczrzDao = null;
    private char[] c = new char[0];
    private static String  menutype = null;
    
    public  String getMenuType() {
    	if(menutype==null){
    		menutype =MenuXml.getInstance().getMenuType();
    	}
		return menutype;
	}
	private PtyhczrzDao getRzInstance(){
		synchronized (c) {
			if(ptyhczrzDao==null){
				ptyhczrzDao=(PtyhczrzDao)BeanHelper.getBean("ptyhczrzDao");
			}
		}
		return ptyhczrzDao;
	}
    public  void before(JoinPoint point){}
    
	public void afterThrow(){}
	
	public Object  doAround(ProceedingJoinPoint point)  throws Throwable{
		String methodName 	=	point.getSignature().getName();
	    String className	=	point.getTarget().getClass().getSimpleName(); 
	    String userzh = "" ;
	    String usermc = "" ;
		Object result = point.proceed(); 
		if (StringUtils.isNotEmpty(methodName)) {
			Method method = point.getTarget().getClass().getMethod(methodName);
			if (method != null) {
				if(method.isAnnotationPresent(OperateType.class)){
						OperateType annotation = method.getAnnotation(OperateType.class);
						//ʱеlistbypage
						if(annotation.info().lastIndexOf("ByPage") ==annotation.info().length()-6 ){
							return result;
						}
			            try{
			            	HttpServletRequest request = Struts2Utils.getRequest();
			            	if( StringUtils.isBlank(userzh) || "NULL".equals(userzh)){
			            		PtyhBean map = (PtyhBean)(request.getSession().getAttribute("userInfo"));
			            		usermc = (map == null)? "" : map.getYhmc();
			            		userzh = (map == null)? "" : map.getYhzh();
			            	}
			            	StringBuffer sb = new StringBuffer(); 
			            	sb.append(point.getSignature().getName());
				            sb.append(";").append(gson.toJson(request.getParameterMap()));
				            //iLog.info(sb); 
			            	Map<String,Object> m = new HashMap<String,Object>();
			    			m.put("czrzbh",StringUtil.getUUID());
			            	m.put("yhbh", userzh);
			            	m.put("yhzh", userzh);
			            	m.put("yhmc", usermc);
			            	m.put("khdip", Struts2Utils.getRequest().getRemoteAddr());
			            	m.put("ms", sb.toString());
			            	m.put("czbm",className.toLowerCase().replace("action",""));
			            	m.put("czdx", annotation.info());
			            	String currentTime=new SimpleDateFormat ("yyyyMMddHHmmss").format(new Date());
			            	m.put("czsj", currentTime);
			            	m.put("czml", annotation.value());
			            	m.put("rzly", getMenuType());
			            	getRzInstance().insert_Ptyhczrz(m);
			            	sb.setLength(0);
			            }catch(Exception ex){
			            	ex.printStackTrace();
							iLog.error(ex.getMessage());
						}
				}
			}
		} 
        return result ;
    }  
}
