package cn.map.szmap.action;

import cn.base.aspect.OperateType;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;
import cn.map.szmap.service.SzMapStatisService;
import cn.yw.detector.service.DetectorService;
import cn.yw.nhyw.nhywjtledydpgl.service.NhywjtledydpglService;
import cn.yw.nhyw.nhywjtxhdgl.service.NhywjtxhdglService;
import cn.yw.zxld.service.ZxldService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.SQLException;
import java.util.*;

@Component("szMapStatisAction")
public class SzMapStatisAction {
    private static Log logger = LogFactory.getLog(SzMapHttpAction.class);
    private static final String ENCODING = "gbk";
    @Autowired
    private SzMapStatisService service;

    @Autowired
    private NhywjtxhdglService xhdservice;

    @Autowired
    private NhywjtledydpglService ydpservice;

    @Autowired
    private DetectorService detectorService;

    @Autowired
    private ZxldService zxldService;
    /**
     * ͳ豸״̬Ϣ
     *
     * @return
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "getMapDeviceStatusData")
    public void getMapDeviceStatusData() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            //жĸ豸
            if (null != map.get("sblb")) {
                switch (map.get("sblb").toString()) {
                    case "1":
                        service.getvideoStatusData(map);
                        break;
                    case "2":
                        service.getmachineStatusData(map);
                        break;
                    case "3":
                        getxhdStatusData(map);
                        break;
                    case "4":
                        service.getroadStatusData(map);
                        break;
                    case "5":
                        service.getjzwxxStatusData(map);
                        break;
                    case "6":
                        service.getbzStatusData(map);
                        break;
                    case "7":
                        service.getbxStatusData(map);
                        break;
                    case "8":
                        service.gethlStatusData(map);
                        break;
                    case "9":
                        ydpservice.listYwAllydpstatusinfo(map);
                        break;
                    case "10":
                        map.put("detectortype", "GVD");
                        detectorService.listDetectorCurrentstateByPage(map);
                        break;
                    case "11":
                        map.put("detectortype", "SMARTSENSOR");
                        detectorService.listDetectorCurrentstateByPage(map);
                        break;
                    case "12":
                        zxldService.listZxldcurrentstateByPage(map);
                        break;
                }
            }
            Struts2Utils.renderJson(map);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("szMapStatisAction getMapDeviceStatusData:" + e);
            Struts2Utils.renderJson(null);
        }
    }

//    public void getxhdStatusData(Map map) throws SQLException {
//        //źŵƵ쳣Ϣ
//        Map xhdstatusmap = xhdservice.listNhywjtxhdglStatus(map);
//        List<Map> xhdstatemap = (List<Map>) xhdstatusmap.get("rows");
//        int page = Integer.parseInt(Struts2Utils.getParameter("page"));
//        int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
//        int start = ((page == 0 ? 1 : page) - 1) * rows;
//        map.put("start", start);
//        map.put("limit", rows);
//        //źŵƵķҳϢ
//        Map xhdmap = xhdservice.listNhywjtxhdglByPage(map);
//        List<Map> xhdmaplist = (List<Map>) xhdmap.get("rows");
//        List<Map> resultlist = new ArrayList<Map>();
//        boolean ischeck = false;
//        //ϻý
//        for (Map mapLD : xhdmaplist) {
//            ischeck = false;
//            Map item = new HashMap();
//            for (Map mapLDState : xhdstatemap) {
//                if (null != mapLD.get("qybh") && null != mapLDState.get("noarea")
//                        && null != mapLD.get("lkh") && null != mapLDState.get("nojunc")
//                        && mapLD.get("qybh").equals(String.valueOf(mapLDState.get("noarea")))
//                        && mapLD.get("lkh").equals(String.valueOf(mapLDState.get("nojunc")))) {
//                    item.put("name", mapLD.get("qybh") + "-" + mapLD.get("lkh"));
//                    item.put("status", mapLDState.get("mode"));
//                    ischeck = true;
//                }
//            }
//            if (!ischeck) {
//                item.put("status", null);
//                item.put("jd", mapLD.get("jd"));
//                item.put("wd", mapLD.get("wd"));
//                item.put("name", mapLD.get("qybh") + "-" + mapLD.get("lkh"));
//            }
//            resultlist.add(item);
//        }
//        map.put("rows", resultlist);
//        map.put("total", xhdmap.get("total"));
//    }
public void getxhdStatusData(Map map) throws SQLException {
    int page = Integer.parseInt(Struts2Utils.getParameter("page"));
    int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
    int start = ((page == 0 ? 1 : page) - 1) * rows;
    map.put("start", start);
    map.put("limit", rows);
    //źŵƵ쳣Ϣ
    xhdservice.listNhywjtxhdglStatus(map);
}
    /**
     * ͳ豸״̬Ϣ
     *
     * @return
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "getDeviceStatusStatis")
    public void getDeviceStatusStatis() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            //жĸ豸
            if (null != map.get("sblb")) {
                switch (map.get("sblb").toString()) {
                    case "1":
                        service.getvideoStatusStatis(map);
                        break;
                    case "2":
                        service.getmachineStatusStatis(map);
                        break;
                    case "3":
                        xhdservice.listNhywjtxhdglStatusStatis(map);
                        break;
                    case "4":
                        service.getroadStatusStatis(map);
                        break;
                    case "5":
                        service.getjzwxxStatusStatis(map);
                        break;
                    case "6":
                        service.getbzStatusStatis(map);
                        break;
                    case "7":
                        service.getbxStatusStatis(map);
                        break;
                    case "8":
                        service.gethlStatusStatis(map);
                        break;
                    case "9":
                        service.getydpStatusStatis(map);
                        break;
                    case "10":
                        map.put("detectortype", "GVD");
                        service.getdDetetorStatusStatis(map);
                        break;
                    case "11":
                        map.put("detectortype", "SMARTSENSOR");
                        service.getdDetetorStatusStatis(map);
                        break;
                    case "12":
                        service.getZxldStatusStatis(map);
                        break;
                }
            }
            if (null != map.get("data")) {
                Struts2Utils.renderJson(getListToMap((List<Map>) map.get("data")));
            } else {
                Struts2Utils.renderJson(null);
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("szMapStatisAction getDeviceStatusStatis:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    public Map getListToMap(List<Map> maplist) {
        Map map = new HashMap();
        for (Map m : maplist) {
            Iterator<Map.Entry<String, String>> iterator = m.entrySet().iterator();
            String key = "", value = "";
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().equalsIgnoreCase("status")) {
                    key = entry.getValue();
                }
                if (entry.getKey().equalsIgnoreCase("total")) {
                    value = String.valueOf(entry.getValue());
                }
            }
            map.put(key, value);
        }
        return map;
    }



}
