package cn.base.conf;

import java.lang.reflect.Field;

import org.apache.log4j.Logger;
import cn.base.util.StringUtil;

public class ModuleConfFactory { 
	static private final Logger logger = Logger.getLogger(ModuleConfFactory.class);
    private static ModuleConfFactory moduleConfService = new ModuleConfFactory();
	public static ModuleConfFactory getInstance() {
		return moduleConfService;
	}
	
	public ModuleConfFactory(){
		logger.debug("Read siyou.xml file... ...");
		ModuleConfManager.getInstance().parseAppXml("siyou.xml", this);
		if(StringUtil.isNotEmpty(this.getScatter().getPcfg())){
			ModuleConfManager.getInstance().parseAppXml(this.getScatter().getPcfg(), this);
		}
    }
	
	public void init(){
		Field[] tc=this.getClass().getDeclaredFields();
		for(int i=0;i<tc.length;i++){
			try {
				String destClassName=tc[i].getType().getSuperclass().getSimpleName();
				if(destClassName.equalsIgnoreCase("NodeHome")==false)continue;
				NodeHome nhObj=(NodeHome) tc[i].get(this);
				if(nhObj==null)continue;
				if(nhObj.hanveParseFlag==false)nhObj.fillField();
				nhObj.hanveParseFlag=true;
			} catch (Exception e) {
				e.printStackTrace();
			} 	
		}
	}
	private Scatter scatter;
	private Db db;
	private Es es;
	private Email email;
	private Amq amq;
	private OracleDB oracleDB;
	private Ice ice;
	private Dac dac;
	private Ditu ditu;
	private Ftps ftps;
	private Ftp ftp;
	private Webrtc webrtc;
	private TraffAccident traffAccident;
	private Impagent impagent;
	private RoadDirection roadDirection;
	private Ywsoftware ywsoftware;
	private YwDp ywDp;
	private VideoTaskAlarm videoTaskAlarm;
	private YwPatrol ywPatrol;
	
	
	public YwPatrol getYwPatrol() {
		return ywPatrol;
	}

	public void setYwPatrol(YwPatrol ywPatrol) {
		this.ywPatrol = ywPatrol;
	}

	public VideoTaskAlarm getVideoTaskAlarm() {
		return videoTaskAlarm;
	}

	public void setVideoTaskAlarm(VideoTaskAlarm videoTaskAlarm) {
		this.videoTaskAlarm = videoTaskAlarm;
	}

	public YwDp getYwDp() {
		return ywDp;
	}

	public void setYwDp(YwDp ywDp) {
		this.ywDp = ywDp;
	}

	public Ywsoftware getYwsoftware() {
		return ywsoftware;
	}

	public void setYwsoftware(Ywsoftware ywsoftware) {
		this.ywsoftware = ywsoftware;
	}

	public RoadDirection getRoadDirection() {
		return roadDirection;
	}

	public void setRoadDirection(RoadDirection roadDirection) {
		this.roadDirection = roadDirection;
	}

	public Impagent getImpagent() {
		return impagent;
	}

	public void setImpagent(Impagent impagent) {
		this.impagent = impagent;
	}
	
	public TraffAccident getTraffAccident() {
		return traffAccident;
	}

	public void setTraffAccident(TraffAccident traffAccident) {
		this.traffAccident = traffAccident;
	}

	public Webrtc getWebrtc() {
		return webrtc;
	}

	public void setWebrtc(Webrtc webrtc) {
		this.webrtc = webrtc;
	}

	public static ModuleConfFactory getModuleConfService() {
		return moduleConfService;
	}

	public static void setModuleConfService(ModuleConfFactory moduleConfService) {
		ModuleConfFactory.moduleConfService = moduleConfService;
	}

	public Scatter getScatter() {
		return scatter;
	}

	public void setScatter(Scatter scatter) {
		this.scatter = scatter;
	}

	public Db getDb() {
		return db;
	}

	public void setDb(Db db) {
		this.db = db;
	}

	public Amq getAmq() {
		return amq;
	}

	public void setAmq(Amq amq) {
		this.amq = amq;
	}

	public OracleDB getOracleDB() {
		return oracleDB;
	}

	public void setOracleDB(OracleDB oracleDB) {
		this.oracleDB = oracleDB;
	}

	public Es getEs() {
		return es;
	}

	public void setEs(Es es) {
		this.es = es;
	}

	public Email getEmail() {
		return email;
	}

	public void setEmail(Email email) {
		this.email = email;
	}
	
	public Ice getIce() {
		return ice;
	}

	public void setIce(Ice ice) {
		this.ice = ice;
	}
	public Dac getDac() {
		return dac;
	}

	public void setDac(Dac dac) {
		this.dac = dac;
	}

	public Ditu getDitu() {
		return ditu;
	}

	public void setDitu(Ditu ditu) {
		this.ditu = ditu;
	}
	public Ftps getFtps() {
		return ftps;
	}

	public void setFtps(Ftps ftps) {
		this.ftps = ftps;
	}

	public Ftp getFtp() {
		return ftp;
	}

	public void setFtp(Ftp ftp) {
		this.ftp = ftp;
	}
	
}
