<%@ page language="java" import="java.util.*" pageEncoding="gbk" %>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=gbk"/>
    <%@include file="../../../../../../frame/assets/header-all.jsp" %>
    <link rel="stylesheet" type="text/css" href="../../../../resource/css/map.frame.css">
</head>
<body class="easyui-layout" onselectstart="return false">
<div data-options="region:'north'" id='north' style="height: 78px;border: none">
    <div class="left-box fl">
        <div>
            <span class="text-content">豸</span>
            <select id="lb" class="easyui-combobox">
                <option value="">ȫ</option>
                <option value="1" selected></option>
                <option value="2"></option>
                <option value="3">źŵ</option>
                <option value="4">յ</option>
                <option value="10">ش</option>
                <option value="11">΢</option>
                <option value="12">״</option>
                <option value="5"></option>
                <option value="6">־</option>
                <option value="7"></option>
                <option value="8"></option>
                <option value="9">·</option>
            </select>
        </div>
        <div>
            <span class="text-content">豸ƣ</span>
            <input class="easyui-textbox" id="LIKEsbmc" prompt='Ż'>
        </div>
    </div>

    <div class="right-box fl">
        <button id="search" class="button-search" onclick="doSearch()">ѯ</button>
    </div>
</div>

<div data-options="region:'center',split:false" class="easyui-layout" style="border: none">
    <table id="monitor-tab-grid"></table>
</div>
<div data-options="region:'south',height:70,borer:false,collapsible:true" class="easyui-layout" id='southPanel'>
    <div style="height:100%;margin:0 auto;" id="GridListDiv">
        <table id="statisgrid" cellspacing="0"  width="100%"  cellpadding="0"  border="1"  align="center"  style="text-align:center;margin:0 auto;" >
            <thead>
            <tr>
                <td></td>
                <td></td>
                <td>쳣</td>
                <td>ά</td>
                <td>Ѿά</td>
            </tr>
            </thead>
            <tbody id='searchGridList'>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        $.fn.pagination.defaults.beforePageText = '';
        $.fn.pagination.defaults.afterPageText = '';
        $.fn.pagination.defaults.showPageList = false;
        $.fn.pagination.defaults.showRefresh = false;

        initGrid();
    })

    //ѯ
    function doSearch() {
        $('#monitor-tab-grid').datagrid('loadData',{total:0,rows:[]})
        $('#monitor-tab-grid').datagrid('load', getQueryParams());
        getdata();
    }

    //ѯ
    function getQueryParams() {
        var sParam = {};
        sParam.layerSeq = 1;
        sParam.LIKEmc = $('#LIKEsbmc').textbox('getText');
        sParam.sblb = $('#lb').combobox('getValue');
//    console.log(sParam);
        return sParam;
    }

    //б
    function initGrid() {
        //ͳ豸
        datagrid = $('#monitor-tab-grid').datagrid({
            url: 'szMapStatisAction!getMapDeviceStatusData.do',
            queryParams: getQueryParams(),
            rownumbers: true,
            columns: [[
                {field: 'name', title: '豸', width: 120},
                {field: 'status', title: '״̬', width: 40},
                {field: 'jd', title: '', width: 90},
                {field: 'wd', title: 'γ', width: 90}
            ]]
        });
        getdata();
    }

    //ѡ
    function getdata() {
        $.ajax({
            type: 'post',
            dateType: 'json',
            url: 'szMapStatisAction!getDeviceStatusStatis.do',
            data: getQueryParams(),
            success: function (res) {
                renderTable(res);
            }
        });
    }

    function renderTable(res) {
        $("#searchGridList").html();
        var table = '';
        if (res) {
            var rows = res;
            table += '<tr>\
				<td>' + transformateEmpty(rows.total) + '</td>\
				<td>' + transformateEmpty(rows.normal) + '</td>\
				<td>' + transformateEmpty(rows.abnormal) + '</td>\
				<td>' + transformateEmpty(rows.repairing) + '</td>\
				<td>' + transformateEmpty(rows.repaired) + '</td>\
				<tr>'
        } else {
            table += '<tr> <td colspan="8"></td> <tr>';

        }
        $("#searchGridList").html(table);
    }

    function transformateEmpty(str) {
        if (!str || str == null || str == "null") {
            return "-";
        }
        return str;
    }
</script>
</body>
</html>	
