package cn.socket.socket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.server.standard.SpringConfigurator;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Author:
 * @ProjectName: socket
 * @Package: com.socket.web.socket
 * @ClassName: WebSocketServer
 * @Description:
 * <p>
 * ServerEndpointĹҪǽĿǰඨһwebsocketˡ
 * עֵڼûӵն˷URLַ
 * </p>
 * @CreateDate:
 * @Version: 1.0
 **/
@ServerEndpoint(value = "/socket/{yhbh}")
public class WebSocketServer {

    /**
     * ʹslf4j־
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketServer.class);

    /**
     * ¼ǰ
     */
    private static int onLineCount = 0;

    /**
     * ÿͻ˶ӦWebSocketServer
     */
    private static ConcurrentHashMap<String, WebSocketServer> webSocketMap = new ConcurrentHashMap<String, WebSocketServer>();

    /**
     * ĳͻ˵ӻỰҪͨͻ˷
     */
    private Session session;

    /**
     * ͻ˵yhbh
     */
    private String yhbh;

    public String getYhbh() {
        return yhbh;
    }

    public void setYhbh(String yhbh) {
        this.yhbh = yhbh;
    }

    /**
     * ӽɹ,õķ,ǰ̨ҳonOpenӦ
     *
     * @param yhbh      ipַ
     * @param session Ự
     */
    @OnOpen
    public void onOpen(@PathParam("yhbh") String yhbh, Session session) {
        //ҵ,Զ߼ʵ
        this.session = session;
        this.yhbh = yhbh;
        //ǰmap
        webSocketMap.put(yhbh, this);
        //һ
        addOnLineCount();
        LOGGER.info("µӼ,yhbh:{}!ǰ:{}", yhbh, getOnLineCount());
    }

    /**
     * ӹرյõķ,ǰ̨ҳonCloseӦ
     *
     * @param yhbh
     */
    @OnClose
    public void onClose(@PathParam("yhbh") String yhbh) {
        //yhbh(key)ƳWebSocketServer
        webSocketMap.remove(yhbh);
        subOnLineCount();
        LOGGER.info("WebSocketر,yhbh:{},ǰ:{}", yhbh, getOnLineCount());
    }

    /**
     * յͻ˷͵Ϣʱõķ,ǰ̨ҳonMessageӦ
     *
     * @param message
     * @param session
     */
    @OnMessage
    public void onMessage(String message, Session session) {
        //ҵ,Զ߼ʵ
        LOGGER.info("յͻ˵Ϣ:{}", message);
    }

    /**
     * ʱ,ǰ̨ҳonErrorӦ
     *
     * @param session
     * @param error
     */
    @OnError
    public void onError(Session session, Throwable error) {
        LOGGER.error("WebSocket");
        error.printStackTrace();
    }


    /**
     * ǰûϢ
     *ddddd
     * @param message
     */
    public void sendMessage(String message) {
        try {
            //getBasicRemote()ͬϢ,ҾˣƼʹgetAsyncRemote()첽
            this.session.getBasicRemote().sendText(message);
        } catch (IOException e) {
            e.printStackTrace();
            LOGGER.info("ݴ:,yhbh:{},message:{}", yhbh, message);
        }
    }

    /**
     * ûϢ
     *
     * @param message
     */
    public static void sendMessageAll(final String message) {
        //ʹentrySetkeySetԭ,entrySetmapӳϵ,ȡݸ졣
        Set<Map.Entry<String, WebSocketServer>> entries = webSocketMap.entrySet();
        for (Map.Entry<String, WebSocketServer> entry : entries) {
            final WebSocketServer webSocketServer = entry.getValue();
            //ʹ߳Ϣķ,Чʸߡ
            new Thread(new Runnable() {
                public void run() {
                    webSocketServer.sendMessage(message);
                }
            }).start();
        }
    }

    /**
     * ȡǰ
     *
     * @return
     */
    public static synchronized int getOnLineCount() {
        return WebSocketServer.onLineCount;
    }

    /**
     * µûʱ,Լ1
     */
    public static synchronized void addOnLineCount() {
        WebSocketServer.onLineCount++;
    }

    /**
     * Ͽʱ,Լ1
     */
    public static synchronized void subOnLineCount() {
        WebSocketServer.onLineCount--;
    }

    public Session getSession() {
        return session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public static ConcurrentHashMap<String, WebSocketServer> getWebSocketMap() {
        return webSocketMap;
    }

    public static void setWebSocketMap(ConcurrentHashMap<String, WebSocketServer> webSocketMap) {
        WebSocketServer.webSocketMap = webSocketMap;
    }
}
