package cn.yw.video.videostate.service;

 import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;
import cn.im.ptxztree.dao.PtxzsDao;
import cn.yw.machinemanage.dao.YwmachinecurrentstateDao;
import cn.yw.machinemanage.service.YwmachinecurrentstateService;
import cn.yw.video.videostate.dao.YwvideocurrentstateDao;

@Service("ywvideocurrentstateService")
public class YwvideocurrentstateService extends BaseService {
	
	private static Log log = LogFactory.getLog(YwvideocurrentstateService.class);
	
	@Autowired
	private YwvideocurrentstateDao ywvideocurrentstateDao;
	@Autowired
	private PtxzsDao ptxzsDao;
	@Autowired
	private YwmachinecurrentstateService ywmachinecurrentstateService;
	
	public Map statisticsVideoOnlineRate(Map param) throws SQLException{
		Map result = ywvideocurrentstateDao.statisticsVideoOnlineRate(param);
		return result;
	}
	public Map statisticsVideoIntactRate() throws SQLException{
		return ywvideocurrentstateDao.statisticsVideoIntactRate();
	}
	public Map statisticsRecordIntactRate() throws SQLException{
		return ywvideocurrentstateDao.statisticsRecordIntactRate();
	}
	public Map videoCurrentStateStatistics(Map map) throws SQLException{
		Map<String,String> result= new HashMap<String,String>();
		List<Map> lists = ywvideocurrentstateDao.videoCurrentStateStatistics(map);
		if(lists!=null && lists.size()>0){
			for(Map m : lists){
				result.put(m.get("name")+"", m.get("total")+"");
			}
		}
		return result;
	}
	
	/**
	 * ¼
	 */
	/*
	public void insert_Ywvideocurrentstate(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywvideocurrentstateDao.insert_Ywvideocurrentstate(map);
	}
	*/

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Ywvideocurrentstate(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ywvideocurrentstateDao.update_Ywvideocurrentstate(map);
	}
	public Integer update_Ywvideocurrentstate_WorkOrder(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ywvideocurrentstateDao.update_Ywvideocurrentstate_WorkOrder(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer delete_Ywvideocurrentstate(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywvideocurrentstateDao.delete_Ywvideocurrentstate(map);
	}
	*/
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer batch_delete_Ywvideocurrentstate(Map map) throws SQLException{
		return ywvideocurrentstateDao.batch_delete_Ywvideocurrentstate(map);
	}
	*/
	
	/**
	 * ѯ
	 */
	public Integer count_Ywvideocurrentstate(Map map) throws SQLException{
		return ywvideocurrentstateDao.count_Ywvideocurrentstate(map);
	}
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Ywvideocurrentstate(Map map) throws SQLException{
		return ywvideocurrentstateDao.query_Ywvideocurrentstate(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	public Map get_Ywvideocurrentstate(Map map) throws SQLException{
		return ywvideocurrentstateDao.get_Ywvideocurrentstate(map);
	}
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwvideocurrentstate(Map map) throws SQLException{
		return this.listYwvideocurrentstateByPage(map);
	}
	*/
	
	/**
	 * Ywvideocurrentstate ҳ
	 */
	public Map listYwvideocurrentstateByPage(Map map) throws SQLException {
		List<Map> list = ywvideocurrentstateDao.query_Ywvideocurrentstate(map);
		Integer totalCount = ywvideocurrentstateDao.count_Ywvideocurrentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Map listVideoDetailByPage(Map map) throws SQLException {
		List<Map> list = ywvideocurrentstateDao.query_Ywvideocurrentstate_detail(map);
		Integer totalCount = ywvideocurrentstateDao.count_Ywvideocurrentstate_detail(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Map vdqStatisticsRegion(Map map) throws SQLException {
		List<Map> result = new ArrayList<Map>();
		List<Map> list = ywvideocurrentstateDao.vdqStatisticsRegion(map);
		Integer totalCount = ywvideocurrentstateDao.count_vdqStatisticsRegion(map);
		int monitorSum = 0,noinspectionSum = 0,zxSum = 0,lxSum = 0,
				videoabnormalSum = 0,videonormalSum = 0,nosignalstatusSum = 0,
				videoocclusionstatusSum = 0,scenechangestatusSum = 0,imgtoodarkstatusSum = 0,
				imgoverbrightstatusSum = 0,imgclearstatusSum = 0,imgcolorstatusSum = 0;
		for(Map m : list){
			Map<String,Object> mapTemp = new HashMap<String,Object>();
			mapTemp.put("videocatalog", m.get("videocatalog"));
			mapTemp.put("videocatalogname", m.get("videocatalogname")==null?"-":m.get("videocatalogname"));
			mapTemp.put("nosignalstatusnum", StringUtil.str2Numeric(m.get("nosignalstatusnum")+""));
			mapTemp.put("videoocclusionstatusnum", StringUtil.str2Numeric(m.get("videoocclusionstatusnum")+""));
			mapTemp.put("scenechangestatusnum", StringUtil.str2Numeric(m.get("scenechangestatusnum")+""));
			mapTemp.put("imgtoodarkstatusnum", StringUtil.str2Numeric(m.get("imgtoodarkstatusnum")+""));
			mapTemp.put("imgoverbrightstatusnum", StringUtil.str2Numeric(m.get("imgoverbrightstatusnum")+""));
			mapTemp.put("imgclearstatusnum", StringUtil.str2Numeric(m.get("imgclearstatusnum")+""));
			mapTemp.put("imgcolorstatusnum", StringUtil.str2Numeric(m.get("imgcolorstatusnum")+""));
			int jknum = StringUtil.str2Numeric(m.get("jknum")+"");//Ѳ
			int totalnum = StringUtil.str2Numeric(m.get("totalnum")+"");//λ
			mapTemp.put("totalnum", totalnum);
			mapTemp.put("noinspectionnum", totalnum-jknum);//δѲ
			int lxnum = StringUtil.str2Numeric(m.get("lxnum")+"");
			int zxnum = StringUtil.str2Numeric(m.get("zxnum")+"");
			mapTemp.put("lxnum", lxnum);//
			mapTemp.put("zxnum", zxnum);//
			int videoabnormalnum = StringUtil.str2Numeric(m.get("videoabnormalnum")+"");
			int videonormalnum = StringUtil.str2Numeric(m.get("videonormalnum")+"");
			mapTemp.put("videoabnormalnum", videoabnormalnum);//Ƶ쳣
			mapTemp.put("videonormalnum", videonormalnum);//Ƶ
			if(jknum==0){
				mapTemp.put("zxrate", "0%");
				mapTemp.put("videorate", "0%");
			}else{
				mapTemp.put("zxrate", new DecimalFormat("0.00").format((zxnum)*100.0/jknum)+"%");
				mapTemp.put("videorate", new DecimalFormat("0.00").format((videonormalnum)*100.0/jknum)+"%");
			}
			//ܼ
			monitorSum += totalnum;
			noinspectionSum += totalnum-jknum;
			zxSum += zxnum;
			lxSum += lxnum;
			videoabnormalSum += videoabnormalnum;
			videonormalSum += videonormalnum;
			nosignalstatusSum += StringUtil.str2Numeric(m.get("nosignalstatusnum")+"");
			videoocclusionstatusSum += StringUtil.str2Numeric(m.get("videoocclusionstatusnum")+"");
			scenechangestatusSum += StringUtil.str2Numeric(m.get("scenechangestatusnum")+"");
			imgtoodarkstatusSum += StringUtil.str2Numeric(m.get("imgtoodarkstatusnum")+"");
			imgoverbrightstatusSum += StringUtil.str2Numeric(m.get("imgoverbrightstatusnum")+"");
			imgclearstatusSum += StringUtil.str2Numeric(m.get("imgclearstatusnum")+"");
			imgcolorstatusSum += StringUtil.str2Numeric(m.get("imgcolorstatusnum")+"");
			result.add(mapTemp);
		}
		//ܼ
		Map<String,Object> totalMap = new HashMap<String,Object>();
		totalMap.put("monitorSum", monitorSum);
		totalMap.put("noinspectionSum", noinspectionSum);
		totalMap.put("zxSum", zxSum);
		totalMap.put("lxSum", lxSum);
		totalMap.put("videoabnormalSum", videoabnormalSum);
		totalMap.put("videonormalSum", videonormalSum);
		totalMap.put("nosignalstatusSum", nosignalstatusSum);
		totalMap.put("videoocclusionstatusSum", videoocclusionstatusSum);
		totalMap.put("scenechangestatusSum", scenechangestatusSum);
		totalMap.put("imgtoodarkstatusSum", imgtoodarkstatusSum);
		totalMap.put("imgoverbrightstatusSum", imgoverbrightstatusSum);
		totalMap.put("imgclearstatusSum", imgclearstatusSum);
		totalMap.put("imgcolorstatusSum", imgcolorstatusSum);
		if((zxSum+lxSum)!=0){
			//totalMap.put("zxrate", new DecimalFormat("0.00").format(zxSum*100.0/(zxSum+lxSum))+"%");
			totalMap.put("zxrate", new DecimalFormat("0.00").format(zxSum*100.0/monitorSum)+"%");
		}else{
			totalMap.put("zxrate","0.00%");
		}
		if((videoabnormalSum+videonormalSum)!=0){
			//totalMap.put("videorate", new DecimalFormat("0.00").format(videonormalSum*100.0/(videoabnormalSum+videonormalSum))+"%");
			totalMap.put("videorate", new DecimalFormat("0.00").format(videonormalSum*100.0/monitorSum)+"%");
		}else{
			totalMap.put("videorate","0.00%");
		}
		result.add(totalMap);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", result);
		return map;
	}
	// Ƶͳ
	public Integer count_vdqStatisticsRegion(Map map) throws SQLException {
		return ywvideocurrentstateDao.count_vdqStatisticsRegion(map);
	}
	// ͳ        ================== start
		public List<Map> query_areaOnline(Map map) throws SQLException{
			return ywvideocurrentstateDao.query_areaOnline(map);
		}
	public List<Map> query_xhdareaOnline(Map map) throws SQLException{
		return ywvideocurrentstateDao.query_xhdareaOnline(map);
	}

	public Integer count_xhdareaOnline(Map map) throws SQLException{
		return ywvideocurrentstateDao.count_xhdareaOnline(map);
	}

	public Integer count_areaOnline(Map map) throws SQLException{
			return ywvideocurrentstateDao.count_areaOnline(map);
		}
		
	public List<Map> query_AreaNotonlineDetail(Map map) throws SQLException{
		return ywvideocurrentstateDao.query_AreaNotonlineDetail(map);
	}
	public Integer count_AreaNotonlineDetail(Map map) throws SQLException{
		return ywvideocurrentstateDao.count_AreaNotonlineDetail(map);
	}
		// ͳ        ================== end

	//̖led
	public List<Map> query_AreaNotonlineDeviceDetail(Map map) throws SQLException{
		return ywvideocurrentstateDao.query_AreaNotonlineDeviceDetail(map);
	}
	public Integer count_AreaNotonlineDeviceDetail(Map map) throws SQLException{
		return ywvideocurrentstateDao.count_AreaNotonlineDeviceDetail(map);
	}

	// ҳͳ
		public Map count_HomepageFalultType(Map map) throws SQLException{
			Map res = ywvideocurrentstateDao.count_HomepageFalultType(map);
			return res;
		}
		// ҳ  мѯ豸
		public Map query_videoState(Map map) throws SQLException{
			List<Map> list = ywvideocurrentstateDao.query_videoState(map);
			Integer totalCount = ywvideocurrentstateDao.count_videoState(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			return map;
		}
	/**
	 * ȡ豸״
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map queryVideoTree(Map map) throws SQLException{
		//սmap
		Map<String,Object> result = new HashMap<String,Object>();
		//ȡϢ
		Map<String,Object> machineMap = new HashMap<String,Object>();
		List<Map> listMachine = ywmachinecurrentstateService.listMachineInfo(map);
		Map machineIntactMap =  ywmachinecurrentstateService.listStatisticsMachineIntactRate();
		machineMap.put("intactRate","0.00%");
		machineMap.put("children",listMachine);
		if(machineIntactMap!=null && machineIntactMap.size()>0){
			Integer machineIntactNum = StringUtil.str2Numeric(machineIntactMap.get("intactNum")+"");
			Integer machineUnIntactNum = StringUtil.str2Numeric(machineIntactMap.get("unIntactNum")+"");
			if((machineIntactNum+machineUnIntactNum)>0){
				machineMap.put("intactRate", new DecimalFormat("0.00").format(machineIntactNum*100.0/(machineIntactNum+machineUnIntactNum))+"%");
			}
		}
		result.put("machine", machineMap);
		//ȡϢ
		List<Map> listVideo = new ArrayList<Map>();
		String rootNode = StringUtil.transEmpty(map.get("sjxzbh")+"");
		List<Map> list = ptxzsDao.query_Ptxzs(map);
		if(list!=null && list.size()>0){
			for(Map m : list){
				StringBuilder conditionXzbh = new StringBuilder();
				Map<String,Object> tempMap = new HashMap<String,Object>();
				String xzbh = StringUtil.transEmpty(m.get("xzbh")+"");
				conditionXzbh.append(" and videocatalog in ('").append(xzbh).append("'");
				conditionXzbh = getAllXzbh(xzbh,conditionXzbh).append(")");
				tempMap.put("tableparam", conditionXzbh.toString());
				//ȡĿ¼豸Ϣ
				List<Map> videoList = ywvideocurrentstateDao.getDpVideoByXzbh(tempMap);
				List<Map> intactList = ywvideocurrentstateDao.getDpIntact(tempMap);
				if(intactList!=null && intactList.size()>0){
					Integer total = 0;
					Integer intactNum = 0;
					for(Map intactM : intactList){
						String name = intactM.get("name")+"";
						if("total".equals(name)){
							total = StringUtil.str2Numeric(intactM.get("total")+"");
						}else if("intactnum".equals(name)){
							intactNum = StringUtil.str2Numeric(intactM.get("total")+"");
							
						}
					}
					if(total>0){
						tempMap.put("intactRate", new DecimalFormat("0.00").format(intactNum*100.0/total)+"%");
					}else{
						tempMap.put("intactRate", "0.00%");
						
					}
							
				}
				tempMap.put("children", videoList);
				tempMap.put("xzbh", xzbh);
				tempMap.put("xzmc", m.get("xzmc"));
				listVideo.add(tempMap);
			}
		}
		result.put("video", listVideo);
		return result;
	}
	/**
	 * ݹȡĳڵ
	 * @param parentXzbh
	 * @param conditionXzbh
	 * @return
	 */
	public StringBuilder getAllXzbh(String parentXzbh,StringBuilder conditionXzbh){
//		String result = "('"+parentXzbh+"'";
		Map<String,String> map = new HashMap<String,String>();
		map.put("sjxzbh", parentXzbh);
		try {
			List<Map> list = ptxzsDao.query_Ptxzs(map);
			if(list!=null && list.size()>0){
				for(Map m : list){
					String xzbh = StringUtil.transEmpty(m.get("xzbh")+"");
					conditionXzbh.append(",'").append(xzbh).append("'");
					getAllXzbh(xzbh,conditionXzbh);
				}
			}else{
				return conditionXzbh;
			}
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
		return conditionXzbh;
		
	}

	public Map queryjsgs(Map map) throws SQLException {
		return  ywvideocurrentstateDao.queryjsgs(map);
	}
	public Integer updatejsgs(Map map) throws SQLException {
		return  ywvideocurrentstateDao.updatejsgs(map);
	}
	public Integer update_sbtdspsrRemarks(Map map) throws SQLException {
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return  ywvideocurrentstateDao.update_sbtdspsrRemarks(map);
	}
	public Integer update_ywvideocurrentstateRepairState(Map map) throws SQLException {
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return  ywvideocurrentstateDao.update_ywvideocurrentstateRepairState(map);
	}
}
