package cn.yw.detector.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.*;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.detector.service.DetectorService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

@SuppressWarnings({"all"})
@Component("detectorAction")
public class DetectorAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(DetectorAction.class);

    @Autowired
    private DetectorService service;

    /**
     * ҳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listDetectorByPage")
    public void listDetectorByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listDetectorByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-listDetectorByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯѾѲ豸
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listDetectortaskByPage")
    public void listDetectortaskByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listDetectortaskByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-listDetectorMy-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * ѯ
     */
    //@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Detector")
    public void count_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.count_Detector(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-count_Detector-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ Detector
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "query_Detector")
    public void query_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_Detector(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-query_Detector-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ һDetector
     */
    @OperateType(value = LogConstants.LOG_GET, info = "get_Detector")
    public void get_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.get_Detector(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorActionquery_Detector-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "deleteDetector")
    public void delete_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!CommUtils.isEmpty(map)) {
                int result = service.delete_Detector(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                throw new Exception("ȷѡɾ¼!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-delete_Detector-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Detector")
    public void insert_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("id"))) {
                map.put("id", StringUtil.getUUID().substring(0, 20));
            }
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
            map.put("create_user", username);
            map.put("updatetime", new Date());
            //map.put("detectionstarttime", DateUtil.currentDateTime());

            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Detector(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    service.insert_Detector(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                service.insert_Detector(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-insert_Detector()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Detector")
    public void update_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();

            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Detector(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    int result = service.update_Detector(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                int result = service.update_Detector(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-update_Detector-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }
    /**
     * ޸ıעά״̬
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_DetectorRemarks")
    public void update_DetectorRemarks() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if(RHUtil.isNotEmpty(map.get("remarks")) && map.get("remarks").equals("survey")){
                map.put("repairstate",900);
            }
            int result = service.update_DetectorRemarks(map);
            Struts2Utils.renderJson(Constants.SUCCESS);

        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-update_DetectorRemarks -error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ͨ޸豸γ
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "updateDetctorJdWdByXh")
    public void updateDetctorJdWdByXh() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int result = service.updateDetctorJdWdByXh(map);
            if (result == 1) {
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                Struts2Utils.renderJson(null);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SbtdspsrAction - updateJdWdByXh : error === " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ񼯺
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_channelset_Detector")
    public void delete_channelset_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.isEmpty(map.get("taskid"))) {
                Struts2Utils.renderJson(Constants.FAIL);
                return;
            }
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
            map.put("modifyaccount", username);
            map.put("modifytime", DateUtil.currentDateTime());

            int result = service.delete_channelset_Detector(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-delete_channelset_Detector-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "batch_delete_Detector")
    public void batch_delete_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String keyword = map.get("keyword").toString();
            if (StringUtil.isEmpty(keyword)) {
                Struts2Utils.renderJson(null);
                return;
            } else {
                List<String> lists = new ArrayList<String>();
                String[] ids = keyword.split(",");
                for (int i = 0; i < ids.length; i++) {
                    lists.add(ids[i]);
                }
                if (lists != null && lists.size() > 0) {

                    service.batch_delete_Detector(lists);
                }
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-batch_delete_Detector-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "batch_update_Detector")
    public void batch_update_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String keyword = map.get("keyword").toString();
            if (StringUtil.isEmpty(keyword)) {
                Struts2Utils.renderJson(null);
                return;
            } else {
//				List<String> lists = new ArrayList<String>();
                String[] ids = keyword.split(",");
//				for(int i=0;i<ids.length;i++){
//					lists.add(ids[i]);
//				}
//				if(lists!=null && lists.size()>0){
                if (ids != null && ids.length > 0) {
                    map.put("keyword", ids);
                    String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
                    map.put("modifyaccount", username);
                    map.put("modifytime", DateUtil.currentDateTime());
                    map.put("detectionstarttime", DateUtil.currentDateTime());
                    service.batch_update_Detector(map);
                }
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-batch_delete_Detector-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    @OperateType(value = LogConstants.LOG_QUERY, info = "listNhywxlydptaskByPage")
    public void listNhywxlydptaskByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.listNhywxlydptaskByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-listnhywxhdxjtaskByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    @OperateType(value = LogConstants.LOG_QUERY, info = "listDetectorNotaskByPage")
    public void listDetectorNotaskByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.listDetectorNotaskByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-listnhywxhdxjtaskByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    //ɾ豸id
    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_Nhywxlydp")
    public void delete_Nhywxlydp() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            this.service.delete_Nhywxlydp(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-delete_Nhywxlydp-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    //ɾ豸id
    @OperateType(value = LogConstants.LOG_DELETE, info = "batchdelete_Nhywxlydp")
    public void batchdelete_Nhywxlydp() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (RHUtil.isNotEmpty(map.get("keyword"))) {
                String ids=String.valueOf(map.get("keyword"));
                String[] keys = ids.split(",");
                map.put("ids", keys);
            }
            this.service.batchdelete_Nhywxlydp(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-batchdelete_Nhywxlydp-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    //豸id
    @OperateType(value = LogConstants.LOG_DELETE, info = "batchinsert_Nhywxlydp")
    public void batchinsert_Nhywxlydp() {
        Map map = Struts2Utils.getRequestParameterMap();
        String keyword = map.get("keyword").toString();
        List maplist = new ArrayList<>();
        try {
            if (StringUtil.isEmpty(keyword)) {
                Struts2Utils.renderJson(null);
                return;
            } else {
                String[] ids = keyword.split(",");
                if (ids != null && ids.length > 0) {
                    for (String deviceid : ids) {
                        Map value = new HashMap();
                        value.put("id", StringUtil.getUUID());
                        value.put("deviceid", deviceid);
                        value.putAll(map);
                        maplist.add(value);
                    }
                    service.batchinsert_Nhywxlydp(maplist);

                }
            }
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-batchinsert_Nhywxlydp-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    // 
    @OperateType(value = LogConstants.LOG_UPDATE, info = "edit_Detector")
    public void edit_Detector() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (RHUtil.isNotEmpty(map.get("ids"))) {
                String ids = String.valueOf(map.get("ids"));
                String[] keys = ids.split(",");
                map.put("keys", keys);
            }
            int result = service.edit_Detector(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("nhywjtxhdglAction-edit_Ywmachineinfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * Excel
     */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Detector")
	public void exp_Detector(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Detector(map);
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
        	String dateTime=formart.format(new Date());
			Map params = new HashMap();
			params.put("fileName", "ά-"+dateTime);
			params.put("sheetName", "ά");
			params.put("header", "ά");
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("DetectorAction-exoprtExcel-error:" +e);

		}
	}
	*/

    /**
     * Excel
     */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Detector")
	public String imp_Detector(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0; <typeAlias
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {

			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("DetectorAction-imp_Detector-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/

    /**
     * ͳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "statisticsDetectorRate")
    public void statisticsDetectorRate() {
        try {
            Struts2Utils.renderJson(this.service.statisticsDetectorRate());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-statisticsDetectorRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    @OperateType(value = LogConstants.LOG_QUERY, info = "getALLDetetorStatusData")
    public void getALLDetetorStatusData() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            //źŵƵϢ
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(service.listDetectorStatus(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("DetectorAction-statisticsDetectorRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * ʵʱ״̬ѯ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listDetectorCurrentstateByPage")
    public void listDetectorCurrentstateByPage() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            if (null != Struts2Utils.getParameter("page")) {
                int page = Integer.parseInt(Struts2Utils.getParameter("page"));
                int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
                int start = ((page == 0 ? 1 : page) - 1) * rows;
                map.put("start", start);
                map.put("limit", rows);
                Struts2Utils.renderJson(this.service.listDetectorCurrentstateByPage(map));
            } else {
                Struts2Utils.renderJson(this.service.listDetectorCurrentstate(map));
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    @OperateType(value = LogConstants.LOG_QUERY, info = "listDetectorhistorystateByPage")
    public void listDetectorhistorystateByPage() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listDetectorhistorystateByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

}
