package cn.yw.aqmjc.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.aqmjc.service.GdwdaqmxxService;

@SuppressWarnings({"all"})
@Component("gdwdaqmxxAction")
public class GdwdaqmxxAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(GdwdaqmxxAction.class);
	
	@Autowired
	private GdwdaqmxxService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listGdwdaqmxxByPage")
	public void listGdwdaqmxxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listGdwdaqmxxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-listGdwdaqmxxByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Gdwdaqmxx")
	public void count_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Gdwdaqmxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-count_Gdwdaqmxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Gdwdaqmxx
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Gdwdaqmxx")
	public void query_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Gdwdaqmxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-query_Gdwdaqmxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һGdwdaqmxx
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Gdwdaqmxx")
	public void get_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Gdwdaqmxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxActionquery_Gdwdaqmxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteGdwdaqmxx")
	public void delete_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Gdwdaqmxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-delete_Gdwdaqmxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Gdwdaqmxx")
	public void insert_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("bjxxid"))){
				map.put("bjxxid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Gdwdaqmxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Gdwdaqmxx(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Gdwdaqmxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-insert_Gdwdaqmxx()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	/*
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Gdwdaqmxx")
	public void update_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Gdwdaqmxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Gdwdaqmxx(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Gdwdaqmxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-update_Gdwdaqmxx-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Gdwdaqmxx")
	public void batch_delete_Gdwdaqmxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Gdwdaqmxx(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-batch_delete_Gdwdaqmxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Gdwdaqmxx")
	public void exp_Gdwdaqmxx(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Gdwdaqmxx(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ȫñ--澯-"+dateTime);
			params.put("sheetName", "ȫñ--澯");
			params.put("header", "ȫñ--澯");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GdwdaqmxxAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Gdwdaqmxx")
	public String imp_Gdwdaqmxx(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("GdwdaqmxxAction-imp_Gdwdaqmxx-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
