package cn.yw.zxld.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.*;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.zxld.service.ZxldService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

@SuppressWarnings({"all"})
@Component("zxldAction")
public class ZxldAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(ZxldAction.class);

    @Autowired
    private ZxldService service;

    /**
     * ҳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listZxldByPage")
    public void listZxldByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listZxldByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-listZxldByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯѾѲ豸
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listZxldtaskByPage")
    public void listZxldtaskByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listZxldtaskByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-listZxldMy-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * ѯ
     */
    //@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Zxld")
    public void count_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.count_Zxld(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-count_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯZxld
     */
    @OperateType(value = LogConstants.LOG_GET, info = "query_Zxld")
    public void query_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_Zxld(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-query_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ һZxld
     */
    @OperateType(value = LogConstants.LOG_GET, info = "get_Zxld")
    public void get_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.get_Zxld(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldActionquery_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }



    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Zxld")
    public void insert_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("xh"))) {
                map.put("xh", StringUtil.getUUID());
            }
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
            map.put("create_user", username);
            map.put("create_time", DateUtil.currentDateTime());
            //map.put("detectionstarttime", DateUtil.currentDateTime());

            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Zxld(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    service.insert_Zxld(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                service.insert_Zxld(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-insert_Zxld()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Zxld")
    public void update_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();

            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Zxld(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    int result = service.update_Zxld(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                int result = service.update_Zxld(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-update_Zxld-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ޸ıעά״̬Ϣ
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_ZxldRemarks")
    public void update_ZxldRemarks() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if(RHUtil.isNotEmpty(map.get("bz"))&& map.get("bz").equals("survey")){
                map.put("repairstate",900);
            }
                int result = service.update_ZxldRemarks(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-update_ZxldRemarks-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }



    /**
     * ɾ񼯺
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "delete_channelset_Zxld")
    public void delete_channelset_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.isEmpty(map.get("taskid"))) {
                Struts2Utils.renderJson(Constants.FAIL);
                return;
            }
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
            map.put("modifyaccount", username);
            map.put("modifytime", DateUtil.currentDateTime());

            int result = service.delete_channelset_Zxld(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-delete_channelset_Zxld-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "batch_delete_Zxld")
    public void batch_delete_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String keyword = map.get("keyword").toString();
            if (StringUtil.isEmpty(keyword)) {
                Struts2Utils.renderJson(null);
                return;
            } else {
                List<String> lists = new ArrayList<String>();
                String[] ids = keyword.split(",");
                for (int i = 0; i < ids.length; i++) {
                    lists.add(ids[i]);
                }
                if (lists != null && lists.size() > 0) {
                    map.put("keyword",lists);
                    service.batch_delete_Zxld(map);
                }
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-batch_delete_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "batch_update_Zxld")
    public void batch_update_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String keyword = map.get("keyword").toString();
            if (StringUtil.isEmpty(keyword)) {
                Struts2Utils.renderJson(null);
                return;
            } else {
//				List<String> lists = new ArrayList<String>();
                String[] ids = keyword.split(",");
//				for(int i=0;i<ids.length;i++){
//					lists.add(ids[i]);
//				}
//				if(lists!=null && lists.size()>0){
                if (ids != null && ids.length > 0) {
                    map.put("keyword", ids);
                    String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
                    map.put("modifyaccount", username);
                    map.put("modifytime", DateUtil.currentDateTime());
                    map.put("detectionstarttime", DateUtil.currentDateTime());
                    service.batch_update_Zxld(map);
                }
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-batch_delete_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    @OperateType(value = LogConstants.LOG_QUERY, info = "listZxldNotaskByPage")
    public void listZxldNotaskByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.listZxldNotaskByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-listnhywxhdxjtaskByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    //ɾ豸id
    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_Zxld")
    public void delete_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            this.service.delete_Zxld(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-delete_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    //ɾ豸id
    @OperateType(value = LogConstants.LOG_DELETE, info = "batchdelete_Zxld")
    public void batchdelete_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {

            if (RHUtil.isNotEmpty(map.get("keyword"))) {
                String ids = String.valueOf(map.get("keyword"));
                String[] keys = ids.split(",");
                map.put("ids", keys);
            }
            this.service.batchdelete_Zxld(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-batchdelete_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    //豸id
    @OperateType(value = LogConstants.LOG_DELETE, info = "batchinsert_Zxld")
    public void batchinsert_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        String keyword = map.get("keyword").toString();
        List maplist = new ArrayList<>();
        try {
            if (StringUtil.isEmpty(keyword)) {
                Struts2Utils.renderJson(null);
                return;
            } else {
                String[] ids = keyword.split(",");
                if (ids != null && ids.length > 0) {
                    for (String deviceid : ids) {
                        Map value = new HashMap();
                        value.put("id", StringUtil.getUUID());
                        value.put("deviceid", deviceid);
                        value.putAll(map);
                        maplist.add(value);
                    }
                    service.batchinsert_Zxld(maplist);

                }
            }
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-batchinsert_Zxld-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    // 
    @OperateType(value = LogConstants.LOG_UPDATE, info = "edit_Zxld")
    public void edit_Zxld() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {

            if (RHUtil.isNotEmpty(map.get("ids"))) {
                String ids = String.valueOf(map.get("ids"));
                String[] keys = ids.split(",");
                map.put("keys", keys);
            }
            int result = service.edit_Zxld(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("nhywjtxhdglAction-edit_Ywmachineinfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * Excel
     */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Zxld")
	public void exp_Zxld(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Zxld(map);
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
        	String dateTime=formart.format(new Date());
			Map params = new HashMap();
			params.put("fileName", "ά-"+dateTime);
			params.put("sheetName", "ά");
			params.put("header", "ά");
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ZxldAction-exoprtExcel-error:" +e);

		}
	}
	*/

    /**
     * Excel
     */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Zxld")
	public String imp_Zxld(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {

			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("ZxldAction-imp_Zxld-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/

    /**
     * ͳ
     */
    @OperateType(value = LogConstants.LOG_GET, info = "statisticsZxldRate")
    public void statisticsZxldRate() {
        try {
            Struts2Utils.renderJson(this.service.statisticsZxldRate());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     *
     * ʵʱ״̬ѯ
     */
    @OperateType(value = LogConstants.LOG_GET, info = "listZxldcurrentstateByPage")
    public void listZxldcurrentstateByPage() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            if(null!=Struts2Utils.getParameter("page")) {
                int page = Integer.parseInt(Struts2Utils.getParameter("page"));
                int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
                int start = ((page == 0 ? 1 : page) - 1) * rows;
                map.put("start", start);
                map.put("limit", rows);
                Struts2Utils.renderJson(this.service.listZxldcurrentstateByPage(map));
            }else{

                Struts2Utils.renderJson(this.service.listZxldcurrentstate(map));
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     *
     * ʷ״̬ѯ
     */
    @OperateType(value = LogConstants.LOG_GET, info = "listZxldHistoryStateByPage")
    public void listZxldHistoryStateByPage() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listZxldHistoryStateByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     *
     *¾γΪգʵֵͼ豸Ƴ
     */
    @OperateType(value = LogConstants.LOG_GET, info = "updateZxldByXh")
    public void updateZxldByXh() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            Struts2Utils.renderJson(this.service.updateZxldByXh(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


}
