package cn.nhyw.khpj.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.nhyw.khpj.dao.YwglbmkhDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Service("ywglbmkhService")
public class YwglbmkhService extends BaseService {

	private static Log log = LogFactory.getLog(YwglbmkhService.class);

	@Autowired
	private YwglbmkhDao YwglbmkhDao;

	/**
	 * ¼
	 */
	public void insert_Ywglbmkh(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		YwglbmkhDao.insert_Ywglbmkh(map);
	}



	/**
	 * ޸ļ¼
	 */
	public Integer update_Ywglbmkh(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return YwglbmkhDao.update_Ywglbmkh(map);
	}


	/**
	 * ɾ¼
	 */
	public Integer delete_Ywglbmkh(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return YwglbmkhDao.delete_Ywglbmkh(map);
	}


	/**
	 * ɾ¼
	 */
	/*
	public Integer batch_delete_Ywglbmkh(Map map) throws SQLException{
		return YwglbmkhDao.batch_delete_Ywglbmkh(map);
	}
	*/

	/**
	 * ѯ
	 */
	public Integer count_Ywglbmkh(Map map) throws SQLException{
		return YwglbmkhDao.countYwglbmkh(map);
	}


	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Ywglbmkh(Map map) throws SQLException{
		return YwglbmkhDao.queryYwglbmkh(map);
	}


	/**
	 * EXCEL
	 */

	/*
	public Map exportYwglbmkh(Map map) throws SQLException{
		return this.listYwglbmkhByPage(map);
	}
	*/

	/**
	 * Ywglbmkh ҳ
	 */
	public Map listYwglbmkhByPage(Map map) throws SQLException {
		List<Map> list = YwglbmkhDao.queryYwglbmkh(map);
		Integer totalCount = YwglbmkhDao.countYwglbmkh(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

}
