package cn.bsystem.ptuserrole.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.service.SbtdjqqxService;
import cn.im.ptxztree.model.PtxzsBean;
import cn.im.ptxztree.service.PtxzsService;

@SuppressWarnings({"all"})
@Component("sbtdjqqxAction")
public class SbtdjqqxAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(SbtdjqqxAction.class);
	
	@Autowired
	private SbtdjqqxService service;
	@Autowired
	private PtxzsService ptxzsService;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listSbtdjqqxByPage")
	public void listSbtdjqqxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listSbtdjqqxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - listSbtdjqqxByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Sbtdjqqx")
	public void count_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Sbtdjqqx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - count_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Sbtdjqqx
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Sbtdjqqx")
	public void query_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Sbtdjqqx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - query_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һSbtdjqqx
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Sbtdjqqx")
	public void get_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Sbtdjqqx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - query_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteSbtdjqqx")
	public void delete_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Sbtdjqqx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - delete_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Sbtdjqqx")
	public void insert_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			service.insert_Sbtdjqqx(map);
			/*
			if(service.count_Sbtdjqqx_bybmbh(map)<=0){
				map.put("xh", StringUtil.getUUID());
				service.insert_Sbtdjqqx(map);
			}else{
				service.update_bmbh_Sbtdjqqx_bysbtd(map);
			}
			*/
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - insert_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Sbtdjqqx")
	public void update_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Sbtdjqqx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - update_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Sbtdjqqx_qx")
	public void update_Sbtdjqqx_qx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Sbtdjqqx_qx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - update_Sbtdjqqx_qx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Sbtdjqqx")
	public void batch_delete_Sbtdjqqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Sbtdjqqx(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - batch_delete_Sbtdjqqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listSbtdjqqx_ByUserRolePage")
	public void listSbtdjqqx_ByUserRolePage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listSbtdjqqx_ByUserRolePage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - listSbtdjqqx_ByUserRolePage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportSbtdjqqx(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("SbtdjqqxAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Sbtdjqqx_up_ByPage")
	public void query_Sbtdjqqx_up_ByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		Map rsMap = new HashMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			if(RHUtil.isEmpty(map.get("sjbmbh"))||"-1".equals(map.get("sjbmbh"))){
				Map smap = new HashMap();
				smap.put("khbh", map.get("khbh"));
				List<Map> ls = this.service.query_Xtkhtptdqx(smap);
				String tableparam = "";
				for(int i=0;i<ls.size();i++){
					Map khMap = (Map)ls.get(i);
					String wbbh = khMap.get("wbbh").toString();
					wbbh = wbbh.replace("?", "_");
					wbbh = wbbh.replace("*", "%");
					if(i==0){
						tableparam = tableparam+" AND ( cc.sbbh like '"+wbbh+"' ";
					}else{
						tableparam = tableparam +  " OR cc.sbbh like '"+wbbh+"' ";
					}
					if(i==ls.size()-1){
						tableparam = tableparam +  ") ";
					}
				}
				if("cc.sbbh like '%'".equals(tableparam)){
					tableparam = tableparam.replace("cc.sbbh like '%'", " 1=1 ");
				}
				Map khmap = new HashMap();
				khmap.put("khbh", map.get("khbh"));
				khmap.put("tdlx", map.get("tdlx"));
				khmap.put("bmbh", map.get("bmbh"));
				khmap.put("xzbh", map.get("xzbh"));
				khmap.put("LIKEsbbh", map.get("LIKEsbbh"));
				khmap.put("LIKEtdmc", map.get("LIKEtdmc"));
				khmap.put("tableparam", tableparam);
				khmap.put("order", map.get("order"));
				khmap.put("start", start);
				khmap.put("limit", rows);
				rsMap = this.service.list_kh_jqtd_right_ByPage(khmap);
			}else{
				rsMap = this.service.list_jg_jqtd_right_ByPage(map);
			}
			Struts2Utils.renderJson(rsMap);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdjqqxAction - query_Sbtdjqqx_up_ByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
}
