package cn.map.szmap.cache.impl;

import cn.base.util.RHUtil;
import cn.map.szmap.cache.AbstractCache;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitorCacheImpl extends AbstractCache {
	private static final Logger iLog = Logger.getLogger(MonitorCacheImpl.class);

	public final Long type;

	public MonitorCacheImpl(Long type) {
		this.type = type;
	}

	public void refreshAll(List<HashMap> list) {
		try {
			iLog.info("MonitorCacheImpl-------refreshAll"+list.size());
			System.out.println("MonitorCacheImpl-------refreshAll"+list.size());
			for (int i = 0; i < list.size(); i++) {
				Map m = list.get(i);
				m.put("id", m.get("sbbh")+"-"+m.get("tdbh"));
				String id = (String) m.get("id");
				m_cache.put(id, m);
				System.out.println("MonitorCacheImpl-------m_cache"+id);
				iLog.info("MonitorCacheImpl-------m_cache"+id);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MonitorCacheImpl refreshAll error ,layer type:"+type ,e);
			refreshTime.set(System.currentTimeMillis());
		
		}
	}

	@Override
	public List<Map> getData(Map condition) {
		// TODO Auto-generated method stub
		return null;
	}
	
	public void updateMonitorInfo(Map map){
		try {
			String id = (String) map.get("XGTJid");
			if (RHUtil.isNotEmpty(id)) {
				HashMap monitor = (HashMap) m_cache.get(id);
				if(RHUtil.isNotEmpty(monitor)){
					 monitor.put("jd", (String) map.get("jd"));
					 monitor.put("wd", (String) map.get("wd"));
					 m_cache.put(id, monitor);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("CheGpsLayerImpl  updateCheGpsInfo error ,layer type:"+type ,e);
		}
		
	}
	
	
}
