package cn.amq.business;

import java.util.List;

import org.apache.log4j.Logger;

import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.basis.AmqSubscribleBasisJob;
import cn.base.bean.BeanHelper;

import com.jtiny.utility.JtinyEvent;
/**
 * amqɹ
 * @author ThinkPad
 *
 */
public class AmqSubscribleJob extends AmqSubscribleBasisJob{
	static Logger logger = Logger.getLogger(AmqSubscribleJob.class);
	
	public AmqSubscribleJob(String url,List<String> subscribleSubjectList){
		super(url,subscribleSubjectList);
		JtinyEvent eventTimer=new JtinyEvent(AmqConst.AMQ_SETUP_INIT_EVENT,0,0,null,null,null);
		this.registerTimer(eventTimer, 5000);
	}
	
	public void doSubscirbleJob(AmqBasisEvent amqBasisMsg) {
		//ͳƴٸsubscribleϢ
		String msgType=amqBasisMsg.getMsgType();
		if(msgType.equalsIgnoreCase(AmqConst.AMQ_MSG_safetyHatAlarm)){
			//ܰȫñ澯Ϣ
			BeanHelper.getAmqSafetyHatAlarmService().doSafetyHatAlarmAction(amqBasisMsg);
		}else if(msgType.equalsIgnoreCase(AmqConst.AMQ_MSG_videoTaskAlarm)){
			logger.info("----------------------------ѲϢ");
			BeanHelper.getAmqVideoTaskAlarmService().doVideoTaskAlarmAction(amqBasisMsg);
		}else{
			logger.error("AmqSubscribleDispatchJob Received Unknow Message,Message Type="+msgType);
		}
	}
}