package cn.im.ptxztree.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.*;
import cn.im.ptxztree.model.PtxzsNode;
import cn.im.ptxztree.service.PtxzsService;
import cn.yw.video.videochannelset.service.SbtdspsrService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings({"all"})
@Component("ptxzsAction")
public class PtxzsAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtxzsAction.class);
	
	@Autowired
	private PtxzsService service;
	@Autowired
	private SbtdspsrService sbtdspsrService;
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtxzsByPage")
	public void listPtxzsByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listPtxzsByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - listPtxzsByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptxzs")
	public void count_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptxzs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - count_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptxzs
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptxzs")
	public void query_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptxzs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - query_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ѯ Ptxzs
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_PtxzsTree")
	@ResponseBody
	public void   query_PtxzsTree(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List<Map> list=this.service.query_PtxzsTree(map);
			List<PtxzsNode>  results=TreeUtil.buildByRecursive(hashMapInit(list));
			Struts2Utils.renderPtxJson(results);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - query_PtxzsTree() : error === " +e);
			//Struts2Utils.renderJson(null);
		}
	}

	public List<PtxzsNode> hashMapInit(List<Map> list){
		List<PtxzsNode> pList=new ArrayList<>();
		if(!list.isEmpty()){
			for(Map map:list){
				PtxzsNode ptxzsNode=new PtxzsNode();
				ptxzsNode.setId(map.get("id")==null?"":String.valueOf( map.get("id")));
				ptxzsNode.setName( map.get("name")==null?"":String.valueOf( map.get("name")));
				ptxzsNode.setPid(map.get("pid")==null?"":String.valueOf( map.get("pid")));
				pList.add(ptxzsNode);
			}
		}

		return pList;
	}

	/**
	 * ѯ Ptxzs
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtxzs")
	@ResponseBody
	public void   listPtxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List<Map> list=this.service.listPtxzs(map);
			Struts2Utils.renderPtxJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - query_listPtxzs() : error === " +e);
		}
	}

	/**
	 * ѯ һPtxzs
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptxzs")
	public void get_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptxzs(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - query_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtxzs")
	public void delete_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptxzs(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - delete_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptxzs")
	public void insert_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			//map.put("д", StringUtil.getUUID());
			service.insert_Ptxzs(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - listPtxzsByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptxzs")
	public void update_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptxzs(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - update_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptxzs")
	public void batch_delete_Ptxzs(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptxzs(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - batch_delete_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportPtxzs(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("PtxzsAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
	
	
	/**
	 * ɾ   Ŀ¼ʹ      ɾĿ¼  ¸Ŀ¼µ豸Ŀ¼Ϊ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_Ptxzs_ext")
	public void delete_Ptxzs_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptxzs(map);
				if(result > 0) {					// ɾɹ     豸Ŀ¼
					result = sbtdspsrService.update_SbtdspsrByXzbh(map);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtxzsAction - delete_Ptxzs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
}
