package cn.yw.video.videochannelset.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.video.videochannelset.service.SbtdspsrService;

@SuppressWarnings({"all"})
@Component("sbtdspsrAction")
public class SbtdspsrAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(SbtdspsrAction.class);
	
	@Autowired
	private SbtdspsrService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listSbtdspsrByPage")
	public void listSbtdspsrByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listSbtdspsrByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-listSbtdspsrByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Sbtdspsr_tdxx_ext")
	public void query_Sbtdspsr_tdxx_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.query_Sbtdspsr_tdxx_ext(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-listSbtdspsrByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listSbtdspsrToChannelSet")
	public void listSbtdspsrToChannelSet(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			PtyhBean userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
//			map.put("yhzh", userInfo.getYhzh());
			Integer sfgly = userInfo.getSfgly();
			if(sfgly != 1) {
				map.put("bmbh", userInfo.getBmbh()); // ȡű
			}
			//
			if (null != map.get("xzbh")) {
				String xzbh = map.get("xzbh").toString();
				map.put("xzbh", xzbh.split(","));
			}
			Struts2Utils.renderJson(this.service.listSbtdspsrToChannelSet(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-listSbtdspsrToChannelSet-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Sbtdspsr")
	public void count_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Sbtdspsr(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-count_Sbtdspsr-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Sbtdspsr
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Sbtdspsr")
	public void query_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Sbtdspsr(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-query_Sbtdspsr-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һSbtdspsr
	 */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Sbtdspsr")
	public void get_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Sbtdspsr(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrActionquery_Sbtdspsr-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_Sbtdspsr")
	public void delete_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Sbtdspsr(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-delete_Sbtdspsr-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Sbtdspsr")
	public void insert_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Sbtdspsr(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Sbtdspsr(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Sbtdspsr(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-insert_Sbtdspsr()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Sbtdspsr")
	public void update_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Sbtdspsr(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction - update_Sbtdspsr() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Sbtdspsr")
	public void batch_delete_Sbtdspsr(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Sbtdspsr(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-batch_delete_Sbtdspsr-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Sbtdspsr")
	public void exp_Sbtdspsr(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Sbtdspsr(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "豸ͨ-"+dateTime);
			params.put("sheetName", "豸ͨ");
			params.put("header", "豸ͨ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Sbtdspsr")
	public String imp_Sbtdspsr(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("SbtdspsrAction-imp_Sbtdspsr-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
	
	// Ŀ¼
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Sbtdspsr_ext")
	public void query_Sbtdspsr_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {

			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}


			Struts2Utils.renderJson(this.service.query_Sbtdspsr_ext(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-query_Sbtdspsr_ext-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Sbtdspsr_ext")
	public void get_Sbtdspsr_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			
			Map resMap = new HashMap();
			List list = service.query_Sbtdspsr_ext(map);
			int count = service.count_Sbtdspsr_ext(map);
			resMap.put("total", count);
			resMap.put("rows", list);
			Struts2Utils.renderJson(resMap);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction-query_Sbtdspsr_ext-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="batch_update_Sbtdspsr_xh")
	public void batch_update_Sbtdspsr_xh(){
		String xhs = Struts2Utils.getParameter("xhs");
		String xzbh = Struts2Utils.getParameter("xzbh");
		try {
			if(StringUtils.isNotBlank(xhs)&&StringUtils.isNotBlank(xzbh)){
				int result = service.batch_update_Sbtdspsr_xh(xhs,xzbh);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				Struts2Utils.renderJson(null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction - batch_update_Sbtdspsr() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Sbtdspsr")
	public void batch_delete_Sbtdspsr_xh(){
		String xhs = Struts2Utils.getParameter("xhs");
		String xzbh = Struts2Utils.getParameter("xzbh");
		try {
			if(StringUtils.isNotBlank(xhs)&&StringUtils.isNotBlank(xzbh)){
				int result = service.batch_delete_Sbtdspsr_xh(xhs,xzbh);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				Struts2Utils.renderJson(null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction - batch_delete_Sbtdspsr_xh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_SbtdspsrDetail")
	public void get_SbtdspsrDetail(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_SbtdspsrDetail(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction - get_SbtdspsrDetail() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ͨ޸豸γ
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateJdWdByXh")
	public void updateJdWdByXh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.updateJdWdByXh(map);
			if(result==1){
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				Struts2Utils.renderJson(null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction - updateJdWdByXh : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ͼ̬Ӽ豸
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getSbtdspsrList")
	public void getSbtdspsrList(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.getSbtdspsrList(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdspsrAction - getSbtdspsrList : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
}
