package cn.yw.archive.videoarchive.action;


import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.bean.BeanHelper;
import cn.base.conf.ModuleConfFactory;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExcelImport;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.FileCopyUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.archive.videoarchive.service.YwarchivevideoinfoService;

@SuppressWarnings({"all"})
@Component("ywarchivevideoinfoAction")
public class YwarchivevideoinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwarchivevideoinfoAction.class);
	
	private File file;
	private String fileContentType;
	private String fileFileName;
	
	public void setFile(File file) {
		this.file = file;
	}
	public File getFile() {
		return file;
	}
	public String getFileContentType() {
		return fileContentType;
	}

	public String getFileFileName() {
		return fileFileName;
	}
	
	public void setFileContentType(String fileContentType) {
		this.fileContentType = fileContentType;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}


	@Autowired
	private YwarchivevideoinfoService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwarchivevideoinfoByPage")
	public void listYwarchivevideoinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwarchivevideoinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-listYwarchivevideoinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywarchivevideoinfo")
	public void count_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywarchivevideoinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-count_Ywarchivevideoinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywarchivevideoinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywarchivevideoinfo")
	public void query_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywarchivevideoinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-query_Ywarchivevideoinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwarchivevideoinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywarchivevideoinfo")
	public void get_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywarchivevideoinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoActionquery_Ywarchivevideoinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwarchivevideoinfo")
	public void delete_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywarchivevideoinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-delete_Ywarchivevideoinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywarchivevideoinfo")
	public void insert_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", time);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(StringUtil.checkEmpty(map.get("archivevideoid"))){
				map.put("archivevideoid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywarchivevideoinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywarchivevideoinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywarchivevideoinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-insert_Ywarchivevideoinfo()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywarchivevideoinfo")
	public void update_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywarchivevideoinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywarchivevideoinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywarchivevideoinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-update_Ywarchivevideoinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywarchivevideoinfo")
	public void batch_delete_Ywarchivevideoinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keywords = map.get("keyword").toString();
			if(RHUtil.isNotEmpty(keywords)) {
				String[] ids = keywords.split(",");
				map.clear();
				map.put("ids", ids);
			}
			int result = service.batch_delete_Ywarchivevideoinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-batch_delete_Ywarchivevideoinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ת   columnnameѯ  뼰
	public void queryByColumnname(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.queryByColumnname(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoActionquery_queryByColumnname-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywarchivevideoinfo")
	public void exp_Ywarchivevideoinfo(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywarchivevideoinfo(map);
			if(RHUtil.isNotEmpty(sList)) {


			}
			
			String[] zdbm = {"channelname", "videofactorymc","cameratypemc","videoresolutionmc","videoinstalladdress","videopointname","installpositiontypemc","builddepartmentmc"};                          
			String[] zdmc = {"豸", "豸","","ֱ","װַ","λ׳","⡢","貿"};
			int excelNum = zdbm.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}			
			new ExportEngine().exportCommExcel("һһ", cells, sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivevideoinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	
	/**
	 * Excel
	 * @throws Exception 
	 */
	/*@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywarchivevideoinfo")
	public void imp_Ywarchivevideoinfo() throws Exception {
		
		String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
		String time = DateUtil.getDateTimeStr(new Date());

		// 貿     
		Map<String,String> xjjsbmMap = new HashMap<String,String>();
		xjjsbmMap.put("Խ", "0");
		xjjsbmMap.put("ᵥλʽ蹫", "1");
		xjjsbmMap.put("ʽ蹫ʹ", "2");
		xjjsbmMap.put("ӹͼ", "3");
		xjjsbmMap.put("ᵥλ", "4");
		xjjsbmMap.put("ᵥλ", "5");
		xjjsbmMap.put("ƶ", "6");
		xjjsbmMap.put("ָһҼڲ", "7");
		xjjsbmMap.put("", "8");
		xjjsbmMap.put("", "9");
		
		// 	Ǳ
		Map<String,String> bmsxMap = new HashMap<String,String>();
		bmsxMap.put("", "0");
		bmsxMap.put("", "1");
		
		//      Ǳ
		Map<String,String> xjglMap = new HashMap<String,String>();
		xjglMap.put("", "1");
		xjglMap.put("Ա", "2");
		xjglMap.put("΢", "3");
		xjglMap.put("", "4");
		xjglMap.put("ͨ", "5");
		
		//            
		Map<String,String> xjjzMap = new HashMap<String,String>();
		xjjzMap.put("񶽲", "1");
		xjjzMap.put("ΰ", "2");
		xjjzMap.put("ͨ", "3");
		xjjzMap.put("ŷ", "4");
		xjjzMap.put("뾳", "5");
		xjjzMap.put("", "6");
		xjjzMap.put("վ", "7");
		xjjzMap.put("", "8");
		
		// ص		
		Map<String,String> jklxMap = new HashMap<String,String>();
		jklxMap.put("һƵ", "1");
		jklxMap.put("Ƶ", "2");
		jklxMap.put("Ƶ", "3");
		jklxMap.put("ڲ", "4");

		// ʹ 		
		Map<String,String> syMap = new HashMap<String,String>();
		syMap.put("", "1");
		syMap.put("", "2");
		syMap.put("Ĳ", "3");
		syMap.put("ҽƲ", "4");
		syMap.put("ι", "5");
		syMap.put("Ź", "6");
		syMap.put("ʳƷҽҩල", "7");
		syMap.put("", "8");
		syMap.put("Ժ", "9");
		syMap.put("Ժ", "10");
		syMap.put("ڲ", "11");
		syMap.put("ͨ", "12");
		syMap.put("סͳ罨貿", "13");
		syMap.put("ˮ", "14");
		syMap.put("ҵ", "15");
		syMap.put("ȫල", "16");
		syMap.put("ί", "17");
		syMap.put("", "18");
		
		// λ          
		Map<String,String> xjwzMap = new HashMap<String,String>();
		xjwzMap.put("ʡʼվ", "1");
		xjwzMap.put("", "2");
		xjwzMap.put("վͷ", "3");
		xjwzMap.put("Ĺ㳡", "4");
		xjwzMap.put("", "5");
		xjwzMap.put("ҵ", "6");
		xjwzMap.put("ڽ̳", "7");
		xjwzMap.put("У԰ܱ", "8");
		xjwzMap.put("ΰ", "9");
		xjwzMap.put("ͨ", "10");
		xjwzMap.put("мʹվ", "96");
		xjwzMap.put("ⳡ", "97");
		xjwzMap.put("߾", "98");
		xjwzMap.put("ξ", "99");

		//װλ /         Ǳ
		Map<String,String> nwMap = new HashMap<String,String>();
		nwMap.put("", "1");
		nwMap.put("", "2");
		
		//ӷλ			Ǳ
		Map<String,String> fwMap = new HashMap<String,String>();
		fwMap.put("", "1");
		fwMap.put("", "2");
		fwMap.put("", "3");
		fwMap.put("", "4");
		fwMap.put("", "5");
		fwMap.put("", "6");
		fwMap.put("", "7");
		fwMap.put("", "8");
		fwMap.put("ȫ", "9");
		
		//			
		Map<String,String> lwMap = new HashMap<String,String>();
		lwMap.put("", "0");
		lwMap.put("δ", "1");
		
		// 豸   		
		Map<String,String> sbcsMap = new HashMap<String,String>();
		sbcsMap.put("", "1");
		sbcsMap.put("", "2");
		sbcsMap.put("ΰҵ", "3");
		sbcsMap.put("ƴ", "4");
		sbcsMap.put("Ѷʿ", "5");
		sbcsMap.put("", "6");
		sbcsMap.put("ǰ", "7");
		sbcsMap.put("Ӣ", "8");
		sbcsMap.put("", "9");
		sbcsMap.put("", "10");
		sbcsMap.put("ǵ", "11");
		sbcsMap.put("", "12");
		sbcsMap.put("", "13");
		sbcsMap.put("", "14");
		sbcsMap.put("", "99");
		
		// 		Ǳ
		Map<String,String> xjlxMap = new HashMap<String,String>();
		xjlxMap.put("ɿ", "1");
		xjlxMap.put("̶", "2");
		xjlxMap.put("̶ǹ", "3");
		xjlxMap.put("̨ǹ", "4");
		xjlxMap.put("ǹ", "5");
		xjlxMap.put("δ֪", "99");
		
		//		Ǳ
		Map<String,String> bgMap = new HashMap<String,String>();
		bgMap.put("޲", "1");
		bgMap.put("ⲹ", "2");
		bgMap.put("׹ⲹ", "3");
		
		// ֱ		Ǳ
		Map<String,String> xjfblMap = new HashMap<String,String>();
		xjfblMap.put("QCIF", "1");
		xjfblMap.put("CIF", "2");
		xjfblMap.put("4CIF", "3");
		xjfblMap.put("DI", "4");
		xjfblMap.put("720P", "5");
		xjfblMap.put("1080P", "6");
		xjfblMap.put("", "7");
		
		// ʽ
		Map<String,String> bmgsMap = new HashMap<String,String>();
		bmgsMap.put("MPEG-4", "1");
		bmgsMap.put("H.264", "2");
		bmgsMap.put("SVACչ", "3");
		bmgsMap.put("H.265", "4");
		
		// Ƶֱ
		Map<String,String> spfblMap = new HashMap<String,String>();
		spfblMap.put("", "1");
		spfblMap.put("", "2");
		spfblMap.put("", "3");
		
		// Ƶź
		Map<String,String> spxhlxMap = new HashMap<String,String>();
		spxhlxMap.put("", "1");
		spxhlxMap.put("ģ", "2");
		
		// 豸״̬
		Map<String,String> sbztMap = new HashMap<String,String>();
		sbztMap.put("", "1");
		sbztMap.put("ά", "2");
		sbztMap.put("", "3");
		
		// Ƿ  / ƽ̨
		Map<String,String> ynMap = new HashMap<String,String>();
		ynMap.put("", "1");
		ynMap.put("", "2");
		
		
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		
		int rkNum = 0;
		int reprkNum = 0;
		
		Map params = Struts2Utils.getRequestParameterMap();
		String sbbh = (String) params.get("sbbh");				// Ƿ񸲸
		
		InputStream inputStream = null;
		String uuid = StringUtil.getUUID();
		try {
	        String rootpath = ModuleConfFactory.getInstance().getScatter().getDownPath(); // private.xmlжȡļ·
	        String path = rootpath+uuid+"\\";
	        File tempPathFile = new File(path);
			if (!tempPathFile.exists()) {
				tempPathFile.mkdirs();
			}
			int isSuccess = 0;
			try{
				inputStream = new FileInputStream(file);
				isSuccess  = FileCopyUtil.copy(inputStream, new BufferedOutputStream(new FileOutputStream(path+fileFileName)));
			}catch(Exception e){
			}finally{
				if(inputStream!=null){
					try {
						inputStream.close();
					} catch (IOException ex) {
					}
				}
			}
			
			
			List<Map> list = new ArrayList();		
			List xhList = new ArrayList();					// xhǷظ
			List failList = new ArrayList();				// Ϣ
			Map<String,Map> repeatMap = new HashMap();		// һظ
			List<Map> repeatList = new ArrayList();			// ظ
			List repeatMsgList = new ArrayList();			// ظݵķϢ
			String failMsg = "";
			String repeatMsg = "";
			String nullMsg = "ݲΪ";
			String transMsg = "ת";
			
	        String[] headArr = {"0","","豸","豸","豸","","ص","豸ͺ","λ׳","IPV4ַ",
	        					"IPV6ַ","MACַ","","","","ʽ","Ӧ洢豸IP",
	        					"Ӧ豸ͨ","װַ","","γ","λ","ӷ","ԤURL","",
	        					"Ͻ","װʱ","λ","λϵʽ","¼񱣴","豸״̬","/ҵ",
	        					"Ƶֱ","Ƶͺ","Ƿ⹲","Ƿƽ̨","̱","Ӧ","װ߶",
	        					"Ӿ","û","","Ӳ¼û","Ӳ¼"};
			int count = 0;
			ExcelImport readExcel = new ExcelImport();
			readExcel.openFile(path+fileFileName);
			readExcel.setSheetNum(0);
			int cellNum = 0;
			count = readExcel.getRowCount();
			 for (int i = 2; i < count; i++) { 
	            String[] rows = readExcel.readExcelLine(i,0);
	            cellNum = rows.length;
	            for(int j=0; j < cellNum; j++) {
	            	String str = readExcel.readStringExcelCell(i,j);		// ȡÿԪ	
	            	System.out.print(""+i+"У"+j+"У"+str + "  ");
	            }
	            System.out.print("\n");
				 Map map = new HashMap();				//  excel Ԫ
				 boolean repeatflag = false;		//Ƿظ
				 boolean flag = true;				//ǷΪ      Ƿȷ
				 
				 int j = 0;                    // ӵ0пʼ
				 String xh = readExcel.readStringExcelCell(i,j++);				
				 
				 String outsidecode = readExcel.readStringExcelCell(i, j++);		// 豸				 
				 if(RHUtil.isEmpty(outsidecode)) {
					 flag = false;					 
				//	 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1, colStr, nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 if(xhList.contains(outsidecode)) {
						 repeatflag = true;
						 repeatNum++;
				//		 Map repMsg = getErrorMsg(i+1, j, "ظ(豸ظ)", outsidecode, xh);
						 repeatMsg = "ţ"+xh+","+(i+1)+","+j+"("+headArr[j]+"),豸룺"+outsidecode+", ظ";
						 repeatMsgList.add(repeatMsg);
					 }else {
						 xhList.add(xh);
					 }
				 }
				 map.put("outsidecode", outsidecode);
				 
				 String channelname = readExcel.readStringExcelCell(i, j++);		//豸
				 if(RHUtil.isEmpty(channelname)) {
					 flag = false;
		//			 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("channelname", channelname);
				 
				 String videofactoryMc = readExcel.readStringExcelCell(i, j++);		//豸         תΪ
				 if(RHUtil.isEmpty(videofactoryMc)) {
					 flag = false;
		//			 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String videofactory = sbcsMap.get(videofactoryMc);
					 if(RHUtil.isEmpty(videofactory)) {
						 flag = false;
			//			 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("videofactory", videofactory);
					 }
				 }
				 
				 
				 String areacode = readExcel.readStringExcelCell(i, j++);				// 
				 if(RHUtil.isEmpty(areacode)) {
					 flag = false;
				//	 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("areacode", areacode);
				 
				 String videopointtypeMc = readExcel.readStringExcelCell(i, j++);		// ص
				 if(RHUtil.isEmpty(videopointtypeMc)) {
					 flag = false;
				//	 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String videopointtype = jklxMap.get(videopointtypeMc);
					 if(RHUtil.isEmpty(videopointtype)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else{
						 map.put("videopointtype", videopointtype);
					 }
				 }
				 
				 
				 String videomodel = readExcel.readStringExcelCell(i, j++);				// 豸ͺ
				 map.put("videomodel", videomodel);
				 
				 String videopointname = readExcel.readStringExcelCell(i, j++);			// λ׳
				 map.put("videopointname", videopointname);
				 
				 String videoip = readExcel.readStringExcelCell(i, j++);				// ipv4ַ
				 map.put("videoip", videoip);
				 
				 String videoipv6 = readExcel.readStringExcelCell(i, j++);				// ipv6ַ
				 map.put("videoipv6", videoipv6);
				 
				 String videomacaddress = readExcel.readStringExcelCell(i, j++);				// MACַ
				 map.put("videomacaddress", videomacaddress);
				 
				 String cameratypeMc = readExcel.readStringExcelCell(i, j++);				//      Ǳ
				 if(RHUtil.isEmpty(cameratypeMc)) {
				//	 map.put("cameratype", cameratypeMc);
				 }else {
					 String cameratype = xjlxMap.get(cameratypeMc);
					 if(RHUtil.isEmpty(cameratype)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("cameratype", cameratype);
					 }
				 }
				 
				 
				 String videofunctiontypeMc = readExcel.readStringExcelCell(i, j++);		//      Ǳ
				 if(RHUtil.isEmpty(videofunctiontypeMc)) {
				//	 map.put("videofunctiontype", videofunctiontypeMc);
				 }else {
					 String videofunctiontype = xjglMap.get(videofunctiontypeMc);
					 if(RHUtil.isEmpty(videofunctiontype)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("videofunctiontype", videofunctiontype);
					 }
				 }
				 
				 
				 String cameralightpropertyMc = readExcel.readStringExcelCell(i, j++);				//     Ǳ
				 if(RHUtil.isNotEmpty(cameralightpropertyMc)) {
				//	 map.put("cameralightproperty", cameralightpropertyMc);
				 }else {
					 String cameralightproperty = bgMap.get(cameralightpropertyMc);
					 if(RHUtil.isEmpty(cameralightproperty)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("cameralightproperty", cameralightproperty);
					 } 
				 }
				 
				 
				 String videocodeformatMc = readExcel.readStringExcelCell(i, j++);				// ʽ      Ǳ
				 if(RHUtil.isEmpty(videocodeformatMc)) {
				//	 map.put("videocodeformat", videocodeformatMc);
				 }else {
					 String videocodeformat = bmgsMap.get(videocodeformatMc);
					 if(RHUtil.isEmpty(videocodeformat)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else{
						 map.put("videocodeformat", videocodeformat);
					 } 
				 }
				 
				 
				 String storageip = readExcel.readStringExcelCell(i, j++);				// Ӧ洢豸ip
				 map.put("storageip", storageip);
				 
				 String storagechannel = readExcel.readStringExcelCell(i, j++);				// Ӧ洢豸ͨ
				 map.put("storagechannel", storagechannel);

				 String videoinstalladdress = readExcel.readStringExcelCell(i, j++);				// װַ
				 if(RHUtil.isEmpty(videoinstalladdress)) {
					 flag = false;
		//			 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("videoinstalladdress", videoinstalladdress);
				 
				 String longitude = readExcel.readStringExcelCell(i, j++);				// 
				 if(RHUtil.isEmpty(longitude)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("longitude", longitude);
				 
				 String dimension = readExcel.readStringExcelCell(i, j++);				// γ
				 if(RHUtil.isEmpty(dimension)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("dimension", dimension);
				 
				 String camerapositiontypeMc = readExcel.readStringExcelCell(i, j++);				// λ
				 if(RHUtil.isEmpty(camerapositiontypeMc)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String camerapositiontype = xjwzMap.get(camerapositiontypeMc);
					 if(RHUtil.isEmpty(camerapositiontype)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("camerapositiontype", camerapositiontype);
					 } 
				 }
				 
				 
				 String monitorposition = readExcel.readStringExcelCell(i, j++);				// ӷ(Ƕ)
				 map.put("monitorposition", monitorposition);
				 
				 String monitorscenepicurl = readExcel.readStringExcelCell(i, j++);				// ԤƬURL
				 map.put("monitorscenepicurl", monitorscenepicurl);
				 
				 String networkpropertyMc = readExcel.readStringExcelCell(i, j++);				// 
				 if(RHUtil.isEmpty(networkpropertyMc)) {
					 flag = false;
		//			 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String networkproperty = lwMap.get(networkpropertyMc);
					 if(RHUtil.isEmpty(networkproperty)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("networkproperty", networkproperty);
					 }
				 }
				 
				
				 String areapolicecode = readExcel.readStringExcelCell(i, j++);				// Ͻ
				 if(RHUtil.isEmpty(areapolicecode)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("areapolicecode", areapolicecode);
				 
				 String monitorinstalltime = readExcel.readStringExcelCell(i, j++);				// װʱ
				 map.put("monitorinstalltime", monitorinstalltime);
				 
				 String manageunitname = readExcel.readStringExcelCell(i, j++);				// λ
				 if(RHUtil.isEmpty(manageunitname)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("manageunitname", manageunitname);
				 
				 String manageunitphone = readExcel.readStringExcelCell(i, j++);				// λϵʽ
				 if(RHUtil.isEmpty(manageunitphone)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ"; 
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }
				 map.put("manageunitphone", manageunitphone);
				 
				 String recordkeepdays = readExcel.readStringExcelCell(i, j++);				// ¼񱣴
				 map.put("recordkeepdays", recordkeepdays);
				 
				 String videostateMc = readExcel.readStringExcelCell(i, j++);				// 豸״̬
				 if(RHUtil.isEmpty(videostateMc)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 map.put("videostate", videostateMc);
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String videostate = sbztMap.get(videostateMc);
					 if(RHUtil.isEmpty(videostate)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("videostate", videostate);
					 } 
				 }
				 
				 
				 String useattributeMc = readExcel.readStringExcelCell(i, j++);				// /ҵ     ʹ
				 if(RHUtil.isEmpty(useattributeMc)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String useattribute = syMap.get(useattributeMc);
					 if(RHUtil.isEmpty(useattribute)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1,colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("useattribute", useattribute);
					 } 
				 }
				 
				
				 String videoresolutionMc = readExcel.readStringExcelCell(i, j++);				// Ƶֱ    Ǳ
				 if(RHUtil.isEmpty(videoresolutionMc)) {
				//	 map.put("videoresolution", videoresolutionMc);
				 }else {
					 String videoresolution = spfblMap.get(videoresolutionMc);
					 if(RHUtil.isEmpty(videoresolution)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("videoresolution", videoresolution);
					 }
				 }
				 
				 
				 String videosignaltypeMc = readExcel.readStringExcelCell(i, j++);				// Ƶź     Ǳ
				 if(RHUtil.isEmpty(videosignaltypeMc)) {
				//	 map.put("videosignaltype", videosignaltypeMc);
				 }else {
					 String videosignaltype = spxhlxMap.get(videosignaltypeMc);
					 if(RHUtil.isEmpty(videosignaltype)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("videosignaltype", videosignaltype);
					 } 
				 }
				 
				 
				 String isshareMc = readExcel.readStringExcelCell(i, j++);				// Ƿ⹲     Ǳ
				 if(RHUtil.isEmpty(isshareMc)) {
				//	 String isshare = ynMap.get(isshareMc);
				 }else {
					 String isshare = ynMap.get(isshareMc);
					 if(RHUtil.isEmpty(isshare)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("isshare", isshare);
					 } 
				 }
				 
				 
				 String isjointhreesystemMc = readExcel.readStringExcelCell(i, j++);				// Ƿƽ̨     Ǳ
				 if(RHUtil.isEmpty(isjointhreesystemMc)) {
				//	 map.put("isjointhreesystem", isjointhreesystemMc);
				 }else {
					 String isjointhreesystem = ynMap.get(isjointhreesystemMc);
					 if(RHUtil.isEmpty(isjointhreesystem)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("isjointhreesystem", isjointhreesystem);
					 } 
				 }
				 
				 
				 String keyboardnum = readExcel.readStringExcelCell(i, j++);				//  ̱
				 map.put("keyboardnum", keyboardnum);
				 
				 String builddepartmentMc = readExcel.readStringExcelCell(i, j++);				//  Ӧ
				 if(RHUtil.isEmpty(builddepartmentMc)) {
					 flag = false;
			//		 failMsg = ""+(i+1)+","+j+",ݲΪ";
					 String colStr = ""+j+",("+headArr[j]+")";
					 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
					 failList.add(errMap);
				 }else {
					 String builddepartment = xjjsbmMap.get(builddepartmentMc);
					 if(RHUtil.isEmpty(builddepartment)) {
						 flag = false;
//						 failMsg = ""+(i+1)+","+j+",ת";
						 String colStr = ""+j+",("+headArr[j]+")";
						 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
						 failList.add(errMap);
					 }else {
						 map.put("builddepartment", builddepartment);
					 }
				 }
				 
				 
				 String monitorininstallhight = readExcel.readStringExcelCell(i, j++);				//  װ߶
				 map.put("monitorininstallhight", monitorininstallhight);
				 
				 String monitorlookrange = readExcel.readStringExcelCell(i, j++);				//  Ӿ
				 map.put("monitorlookrange", monitorlookrange);
				 
				 String videousername = readExcel.readStringExcelCell(i, j++);				//  û
				 map.put("videousername", videousername);
				 
				 String videopassword = readExcel.readStringExcelCell(i, j++);				//    
				 map.put("videopassword", videopassword);
				 
				 String dvrusername = readExcel.readStringExcelCell(i, j++);				//  Ӳ¼û
				 map.put("dvrusername", dvrusername);
				 
				 String dvrpassword = readExcel.readStringExcelCell(i, j++);				//  Ӳ¼
				 map.put("dvrpassword", dvrpassword);
				 
				 
				 String archivevideoid = StringUtil.getUUID();
				 map.put("archivevideoid",archivevideoid);
				 map.put("createaccount", username);
				 map.put("createtime", time);
				 map.put("modifyaccount", username);
				 map.put("modifytime", time);
		//		 жǷظ   豸 Ƿظ
				 if(repeatflag && flag) {
					 repeatMap.put(outsidecode, map);			// excelеظ 豸	
					 repeatList.add(map);
				 }else {	
					 if(flag) {
						 list.add(map);				// Уȷظ
					 }else {
						 failNum++;
					 }
				 }	
				 
	        }

			File file = new File(path+fileFileName);
			if(file.exists()){
				file.delete();
				File dir = new File(rootpath+uuid);
				dir.delete();
			}
						
			// 
			if("1".equals(sbbh)) {				//   豸ͬ  
				for(Map rkMap : list) {
					String outsidecode = (String) rkMap.get("outsidecode");
					Map repMap = repeatMap.get(outsidecode);
					if(RHUtil.isEmpty(repMap)) {    // Ƿظ
						
					}else {
						list.remove(rkMap);
						list.add(repMap);
					}
				}
				// 
				if(list.size() > 0) {
					for(Map insertMap : list) {
						service.insert_Ywarchivevideoinfo(insertMap);
					}
					service.batch_insert_Ywarchivevideoinfo(list);
				}
				rkNum = list.size();               // 
			}else {
				// 
				if(list !=null && list.size() > 0) {
					for(Map insertMap : list) {
						service.insert_Ywarchivevideoinfo(insertMap);
					}
					service.batch_insert_Ywarchivevideoinfo(list);
					rkNum = list.size(); 
				}
				if(RHUtil.isNotEmpty(repeatList)) {
					//  豸ظ
					if(repeatList.size() > 0) {
						for(Map insertMap : repeatList) {
							service.insert_Ywarchivevideoinfo(insertMap);
						}
						service.batch_insert_Ywarchivevideoinfo(repeatList);
					}	
					rkNum = rkNum + repeatList.size();
				}
				
			}
			
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ (count-2) +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
//			System.out.println("count--->" + count);
//			System.out.println(rs);
			//   rkNum
			// ظ  reprkNum
			//    failNum
			reprkNum = repeatList.size();
			Map resMap = new HashMap();       // ǰչʾ
			resMap.put("repeatData", repeatMsgList);		// ظ
			resMap.put("failData", failList);				// ʧϢ
			resMap.put("sucNum", rkNum);					// 
			resMap.put("reprkNum", reprkNum);				// ǵ
			resMap.put("failNum", failNum);					// ʧܵ
			Struts2Utils.renderJson(resMap);
		} catch (Exception e) {			
			iLog.error("YwarchivevideoinfoAction-imp_Ywarchivevideoinfo-error:" +e);
			e.printStackTrace();
			Struts2Utils.renderJson(null);
		}		
	}
	*/
	
	@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywarchivevideoinfo")
	public void imp_Ywarchivevideoinfo() throws Exception {
		
		String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
		String time = DateUtil.getDateTimeStr(new Date());

		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		
		int rkNum = 0;
		int reprkNum = 0;
		
		Map params = Struts2Utils.getRequestParameterMap();
		String sbbh = (String) params.get("sbbh");				// Ƿ񸲸
		
		InputStream inputStream = null;
		String uuid = StringUtil.getUUID();
		try {
	        String rootpath = ModuleConfFactory.getInstance().getScatter().getDownPath(); // private.xmlжȡļ·
	        String path = rootpath+uuid+"\\";
	        File tempPathFile = new File(path);
			if (!tempPathFile.exists()) {
				tempPathFile.mkdirs();
			}
			int isSuccess = 0;
			try{
				inputStream = new FileInputStream(file);
				isSuccess  = FileCopyUtil.copy(inputStream, new BufferedOutputStream(new FileOutputStream(path+fileFileName)));
			}catch(Exception e){
			}finally{
				if(inputStream!=null){
					try {
						inputStream.close();
					} catch (IOException ex) {
					}
				}
			}
			
			
			List<Map> list = new ArrayList();		
			List xhList = new ArrayList();					// xhǷظ
			List failList = new ArrayList();				// Ϣ
			Map<String,Map> repeatMap = new HashMap();		// һظ
			List<Map> repeatList = new ArrayList();			// ظ
			List repeatMsgList = new ArrayList();			// ظݵķϢ
			
			List<String> outsidecodeList = service.queryOutsidecode(null);
			List<Map> editList = new ArrayList();          // ݿ ⲿظ
			
			String failMsg = "";
			String repeatMsg = "";
			String nullMsg = "ݲΪ";
			String transMsg = "ת";
			
	       
			int count = 0;
			ExcelImport readExcel = new ExcelImport();
			readExcel.openFile(path+fileFileName);
			readExcel.setSheetNum(0);
			int cellNum = 0;
			count = readExcel.getRowCount();
			
			if(count > 2) {
				// ѯ excel Ϣ
				List<Map> colList = service.getExeclColname(null);
				Map<String,String> colnum_keyMap = new HashMap();
				Map<String,String> colnum_headMap = new HashMap();
				Map<String,String> colnum_checkMap = new HashMap();
				if(RHUtil.isNotEmpty(colList)) {
					for(Map map : colList) {
						String columnnum = (String) map.get("columnnum");
						String columnname = (String) map.get("columnname");
						String checktype = (String) map.get("checktype");
						String remarks = (String) map.get("remarks");
						colnum_keyMap.put(columnnum, columnname);
						colnum_headMap.put(columnnum, remarks);
						colnum_checkMap.put(columnnum, checktype);
					}
				}else {
					// ˵ûywarchivevideoimportchecköӦexcelϢ
					
				}
				
				// ҪתΪ
				List<Map> transList = service.getExeclCodeName(null);
				// 貿     
				Map<String,String> xjjsbmMap = new HashMap<String,String>();								
				// 	Ǳ
				Map<String,String> bmsxMap = new HashMap<String,String>();				
				//      Ǳ
				Map<String,String> xjglMap = new HashMap<String,String>();														
				// ص		
				Map<String,String> jklxMap = new HashMap<String,String>();				
				// ʹ 		
				Map<String,String> syMap = new HashMap<String,String>();								
				// λ          
				Map<String,String> xjwzMap = new HashMap<String,String>();				
				//װλ /         Ǳ
				Map<String,String> nwMap = new HashMap<String,String>();				
				//ӷλ			Ǳ
				Map<String,String> fwMap = new HashMap<String,String>();								
				//			
				Map<String,String> lwMap = new HashMap<String,String>();								
				// 豸   		
				Map<String,String> sbcsMap = new HashMap<String,String>();								
				// 		Ǳ
				Map<String,String> xjlxMap = new HashMap<String,String>();								
				//		Ǳ
				Map<String,String> bgMap = new HashMap<String,String>();								
				// ֱ		Ǳ
				Map<String,String> xjfblMap = new HashMap<String,String>();								
				// ʽ
				Map<String,String> bmgsMap = new HashMap<String,String>();				
				// Ƶֱ
				Map<String,String> spfblMap = new HashMap<String,String>();				
				// Ƶź
				Map<String,String> spxhlxMap = new HashMap<String,String>();								
				// 豸״̬
				Map<String,String> sbztMap = new HashMap<String,String>();								
				// Ƿ  
				Map<String,String> gxMap = new HashMap<String,String>();
				// ƽ̨
				Map<String,String> sjptMap = new HashMap<String,String>();
				
				if(RHUtil.isNotEmpty(transList)) {
					for(Map transMap : transList) {
						String columnname = (String) transMap.get("columnname");
						String code = (String) transMap.get("code");
						String codename = (String) transMap.get("codename");
						if("cameratype".equals(columnname)) {				// 
							xjlxMap.put(codename, code);
						}else if("videofunctiontype".equals(columnname)) {	// 
							xjglMap.put(codename, code);
						}else if("cameralightproperty".equals(columnname)) {      // 
							bgMap.put(codename, code);
						}else if("videocodeformat".equals(columnname)) {   // ʽ
							bmgsMap.put(codename, code);
						}else if("camerapositiontype".equals(columnname)) {  // λ
							xjwzMap.put(codename, code);
						}else if("monitorposition".equals(columnname)) {		//ӷλ	
							fwMap.put(codename, code);
						}else if("networkproperty".equals(columnname)) {  // 
							lwMap.put(codename, code);
						}else if("videostate".equals(columnname)) {  // 豸״̬
							sbztMap.put(codename, code);
						}else if("videofactory".equals(columnname)) {  // 豸
							sbcsMap.put(codename, code);
						}else if("useattribute".equals(columnname)) {  // /ҵ
							syMap.put(codename, code);
						}else if("videoresolution".equals(columnname)) {  // Ƶֱ
							spfblMap.put(codename, code);
						}else if("videosignaltype".equals(columnname)) {  // Ƶź
							spxhlxMap.put(codename, code);
						}else if("isshare".equals(columnname)) {  // Ƿ⹲
							gxMap.put(codename, code);
						}else if("isjointhreesystem".equals(columnname)) {  // Ƿƽ̨
							sjptMap.put(codename, code);
						}else if("builddepartment".equals(columnname)) {  // Ӧ
							xjjsbmMap.put(codename, code);
						}else if("videopointtype".equals(columnname)) {  // ص
							jklxMap.put(codename, code);
						}
					}
				}
								
				 
				for (int i = 3; i < count; i++) {						// ѭ excel 
					
					 Map map = new HashMap();				//  excel Ԫ
					 boolean repeatflag = false;		//Ƿظ
					 boolean flag = true;				//ǷΪ      Ƿȷ
					 
					 String xh = "";
					 String outsidecode = "";
					 
					for(int j=0; j<colnum_keyMap.size(); j++ ) {
						String str = readExcel.readStringExcelCell(i,j);		// ȡӦԪ
						String colnum = String.valueOf(j);
						String key = colnum_keyMap.get(colnum);
						String isCheck = colnum_checkMap.get(colnum);
						String colName = colnum_headMap.get(colnum);
						
						if("outsidecode".equals(key)) {						//豸
							outsidecode = str;
							if(RHUtil.isEmpty(str)) {
								 flag = false;					 
								 String colStr = ""+(j+1)+",("+colName+")";
								 Map errMap = getErrorMsg(i+1, colStr, nullMsg, outsidecode, xh);
								 failList.add(errMap);
							}else {
								if(xhList.contains(str)) {
									 repeatflag = true;
									 repeatNum++;
									 repeatMsg = "ţ"+xh+","+(i+1)+","+(j+1)+"("+colName+"),豸룺"+outsidecode+", ظ";
									 repeatMsgList.add(repeatMsg);
								 }else {
									 xhList.add(outsidecode);
								 }
							}
							map.put(key, str);
						}else if("xh".equals(key)){					//
							xh = str;
						}else {
							
							if("0".equals(isCheck)) {			// У
								map.put(key, str);
							}else if("1".equals(isCheck)) {		// ǿУ
								if(RHUtil.isEmpty(str)) {
									flag = false;
								    String colStr = ""+(j+1)+",("+colName+")";
								    Map errMap = getErrorMsg(i+1, colStr, nullMsg, outsidecode, xh);
								    failList.add(errMap);
								} 
								map.put(key, str);
							}else if("2".equals(isCheck)) {		// ת
								if(RHUtil.isEmpty(str)) {
									 flag = false;
									 String colStr = ""+(j+1)+",("+colName+")";
									 Map errMap = getErrorMsg(i+1,colStr,nullMsg, outsidecode, xh);
									 failList.add(errMap);
								}else {
									if("videofactory".equals(key)) {				// 豸
										str = sbcsMap.get(str);
									}else if("videopointtype".equals(key)) {			// ص
										str = jklxMap.get(str);
									}else if("cameratype".equals(key)) {				// 
										str = xjlxMap.get(str);
									}else if("videofunctiontype".equals(key)) {				// 
										str = xjglMap.get(str);
									}else if("cameralightproperty".equals(key)) {				// 
										str = bgMap.get(str);
									}else if("videocodeformat".equals(key)) {				// ʽ
										str = bmgsMap.get(str);
									}else if("monitorposition".equals(key)) {			//ӷλ
										str = fwMap.get(str);
									}else if("camerapositiontype".equals(key)) {				// λ
										str = xjwzMap.get(str);
									}else if("networkproperty".equals(key)) {				// 
										str = lwMap.get(str);
									}else if("videostate".equals(key)) {				// 豸״̬
										str = sbztMap.get(str);
									}else if("useattribute".equals(key)) {				// /ҵ
										if(str.contains("/")) {
											String[] arr = str.split("/");
											for(String s : arr) {
												str += syMap.get(s)+"/";
											}
										}else {
											str = syMap.get(str);
										}									
									}else if("videoresolution".equals(key)) {				// Ƶֱ
										str = spfblMap.get(str);
									}else if("videosignaltype".equals(key)) {				// Ƶź 
										str = spxhlxMap.get(str);
									}else if("isshare".equals(key)) {				// Ƿ⹲
										str = gxMap.get(str);
									}else if("isjointhreesystem".equals(key)) {				// Ƿƽ̨
										str = sjptMap.get(str);
									}else if("builddepartment".equals(key)) {				// Ӧ
										str = xjjsbmMap.get(str);
									}
									
									if(RHUtil.isEmpty(str)) {
										 flag = false;
										 String colStr = ""+j+",("+colName+")";
										 Map errMap = getErrorMsg(i+1, colStr, transMsg, outsidecode, xh);
										 failList.add(errMap);
									 }else {
										 map.put(key, str);
									 }
								}
								
							}else if("3".equals(isCheck)) {		// У    ʱ
								map.put(key, str);
							}
						}								
					} 
					
					String archivevideoid = StringUtil.getUUID();
					 map.put("archivevideoid",archivevideoid);
					 map.put("createaccount", username);
					 map.put("createtime", time);
					 map.put("modifyaccount", username);
					 map.put("modifytime", time);
			//		 жǷظ   豸 Ƿظ
					 if(RHUtil.isEmpty(outsidecodeList)) {				// ݿ豸ⲿǷظ
						 if(repeatflag && flag) {
							 repeatMap.put(outsidecode, map);			// excelеظ 豸	
							 repeatList.add(map);
						 }else {	
							 if(flag) {
								 list.add(map);				// Уȷظ
							 }else {
								 failNum++;
							 }
						 }	
					 }else {
						 if(outsidecodeList.contains(outsidecode)) {
							 editList.add(map);
						 }else {
							 if(repeatflag && flag) {
								 repeatMap.put(outsidecode, map);			// excelеظ 豸	
								 repeatList.add(map);
							 }else {	
								 if(flag) {
									 list.add(map);				// Уȷظ
								 }else {
									 failNum++;
								 }
							 }
						 }
					 }		 
				}
	
			}
			
			

			File file = new File(path+fileFileName);
			if(file.exists()){
				file.delete();
				File dir = new File(rootpath+uuid);
				dir.delete();
			}
						
			// 
			if("1".equals(sbbh)) {				//   豸ͬ  
			
				Iterator<Map> it = list.iterator();
				while(it.hasNext()){
					Map rkMap = it.next();
					String outsidecode = (String) rkMap.get("outsidecode");
					Map repMap = repeatMap.get(outsidecode);
					if(RHUtil.isNotEmpty(repMap)) {    // Ƿظ
						it.remove();
					}
				}
				// ظݴ
				int editNum = editList.size();
				if(RHUtil.isNotEmpty(editList)) {			// ݿͬ outsidecode ݸ
					for(Map editMap : editList ) {
						editMap.put("XGTJoutsidecode", editMap.get("outsidecode"));
						service.update_Ywarchivevideoinfo(editMap);
					}
				}
				if(RHUtil.isNotEmpty(repeatMap)) {
					for(String key : repeatMap.keySet()) {
						list.add(repeatMap.get(key));						
					}
				}
				// 
				if(list.size() > 0) {
					/*for(Map insertMap : list) {
						service.insert_Ywarchivevideoinfo(insertMap);
					}*/
					service.batch_insert_Ywarchivevideoinfo(list);
				}
				rkNum = list.size() + editNum;               // 
			}else {
				// 
				if(list !=null && list.size() > 0) {
					/*for(Map insertMap : list) {
						service.insert_Ywarchivevideoinfo(insertMap);
					}*/
					service.batch_insert_Ywarchivevideoinfo(list);
					rkNum = list.size(); 
				}
				if(RHUtil.isNotEmpty(repeatList)) {
					//  豸ظ
					if(repeatList.size() > 0) {
						/*for(Map insertMap : repeatList) {
							service.insert_Ywarchivevideoinfo(insertMap);
						}*/
						service.batch_insert_Ywarchivevideoinfo(repeatList);
					}	
					rkNum = rkNum + repeatList.size();
				}
				
			}
			
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ (count-2) +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
//			System.out.println("count--->" + count);
//			System.out.println(rs);
			//   rkNum
			// ظ  reprkNum
			//    failNum
			reprkNum = repeatMsgList.size();
			Map resMap = new HashMap();       // ǰչʾ
			resMap.put("repeatData", repeatMsgList);		// ظ
			resMap.put("failData", failList);				// ʧϢ
			resMap.put("sucNum", rkNum);					// 
			resMap.put("reprkNum", reprkNum);				// ǵ
			resMap.put("failNum", failNum);					// ʧܵ
			Struts2Utils.renderJson(resMap);
		} catch (Exception e) {			
			iLog.error("YwarchivevideoinfoAction-imp_Ywarchivevideoinfo-error:" +e);
			e.printStackTrace();
			Struts2Utils.renderJson(null);
		}		
	}
	
	public Map getErrorMsg(int row, String column, String errMsg, String sbbm, String xh) {
		Map map = new HashMap();
		map.put("row", row);
		map.put("colu", column);
		map.put("errMsg", errMsg);
		map.put("sbbm", sbbm);
		map.put("xh", xh);
		return map;
	}
	
	
	public void isDownload() {
		ServletRequest req = getRequest();
		String fileName = req.getParameter("fileName");
		String pacPath = BeanHelper.getModuleConfFactory().getScatter().getDownPath(); //siyou.xmlжȡļ·
		String fullPath = pacPath + fileName;
		File file = new File(fullPath);
		if(file.exists()) {
			Struts2Utils.renderJson(Constants.SUCCESS);
		}else {
			Struts2Utils.renderJson(null);
		}
		
	}
	
	/*@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywarchivevideoinfo")
	public String imp_Ywarchivevideoinfo(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwarchivevideoinfoAction-imp_Ywarchivevideoinfo-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}*/

	
}
