package cn.im.ptdlfw.dao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;

import com.ibatis.sqlmap.client.SqlMapClient;

@Repository("ptdlfwDao")
public class PtdlfwDao  extends SqlMapClientDaoSupport{

	@Autowired 
    private SqlMapClient sqlMapClient;  
      
	@PostConstruct          
    public  void initSqlMapClient(){  
     super.setSqlMapClient(sqlMapClient);      
    }
	
	/**
	 * Ӽ¼
	 * @param map
	 */
	public void insert_Ptdlfw(Map map) throws SQLException{
		this.getSqlMapClientTemplate().insert("insert_Ptdlfw",map);
	}
	
	/**
	 * Ӽ¼
	 * @param batch
	 */
	public void batch_insert_Ptdlfw(List batch) throws SQLException{
		this.getSqlMapClientTemplate().insert("batch_insert_Ptdlfw",batch);
	}

	/**
	 * ޸ļ¼
	 * @param map
	 * @return Integer
	 */
	public Integer update_Ptdlfw(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().update("update_Ptdlfw",map);
	}

	/**
	 * ɾ¼
	 * @param map
	 * @return Integer
	 */
	public Integer delete_Ptdlfw(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().delete("delete_Ptdlfw",map);
	}
	
	/**
	 * ɾ¼
	 * @param map
	 * @return Integer
	 */
	public Integer batch_delete_Ptdlfw(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().delete("batch_delete_Ptdlfw",map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param map
	 * @return Integer
	 */
	public Integer count_Ptdlfw(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_Ptdlfw",map);
	}
	
	/**
	 * ѯб¼
	 * 
	 * @param map
	 * @return List
	 */
	public List<Map> query_Ptdlfw(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_Ptdlfw",map);
	}
	
	/**
	 * ѯб¼
	 * 
	 * @param map
	 * @return List
	 */
	public Map get_Ptdlfw(Map map) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("query_Ptdlfw",map);
	}
	
}
