package cn.yw.video.videochannelset.action;

 import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.cxf.common.util.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.video.videochannelset.service.YwvideochannelsetlistService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywvideochannelsetlistAction")
public class YwvideochannelsetlistAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwvideochannelsetlistAction.class);
	
	@Autowired
	private YwvideochannelsetlistService service;
	
	/**
	 * ҳ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwvideochannelsetlistByPage")
	public void listYwvideochannelsetlistByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		if(RHUtil.isEmpty(map.get("channelsetid"))) {
			map.clear();
			map.put("total", 0);
			map.put("rows", new ArrayList<Map>());
			Struts2Utils.renderJson(map);
		}
		else {
			try {
				int page = Integer.parseInt(Struts2Utils.getParameter("page"));
				int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
				int start = ((page == 0 ? 1 : page) - 1) * rows;
				map.put("start", start);
				map.put("limit", rows);
				if (null != map.get("xzbh")) {
					String xzbh = map.get("xzbh").toString();
					map.put("xzbh", xzbh.split(","));
				}
				Struts2Utils.renderJson(this.service.listYwvideochannelsetlistByPage(map));

			} catch (Exception e) {
				e.printStackTrace();
				iLog.error("YwvideochannelsetlistAction-listYwvideochannelsetlistByPage-error:" + e);
				Struts2Utils.renderJson(null);
			}
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywvideochannelsetlist")
	public void count_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywvideochannelsetlist(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-count_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywvideochannelsetlist
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywvideochannelsetlist")
	public void query_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywvideochannelsetlist(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-query_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwvideochannelsetlist
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywvideochannelsetlist")
	public void get_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywvideochannelsetlist(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistActionquery_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwvideochannelsetlist")
	public void delete_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywvideochannelsetlist(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-delete_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywvideochannelsetlist")
	public void insert_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		
		try {
			if(StringUtil.checkEmpty(map.get("channellistid"))){
				map.put("channellistid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywvideochannelsetlist(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywvideochannelsetlist(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywvideochannelsetlist(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-insert_Ywvideochannelsetlist()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	@OperateType(value = LogConstants.LOG_ADD ,info ="batch_add_Ywvideochannelsetlist")
	public void batch_add_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			String channelsetid = (String) map.get("channelsetid");
			String param = (String) map.get("param");
			JSONArray json = JSONArray.fromObject(param);
			JSONObject object = null;
			
			List<Map> insertList = new ArrayList<Map>();
			for(int i=0;i<json.size();i++){
				String channellistid =  StringUtil.getUUID();
				object = JSONObject.fromObject(json.get(i));
				Map m = new HashMap();
				m.put("channelsetid", channelsetid);
				//жǷǼ
				if( RHUtil.isNotEmpty(map.get("devicetype")) && map.get("devicetype").equals("1")) {
					m.put("videonum", object.get("sbbh"));
					m.put("channelnum", object.get("tdbh"));
				}else {
					m.put("videonum", object.get("xh"));
				}


				m.put("channelname", object.get("tdmc"));
				List ls = service.query_Ywvideochannelsetlist_select(m);
				if(!(!StringUtil.checkEmpty(ls)||ls.size()>0)){
					m.put("createaccount", username);
					m.put("createtime", DateUtil.currentDateTime());
					m.put("modifyaccount", username);
					m.put("modifytime", DateUtil.currentDateTime());
					m.put("channellistid", channellistid);
//					service.insert_Ywvideochannelsetlist(m);       Ϊ
					insertList.add(m);
				}
			}
			if(RHUtil.isNotEmpty(insertList)) {
				service.insert_batch_Ywvideochannelsetlist(insertList);
			}
//			if(insertList!=null && insertList.size()>0){
//				for(Map insertMap : insertList) {
//					service.insert_Ywvideochannelsetlist(insertMap);
//				}		
//	//			service.batch_add_Ywvideochannelsetlist(insertList);
//			}
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-batch_add_Ywvideochannelsetlist()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywvideochannelsetlist")
	public void update_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywvideochannelsetlist(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywvideochannelsetlist(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywvideochannelsetlist(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-update_Ywvideochannelsetlist-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywvideochannelsetlist")
	public void batch_delete_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keyword = map.get("keyword").toString();
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					
					service.batch_delete_Ywvideochannelsetlist(lists);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-batch_delete_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_start_Ywvideochannelsetlist")
	public void batch_start_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			String keyword = map.get("keyword").toString();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			m.put("modifyaccount", username);
			m.put("modifytime", DateUtil.currentDateTime());
			m.put("channelsetid", map.get("channelsetid"));
			m.put("extend1", 1);
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					m.put("list", lists);
					service.update_batch_ywvideochannelsetlist(m);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-batch_start_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ر
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_end_Ywvideochannelsetlist")
	public void batch_end_Ywvideochannelsetlist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			String keyword = map.get("keyword").toString();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			m.put("modifyaccount", username);
			m.put("modifytime", DateUtil.currentDateTime());
			m.put("channelsetid", map.get("channelsetid"));
			m.put("extend1", 0);
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					m.put("list", lists);
					service.update_batch_ywvideochannelsetlist(m);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-batch_end_Ywvideochannelsetlist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * Ƶģʽ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="update_batch_videomodel")
	public void update_batch_videomodel(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			String keyword = map.get("keyword").toString();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			m.put("modifyaccount", username);
			m.put("modifytime", DateUtil.currentDateTime());
			m.put("channelsetid", map.get("channelsetid"));
			m.put("videomodel", Integer.parseInt(map.get("videomodel").toString()));
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					m.put("list", lists);
					service.update_batch_ywvideochannelsetlist(m);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-update_batch_videomodel-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * Ƶȡʱ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="update_batch_recorddays")
	public void update_batch_recorddays(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			String keyword = map.get("keyword").toString();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			m.put("modifyaccount", username);
			m.put("modifytime", DateUtil.currentDateTime());
			m.put("channelsetid", map.get("channelsetid"));
			m.put("recordxdays", Integer.parseInt(map.get("recordxdays").toString()));
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					m.put("list", lists);
					service.update_batch_ywvideochannelsetlist(m);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-update_batch_recorddays-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ¼ģʽ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="update_batch_recordmodel")
	public void update_batch_recordmodel(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			String keyword = map.get("keyword").toString();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			m.put("modifyaccount", username);
			m.put("modifytime", DateUtil.currentDateTime());
			m.put("channelsetid", map.get("channelsetid"));
			m.put("recordmodel", Integer.parseInt(map.get("recordmodel").toString()));
			if(StringUtil.isEmpty(keyword)){
				Struts2Utils.renderJson(null);
				return ;
			}else{
				List<String> lists = new ArrayList<String>();
				String[] ids = keyword.split(",");
				for(int i=0;i<ids.length;i++){
					lists.add(ids[i]);
				}
				if(lists!=null && lists.size()>0){
					m.put("list", lists);
					service.update_batch_ywvideochannelsetlist(m);
				}
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-update_batch_recordmodel-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywvideochannelsetlist")
	public void exp_Ywvideochannelsetlist(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywvideochannelsetlist(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άͨб-"+dateTime);
			params.put("sheetName", "άͨб");
			params.put("header", "άͨб");	
			new ExportEngine().exportCommData(params, cells, (List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwvideochannelsetlistAction-exoprtExcel-error:" +e);
			
		}
	}
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywvideochannelsetlist")
	public String imp_Ywvideochannelsetlist(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwvideochannelsetlistAction-imp_Ywvideochannelsetlist-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
