package cn.yw.softwaremanage.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.softwaremanage.service.YwsoftwarelistService;

@SuppressWarnings({"all"})
@Component("ywsoftwarelistAction")
public class YwsoftwarelistAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwsoftwarelistAction.class);
	
	@Autowired
	private YwsoftwarelistService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwsoftwarelistByPage")
	public void listYwsoftwarelistByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwsoftwarelistByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-listYwsoftwarelistByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywsoftwarelist")
	public void count_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywsoftwarelist(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-count_Ywsoftwarelist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywsoftwarelist
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywsoftwarelist")
	public void query_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywsoftwarelist(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-query_Ywsoftwarelist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwsoftwarelist
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywsoftwarelist")
	public void get_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywsoftwarelist(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistActionquery_Ywsoftwarelist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwsoftwarelist")
	public void delete_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywsoftwarelist(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-delete_Ywsoftwarelist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywsoftwarelist")
	public void insert_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String curTime = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", curTime);
			map.put("modifyaccount", username);
			map.put("modifytime", curTime);
			
			if(StringUtil.checkEmpty(map.get("listid"))){
				map.put("listid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywsoftwarelist(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywsoftwarelist(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywsoftwarelist(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-insert_Ywsoftwarelist()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywsoftwarelist")
	public void update_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String curTime = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", curTime);
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywsoftwarelist(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywsoftwarelist(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywsoftwarelist(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-update_Ywsoftwarelist-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywsoftwarelist")
	public void batch_delete_Ywsoftwarelist(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywsoftwarelist(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-batch_delete_Ywsoftwarelist-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywsoftwarelist")
	public void exp_Ywsoftwarelist(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywsoftwarelist(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άӦϵͳĿ¼-"+dateTime);
			params.put("sheetName", "άӦϵͳĿ¼");
			params.put("header", "άӦϵͳĿ¼");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwarelistAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywsoftwarelist")
	public String imp_Ywsoftwarelist(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwsoftwarelistAction-imp_Ywsoftwarelist-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
